/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.commons.database.accessor;

import java.sql.ResultSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.phosphoresce.commons.database.accessor.ResultAccessorAbstract;
import org.phosphoresce.commons.database.accessor.ResultAccessorState;
import org.phosphoresce.commons.database.accessor.ResultColumnDefinition;
import org.phosphoresce.commons.database.accessor.ResultRowDefinition;
import org.phosphoresce.commons.database.accessor.ResultTemplateColumn;
import org.phosphoresce.commons.database.exception.IllegalResultSetAdjustmentException;
import org.phosphoresce.commons.database.exception.IllegalResultSetLocationIndexException;
import org.phosphoresce.commons.database.exception.ResultSetAccessException;

public final class ResultTemplateRow
extends ResultAccessorAbstract {
    private ResultRowDefinition definition;
    private List columns = new LinkedList();

    ResultTemplateRow(ResultSet resultSet, ResultRowDefinition definition) throws ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException {
        super(resultSet, ResultAccessorState.TEMPLATE, null);
        this.definition = definition;
        for (int i = 0; i <= definition.getColumnCount() - 1; ++i) {
            this.columns.add(new ResultTemplateColumn(resultSet, this, definition.getColumnDefinition(i), i));
        }
        this.refreshResult();
    }

    protected void refreshResult(boolean force) throws ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException {
        this.definition.refreshResult();
    }

    protected void updateResult() throws ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException {
    }

    public ResultRowDefinition getDefinition() {
        return this.definition;
    }

    public ResultColumnDefinition getColumnDefinition(int index) throws IllegalResultSetLocationIndexException {
        if (this.columns.size() - 1 < index || index < 0) {
            throw new IllegalResultSetLocationIndexException(index + " is illegal index");
        }
        return this.definition.getColumnDefinition(index);
    }

    public ResultColumnDefinition getColumnDefinition(String name) throws IllegalResultSetLocationIndexException {
        return this.getColumnDefinition(this.definition.getColumnIndex(name));
    }

    public ResultTemplateColumn getColumn(int index) throws IllegalResultSetLocationIndexException {
        if (this.columns.size() - 1 < index || index < 0) {
            throw new IllegalResultSetLocationIndexException(index + " is illegal index");
        }
        return (ResultTemplateColumn)this.columns.get(index);
    }

    public ResultTemplateColumn getColumn(String name) throws IllegalResultSetLocationIndexException {
        return this.getColumn(this.definition.getColumnIndex(name));
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        Iterator iterator = this.columns.iterator();
        while (iterator.hasNext()) {
            buffer.append(iterator.next());
            if (!iterator.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("]");
        return buffer.toString();
    }
}

