/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.commons.database.accessor.util;

import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.phosphoresce.commons.database.accessor.ResultColumnDefinition;
import org.phosphoresce.commons.database.exception.IllegalColumnValueException;

public final class AccessorColumnUtil {
    private AccessorColumnUtil() {
    }

    public static Object renderColumnObject(ResultColumnDefinition definition, Object value) throws IllegalColumnValueException {
        try {
            Object render = null;
            if (value == null) {
                render = null;
            } else if (value instanceof String) {
                String string = value.toString();
                if (definition.getColumnClass().equals(Byte.class)) {
                    render = new Byte(Byte.parseByte(string));
                } else if (definition.getColumnClass().equals(String.class)) {
                    render = string;
                } else if (definition.getColumnClass().equals(BigDecimal.class)) {
                    render = new BigDecimal(string);
                } else if (definition.getColumnClass().equals(Short.class)) {
                    render = new Short(Short.parseShort(string));
                } else if (definition.getColumnClass().equals(Integer.class)) {
                    render = new Integer(Integer.parseInt(string));
                } else if (definition.getColumnClass().equals(Long.class)) {
                    render = new Long(Long.parseLong(string));
                } else if (definition.getColumnClass().equals(Float.class)) {
                    render = new Float(Float.parseFloat(string));
                } else if (definition.getColumnClass().equals(Double.class)) {
                    render = new Double(Double.parseDouble(string));
                } else if (definition.getColumnClass().equals([B.class)) {
                    render = string.getBytes();
                } else if (definition.getColumnClass().equals(Date.class)) {
                    render = AccessorColumnUtil.parseDate(string);
                } else if (definition.getColumnClass().equals(Time.class)) {
                    render = Time.valueOf(new SimpleDateFormat("HH:mm:ss").format(AccessorColumnUtil.parseDate(string)));
                } else if (definition.getColumnClass().equals(Timestamp.class)) {
                    render = Timestamp.valueOf(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSSSSS").format(AccessorColumnUtil.parseDate(string)));
                } else if (definition.getColumnClass().equals(Boolean.class)) {
                    render = new Boolean("true".equals(string.toLowerCase()) || "1".equals(string));
                } else if (!definition.getColumnClass().equals(InputStream.class) && !definition.getColumnClass().equals(Blob.class) && !definition.getColumnClass().equals(Clob.class) && definition.getColumnClass().equals(java.sql.Date.class)) {
                    render = java.sql.Date.valueOf(new SimpleDateFormat("yyyy-MM-dd").format(AccessorColumnUtil.parseDate(string)));
                }
            } else if (!definition.getColumnClass().equals(value.getClass())) {
                throw new IllegalColumnValueException("failed to convert column value. column type is '" + definition.getColumnClass().getName() + "', but parameter is '" + value.getClass().getName() + "'.");
            }
            return render;
        }
        catch (Throwable throwable) {
            throw new IllegalColumnValueException("failed to convert column value. column type is '" + definition.getColumnClass().getName() + "'.", throwable);
        }
    }

    public static Date parseDate(String value) throws ParseException {
        ParseException throwable = null;
        Date date = null;
        if (value == null || "".equals(value)) {
            return date;
        }
        try {
            date = new SimpleDateFormat("y/M/d H:m:s.S").parse(value);
            if (date != null) {
                return date;
            }
        }
        catch (ParseException e) {
            throwable = e;
        }
        try {
            date = new SimpleDateFormat("y/M/d H:m").parse(value);
            if (date != null) {
                return date;
            }
        }
        catch (ParseException e) {
            throwable = e;
        }
        try {
            date = new SimpleDateFormat("yyyy/MM/dd").parse(value);
            if (date != null) {
                return date;
            }
        }
        catch (ParseException e) {
            throwable = e;
        }
        try {
            date = new SimpleDateFormat("y-M-d H:m:s.S").parse(value);
            if (date != null) {
                return date;
            }
        }
        catch (ParseException e) {
            throwable = e;
        }
        try {
            date = new SimpleDateFormat("y-M-d H:m").parse(value);
            if (date != null) {
                return date;
            }
        }
        catch (ParseException e) {
            throwable = e;
        }
        try {
            date = new SimpleDateFormat("y-M-d").parse(value);
            if (date != null) {
                return date;
            }
        }
        catch (ParseException e) {
            throwable = e;
        }
        try {
            date = new SimpleDateFormat("H:m:s.S").parse(value);
            if (date != null) {
                return date;
            }
        }
        catch (ParseException e) {
            throwable = e;
        }
        try {
            date = new SimpleDateFormat("H:m:s").parse(value);
            if (date != null) {
                return date;
            }
        }
        catch (ParseException e) {
            throwable = e;
        }
        try {
            date = new SimpleDateFormat("H:m").parse(value);
            if (date != null) {
                return date;
            }
        }
        catch (ParseException e) {
            throwable = e;
        }
        try {
            date = new SimpleDateFormat("yyyyMMddHHmmssSSS").parse(value);
            if (date != null) {
                return date;
            }
        }
        catch (ParseException e) {
            throwable = e;
        }
        try {
            date = new SimpleDateFormat("yyyyMMddHHmmss").parse(value);
            if (date != null) {
                return date;
            }
        }
        catch (ParseException e) {
            throwable = e;
        }
        try {
            date = new SimpleDateFormat("yyyyMMddHHmm").parse(value);
            if (date != null) {
                return date;
            }
        }
        catch (ParseException e) {
            throwable = e;
        }
        try {
            date = new SimpleDateFormat("yyyyMMdd").parse(value);
            if (date != null) {
                return date;
            }
        }
        catch (ParseException e) {
            throwable = e;
        }
        try {
            date = new SimpleDateFormat("HHmmssSSS").parse(value);
            if (date != null) {
                return date;
            }
        }
        catch (ParseException e) {
            throwable = e;
        }
        try {
            date = new SimpleDateFormat("HHmmss").parse(value);
            if (date != null) {
                return date;
            }
        }
        catch (ParseException e) {
            throwable = e;
        }
        try {
            date = new SimpleDateFormat("HHmm").parse(value);
            if (date != null) {
                return date;
            }
        }
        catch (ParseException e) {
            throwable = e;
        }
        if (throwable != null) {
            throw throwable;
        }
        return date;
    }
}

