/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.dbbrowser.gui.common.component;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Iterator;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.phosphoresce.commons.database.container.DatabaseCatalog;
import org.phosphoresce.commons.database.container.DatabaseContainer;
import org.phosphoresce.commons.database.container.DatabaseSchema;
import org.phosphoresce.commons.database.container.DatabaseTable;
import org.phosphoresce.commons.database.core.DatabaseSession;
import org.phosphoresce.commons.eswing.EPanel;
import org.phosphoresce.commons.eswing.EScrollPane;
import org.phosphoresce.commons.eswing.ETree;
import org.phosphoresce.dbbrowser.DatabaseBrowserSession;
import org.phosphoresce.dbbrowser.gui.RefreshableComponent;
import org.phosphoresce.dbbrowser.gui.common.component.CatalogSchemaTableListCellRenderer;

public final class CatalogSchemaTableListPanel
extends EPanel
implements RefreshableComponent {
    private Log log = LogFactory.getLog(this.getClass());
    private ETree tableTree = null;
    private EScrollPane tableTreeScrollPane = null;

    public CatalogSchemaTableListPanel() {
        this.initialize();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(180, 320));
        this.add((Component)this.getTableTreeScrollPane(), gridBagConstraints);
    }

    public void refresh() throws Throwable {
        DefaultMutableTreeNode tableNode;
        DatabaseTable table;
        Iterator tableIterator;
        DatabaseContainer container = DatabaseContainer.createDatabaseContainer((DatabaseSession)DatabaseBrowserSession.instance().getCommonDatabaseSession());
        DefaultMutableTreeNode containerNode = new DefaultMutableTreeNode(container);
        Iterator catalogIterator = container.getCatalogListIterator();
        while (catalogIterator.hasNext()) {
            DatabaseCatalog catalog = (DatabaseCatalog)catalogIterator.next();
            DefaultMutableTreeNode catalogNode = new DefaultMutableTreeNode(catalog);
            containerNode.add(catalogNode);
            tableIterator = catalog.getTableListIterator();
            while (tableIterator.hasNext()) {
                table = (DatabaseTable)tableIterator.next();
                tableNode = new DefaultMutableTreeNode(table);
                catalogNode.add(tableNode);
                Iterator schemaIterator = catalog.getSchemaListIterator();
                while (schemaIterator.hasNext()) {
                    DatabaseSchema schema = (DatabaseSchema)schemaIterator.next();
                    DefaultMutableTreeNode schemaNode = new DefaultMutableTreeNode(schema);
                    catalogNode.add(schemaNode);
                    Iterator tableIterator2 = schema.getTableListIterator();
                    while (tableIterator2.hasNext()) {
                        DatabaseTable table2 = (DatabaseTable)tableIterator.next();
                        DefaultMutableTreeNode tableNode2 = new DefaultMutableTreeNode(table);
                        schemaNode.add(tableNode2);
                    }
                }
            }
        }
        Iterator schemaIterator = container.getSchemaListIterator();
        while (schemaIterator.hasNext()) {
            DatabaseSchema schema = (DatabaseSchema)schemaIterator.next();
            DefaultMutableTreeNode schemaNode = new DefaultMutableTreeNode(schema);
            containerNode.add(schemaNode);
            tableIterator = schema.getTableListIterator();
            while (tableIterator.hasNext()) {
                table = (DatabaseTable)tableIterator.next();
                tableNode = new DefaultMutableTreeNode(table);
                schemaNode.add(tableNode);
            }
        }
        Iterator tableIterator2 = container.getTableListIterator();
        while (tableIterator2.hasNext()) {
            DatabaseTable table2 = (DatabaseTable)tableIterator2.next();
            DefaultMutableTreeNode tableNode2 = new DefaultMutableTreeNode(table2);
            containerNode.add(tableNode2);
        }
        DefaultTreeModel treeModel = new DefaultTreeModel(containerNode);
        this.getTableTree().setModel((TreeModel)treeModel);
    }

    public ETree getTableTree() {
        if (this.tableTree == null) {
            this.tableTree = new ETree();
            this.tableTree.setModel((TreeModel)new DefaultTreeModel(new DefaultMutableTreeNode("no data")));
            this.tableTree.setCellRenderer((TreeCellRenderer)new CatalogSchemaTableListCellRenderer());
            this.tableTree.setBorder((Border)new EmptyBorder(new Insets(2, 2, 2, 2)));
        }
        return this.tableTree;
    }

    public EScrollPane getTableTreeScrollPane() {
        if (this.tableTreeScrollPane == null) {
            this.tableTreeScrollPane = new EScrollPane();
            this.tableTreeScrollPane.setVerticalScrollBarPolicy(20);
            this.tableTreeScrollPane.setHorizontalScrollBarPolicy(30);
            this.tableTreeScrollPane.setViewportView((Component)this.getTableTree());
            this.tableTreeScrollPane.setBorder((Border)new EmptyBorder(new Insets(0, 0, 0, 0)));
        }
        return this.tableTreeScrollPane;
    }
}

