package org.phosphoresce.dbbrowser.gui.logging;

import java.awt.Dimension;

import javax.swing.border.EmptyBorder;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.phosphoresce.commons.eswing.EScrollPane;
import org.phosphoresce.commons.eswing.ETextPane;
import org.phosphoresce.commons.logging.appender.TextPaneAppender;
import org.phosphoresce.dbbrowser.DatabaseBrowserConstants;
import org.phosphoresce.dbbrowser.gui.RefreshableComponent;

/**
 * DatabaseBrowserMOyCNX<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/09/27	Kitagawa		VK쐬
 *-->
 */
public final class LoggingPane extends EScrollPane implements RefreshableComponent {

	/** K[IuWFNg */
	private Log log = LogFactory.getLog(getClass());

	/** VOgZtCX^X */
	private static LoggingPane instance = null;

	/**
	 * RXgN^<br>
	 */
	private LoggingPane() {
		super();
		initialize();
	}

	/**
	 * VOgZtCX^X擾܂B<br>
	 * @return VOgZtCX^X
	 */
	public static LoggingPane instance() {
		if (instance == null) {
			instance = new LoggingPane();
		}
		return instance;
	}

	/**
	 * XV܂B<br>
	 * @throws Throwable ɏ̍XVsȂꍇɔ
	 * @see org.phosphoresce.dbbrowser.gui.RefreshableComponent#refresh()
	 */
	public void refresh() throws Throwable {
	}

	/**
	 * R|[lgs܂B<br>
	 */
	private void initialize() {
		this.setViewportView(getLoggingTextPane());
		this.setMinimumSize(new Dimension(400, 80));
		this.setBorder(new EmptyBorder(0, 0, 0, 0));
	}

	/**
	 * Ay_񋟂郍MOeLXgyC擾܂B<br>
	 * @return Ay_񋟂郍MOeLXgyC
	 */
	private ETextPane getLoggingTextPane() {
		TextPaneAppender appender = TextPaneAppender.getAppender(DatabaseBrowserConstants.LOGAPPENDER_TEXTPANE);
		if (appender != null) {
			return appender.getLoggingTarget();
		} else {
			return null;
		}
	}
}
