package org.phosphoresce.dbbrowser.gui.panel.dbinformation;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.phosphoresce.commons.database.DatabaseInformation;
import org.phosphoresce.commons.eswing.EFieldSet;
import org.phosphoresce.commons.eswing.ELabel;
import org.phosphoresce.dbbrowser.DatabaseBrowserSession;
import org.phosphoresce.dbbrowser.gui.RefreshableComponent;

/**
 * f[^x[XplR|[lgNX<br>
 * f[^x[X{tB[hZbg<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/09/17	Kitagawa		VK쐬
 *-->
 */
public class DatabaseInformationFieldSet extends EFieldSet implements RefreshableComponent {

	/** K[IuWFNg */
	private Log log = LogFactory.getLog(getClass());

	/** VOgZtCX^X */
	private static DatabaseInformationFieldSet instance = null;

	/** f[^x[Xix */
	private ELabel productNameLabel = null;

	/** f[^x[Xi */
	private ELabel productName = null;

	/** f[^x[Xio[Wx */
	private ELabel productVersionLabel = null;

	/** f[^x[Xio[W */
	private ELabel productVersion = null;

	/**
	 * RXgN^<br>
	 */
	private DatabaseInformationFieldSet() {
		super();
		initialize();
	}

	/**
	 * VOgZtCX^X擾܂B<br>
	 * @return VOgZtCX^X
	 */
	public static DatabaseInformationFieldSet instance() {
		if (instance == null) {
			instance = new DatabaseInformationFieldSet();
		}
		return instance;
	}

	/**
	 * XV܂B<br>
	 * @throws Throwable ɏ̍XVsȂꍇɔ
	 * @see org.phosphoresce.dbbrowser.gui.RefreshableComponent#refresh()
	 */
	public void refresh() throws Throwable {
		DatabaseInformation information = new DatabaseInformation(DatabaseBrowserSession.instance().getCommonDatabaseSession());
		getProductName().setText(information.getProductName());
		getProductVersion().setText(information.getProductVersion());
	}

	/**
	 * R|[lgs܂B<br>
	 */
	private void initialize() {
		GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
		gridBagConstraints1.insets = new Insets(0, 5, 0, 0);
		gridBagConstraints1.fill = GridBagConstraints.BOTH;
		gridBagConstraints1.gridx = 0;
		gridBagConstraints1.gridy = 0;
		gridBagConstraints1.weightx = 0.0D;
		gridBagConstraints1.weighty = 0.0D;
		GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
		gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
		gridBagConstraints2.fill = GridBagConstraints.BOTH;
		gridBagConstraints2.gridx = 1;
		gridBagConstraints2.gridy = 0;
		gridBagConstraints2.weightx = 1.0D;
		gridBagConstraints2.weighty = 0.0D;
		GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
		gridBagConstraints3.insets = new Insets(0, 5, 0, 0);
		gridBagConstraints3.fill = GridBagConstraints.BOTH;
		gridBagConstraints3.gridx = 0;
		gridBagConstraints3.gridy = 1;
		gridBagConstraints3.weightx = 0.0D;
		gridBagConstraints3.weighty = 0.0D;
		GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
		gridBagConstraints4.insets = new Insets(0, 0, 0, 0);
		gridBagConstraints4.fill = GridBagConstraints.BOTH;
		gridBagConstraints4.gridx = 1;
		gridBagConstraints4.gridy = 1;
		gridBagConstraints4.weightx = 0.0D;
		gridBagConstraints4.weighty = 0.0D;
		this.setLayout(new GridBagLayout());
		this.setSize(new Dimension(500, 84));
		this.setPreferredSize(new Dimension(500, 84));
		this.setMaximumSize(new Dimension(500, 84));
		this.setMinimumSize(new Dimension(500, 84));
		this.setText("Database Information");
		this.add(getProductNameLabel(), gridBagConstraints1);
		this.add(getProductName(), gridBagConstraints2);
		this.add(getProductVersionLabel(), gridBagConstraints3);
		this.add(getProductVersion(), gridBagConstraints4);
	}

	/**
	 * f[^x[Xix擾܂B<br>
	 * @return f[^x[Xix
	 */
	private ELabel getProductNameLabel() {
		if (productNameLabel == null) {
			productNameLabel = new ELabel();
			productNameLabel.setText("Product Name :");
			productNameLabel.setPreferredSize(new Dimension(150, 22));
		}
		return productNameLabel;
	}

	/**
	 * f[^x[Xi擾܂B<br>
	 * @return f[^x[Xix
	 */
	private ELabel getProductName() {
		if (productName == null) {
			productName = new ELabel();
			productName.setPreferredSize(new Dimension(150, 22));
		}
		return productName;
	}

	/**
	 * f[^x[Xio[Wx擾܂B<br>
	 * @return f[^x[Xio[Wx
	 */
	private ELabel getProductVersionLabel() {
		if (productVersionLabel == null) {
			productVersionLabel = new ELabel();
			productVersionLabel.setPreferredSize(new Dimension(150, 22));
			productVersionLabel.setText("Product Version :");
		}
		return productVersionLabel;
	}

	/**
	 * f[^x[Xio[W擾܂B<br>
	 * @return f[^x[Xio[W
	 */
	private ELabel getProductVersion() {
		if (productVersion == null) {
			productVersion = new ELabel();
			productVersion.setPreferredSize(new Dimension(150, 22));
		}
		return productVersion;
	}
}
