package org.phosphoresce.commons.wpoi.adapter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;

import org.phosphoresce.commons.wpoi.exception.PoiException;

/**
 * POIZlێNXB<br>
 * Z̐ݒľ^𖾎IɕێA䂷邱ƂړIƂNX<br>
 * 
 * @author last modified by: Kitagawa<br>
 * LastUpdate: 2005/12/09
 * 
 *<!--
 * XV       XV          XVe
 * 2005/11/21	Kitagawa		VK쐬
 * 2005/12/09	Kitagawa		BigDecimalɑΉ
 * 								BigIntegerɑΉ
 * 								nullIuWFNgɑΉ
 * 2006/02/13	Kitagawa		equals()\bhI[o[Ch
 * 2006/02/16	Kitagawa		createPoiValue(),isValidPoiValue()ǉ
 * 2006/03/24	Kitagawa		isNumericalStringValue()ǉ
 *-->
 */
public final class PoiValue implements Serializable {

	/** l^CvF^Ul */
	public static final int TYPE_BOOLEAN = 0;

	/** l^CvFtl */
	public static final int TYPE_DATE = 1;

	/** l^CvFl */
	public static final int TYPE_STRING = 2;

	/** l^CvFl */
	public static final int TYPE_NUMERIC = 3;

	/** lF^Ul(false) */
	public static final boolean DEFAULT_BOOLEAN = false;

	/** lFt(1900/01/01) */
	public static final Date DEFAULT_DATE = new Date(-2209021200000L);

	/** lF("") */
	public static final String DEFAULT_STRING = "";

	/** lFl(0) */
	public static final double DEFAULT_NUMERIC = 0;

	/** l^Cv */
	private int type;

	/** lIuWFNg */
	private Object value;

	/**
	 * RXgN^<br>
	 */
	private PoiValue() {
		//
	}

	/**
	 * RXgN^<br>
	 * w肳ꂽlŃNX܂B<br>
	 * l^CvɊւĂ̓p[^^Ɉˑ܂B<br>
	 * @param value l
	 */
	public PoiValue(boolean value) {
		this.type = TYPE_BOOLEAN;
		this.value = Boolean.valueOf(value);
	}

	/**
	 * RXgN^<br>
	 * w肳ꂽlŃNX܂B<br>
	 * l^CvɊւĂ̓p[^^Ɉˑ܂B<br>
	 * @param value l
	 */
	public PoiValue(Boolean value) {
		this.type = TYPE_BOOLEAN;
		this.value = value;
	}

	/**
	 * RXgN^<br>
	 * w肳ꂽlŃNX܂B<br>
	 * l^CvɊւĂ̓p[^^Ɉˑ܂B<br>
	 * @param value l
	 */
	public PoiValue(Date value) {
		this.type = TYPE_DATE;
		this.value = value;
	}

	/**
	 * RXgN^<br>
	 * w肳ꂽlŃNX܂B<br>
	 * l^CvɊւĂ̓p[^^Ɉˑ܂B<br>
	 * @param value l
	 */
	public PoiValue(int value) {
		this.type = TYPE_NUMERIC;
		this.value = Double.valueOf(String.valueOf(value));
	}

	/**
	 * RXgN^<br>
	 * w肳ꂽlŃNX܂B<br>
	 * l^CvɊւĂ̓p[^^Ɉˑ܂B<br>
	 * @param value l
	 */
	public PoiValue(Integer value) {
		this.type = TYPE_NUMERIC;
		this.value = value == null ? null : Double.valueOf(String.valueOf(value.intValue()));
	}

	/**
	 * RXgN^<br>
	 * w肳ꂽlŃNX܂B<br>
	 * l^CvɊւĂ̓p[^^Ɉˑ܂B<br>
	 * @param value l
	 */
	public PoiValue(long value) {
		this.type = TYPE_NUMERIC;
		this.value = Double.valueOf(String.valueOf(value));
	}

	/**
	 * RXgN^<br>
	 * w肳ꂽlŃNX܂B<br>
	 * l^CvɊւĂ̓p[^^Ɉˑ܂B<br>
	 * @param value l
	 */
	public PoiValue(Long value) {
		this.type = TYPE_NUMERIC;
		this.value = value == null ? null : Double.valueOf(String.valueOf(value.longValue()));
	}

	/**
	 * RXgN^<br>
	 * w肳ꂽlŃNX܂B<br>
	 * l^CvɊւĂ̓p[^^Ɉˑ܂B<br>
	 * @param value l
	 */
	public PoiValue(double value) {
		this.type = TYPE_NUMERIC;
		this.value = Double.valueOf(String.valueOf(value));
	}

	/**
	 * RXgN^<br>
	 * w肳ꂽlŃNX܂B<br>
	 * l^CvɊւĂ̓p[^^Ɉˑ܂B<br>
	 * @param value l
	 */
	public PoiValue(Double value) {
		this.type = TYPE_NUMERIC;
		this.value = value == null ? null : value;
	}

	/**
	 * RXgN^<br>
	 * w肳ꂽlŃNX܂B<br>
	 * l^CvɊւĂ̓p[^^Ɉˑ܂B<br>
	 * @param value l
	 */
	public PoiValue(BigDecimal value) {
		this.type = TYPE_NUMERIC;
		this.value = value == null ? null : Double.valueOf(String.valueOf(value.doubleValue()));
	}

	/**
	 * RXgN^<br>
	 * w肳ꂽlŃNX܂B<br>
	 * l^CvɊւĂ̓p[^^Ɉˑ܂B<br>
	 * @param value l
	 */
	public PoiValue(BigInteger value) {
		this.type = TYPE_NUMERIC;
		this.value = value == null ? null : Double.valueOf(String.valueOf(value.doubleValue()));
	}

	/**
	 * RXgN^<br>
	 * w肳ꂽlŃNX܂B<br>
	 * l^CvɊւĂ̓p[^^Ɉˑ܂B<br>
	 * @param value l
	 */
	public PoiValue(String value) {
		this.type = TYPE_STRING;
		this.value = value == null ? null : value;
	}

	/**
	 * RXgN^<br>
	 * @param type
	 * @param value
	 * @throws PoiException
	 */
	public PoiValue(int type, String value) throws PoiException {
		try {
			switch (type) {
			case TYPE_BOOLEAN:
				this.value = value == null ? null : Boolean.valueOf(value);
				break;
			case TYPE_DATE:
				this.value = value == null ? null : PoiUtil.parseDate(value);
				break;
			case TYPE_STRING:
				this.value = value == null ? null : value;
				break;
			case TYPE_NUMERIC:
				this.value = value == null ? null : Double.valueOf(value);
				break;
			default:
				throw new PoiException("s̃Z^Cv[" + type + "]w肳܂");
			}
		} catch (PoiException e) {
			throw new PoiException("ȃZ^Cv[" + type + "]ƃZl[" + value + "]̑gݍ킹w肳܂");
		} catch (RuntimeException e) {
			throw new PoiException("ȃZ^Cv[" + type + "]ƃZl[" + value + "]̑gݍ킹w肳܂");
		}

		this.type = type;
	}

	/**
	 * ێĂlnullł邩肵܂B<br>
	 * @return ێĂlnull̏ꍇtrueԋp
	 */
	public boolean isNullValue() {
		return value == null;
	}

	/**
	 * ێĂl^Ulł邩肵܂B<br>
	 * @return ێĂl^Ul̏ꍇtrueԋp
	 */
	public boolean isBoolean() {
		return type == TYPE_BOOLEAN;
	}

	/**
	 * ێĂltł邩肵܂B<br>
	 * @return ێĂlt̏ꍇtrueԋp
	 */
	public boolean isDate() {
		return type == TYPE_DATE;
	}

	/**
	 * ێĂlł邩肵܂B<br>
	 * @return ێĂl̏ꍇtrueԋp
	 */
	public boolean isString() {
		return type == TYPE_STRING;
	}

	/**
	 * ێĂllł邩肵܂B<br>
	 * @return ێĂll̏ꍇtrueԋp
	 */
	public boolean isNumeric() {
		return type == TYPE_NUMERIC;
	}

	/**
	 * w肳ĂlłꍇAlɕϊłlł邩肵܂B<br>
	 * @return lɕϊłlݒ肳Ăꍇtrueԋp
	 */
	public boolean isNumericalStringValue() {
		if (value instanceof String) {
			try {
				Long.parseLong((String) value);
			} catch (Exception e) {
				return false;
			}
			return true;
		} else {
			return false;
		}
	}

	/**
	 * ݒ肳Ăl^Cv擾܂B<br>
	 * @return l^Cv
	 */
	public int getType() {
		return type;
	}

	/**
	 * ݒ肳Ăl^UlƂĎ擾܂B<br>
	 * @return ݒl
	 * @throws PoiException ݒ肳Ă^CvƈقȂ^CvŒl擾悤Ƃꍇɔ
	 */
	public boolean getBooleanValue() throws PoiException {
		if (!isBoolean()) {
			throw new PoiException("ݒ肳Ă^CvƈقȂ^CvŒl擾悤Ƃ܂");
		}

		return isNullValue() ? DEFAULT_BOOLEAN : ((Boolean) value).booleanValue();
	}

	/**
	 * ݒ肳ĂltƂĎ擾܂B<br>
	 * @return ݒl
	 * @throws PoiException ݒ肳Ă^CvƈقȂ^CvŒl擾悤Ƃꍇɔ
	 */
	public Date getDateValue() throws PoiException {
		if (!isDate()) {
			throw new PoiException("ݒ肳Ă^CvƈقȂ^CvŒl擾悤Ƃ܂");
		}

		return isNullValue() ? null : (Date) value;
	}

	/**
	 * ݒ肳Ăl𕶎ƂĎ擾܂B<br>
	 * @return ݒl
	 * @throws PoiException ݒ肳Ă^CvƈقȂ^CvŒl擾悤Ƃꍇɔ
	 */
	public String getStringValue() throws PoiException {
		if (!isString()) {
			throw new PoiException("ݒ肳Ă^CvƈقȂ^CvŒl擾悤Ƃ܂");
		}

		return isNullValue() ? DEFAULT_STRING : (String) value;
	}

	/**
	 * ݒ肳Ăl𐔒lƂĎ擾܂B<br>
	 * @return ݒl
	 * @throws PoiException ݒ肳Ă^CvƈقȂ^CvŒl擾悤Ƃꍇɔ
	 */
	public double getNumericValue() throws PoiException {
		if (!isNumeric()) {
			throw new PoiException("ݒ肳Ă^CvƈقȂ^CvŒl擾悤Ƃ܂");
		}

		return isNullValue() ? DEFAULT_NUMERIC : ((Double) value).doubleValue();
	}

	/**
	 * NX𕶎ƂĎ擾܂B<br>
	 * @return NX
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		return value == null ? "" : value.toString();
	}

	/**
	 * PoiValueIuWFNgł邩肵܂B<br>
	 * IuWFNgequals\bhI[o[ChPoiValuel
	 * ǂɔf܂B<br>
	 * @param object rΏۃIuWFNg
	 * @return IuWFNg̏ꍇtrueԋp
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	public boolean equals(Object object) {
		if (!(object instanceof PoiValue)) {
			return false;
		}

		if (!((object == null && value == null) || (object != null && value != null))) {
			return false;
		}

		return object.toString().equals(value.toString());
	}

	/**
	 * w肳ꂽIuWFNgPoiValue𐶐܂B<br>
	 * @param object PoiValueIuWFNg
	 * @return PoiValueIuWFNg
	 * @throws PoiException PoiValueIuWFNgΉĂȂIuWFNgw肵ꍇɔ
	 */
	public static PoiValue createPoiValue(Object object) throws PoiException {
		if (object == null) {
			return new PoiValue("");
		} else if (object instanceof Boolean) {
			return new PoiValue((Boolean) object);
		} else if (object instanceof Date) {
			return new PoiValue((Date) object);
		} else if (object instanceof Integer) {
			return new PoiValue((Integer) object);
		} else if (object instanceof Long) {
			return new PoiValue((Long) object);
		} else if (object instanceof Double) {
			return new PoiValue((Double) object);
		} else if (object instanceof BigDecimal) {
			return new PoiValue((BigDecimal) object);
		} else if (object instanceof BigInteger) {
			return new PoiValue((BigInteger) object);
		} else if (object instanceof String) {
			return new PoiValue((String) object);
		} else {
			throw new PoiException("PoiValueɑΉĂȂIuWFNgPoiValue𐶐悤Ƃ܂");
		}
	}

	/**
	 * w肳ꂽIuWFNgPoiValueƂĈ邩ǂ𔻒肵܂B<br>
	 * @param object ΏۃIuWFNg
	 * @return w肳ꂽIuWFNgPoiValueƂĈꍇtrueԋp
	 */
	public static boolean isValidPoiValue(Object object) {
		try {
			createPoiValue(object);
			return true;
		} catch (PoiException e) {
			return false;
		}
	}
}
