package org.phosphoresce.commons.eswing.test;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.ButtonGroup;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;

import org.phosphoresce.commons.eswing.EButton;
import org.phosphoresce.commons.eswing.ECheckBox;
import org.phosphoresce.commons.eswing.EComboBox;
import org.phosphoresce.commons.eswing.EDialog;
import org.phosphoresce.commons.eswing.EEditorPane;
import org.phosphoresce.commons.eswing.EFrame;
import org.phosphoresce.commons.eswing.ELabel;
import org.phosphoresce.commons.eswing.EList;
import org.phosphoresce.commons.eswing.EMessageDialog;
import org.phosphoresce.commons.eswing.EOptionPane;
import org.phosphoresce.commons.eswing.EPanel;
import org.phosphoresce.commons.eswing.EPasswordField;
import org.phosphoresce.commons.eswing.EProgressBar;
import org.phosphoresce.commons.eswing.ERadioButton;
import org.phosphoresce.commons.eswing.EScrollBar;
import org.phosphoresce.commons.eswing.EScrollPane;
import org.phosphoresce.commons.eswing.ESlider;
import org.phosphoresce.commons.eswing.ESplitPane;
import org.phosphoresce.commons.eswing.ETabbedPane;
import org.phosphoresce.commons.eswing.ETable;
import org.phosphoresce.commons.eswing.ETextArea;
import org.phosphoresce.commons.eswing.ETextField;
import org.phosphoresce.commons.eswing.ETextPane;
import org.phosphoresce.commons.eswing.EToggleButton;
import org.phosphoresce.commons.eswing.ETree;

/**
 * SwinggR|[lgeXgNX<br>
 * WR|[lggeXg<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/09/02	Kitagawa		VK쐬
 *-->
 */
public class ESwingDefaultComponentTest extends EFrame {

	private ESwingDefaultComponentTest instance = null;

	private EPanel jContentPane = null;

	private ETabbedPane eTabbedPane = null;

	private ESplitPane eSplitPane = null;

	private EList eList = null;

	private EScrollPane eScrollPane = null;

	private ETextArea eTextArea = null;

	private EPanel ePanel = null;

	private EButton eButton = null;

	private ECheckBox eCheckBox = null;

	private ERadioButton eRadioButton = null;

	private ERadioButton eRadioButton1 = null;

	private ERadioButton eRadioButton2 = null;

	private ButtonGroup buttonGroup = null;

	private EToggleButton eToggleButton = null;

	private ELabel eLabel = null;

	private ETextField eTextField = null;

	private EPasswordField ePasswordField = null;

	private EScrollPane eScrollPane1 = null;

	private ETextArea eTextArea1 = null;

	private EScrollPane eScrollPane2 = null;

	private ETextPane eTextPane = null;

	private ESlider eSlider = null;

	private EScrollBar eScrollBar = null;

	private EScrollBar eScrollBar1 = null;

	private EList eList1 = null;

	private EComboBox eComboBox = null;

	private EScrollPane eScrollPane3 = null;

	private ETree eTree = null;

	private EScrollPane eScrollPane4 = null;

	private EScrollPane eScrollPane5 = null;

	private ETable eTable = null;

	private EProgressBar eProgressBar = null;

	private EOptionPane eOptionPane = null;

	private EScrollPane eScrollPane6 = null;

	private EEditorPane eEditorPane = null;

	/**
	 * RXgN^<br>
	 */
	public ESwingDefaultComponentTest() {
		super();
		initialize();
		this.instance = this;
	}

	/**
	 * This method initializes this
	 */
	private void initialize() {
		this.setSize(new Dimension(806, 380));
		this.setContentPane(getJContentPane());
		this.setTitle("ESwing Default Component Test");
	}

	/**
	 * This method initializes jContentPane	
	 * @return org.phosphoresce.commons.eswing.EPanel
	 */
	private EPanel getJContentPane() {
		if (jContentPane == null) {
			jContentPane = new EPanel();
			jContentPane.setLayout(null);
			jContentPane.setSize(new Dimension(1017, 386));
			jContentPane.add(getETabbedPane(), null);
		}
		return jContentPane;
	}

	/**
	 * This method initializes eTabbedPane	
	 * @return org.phosphoresce.commons.eswing.ETabbedPane
	 */
	private ETabbedPane getETabbedPane() {
		if (eTabbedPane == null) {
			eTabbedPane = new ETabbedPane();
			eTabbedPane.setBounds(new Rectangle(5, 5, 776, 331));
			eTabbedPane.addTab("Components", null, getEPanel(), null);
			eTabbedPane.addTab("Split Pane", null, getESplitPane(), null);
		}
		return eTabbedPane;
	}

	/**
	 * This method initializes eSplitPane	
	 * @return org.phosphoresce.commons.eswing.ESplitPane	
	 */
	private ESplitPane getESplitPane() {
		if (eSplitPane == null) {
			eSplitPane = new ESplitPane();
			eSplitPane.setLeftComponent(getEList());
			eSplitPane.setRightComponent(getEScrollPane());
		}
		return eSplitPane;
	}

	/**
	 * This method initializes eList	
	 * @return org.phosphoresce.commons.eswing.EList	
	 */
	private EList getEList() {
		if (eList == null) {
			eList = new EList(new String[] { "ListItem1", "ListItem2", "ListItem3" });
			eList.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
				public void valueChanged(javax.swing.event.ListSelectionEvent e) {
					getETextArea().setText(getEList().getSelectedValue().toString());
				}
			});
		}
		return eList;
	}

	/**
	 * This method initializes eScrollPane	
	 * @return org.phosphoresce.commons.eswing.EScrollPane	
	 */
	private EScrollPane getEScrollPane() {
		if (eScrollPane == null) {
			eScrollPane = new EScrollPane();
			eScrollPane.setViewportView(getETextArea());
		}
		return eScrollPane;
	}

	/**
	 * This method initializes eTextArea	
	 * @return org.phosphoresce.commons.eswing.ETextArea	
	 */
	private ETextArea getETextArea() {
		if (eTextArea == null) {
			eTextArea = new ETextArea();
		}
		return eTextArea;
	}

	/**
	 * This method initializes ePanel	
	 * @return org.phosphoresce.commons.eswing.EPanel	
	 */
	private EPanel getEPanel() {
		if (ePanel == null) {
			ePanel = new EPanel();
			ePanel.setLayout(null);
			ePanel.add(getEButton(), null);
			ePanel.add(getECheckBox(), null);
			ePanel.add(getERadioButton(), null);
			ePanel.add(getERadioButton1(), null);
			ePanel.add(getERadioButton2(), null);
			ePanel.add(getEToggleButton(), null);
			ePanel.add(getELabel(), null);
			ePanel.add(getETextField(), null);
			ePanel.add(getEPasswordField(), null);
			ePanel.add(getEScrollPane1(), null);
			ePanel.add(getEScrollPane2(), null);
			ePanel.add(getESlider(), null);
			ePanel.add(getEScrollBar(), null);
			ePanel.add(getEScrollBar1(), null);
			ePanel.add(getEComboBox(), null);
			ePanel.add(getEScrollPane3(), null);
			ePanel.add(getEScrollPane4(), null);
			ePanel.add(getEScrollPane5(), null);
			ePanel.add(getEProgressBar(), null);
			ePanel.add(getEOptionPane(), null);
			ePanel.add(getEScrollPane6(), null);
		}
		return ePanel;
	}

	/**
	 * This method initializes eButton	
	 * @return org.phosphoresce.commons.eswing.EButton	
	 */
	private EButton getEButton() {
		if (eButton == null) {
			eButton = new EButton();
			eButton.setBounds(new Rectangle(5, 5, 86, 24));
			eButton.setText("Button");
			eButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					EMessageDialog.showError(instance, "Error Message");
				}
			});
		}
		return eButton;
	}

	/**
	 * This method initializes eCheckBox	
	 * @return org.phosphoresce.commons.eswing.ECheckBox	
	 */
	private ECheckBox getECheckBox() {
		if (eCheckBox == null) {
			eCheckBox = new ECheckBox();
			eCheckBox.setBounds(new Rectangle(185, 5, 132, 24));
			eCheckBox.setText("CheckBox");
		}
		return eCheckBox;
	}

	/**
	 * This method initializes eRadioButton	
	 * @return org.phosphoresce.commons.eswing.ERadioButton	
	 */
	private ERadioButton getERadioButton() {
		if (eRadioButton == null) {
			eRadioButton = new ERadioButton();
			eRadioButton.setBounds(new Rectangle(5, 35, 142, 24));
			eRadioButton.setText("RadioButton1");
			getButtonGroup().add(eRadioButton);
		}
		return eRadioButton;
	}

	/**
	 * This method initializes eRadioButton1	
	 * @return org.phosphoresce.commons.eswing.ERadioButton	
	 */
	private ERadioButton getERadioButton1() {
		if (eRadioButton1 == null) {
			eRadioButton1 = new ERadioButton();
			eRadioButton1.setText("RadioButton2");
			eRadioButton1.setBounds(new Rectangle(150, 35, 141, 24));
			getButtonGroup().add(eRadioButton1);
		}
		return eRadioButton1;
	}

	/**
	 * This method initializes eRadioButton2	
	 * @return org.phosphoresce.commons.eswing.ERadioButton	
	 */
	private ERadioButton getERadioButton2() {
		if (eRadioButton2 == null) {
			eRadioButton2 = new ERadioButton();
			eRadioButton2.setBounds(new Rectangle(295, 35, 141, 24));
			eRadioButton2.setText("RadioButton3");
			getButtonGroup().add(eRadioButton2);
		}
		return eRadioButton2;
	}

	/**
	 * This method initializes buttonGroup	
	 * @return javax.swing.ButtonGroup	
	 */
	private ButtonGroup getButtonGroup() {
		if (buttonGroup == null) {
			buttonGroup = new ButtonGroup();
		}
		return buttonGroup;
	}

	/**
	 * This method initializes eToggleButton	
	 * @return org.phosphoresce.commons.eswing.EToggleButton	
	 */
	private EToggleButton getEToggleButton() {
		if (eToggleButton == null) {
			eToggleButton = new EToggleButton();
			eToggleButton.setBounds(new Rectangle(95, 5, 86, 24));
			eToggleButton.setText("Toggle");
		}
		return eToggleButton;
	}

	/**
	 * This method initializes eLabel	
	 * @return org.phosphoresce.commons.eswing.ELabel	
	 */
	private ELabel getELabel() {
		if (eLabel == null) {
			eLabel = new ELabel();
			eLabel.setBounds(new Rectangle(5, 65, 60, 21));
			eLabel.setText("Label");
		}
		return eLabel;
	}

	/**
	 * This method initializes eTextField	
	 * @return org.phosphoresce.commons.eswing.ETextField	
	 */
	private ETextField getETextField() {
		if (eTextField == null) {
			eTextField = new ETextField();
			eTextField.setBounds(new Rectangle(70, 65, 181, 21));
			eTextField.setText("TextField");
		}
		return eTextField;
	}

	/**
	 * This method initializes ePasswordField	
	 * @return org.phosphoresce.commons.eswing.EPasswordField	
	 */
	private EPasswordField getEPasswordField() {
		if (ePasswordField == null) {
			ePasswordField = new EPasswordField();
			ePasswordField.setBounds(new Rectangle(255, 65, 181, 21));
			ePasswordField.setText("PasswordField");
		}
		return ePasswordField;
	}

	/**
	 * This method initializes eScrollPane1	
	 * @return org.phosphoresce.commons.eswing.EScrollPane	
	 */
	private EScrollPane getEScrollPane1() {
		if (eScrollPane1 == null) {
			eScrollPane1 = new EScrollPane();
			eScrollPane1.setBounds(new Rectangle(5, 90, 216, 81));
			eScrollPane1.setViewportView(getETextArea1());
		}
		return eScrollPane1;
	}

	/**
	 * This method initializes eTextArea1	
	 * @return org.phosphoresce.commons.eswing.ETextArea	
	 */
	private ETextArea getETextArea1() {
		if (eTextArea1 == null) {
			eTextArea1 = new ETextArea();
			eTextArea1.setText("TextArea");
		}
		return eTextArea1;
	}

	/**
	 * This method initializes eScrollPane2	
	 * @return org.phosphoresce.commons.eswing.EScrollPane	
	 */
	private EScrollPane getEScrollPane2() {
		if (eScrollPane2 == null) {
			eScrollPane2 = new EScrollPane();
			eScrollPane2.setBounds(new Rectangle(225, 90, 211, 81));
			eScrollPane2.setViewportView(getETextPane());
		}
		return eScrollPane2;
	}

	/**
	 * This method initializes eTextPane	
	 * @return org.phosphoresce.commons.eswing.ETextPane	
	 */
	private ETextPane getETextPane() {
		if (eTextPane == null) {
			eTextPane = new ETextPane();
			eTextPane.setText("TextPane");
		}
		return eTextPane;
	}

	/**
	 * This method initializes eSlider	
	 * @return org.phosphoresce.commons.eswing.ESlider	
	 */
	private ESlider getESlider() {
		if (eSlider == null) {
			eSlider = new ESlider();
			eSlider.setBounds(new Rectangle(270, 195, 166, 23));
			eSlider.addChangeListener(new javax.swing.event.ChangeListener() {
				public void stateChanged(javax.swing.event.ChangeEvent e) {
					getEProgressBar().setValue(getESlider().getValue());
					getEScrollBar().setValue(getESlider().getValue());
					getEScrollBar1().setValue(getESlider().getValue());
				}
			});
		}
		return eSlider;
	}

	/**
	 * This method initializes eScrollBar	
	 * @return org.phosphoresce.commons.eswing.EScrollBar	
	 */
	private EScrollBar getEScrollBar() {
		if (eScrollBar == null) {
			eScrollBar = new EScrollBar();
			eScrollBar.setBounds(new Rectangle(250, 175, 17, 61));
			eScrollBar.setValue(50);
			eScrollBar.addAdjustmentListener(new java.awt.event.AdjustmentListener() {
				public void adjustmentValueChanged(java.awt.event.AdjustmentEvent e) {
					getESlider().setValue(getEScrollBar().getValue());
				}
			});
		}
		return eScrollBar;
	}

	/**
	 * This method initializes eScrollBar1	
	 * @return org.phosphoresce.commons.eswing.EScrollBar	
	 */
	private EScrollBar getEScrollBar1() {
		if (eScrollBar1 == null) {
			eScrollBar1 = new EScrollBar();
			eScrollBar1.setBounds(new Rectangle(270, 175, 166, 17));
			eScrollBar1.setOrientation(JScrollBar.HORIZONTAL);
			eScrollBar1.setValue(50);
			eScrollBar1.addAdjustmentListener(new java.awt.event.AdjustmentListener() {
				public void adjustmentValueChanged(java.awt.event.AdjustmentEvent e) {
					getESlider().setValue(getEScrollBar1().getValue());
				}
			});
		}
		return eScrollBar1;
	}

	/**
	 * This method initializes eList1	
	 * @return org.phosphoresce.commons.eswing.EList	
	 */
	private EList getEList1() {
		if (eList1 == null) {
			eList1 = new EList(new String[] { "Item1", "Item2", "Item3", "Item4", "Item5", "Item6", "Item7", "Item8", "Item9", "Item10", "Item11" });
		}
		return eList1;
	}

	/**
	 * This method initializes eComboBox	
	 * @return org.phosphoresce.commons.eswing.EComboBox	
	 */
	private EComboBox getEComboBox() {
		if (eComboBox == null) {
			eComboBox = new EComboBox(new String[] { "Item1", "Item2", "Item3", "Item4", "Item5", "Item6", "Item7", "Item8", "Item9", "Item10", "Item11" });
			eComboBox.setBounds(new Rectangle(320, 5, 116, 21));
		}
		return eComboBox;
	}

	/**
	 * This method initializes eScrollPane3	
	 * @return org.phosphoresce.commons.eswing.EScrollPane	
	 */
	private EScrollPane getEScrollPane3() {
		if (eScrollPane3 == null) {
			eScrollPane3 = new EScrollPane();
			eScrollPane3.setBounds(new Rectangle(130, 175, 116, 121));
			eScrollPane3.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
			eScrollPane3.setViewportView(getEList1());
		}
		return eScrollPane3;
	}

	/**
	 * This method initializes eTree	
	 * @return org.phosphoresce.commons.eswing.ETree	
	 */
	private ETree getETree() {
		if (eTree == null) {
			DefaultMutableTreeNode node = new DefaultMutableTreeNode("Root");
			DefaultMutableTreeNode child1 = new DefaultMutableTreeNode("Child1");
			DefaultMutableTreeNode child2 = new DefaultMutableTreeNode("Child2");
			DefaultMutableTreeNode child3 = new DefaultMutableTreeNode("Child3");
			DefaultMutableTreeNode child4 = new DefaultMutableTreeNode("Child4");
			DefaultMutableTreeNode child5 = new DefaultMutableTreeNode("Child5");
			DefaultMutableTreeNode child11 = new DefaultMutableTreeNode("Child11");
			DefaultMutableTreeNode child12 = new DefaultMutableTreeNode("Child12");
			DefaultMutableTreeNode child13 = new DefaultMutableTreeNode("Child13");
			DefaultMutableTreeNode child14 = new DefaultMutableTreeNode("Child14");
			DefaultMutableTreeNode child15 = new DefaultMutableTreeNode("Child15");
			child1.add(child11);
			child1.add(child12);
			child1.add(child13);
			child1.add(child14);
			child1.add(child15);
			node.add(child1);
			node.add(child2);
			node.add(child3);
			node.add(child4);
			node.add(child5);
			TreeModel model = new DefaultTreeModel(node);
			eTree = new ETree(model);
		}
		return eTree;
	}

	/**
	 * This method initializes eScrollPane4	
	 * @return org.phosphoresce.commons.eswing.EScrollPane	
	 */
	private EScrollPane getEScrollPane4() {
		if (eScrollPane4 == null) {
			eScrollPane4 = new EScrollPane();
			eScrollPane4.setBounds(new Rectangle(5, 175, 121, 121));
			eScrollPane4.setViewportView(getETree());
		}
		return eScrollPane4;
	}

	/**
	 * This method initializes eScrollPane5	
	 * @return org.phosphoresce.commons.eswing.EScrollPane	
	 */
	private EScrollPane getEScrollPane5() {
		if (eScrollPane5 == null) {
			eScrollPane5 = new EScrollPane();
			eScrollPane5.setBounds(new Rectangle(440, 100, 326, 136));
			eScrollPane5.setViewportView(getETable());
		}
		return eScrollPane5;
	}

	/**
	 * This method initializes eTable	
	 * @return org.phosphoresce.commons.eswing.ETable	
	 */
	private ETable getETable() {
		if (eTable == null) {
			eTable = new ETable(new String[][] { //
					//
							{ "1", "2", "3", "4", "5" }, //
							{ "2", "3", "4", "5", "6" }, //
							{ "3", "4", "5", "6", "7" }, //
							{ "4", "5", "6", "7", "8" }, //
							{ "5", "6", "7", "8", "9" }, //
							{ "6", "7", "8", "9", "10" } }, //
					new String[] { "col1", "col2", "col3", "col4", "col5" });
			eTable.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
		}
		return eTable;
	}

	/**
	 * This method initializes eProgressBar	
	 * @return org.phosphoresce.commons.eswing.EProgressBar	
	 */
	private EProgressBar getEProgressBar() {
		if (eProgressBar == null) {
			eProgressBar = new EProgressBar();
			eProgressBar.setBounds(new Rectangle(270, 220, 166, 14));
			eProgressBar.setValue(50);
		}
		return eProgressBar;
	}

	/**
	 * This method initializes eOptionPane	
	 * @return org.phosphoresce.commons.eswing.EOptionPane	
	 */
	private EOptionPane getEOptionPane() {
		if (eOptionPane == null) {
			eOptionPane = new EOptionPane();
			eOptionPane.setBounds(new Rectangle(440, 5, 326, 91));
		}
		return eOptionPane;
	}

	/**
	 * This method initializes eScrollPane6	
	 * @return org.phosphoresce.commons.eswing.EScrollPane	
	 */
	private EScrollPane getEScrollPane6() {
		if (eScrollPane6 == null) {
			eScrollPane6 = new EScrollPane();
			eScrollPane6.setBounds(new Rectangle(250, 240, 516, 56));
			eScrollPane6.setViewportView(getEEditorPane());
		}
		return eScrollPane6;
	}

	/**
	 * This method initializes eEditorPane	
	 * @return org.phosphoresce.commons.eswing.EEditorPane	
	 */
	private EEditorPane getEEditorPane() {
		if (eEditorPane == null) {
			eEditorPane = new EEditorPane("text/html", "<html><b>foo</b></html>");
		}
		return eEditorPane;
	}
}
