dnl $Id: config.m4,v 1.8 2006/02/01 18:50:06 ryuzo Exp $
dnl config.m4 for extension rast

PHP_ARG_WITH(rast, for rast support,
[  --with-rast[=DIR]         Include rast support. DIR is the rast
                          base install directory.])

if test "$PHP_RAST" != "no"; then
    if test "$PHP_RAST" = "yes"; then
        AC_MSG_CHECKING(for rast-config in default path...)
        for i in /usr/local/rast /usr/local /usr; do
            if test -x "$i/bin/rast-config"; then
                RAST_CONFIG=$i/bin/rast-config
            fi
        done
    else
        AC_MSG_CHECKING(for rast-config in $PHP_RAST/bin...)
        if test -x "$PHP_RAST/bin/rast-config"; then
            RAST_CONFIG=$PHP_RAST/bin/rast-config
        fi
    fi

    if test -x $RAST_CONFIG; then
        AC_MSG_RESULT($RAST_CONFIG)
    else
        AC_MSG_ERROR(Cannot find rast-config. Please specify correct Rast installation path)
    fi 

    PHP_EVAL_LIBLINE(`$RAST_CONFIG  --libs-ld --ldflags`)
    PHP_EVAL_INCLINE(`$RAST_CONFIG --includes --cppflags`)
    PHP_ADD_LIBRARY_WITH_PATH(rast, `$RAST_CONFIG --libdir`, RAST_SHARED_LIBADD)

dnl     RAST_VERSION=`$RAST_CONFIG --version`
    AC_DEFINE_UNQUOTED(RAST_VERSION, "`$RAST_CONFIG --version`", [rast version])

  PHP_NEW_EXTENSION(rast, rast.c, $ext_shared)
fi

PHP_SUBST(RAST_SHARED_LIBADD)
