<?php
/***************************************************************************
 *                            lang_main.php [Japanese]
 *                              -------------------
 *     begin                : Sat Dec 16 2000
 *     copyright            : (C) 2001 The phpBB Group
 *     email                : support@phpbb.com
 *
 *     $Id: lang_main.php,v 1.85.2.15 2003/06/10 00:31:19 psotfx Exp $
 *     $Id: lang_main.php,v 1.85.2.15.1 2003/06/10 00:31:19 hiikun7 Exp $
 *
 ****************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/

//
// CONTRIBUTORS:
//	 Add your details here if wanted, e.g. Name, username, email address, website
// 2002-08-27  Philip M. White        - fixed many grammar problems
//

//
// The format of this file is ---> $lang['message'] = 'text';
//
// You should also try to set a locale and a character encoding (plus direction). The encoding and direction
// will be sent to the template. The locale may or may not work, it's dependent on OS support and the syntax
// varies ... give it your best guess!
//

$lang['ENCODING'] = 'UTF-8';
$lang['DIRECTION'] = 'ltr';
$lang['LEFT'] = 'left';
$lang['RIGHT'] = 'right';
$lang['DATE_FORMAT'] =  'Y.m.d'; // This should be changed to the default date format for your language, php date() format


// This is optional, if you would like a _SHORT_ message output
// along with our copyright message indicating you are the translator
// please add it here.
$lang['TRANSLATION_INFO'] = 'Traduction par : PHPBB JAPAN / UTF-8 i18n Edition : <a href="http://support.hiikun.net/" target="_forum" class="copyright" title="JP Support Forum">JP Support Forum</a>';


//
// Common, these terms are used
// extensively on several pages
//
$lang['Forum'] = 'フォーラム';
$lang['Category'] = 'カテゴリー';
$lang['Topic'] = 'トピック';
$lang['Topics'] = '<nobr>トピック';
$lang['Replies'] = '返信';
$lang['Views'] = '表示';
$lang['Post'] = '記事';
$lang['Posts'] = '記事';
$lang['Posted'] = '日時';
$lang['Username'] = 'ユーザー名';
$lang['Password'] = 'パスワード';
$lang['Email'] = 'メール';
$lang['Poster'] = '投稿者';
$lang['Author'] = '投稿者';
$lang['Time'] = '時間';
$lang['Hours'] = '時間';
$lang['Message'] = 'メッセージ';

$lang['1_Day'] = '1 日間';
$lang['7_Days'] = '7 日間';
$lang['2_Weeks'] = '2 週間';
$lang['1_Month'] = '1 ヶ月間';
$lang['3_Months'] = '3 ヶ月間';
$lang['6_Months'] = '6 ヶ月間';
$lang['1_Year'] = '1 年間';

$lang['Go'] = '送信';
$lang['Jump_to'] = '移動先';
$lang['Submit'] = '送信';
$lang['Reset'] = 'リセット';
$lang['Cancel'] = 'キャンセル';
$lang['Preview'] = 'プレビュー';
$lang['Confirm'] = 'Confirm';
$lang['Spellcheck'] = 'スペルチェック';
$lang['Yes'] = 'はい';
$lang['No'] = 'いいえ';
$lang['Enabled'] = '有効';
$lang['Disabled'] = '無効';
$lang['Error'] = 'Error';

$lang['Next'] = '次へ';
$lang['Previous'] = '前へ';
$lang['Goto_page'] = 'ページ移動';
$lang['Joined'] = '登録日';
$lang['IP_Address'] = 'IP アドレス';

$lang['Select_forum'] = 'フォーラムを選択';
$lang['View_latest_post'] = '新しい記事を表示';
$lang['View_newest_post'] = '最新の記事を表示';
$lang['Page_of'] = 'Page <b>%d</b> of <b>%d</b>'; // Replaces with: Page 1 of 2 for example

$lang['ICQ'] = 'ICQ';
$lang['AIM'] = 'AIM';
$lang['MSNM'] = 'MSNM';
$lang['YIM'] = 'YIM';

$lang['Forum_Index'] = '%s Forum Index';  // eg. sitename Forum Index, %s can be removed if you prefer

$lang['Post_new_topic'] = '新しいトピックを投稿';
$lang['Reply_to_topic'] = 'トピックに返信';
$lang['Reply_with_quote'] = '引用付きで返信';

$lang['Click_return_topic'] = 'トピックに戻る場合は %sこちら%s をクリックしてください'; // %s's here are for uris, do not remove!
$lang['Click_return_login'] = 'もう一度試す場合は %sこちら%s をクリックしてください';
$lang['Click_return_forum'] = 'フォーラムに戻る場合は %sこちら%s をクリックしてください';
$lang['Click_view_message'] = '投稿したメッセージを表示する場合は %sこちら%s をクリックしてください';
$lang['Click_return_modcp'] = 'Moderator CP に戻る場合は %sこちら%s をクリックしてください';
$lang['Click_return_group'] = 'グループ情報に戻る場合は %sこちら%s をクリックしてください';

$lang['Admin_panel'] = 'Administration CP';

$lang['Board_disable'] = '現在この掲示板は利用できません。また後ほどお越しください。';


//
// Global Header strings
//
$lang['Registered_users'] = '登録ユーザー:';
$lang['Browsing_forum'] = 'このフォーラムを表示中のユーザー:';
$lang['Online_users_zero_total'] = 'オンラインユーザー: <b>0</b> 人 :: ';
$lang['Online_users_total'] = 'オンラインユーザー: <b>%d</b> 人 :: ';
$lang['Online_user_total'] = 'オンラインユーザー: <b>%d</b> 人 :: ';
$lang['Reg_users_zero_total'] = '登録ユーザー [0] ';
$lang['Reg_users_total'] = '登録ユーザー [%d] ';
$lang['Reg_user_total'] = '登録ユーザー [%d] ';
$lang['Hidden_users_zero_total'] = 'お忍びユーザー [0] ';
$lang['Hidden_user_total'] = 'お忍びユーザー [%d] ';
$lang['Hidden_users_total'] = 'お忍びユーザー [%d] ';
$lang['Guest_users_zero_total'] = '未登録ユーザー [0]';
$lang['Guest_users_total'] = '未登録ユーザー [%d]';
$lang['Guest_user_total'] = '未登録ユーザー [%d]';
$lang['Record_online_users'] = 'オンラインユーザーの記録: <b>%s</b> 人 [ 記録更新日時 - %s ]'; // first %s = number of users, second %s is the date.

$lang['Admin_online_color'] = '%sAdministrator%s';
$lang['Mod_online_color'] = '%sModerator%s';

$lang['You_last_visit'] = '前回訪問日 - %s'; // %s replaced by date/time
$lang['Current_time'] = '現在の時刻 - %s'; // %s replaced by time

$lang['Search_new'] = '新しい記事を表示';
$lang['Search_your_posts'] = '投稿した記事を表示';
$lang['Search_unanswered'] = '未返信の記事を表示';

$lang['Register'] = '登録する';
$lang['Profile'] = 'プロフィール';
$lang['Edit_profile'] = 'プロフィールを編集';
$lang['Search'] = '検索';
$lang['Memberlist'] = 'メンバーリスト';
$lang['FAQ'] = 'FAQ';
$lang['BBCode_guide'] = 'BBCode ガイド';
$lang['Usergroups'] = 'ユーザーグループ';
$lang['Last_Post'] = '最新記事';
$lang['Moderator'] = 'モデレーター';
$lang['Moderators'] = 'モデレーター';


//
// Stats block text
//
$lang['Posted_articles_zero_total'] = '投稿記事数: <b>0</b> 件'; // Number of posts
$lang['Posted_articles_total'] = '投稿記事数: <b>%d</b> 件'; // Number of posts
$lang['Posted_article_total'] = '投稿記事数: <b>%d</b> 件'; // Number of posts
$lang['Registered_users_zero_total'] = '登録ユーザー数: <b>0</b> 人'; // # registered users
$lang['Registered_users_total'] = '登録ユーザー数: <b>%d</b> 人'; // # registered users
$lang['Registered_user_total'] = '登録ユーザー数: <b>%d</b> 人'; // # registered users
$lang['Newest_user'] = '最新登録ユーザー: <b>%s%s%s</b>'; // a href, username, /a 

$lang['No_new_posts_last_visit'] = '新しい記事はありません';
$lang['No_new_posts'] = '新しい記事なし';
$lang['New_posts'] = '新しい記事あり';
$lang['New_post'] = '新しい記事あり';
$lang['No_new_posts_hot'] = '新しい記事なし [ 人気 ]';
$lang['New_posts_hot'] = '新しい記事あり [ 人気 ]';
$lang['No_new_posts_locked'] = '新しい記事なし [ 閉鎖 ]';
$lang['New_posts_locked'] = '新しい記事あり [ 閉鎖 ]';
$lang['Forum_is_locked'] = '閉鎖中フォーラム';


//
// Login
//
$lang['Enter_password'] = 'ユーザー名とパスワードを入力してログインしてください';
$lang['Login'] = 'ログイン';
$lang['Logout'] = 'ログアウト';

$lang['Forgotten_password'] = 'パスワードを忘れてしまいました';

$lang['Log_me_in'] = '自動ログインを有効にする';

$lang['Error_login'] = 'アカウントが未承認またはユーザー名やパスワードが正しくありません';


//
// Index page
//
$lang['Index'] = 'Board Index';
$lang['No_Posts'] = '記事はありません';
$lang['No_forums'] = 'この掲示板にフォーラムはありません';

$lang['Private_Message'] = 'プライベートメッセージ';
$lang['Private_Messages'] = 'プライベートメッセージ';
$lang['Who_is_Online'] = 'オンラインデータ';

$lang['Mark_all_forums'] = 'すべてのフォーラムを既読にする';
$lang['Forums_marked_read'] = 'すべてのフォーラムを既読にしました';


//
// Viewforum
//
$lang['View_forum'] = 'フォーラムを表示';

$lang['Forum_not_exist'] = '選択したフォーラムはありません';
$lang['Reached_on_error'] = 'エラーが起きています';

$lang['Display_topics'] = '特定期間内のトピックを表示';
$lang['All_Topics'] = 'すべて';

$lang['Topic_Announcement'] = '<b>Announcement:</b>';
$lang['Topic_Sticky'] = '<b>Sticky:</b>';
$lang['Topic_Moved'] = '<b>Moved:</b>';
$lang['Topic_Poll'] = '<b>[ Poll ]</b>';

$lang['Mark_all_topics'] = 'すべてのトピックを既読にする';
$lang['Topics_marked_read'] = 'このフォーラムのトピックを既読にしました';

$lang['Rules_post_can'] = '新規投稿: <b>可</b>';
$lang['Rules_post_cannot'] = '新規投稿: <b>不可</b>';
$lang['Rules_reply_can'] = '返信投稿: <b>可</b>';
$lang['Rules_reply_cannot'] = '返信投稿: <b>不可</b>';
$lang['Rules_edit_can'] = '記事編集: <b>可</b>';
$lang['Rules_edit_cannot'] = '記事編集: <b>不可</b>';
$lang['Rules_delete_can'] = '記事削除: <b>可</b>';
$lang['Rules_delete_cannot'] = '記事削除: <b>不可</b>';
$lang['Rules_vote_can'] = '投票参加: <b>可</b>';
$lang['Rules_vote_cannot'] = '投票参加: <b>不可</b>';
$lang['Rules_moderate'] = '%sModerator CP%s'; // %s replaced by a href links, do not remove! 

$lang['No_topics_post_one'] = 'このフォーラムに記事はありません<br />このページの <b>新しいトピックを投稿</b> をクリックしてください';


//
// Viewtopic
//
$lang['View_topic'] = 'トピックを表示';

$lang['Guest'] = '未登録ユーザー';
$lang['Post_subject'] = '記事の件名';
$lang['View_next_topic'] = '次のトピックを表示';
$lang['View_previous_topic'] = '前のトピックを表示';
$lang['Submit_vote'] = '投票する';
$lang['View_results'] = '投票結果を表示';

$lang['No_newer_topics'] = 'このフォーラムに新しいトピックはありません';
$lang['No_older_topics'] = 'このフォーラムに古いトピックはありません';
$lang['Topic_post_not_exist'] = '要求したトピックまたは記事はありません';
$lang['No_posts_topic'] = 'このトピックに記事はありません';

$lang['Display_posts'] = '特定期間内の記事を表示';
$lang['All_Posts'] = 'すべて';
$lang['Newest_First'] = '新しい順';
$lang['Oldest_First'] = '古い順';

$lang['Back_to_top'] = 'トップに戻る';

$lang['Read_profile'] = 'ユーザーのプロフィールを表示'; 
//$lang['Send_email'] = 'ユーザーにメールを送信';
$lang['Visit_website'] = '投稿者のウェブサイトに移動';
$lang['ICQ_status'] = 'ICQ の状態';
$lang['Edit_delete_post'] = 'この記事を編集 / 削除';
$lang['View_IP'] = '投稿者の IP アドレスを表示';
//$lang['Delete_post'] = 'この記事を削除';

$lang['wrote'] = 'wrote'; // proceeds the username and is followed by the quoted text
$lang['Quote'] = 'Quote'; // comes before bbcode quote output.
$lang['Code'] = 'Code'; // comes before bbcode code output.

$lang['Edited_time_total'] = '最終編集者 %s [ %s ], 編集回数 %d 回'; // Last edited by me on 12 Oct 2001; edited 1 time in total
$lang['Edited_times_total'] = '最終編集者 %s [ %s ], 編集回数 %d 回'; // Last edited by me on 12 Oct 2001; edited 2 times in total

$lang['Lock_topic'] = 'このトピックを閉鎖';
$lang['Unlock_topic'] = 'このトピックを開放';
$lang['Move_topic'] = 'このトピックを移動';
$lang['Delete_topic'] = 'このトピックを削除';
$lang['Split_topic'] = 'このトピックを分割';

$lang['Stop_watching_topic'] = 'このトピックの監視を停止';
$lang['Start_watching_topic'] = 'このトピックの返信を監視';
$lang['No_longer_watching'] = 'このトピックの監視を停止しました';
$lang['You_are_watching'] = 'このトピックの監視を開始しました';

$lang['Total_votes'] = '投票数';

//
// Posting/Replying (Not private messaging!)
//
$lang['Message_body'] = 'メッセージの内容';
$lang['Topic_review'] = 'トピックのレビュー';

$lang['No_post_mode'] = '投稿モードの指定がありません'; // If posting.php is called without a mode (newtopic/reply/delete/etc, shouldn't be shown normaly)

$lang['Post_a_new_topic'] = '新しいトピックを投稿';
$lang['Post_a_reply'] = '返信を投稿';
$lang['Post_topic_as'] = 'トピックの種類';
$lang['Edit_Post'] = '記事を編集';
$lang['Options'] = 'オプション';

$lang['Post_Announcement'] = '告知トピック';
$lang['Post_Sticky'] = '注目トピック';
$lang['Post_Normal'] = '通常トピック';

$lang['Confirm_delete'] = 'この記事を削除しますか？';
$lang['Confirm_delete_poll'] = 'この投票を削除しますか？';

$lang['Flood_Error'] = '連続投稿は禁止です。少し時間をおいてください。';
$lang['Empty_subject'] = '件名を入力して新しいトピックを投稿してください';
$lang['Empty_message'] = 'メッセージを入力して投稿してください';
$lang['Forum_locked'] = 'このフォーラムは閉鎖されているので新規投稿 ･ 返信投稿 ･ 記事編集はできません';
$lang['Topic_locked'] = 'このトピックは閉鎖されているので記事編集または返信投稿はできません';
$lang['No_post_id'] = '編集する記事を選択してください';
$lang['No_topic_id'] = '返信するトピックを選択してください';
$lang['No_valid_mode'] = 'メッセージの新規投稿 ･ 返信投稿 ･ 記事編集 ･ 引用付き返信しかできません';
$lang['No_such_post'] = 'そのような記事はありません';
$lang['Edit_own_posts'] = '投稿した記事しか編集できません';
$lang['Delete_own_posts'] = '投稿した記事しか削除できません';
$lang['Cannot_delete_replied'] = '返信のついた記事は削除できません';
$lang['Cannot_delete_poll'] = '継続中の投票は削除できません';
$lang['Empty_poll_title'] = '投票のタイトルを入力してください';
$lang['To_few_poll_options'] = '投票オプションは 2 つ以上入力してください';
$lang['To_many_poll_options'] = '投票オプションが多すぎます';
$lang['Post_has_no_poll'] = 'この記事に投票はありません';
$lang['Already_voted'] = 'すでに投票しています';
$lang['No_vote_option'] = 'オプションを選択して投票してください';

$lang['Add_poll'] = '投票を追加';
$lang['Add_poll_explain'] = 'トピックに投票を追加しない場合は項目を空白のままにしてください。';
$lang['Poll_question'] = '投票のタイトル';
$lang['Poll_option'] = '投票オプション';
$lang['Add_option'] = 'オプションを追加';
$lang['Update'] = '更新';
$lang['Delete'] = '削除';
$lang['Poll_for'] = '投票期間';
$lang['Days'] = '日間'; // This is used for the Run poll for ... Days + in admin_forums for pruning
$lang['Poll_for_explain'] = '[ 投票期間無制限の場合は 0 を入力または空白のままにしてください ]';
$lang['Delete_poll'] = '投票を削除';

$lang['Disable_HTML_post'] = 'この記事の HTML を無効にする';
$lang['Disable_BBCode_post'] = 'この記事の BBCode を無効にする';
$lang['Disable_Smilies_post'] = 'この記事の Smilies を無効にする';

$lang['HTML_is_ON'] = 'HTML is <u>ON</u>';
$lang['HTML_is_OFF'] = 'HTML is <u>OFF</u>';
$lang['BBCode_is_ON'] = '%sBBCode%s is <u>ON</u>'; // %s are replaced with URI pointing to FAQ
$lang['BBCode_is_OFF'] = '%sBBCode%s is <u>OFF</u>';
$lang['Smilies_are_ON'] = 'Smilies are <u>ON</u>';
$lang['Smilies_are_OFF'] = 'Smilies are <u>OFF</u>';

$lang['Attach_signature'] = '署名を表示する (署名はプロフィールで変更できます)';
$lang['Notify'] = '返信が投稿されたら通知する';
$lang['Delete_post'] = 'この記事を削除する';

$lang['Stored'] = 'メッセージを投稿しました';
$lang['Deleted'] = 'メッセージを削除しました';
$lang['Poll_delete'] = '投票を削除しました';
$lang['Vote_cast'] = '投票をしました';

$lang['Topic_reply_notification'] = 'トピックの返信通知';

$lang['bbcode_b_help'] = '太字にする: [b]text[/b]  (alt+b)';
$lang['bbcode_i_help'] = '斜体にする: [i]text[/i]  (alt+i)';
$lang['bbcode_u_help'] = '下線を引く: [u]text[/u]  (alt+u)';
$lang['bbcode_q_help'] = '引用する: [quote]text[/quote]  (alt+q)';
$lang['bbcode_c_help'] = 'コード表示: [code]code[/code]  (alt+c)';
$lang['bbcode_l_help'] = 'リストの作成: [list]text[/list]  (alt+l)';
$lang['bbcode_o_help'] = '番号付きリストの作成: [list=]text[/list]  (alt+o)';
$lang['bbcode_p_help'] = '画像を挿入: [img]http://image_url[/img]  (alt+p)';
$lang['bbcode_w_help'] = 'URLを挿入: [url]http://url[/url] または [url=http://url]URL text[/url]  (alt+w)';
$lang['bbcode_a_help'] = 'BBCode の開始タグをすべて閉じる';
$lang['bbcode_s_help'] = '文字の色: [color=red]text[/color]  Tip: color=#FF0000 も使用可能です';
$lang['bbcode_f_help'] = '文字のサイズ: [size=x-small]small text[/size]';

$lang['Emoticons'] = 'Emoticons';
$lang['More_emoticons'] = 'すべて表示する';

$lang['Font_color'] = '文字の色';
$lang['color_default'] = '指定なし';
$lang['color_dark_red'] = 'Dark Red';
$lang['color_red'] = 'Red';
$lang['color_orange'] = 'Orange';
$lang['color_brown'] = 'Brown';
$lang['color_yellow'] = 'Yellow';
$lang['color_green'] = 'Green';
$lang['color_olive'] = 'Olive';
$lang['color_cyan'] = 'Cyan';
$lang['color_blue'] = 'Blue';
$lang['color_dark_blue'] = 'Dark Blue';
$lang['color_indigo'] = 'Indigo';
$lang['color_violet'] = 'Violet';
$lang['color_white'] = 'White';
$lang['color_black'] = 'Black';

$lang['Font_size'] = '文字のサイズ';
$lang['font_tiny'] = '7 px';
$lang['font_small'] = '9 px';
$lang['font_normal'] = '12 px';
$lang['font_large'] = '18 px';
$lang['font_huge'] = '24 px';

$lang['Close_Tags'] = 'タグを閉じる';
$lang['Styles_tip'] = 'Tip: 選択した文章に素早く適用されます';


//
// Private Messaging
//
$lang['Private_Messaging'] = 'プライベートメッセージ';

$lang['Login_check_pm'] = 'プライベートメッセージをチェックする';
$lang['New_pms'] = '新しいメッセージ %d 件'; // You have 2 new messages
$lang['New_pm'] = '新しいメッセージ %d 件'; // You have 1 new message
$lang['No_new_pm'] = '新しいメッセージはありません';
$lang['Unread_pms'] = '未読メッセージ %d 件';
$lang['Unread_pm'] = '未読メッセージ %d 件';
$lang['No_unread_pm'] = '未読メッセージはありません';
$lang['You_new_pm'] = '受信ボックスに新しいプライベートメッセージがあります';
$lang['You_new_pms'] = '受信ボックスに新しいプライベートメッセージがあります';
$lang['You_no_new_pm'] = '新しいプライベートメッセージはありません';

$lang['Unread_message'] = '未読メッセージ';
$lang['Read_message'] = '既読メッセージ';

$lang['Read_pm'] = 'メッセージを表示';
$lang['Post_new_pm'] = 'メッセージを送信';
$lang['Post_reply_pm'] = 'メッセージを返信';
$lang['Post_quote_pm'] = '引用付きでメッセージを返信';
$lang['Edit_pm'] = 'メッセージを編集';

$lang['Inbox'] = '受信ボックス';
$lang['Outbox'] = '送信ボックス';
$lang['Savebox'] = '保存ボックス';
$lang['Sentbox'] = '送信済みボックス';
$lang['Flag'] = '';
$lang['Subject'] = '件名';
$lang['From'] = '送信者';
$lang['To'] = '宛先';
$lang['Date'] = '日時';
$lang['Mark'] = '選択';
$lang['Sent'] = '送信済み';
$lang['Saved'] = '保存済み';
$lang['Delete_marked'] = '選択項目を削除';
$lang['Delete_all'] = 'すべて削除';
$lang['Save_marked'] = '選択項目を保存'; 
$lang['Save_message'] = 'メッセージを保存';
$lang['Delete_message'] = 'メッセージを削除';

$lang['Display_messages'] = '特定期間内のメッセージを表示'; // Followed by number of days/weeks/months
$lang['All_Messages'] = 'すべて';

$lang['No_messages_folder'] = 'このフォルダにメッセージはありません';

$lang['PM_disabled'] = 'プライベートメッセージはこの掲示板で利用できません';
$lang['Cannot_send_privmsg'] = 'プライベートメッセージの利用を禁止されています';
$lang['No_to_user'] = 'ユーザー名を入力してこのメッセージを送信してください';
$lang['No_such_user'] = 'そのようなユーザーはいません';

$lang['Disable_HTML_pm'] = 'このメッセージの HTML を無効にする';
$lang['Disable_BBCode_pm'] = 'このメッセージの BBCode を無効にする';
$lang['Disable_Smilies_pm'] = 'このメッセージの Smilies を無効にする';

$lang['Message_sent'] = 'メッセージを送信しました';

$lang['Click_return_inbox'] = '受信ボックスに戻る場合は %sこちら%s をクリックしてください';
$lang['Click_return_index'] = '掲示板に戻る場合は %sこちら%s をクリックしてください';

$lang['Send_a_new_message'] = '新しいプライベートメッセージを送信';
$lang['Send_a_reply'] = 'プライベートメッセージを返信';
$lang['Edit_message'] = 'プライベートメッセージを編集';

$lang['Notification_subject'] = '新しいプライベートメッセージが届きました！';

$lang['Find_username'] = '検索';
$lang['Find'] = '検索';
$lang['No_match'] = '見つかりませんでした';

$lang['No_post_id'] = '記事 ID の指定がありません';
$lang['No_such_folder'] = 'そのようなフォルダはありません';
$lang['No_folder'] = '指定されたフォルダはありません';

$lang['Mark_all'] = 'すべて選択';
$lang['Unmark_all'] = 'すべての選択を解除';

$lang['Confirm_delete_pm'] = 'このメッセージを削除しますか？';
$lang['Confirm_delete_pms'] = 'これらのメッセージを削除しますか？';

$lang['Inbox_size'] = '受信ボックスの容量: %d%% 使用'; // eg. Your Inbox is 50% full
$lang['Sentbox_size'] = '送信済みボックスの容量: %d%% 使用'; 
$lang['Savebox_size'] = '保存ボックスの容量: %d%% 使用'; 

$lang['Click_view_privmsg'] = '受信ボックスに移動する場合は %sこちら%s をクリックしてください';


//
// Profiles/Registration
//
$lang['Viewing_user_profile'] = 'プロフィールを表示 :: %s'; // %s is username 
$lang['About_user'] = '詳細データ [ %s ]'; // %s is username

$lang['Preferences'] = '設定オプション';
$lang['Items_required'] = '* 印の項目で特に明記されていない場合は必須項目です。';
$lang['Registration_info'] = '登録情報';
$lang['Profile_info'] = 'プロフィール情報';
$lang['Profile_info_warn'] = 'この情報は公開されます。';
$lang['Avatar_panel'] = 'Avatar CP';
$lang['Avatar_gallery'] = 'アバターのギャラリー';

$lang['Website'] = 'ウェブサイト';
$lang['Location'] = '所在地';
$lang['Contact'] = '連絡先 -';
$lang['Email_address'] = 'メールアドレス';
//$lang['Email'] = 'メール';
$lang['Send_private_message'] = 'プライベートメッセージを送信';
$lang['Hidden_email'] = '[ 非公開 ]';
//$lang['Search_user_posts'] = 'このユーザーの記事を検索';
$lang['Interests'] = '趣味';
$lang['Occupation'] = '職業'; 
$lang['Poster_rank'] = '投稿者のランク';

$lang['Total_posts'] = '投稿数';
$lang['User_post_pct_stats'] = '投稿数の割合: %.2f%%'; // 1.25% of total
$lang['User_post_day_stats'] = '1 日当たりの投稿数: %.2f 件'; // 1.5 posts per day
$lang['Search_user_posts'] = '%s の記事をすべて検索'; // Find all posts by username

$lang['No_user_id_specified'] = 'そのユーザーはいません';
$lang['Wrong_Profile'] = '他のユーザーのプロフィールは編集できません';

$lang['Only_one_avatar'] = 'アバターは複数選択できません';
$lang['File_no_data'] = '指定したURLのファイルにデータはありません';
$lang['No_connection_URL'] = '指定したURLにアクセスできません';
$lang['Incomplete_URL'] = '入力したURLが正しくありません';
$lang['Wrong_remote_avatar_format'] = 'リンク先アバターのURLが正しくありません';
$lang['No_send_account_inactive'] = '現在アカウントが未承認のためパスワードを検索できませんでした。詳細についてはフォーラムの管理者にご連絡ください。';

$lang['Always_smile'] = 'Smilies を常に有効にする';
$lang['Always_html'] = 'HTML を常に有効にする';
$lang['Always_bbcode'] = 'BBCode を常に有効にする';
$lang['Always_add_sig'] = '署名を常に表示する';
$lang['Always_notify'] = '返信を常に通知する';
$lang['Always_notify_explain'] = '投稿したトピックに誰かが返信をすると通知メールが届きます。投稿時にいつでも変更できます。';

$lang['Board_style'] = '掲示板のスタイル';
$lang['Board_lang'] = '掲示板の言語';
$lang['No_themes'] = 'データベースにテーマはありません';
$lang['Timezone'] = 'タイムゾーン';
$lang['Date_format'] = '日付のフォーマット';
$lang['Date_format_explain'] = '使用されるシンタックスは PHP <a href=\'http://www.php.net/date\' target=\'_other\'>date()</a> 関数と同じです。';
$lang['Signature'] = '署名';
$lang['Signature_explain'] = '投稿記事に追加できるテキストブロックです。文字制限は %d 文字です。';
$lang['Public_view_email'] = 'メールアドレスを常に表示する';

$lang['Current_password'] = '現在のパスワード';
$lang['New_password'] = '新しいパスワード';
$lang['Confirm_password'] = 'パスワードの確認';
$lang['Confirm_password_explain'] = 'パスワードまたはメールアドレスを変更する場合は現在のパスワードの確認が必要です。';
$lang['password_if_changed'] = 'パスワードを変更する場合のみパスワードを入力してください。';
$lang['password_confirm_if_changed'] = '上記でパスワードを変更する場合のみパスワードの確認が必要です。';

$lang['Avatar'] = 'アバター';
$lang['Avatar_explain'] = '投稿記事の詳細データに小さなグラフィックイメージを表示します。同時に複数の画像は表示できません。画像の範囲は %d x %d pixels, %d KB 以内です。';
$lang['Upload_Avatar_file'] = 'ローカルマシンからアバターをアップロード';
$lang['Upload_Avatar_URL'] = 'URLからアバターをアップロード';
$lang['Upload_Avatar_URL_explain'] = 'アバター画像のURLを入力してください。このサイトにコピーされます。';
$lang['Pick_local_Avatar'] = 'ギャラリーからアバターを選択';
$lang['Link_remote_Avatar'] = '他のサイトのアバターにリンク';
$lang['Link_remote_Avatar_explain'] = 'リンクしたいアバター画像のURLを入力してください。';
$lang['Avatar_URL'] = 'アバター画像のURL';
$lang['Select_from_gallery'] = 'ギャラリーからアバターを選択';
$lang['View_avatar_gallery'] = 'ギャラリーを表示';

$lang['Select_avatar'] = 'アバターを選択';
$lang['Return_profile'] = 'アバターをキャンセル';
$lang['Select_category'] = 'カテゴリーを選択';

$lang['Delete_Image'] = '画像を削除';
$lang['Current_Image'] = '現在の画像';

$lang['Notify_on_privmsg'] = '新しいプライベートメッセージを通知する';
$lang['Popup_on_privmsg'] = 'ポップアップウィンドウで通知する'; 
$lang['Popup_on_privmsg_explain'] = 'テンプレートの中には新しいプライベートメッセージが届くと新しいウィンドウを開いて通知するものがあります。';
$lang['Hide_user'] = 'オンラインの状態を隠す';

$lang['Profile_updated'] = 'プロフィールを更新しました';
$lang['Profile_updated_inactive'] = 'プロフィールを更新しましたが必須項目の情報を変更をしたのでアカウントが未承認になりました。メールを確認してアカウントを復活するかまたは管理者の承認が必要な場合は管理者がアカウントを復活させるまでお待ちください。';

$lang['Password_mismatch'] = '入力したパスワードは一致しませんでした';
$lang['Current_password_mismatch'] = '供給されたパスワードはデータベースに格納されているパスワードと一致しませんでした';
$lang['Password_long'] = 'パスワードは 32 文字以内にしてください';
//$lang['Too_many_registers'] = '登録に失敗したのでもう一度試してください';
$lang['Username_taken'] = 'このユーザー名はすでに使用されています';
$lang['Username_invalid'] = 'ユーザー名に \' のような使用できない文字があります';
$lang['Username_disallowed'] = 'このユーザー名は使用できません';
$lang['Email_taken'] = 'そのメールアドレスはすでにユーザーに登録されています';
$lang['Email_banned'] = 'このメールアドレスは使用できません';
$lang['Email_invalid'] = 'このメールアドレスは正しくありません';
$lang['Signature_too_long'] = '署名が長すぎます';
$lang['Fields_empty'] = '必須項目をすべて入力してください';
$lang['Avatar_filetype'] = 'アバターの拡張子は .jpg, .gif, .png です';
$lang['Avatar_filesize'] = 'アバター画像のファイルサイズは %d KB 以内です'; // The avatar image file size must be less than 6 KB
$lang['Avatar_imagesize'] = 'アバターは %d x %d pixels 以内です'; 

$lang['Welcome_subject'] = 'Welcome to %s Forums'; // Welcome to my.com forums
$lang['New_account_subject'] = '新しいユーザーアカウント';
$lang['Account_activated_subject'] = 'アカウントが承認されました';

$lang['Account_added'] = 'ご登録ありがとうございます。アカウントが作成されましたのでユーザー名とパスワードを使ってログインしてください。';
$lang['Account_inactive'] = 'アカウントが作成されましたがアカウントの承認が必要です。ご登録いただいたメールアドレスにアクティベーションキーを送信しましたので詳細についてはそちらをご覧ください。';
$lang['Account_inactive_admin'] = 'アカウントが作成されましたが管理者の承認が必要です。アカウントの承認が完了しましたらその旨をご登録いただいたメールアドレスにてお知らせいたします。';
$lang['Account_active'] = 'アカウントを承認しました。ご登録ありがとうございました。';
$lang['Account_active_admin'] = 'アカウントを承認しました';
$lang['Reactivate'] = 'アカウントを復活してください！';
$lang['Already_activated'] = 'アカウントはすでに承認されています';
$lang['COPPA'] = 'アカウントが作成されましたが承認が必要です。詳細についてはメールをご覧ください。';

$lang['Registration'] = '登録に関する規約';
//$lang['Reg_agreement'] = 'While the administrators and moderators of this forum will attempt to remove or edit any generally objectionable material as quickly as possible, it is impossible to review every message. Therefore you acknowledge that all posts made to these forums express the views and opinions of the author and not the administrators, moderators or webmaster (except for posts by these people) and hence will not be held liable.<br /><br />You agree not to post any abusive, obscene, vulgar, slanderous, hateful, threatening, sexually-oriented or any other material that may violate any applicable laws. Doing so may lead to you being immediately and permanently banned (and your service provider being informed). The IP address of all posts is recorded to aid in enforcing these conditions. You agree that the webmaster, administrator and moderators of this forum have the right to remove, edit, move or close any topic at any time should they see fit. As a user you agree to any information you have entered above being stored in a database. While this information will not be disclosed to any third party without your consent the webmaster, administrator and moderators cannot be held responsible for any hacking attempt that may lead to the data being compromised.<br /><br />This forum system uses cookies to store information on your local computer. These cookies do not contain any of the information you have entered above; they serve only to improve your viewing pleasure. The e-mail address is used only for confirming your registration details and password (and for sending new passwords should you forget your current one).<br /><br />By clicking Register below you agree to be bound by these conditions.';
$lang['Reg_agreement'] = "掲示板の管理者とモデレーターは、不適切な記事を発見次第削除/編集するように心がけますが、全ての記事に目を通すことはできません。そのため、この掲示板に投稿される全ての記事はその投稿者の視点と意見を表現するものであり、掲示板管理者、モデレーター、サイト管理者の視点と意見を表現するものではなく、管理人は記事に対する責任を一切負いません（掲示板管理者、モデレーター、サイト管理者自身の記事は除く）。<br /><br />口汚い記事、猥褻な言葉、品性を欠く記事、他人を中傷する記事、嫌悪感を与える記事、脅迫的な記事、性的差別につながる記事、法律を違反する記事の投稿は禁止します。この規約を破った場合は、対象ユーザーのアカウント停止が即座に行われます（場合によっては対象ユーザーのプロバイダーに報告されます）。このような処置を実行するために、全ての記事のIPアドレスが記録されています。掲示板管理者、モデレーター、サイト管理者は、自らの判断で掲示板の如何なる記事を削除、編集、移動、ロックする権限があります。あなたが掲示板上で入力した情報をデータベースに保管されます。あなたの同意がない限り、この情報は第三者に公開されることはありませんが、ハッキング等によるデータの損傷や盗難があった場合は掲示板管理者、モデレーター、サイト管理者はその責任を一切負いません。<br /><br />この掲示板では、あなたのローカル・コンピューターに情報を保管するためにCookieを使用しています。このCookieは、掲示板の使い勝手の向上させるための情報しか含まれません。メールアドレスは、登録したアカウントの詳細とパスワードを確認するためにだけ使われます（現在のパスワードを忘れた場合、パスワードを再発行する場合にも使われます）。<br /><br />登録を続ける場合は、これらの規約に同意したものと見なされます。";

$lang['Agree_under_13'] = 'これらの規約に同意します [ 13 歳<b>未満</b> ]';
//$lang['Agree_over_13'] = 'これらの規約に同意します [ 13 歳<b>以上</b> ]';
$lang['Agree_over_13'] = 'これらの規約に同意します';
$lang['Agree_not'] = 'これらの規約に同意しません';

$lang['Wrong_activation'] = '供給されたアクティベーションキーはデータベースのものと一致しませんでした';
$lang['Send_password'] = '新しいパスワードを再発行'; 
$lang['Password_updated'] = '新しいパスワードを発行しました。メールを確認して新しいパスワードの承認をしてください。';
$lang['No_email_match'] = '供給されたメールアドレスはそのユーザー名のものと一致しませんでした';
$lang['New_password_activation'] = '新しいパスワードの承認';
$lang['Password_activated'] = 'アカウントを復活しました。受け取ったメールに書かれているパスワードを使ってログインしてください。';

$lang['Send_email_msg'] = 'メッセージをメールで送信';
$lang['No_user_specified'] = 'ユーザーの指定がありません';
$lang['User_prevent_email'] = 'このユーザーはメールの受信を有効にしていません。プライベートメッセージを送信してみてください。';
$lang['User_not_exist'] = 'そのユーザーはいません';
$lang['CC_email'] = '自分にもこのメールのコピーを送信';
$lang['Email_message_desc'] = 'このメッセージはプレーンテキストで送信されますので HTML または BBCode を使用しないでください。このメッセージの返信先アドレスはメールアドレスに設定されます。';
$lang['Flood_email_limit'] = '現在メールを送信することができません';
$lang['Recipient'] = '宛先';
$lang['Email_sent'] = 'メールを送信しました';
$lang['Send_email'] = 'メールを送信';
$lang['Empty_subject_email'] = 'メールの件名を入力してください';
$lang['Empty_message_email'] = 'メールのメッセージを入力してください';


//
// Visual confirmation system strings
//
$lang['Confirm_code_wrong'] = '入力した確認コードが正しくありません';
$lang['Too_many_registers'] = 'このセッションの登録数が超過しました';
$lang['Confirm_code_impaired'] = '視覚障害の方またはコードが読めない方は %s管理者%s にご連絡ください。';
$lang['Confirm_code'] = '確認コード';
$lang['Confirm_code_explain'] = '表示されたコードを正確に入力してください。数字の 0 [ ゼロ ] には対角線が入っていますのでコードを注意をして見てください';



//
// Memberslist
//
$lang['Select_sort_method'] = '分類方法を選択';
$lang['Sort'] = '送信';
$lang['Sort_Top_Ten'] = '投稿者 TOP 10';
$lang['Sort_Joined'] = '登録日';
$lang['Sort_Username'] = 'ユーザー名';
$lang['Sort_Location'] = '所在地';
$lang['Sort_Posts'] = '投稿数';
$lang['Sort_Email'] = 'メール';
$lang['Sort_Website'] = 'ウェブサイト';
$lang['Sort_Ascending'] = '昇順';
$lang['Sort_Descending'] = '降順';
$lang['Order'] = '並び順';


//
// Group control panel
//
$lang['Group_Control_Panel'] = 'Group CP';
$lang['Group_member_details'] = 'グループメンバーシップの詳細';
$lang['Group_member_join'] = 'グループに参加';

$lang['Group_Information'] = 'グループの情報';
$lang['Group_name'] = 'グループの名前';
$lang['Group_description'] = 'グループの説明';
$lang['Group_membership'] = 'グループのメンバーシップ';
$lang['Group_Members'] = 'グループのメンバー';
$lang['Group_Moderator'] = 'グループのモデレーター';
$lang['Pending_members'] = '保留中のメンバー';

$lang['Group_type'] = 'グループの種類';
$lang['Group_open'] = '公開グループ';
$lang['Group_closed'] = '閉鎖グループ';
$lang['Group_hidden'] = '非公開グループ';

$lang['Current_memberships'] = '現在のメンバーシップ';
$lang['Non_member_groups'] = '非メンバーグループ';
$lang['Memberships_pending'] = '保留中のメンバーシップ';

$lang['No_groups_exist'] = 'グループはありません';
$lang['Group_not_exist'] = 'そのユーザーグループはありません';

$lang['Join_group'] = 'グループに参加';
$lang['No_group_members'] = 'このグループにメンバーはいません';
$lang['Group_hidden_members'] = 'このグループは非公開なのでメンバーシップを公開できません';
$lang['No_pending_group_members'] = 'このグループに保留中メンバーはいません';
$lang['Group_joined'] = 'このグループへの参加を申し込みました<br />グループのモデレーターが申し込みを承認したらその旨をお知らせします';
$lang['Group_request'] = 'グループ参加の申し込みがあります';
$lang['Group_approved'] = 'グループ参加を承認されました';
$lang['Group_added'] = 'グループに追加されました'; 
$lang['Already_member_group'] = 'すでにこのグループのメンバーになっています';
$lang['User_is_member_group'] = 'ユーザーはすでにこのグループのメンバーです';
$lang['Group_type_updated'] = 'グループの種類を更新しました';

$lang['Could_not_add_user'] = '選択したユーザーはいません';
$lang['Could_not_anon_user'] = '匿名ユーザーをグループのメンバーにはできません';

$lang['Confirm_unsub'] = 'このグループへの参加の申し込みを破棄しますか？';
$lang['Confirm_unsub_pending'] = 'このグループへの参加はまだ承認されていません。申し込みを破棄しますか？';

$lang['Unsub_success'] = 'このグループから脱退しました';

$lang['Approve_selected'] = '選択したものを承認';
$lang['Deny_selected'] = '選択したものを拒否';
$lang['Not_logged_in'] = 'グループへの参加はログインが必要です';
$lang['Remove_selected'] = '選択したものを削除';
$lang['Add_member'] = 'メンバーを追加';
$lang['Not_group_moderator'] = 'このグループのモデレータしか実行できません';

$lang['Login_to_join'] = 'グループへの参加またはメンバーシップの管理はログインが必要です';
$lang['This_open_group'] = '公開グループ [ 申し込む場合はクリックしてください ]';
$lang['This_closed_group'] = '閉鎖グループ [ メンバーの参加はできません ]';
$lang['This_hidden_group'] = '非公開グループ [ 自動的にユーザーが申し込みできません ]';
$lang['Member_this_group'] = 'このグループのメンバーです';
$lang['Pending_this_group'] = 'このグループの保留中メンバーです';
$lang['Are_group_moderator'] = 'グループのモデレーターです';
$lang['None'] = 'None';

$lang['Subscribe'] = '参加の申し込み';
$lang['Unsubscribe'] = '申し込みを破棄';
$lang['View_Information'] = '情報を表示';


//
// Search
//
$lang['Search_query'] = '検索条件';
$lang['Search_options'] = '検索オプション';

$lang['Search_keywords'] = 'キーワード検索';
$lang['Search_keywords_explain'] = '検索には <u>AND</u> [ すべてのキーワードを含む ], <u>OR</u> [ 一つ以上のキーワードを含む ], <u>NOT</u> [ キーワードを含まない ] などが使用できます。部分一致検索には * [ ワイルドカード ] を使用してください。';
$lang['Search_author'] = '投稿者検索';
$lang['Search_author_explain'] = '部分一致検索には * [ ワイルドカード ] を使用してください。';

$lang['Search_for_any'] = 'すべての単語を検索またはクエリ検索';
$lang['Search_for_all'] = 'すべての単語を検索';
$lang['Search_title_msg'] = 'トピックの件名とメッセージの内容を検索';
$lang['Search_msg_only'] = 'メッセージ内容のみ検索';

$lang['Return_first'] = '表示文字数'; // followed by xxx characters in a select box
$lang['characters_posts'] = '文字';

$lang['Search_previous'] = '特定期間内の記事を検索'; // followed by days, weeks, months, year, all in a select box

$lang['Sort_by'] = '分類方法';
$lang['Sort_Time'] = '投稿時間';
$lang['Sort_Post_Subject'] = '記事の件名';
$lang['Sort_Topic_Title'] = 'トピックの件名';
$lang['Sort_Author'] = '投稿者';
$lang['Sort_Forum'] = 'フォーラム';

$lang['Display_results'] = '検索結果の表示';
$lang['All_available'] = 'すべて';
$lang['No_searchable_forums'] = 'このサイトのフォーラムは検索できません';

$lang['No_search_match'] = '検索条件に一致するトピックまたは記事はありません';
$lang['Found_search_match'] = '検索結果 %d 件'; // eg. Search found 1 match
$lang['Found_search_matches'] = '検索結果 %d 件'; // eg. Search found 24 matches

// Search Flood Control - added 2.0.20
$lang['Search_Flood_Error'] = '検索してから直後に別の検索はできません。しばらく（ほんの数秒）経過してから再び試みてください。';

$lang['Close_window'] = 'ウィンドウを閉じる';


//
// Auth related entries
//
// Note the %s will be replaced with one of the following 'user' arrays
$lang['Sorry_auth_announce'] = 'このフォーラムでは %s しか告知トピックを投稿できません';
$lang['Sorry_auth_sticky'] = 'このフォーラムでは %s しか注目トピックを投稿できません'; 
$lang['Sorry_auth_read'] = 'このフォーラムでは %s しかトピックを表示できません'; 
$lang['Sorry_auth_post'] = 'このフォーラムでは %s しかトピックを投稿できません'; 
$lang['Sorry_auth_reply'] = 'このフォーラムでは %s しか記事に返信できません';
$lang['Sorry_auth_edit'] = 'このフォーラムでは %s しか記事を編集できません'; 
$lang['Sorry_auth_delete'] = 'このフォーラムでは %s しか記事を削除できません';
$lang['Sorry_auth_vote'] = 'このフォーラムでは %s しか投票に参加できません';

// These replace the %s in the above strings
$lang['Auth_Anonymous_Users'] = '<b>匿名ユーザー</b>';
$lang['Auth_Registered_Users'] = '<b>登録ユーザー</b>';
$lang['Auth_Users_granted_access'] = '<b>特別ユーザー</b>';
$lang['Auth_Moderators'] = '<b>モデレーター</b>';
$lang['Auth_Administrators'] = '<b>管理者</b>';

$lang['Not_Moderator'] = 'このフォーラムのモデレーターではありません';
$lang['Not_Authorised'] = '許可されていません';

$lang['You_been_banned'] = 'このフォーラムの使用を禁止されました<br />詳細についてはウェブマスターまたは掲示板の管理者にご連絡ください';


//
// Viewonline
//
$lang['Reg_users_zero_online'] = '登録ユーザー [0], '; // There are 5 Registered and
$lang['Reg_users_online'] = '登録ユーザー [%d], '; // There are 5 Registered and
$lang['Reg_user_online'] = '登録ユーザー [%d], '; // There is 1 Registered and
$lang['Hidden_users_zero_online'] = 'お忍びユーザー [0]'; // 6 Hidden users online
$lang['Hidden_users_online'] = 'お忍びユーザー [%d]'; // 6 Hidden users online
$lang['Hidden_user_online'] = 'お忍びユーザー [%d]'; // 6 Hidden users online
$lang['Guest_users_online'] = '未登録ユーザー [%d]'; // There are 10 Guest users online
$lang['Guest_users_zero_online'] = '未登録ユーザー [0]'; // There are 10 Guest users online
$lang['Guest_user_online'] = '未登録ユーザー [%d]'; // There is 1 Guest user online
$lang['No_users_browsing'] = '現在このフォーラムを表示中のユーザーはいません';

$lang['Online_explain'] = 'これは過去 5 分間にユーザーが取った行動を基にしたデータです';

$lang['Forum_Location'] = '現在地';
$lang['Last_updated'] = '最終更新';

$lang['Forum_index'] = 'Forum Index を表示中';
$lang['Logging_on'] = 'ログイン中';
$lang['Posting_message'] = 'メッセージを投稿中';
$lang['Searching_forums'] = 'フォーラムを検索中';
$lang['Viewing_profile'] = 'プロフィールを表示中';
$lang['Viewing_online'] = 'オンラインデータを表示中';
$lang['Viewing_member_list'] = 'メンバーリストを表示中';
$lang['Viewing_priv_msgs'] = 'プライベートメッセージを表示中';
$lang['Viewing_FAQ'] = 'FAQ を表示中';


//
// Moderator Control Panel
//
$lang['Mod_CP'] = 'Moderator CP';
$lang['Mod_CP_explain'] = 'このフォーラムのトピックをまとめて操作 [ 閉鎖 ･ 開放 ･ 移動 ･ 削除 ] できます。';

$lang['Select'] = '選択';
$lang['Delete'] = '削除';
$lang['Move'] = '移動';
$lang['Lock'] = '閉鎖';
$lang['Unlock'] = '開放';

$lang['Topics_Removed'] = '選択したトピックを削除しました';
$lang['Topics_Locked'] = '選択したトピックを閉鎖しました';
$lang['Topics_Moved'] = '選択したトピックを移動しました';
$lang['Topics_Unlocked'] = '選択したトピックを開放しました';
$lang['No_Topics_Moved'] = 'トピックを移動できません';

$lang['Confirm_delete_topic'] = '選択したトピックを削除しますか？';
$lang['Confirm_lock_topic'] = '選択したトピックを閉鎖しますか？';
$lang['Confirm_unlock_topic'] = '選択したトピックを開放しますか？';
$lang['Confirm_move_topic'] = '選択したトピックを移動しますか？';

$lang['Move_to_forum'] = '移動先';
$lang['Leave_shadow_topic'] = '現在のフォーラムにシャドウトピックを残す';

$lang['Split_Topic'] = 'Split Topic CP';
$lang['Split_Topic_explain'] = '選択した記事を分割または選択した記事から分割してトピックを分けることができます。';
$lang['Split_title'] = '新しいトピックの件名';
$lang['Split_forum'] = '新しいトピックの移動先';
$lang['Split_posts'] = '選択した記事を分割';
$lang['Split_after'] = '選択した記事から分割';
$lang['Topic_split'] = '選択したトピックを分割しました';

$lang['Too_many_error'] = '記事を選択しすぎです。複数選択しなくてもそれ以降の記事をまとめてトピックに分割できます！';

$lang['None_selected'] = '実行するトピックを選択してください';
$lang['New_forum'] = '新しいフォーラム';

$lang['This_posts_IP'] = 'この記事の IP アドレス';
$lang['Other_IP_this_user'] = 'このユーザーが投稿したときに使用した他の IP アドレス';
$lang['Users_this_IP'] = 'この IP アドレスから投稿したユーザー';
$lang['IP_info'] = 'IP 情報';
$lang['Lookup_IP'] = 'IP アドレスを調べる';


//
// Timezones ... for display on each page
//
$lang['All_times'] = 'All times are %s'; // eg. All times are GMT - 12 Hours (times from next block)

$lang['-12'] = 'GMT - 12 Hours';
$lang['-11'] = 'GMT - 11 Hours';
$lang['-10'] = 'GMT - 10 Hours';
$lang['-9'] = 'GMT - 9 Hours';
$lang['-8'] = 'GMT - 8 Hours';
$lang['-7'] = 'GMT - 7 Hours';
$lang['-6'] = 'GMT - 6 Hours';
$lang['-5'] = 'GMT - 5 Hours';
$lang['-4'] = 'GMT - 4 Hours';
$lang['-3.5'] = 'GMT - 3.5 Hours';
$lang['-3'] = 'GMT - 3 Hours';
$lang['-2'] = 'GMT - 2 Hours';
$lang['-1'] = 'GMT - 1 Hours';
$lang['0'] = 'GMT';
$lang['1'] = 'GMT + 1 Hour';
$lang['2'] = 'GMT + 2 Hours';
$lang['3'] = 'GMT + 3 Hours';
$lang['3.5'] = 'GMT + 3.5 Hours';
$lang['4'] = 'GMT + 4 Hours';
$lang['4.5'] = 'GMT + 4.5 Hours';
$lang['5'] = 'GMT + 5 Hours';
$lang['5.5'] = 'GMT + 5.5 Hours';
$lang['6'] = 'GMT + 6 Hours';
$lang['6.5'] = 'GMT + 6.5 Hours';
$lang['7'] = 'GMT + 7 Hours';
$lang['8'] = 'GMT + 8 Hours';
$lang['9'] = 'GMT + 9 Hours';
$lang['9.5'] = 'GMT + 9.5 Hours';
$lang['10'] = 'GMT + 10 Hours';
$lang['11'] = 'GMT + 11 Hours';
$lang['12'] = 'GMT + 12 Hours';
$lang['13'] = 'GMT + 13 Hours';

// These are displayed in the timezone select box
$lang['tz']['-12'] = 'GMT - 12 Hours';
$lang['tz']['-11'] = 'GMT - 11 Hours';
$lang['tz']['-10'] = 'GMT - 10 Hours';
$lang['tz']['-9'] = 'GMT - 9 Hours';
$lang['tz']['-8'] = 'GMT - 8 Hours';
$lang['tz']['-7'] = 'GMT - 7 Hours';
$lang['tz']['-6'] = 'GMT - 6 Hours';
$lang['tz']['-5'] = 'GMT - 5 Hours';
$lang['tz']['-4'] = 'GMT - 4 Hours';
$lang['tz']['-3.5'] = 'GMT - 3.5 Hours';
$lang['tz']['-3'] = 'GMT - 3 Hours';
$lang['tz']['-2'] = 'GMT - 2 Hours';
$lang['tz']['-1'] = 'GMT - 1 Hours';
$lang['tz']['0'] = 'GMT';
$lang['tz']['1'] = 'GMT + 1 Hour';
$lang['tz']['2'] = 'GMT + 2 Hours';
$lang['tz']['3'] = 'GMT + 3 Hours';
$lang['tz']['3.5'] = 'GMT + 3.5 Hours';
$lang['tz']['4'] = 'GMT + 4 Hours';
$lang['tz']['4.5'] = 'GMT + 4.5 Hours';
$lang['tz']['5'] = 'GMT + 5 Hours';
$lang['tz']['5.5'] = 'GMT + 5.5 Hours';
$lang['tz']['6'] = 'GMT + 6 Hours';
$lang['tz']['6.5'] = 'GMT + 6.5 Hours';
$lang['tz']['7'] = 'GMT + 7 Hours';
$lang['tz']['8'] = 'GMT + 8 Hours';
$lang['tz']['9'] = 'GMT + 9 Hours [ 東京 ･ 大阪 ･ 札幌 ]';
$lang['tz']['9.5'] = 'GMT + 9.5 Hours';
$lang['tz']['10'] = 'GMT + 10 Hours';
$lang['tz']['11'] = 'GMT + 11 Hours';
$lang['tz']['12'] = 'GMT + 12 Hours';
$lang['tz']['13'] = 'GMT + 13 Hours';

$lang['datetime']['Sunday'] = 'Sunday';
$lang['datetime']['Monday'] = 'Monday';
$lang['datetime']['Tuesday'] = 'Tuesday';
$lang['datetime']['Wednesday'] = 'Wednesday';
$lang['datetime']['Thursday'] = 'Thursday';
$lang['datetime']['Friday'] = 'Friday';
$lang['datetime']['Saturday'] = 'Saturday';
$lang['datetime']['Sun'] = 'Sun';
$lang['datetime']['Mon'] = 'Mon';
$lang['datetime']['Tue'] = 'Tue';
$lang['datetime']['Wed'] = 'Wed';
$lang['datetime']['Thu'] = 'Thu';
$lang['datetime']['Fri'] = 'Fri';
$lang['datetime']['Sat'] = 'Sat';
$lang['datetime']['January'] = 'January';
$lang['datetime']['February'] = 'February';
$lang['datetime']['March'] = 'March';
$lang['datetime']['April'] = 'April';
$lang['datetime']['May'] = 'May';
$lang['datetime']['June'] = 'June';
$lang['datetime']['July'] = 'July';
$lang['datetime']['August'] = 'August';
$lang['datetime']['September'] = 'September';
$lang['datetime']['October'] = 'October';
$lang['datetime']['November'] = 'November';
$lang['datetime']['December'] = 'December';
$lang['datetime']['Jan'] = 'Jan';
$lang['datetime']['Feb'] = 'Feb';
$lang['datetime']['Mar'] = 'Mar';
$lang['datetime']['Apr'] = 'Apr';
$lang['datetime']['May'] = 'May';
$lang['datetime']['Jun'] = 'Jun';
$lang['datetime']['Jul'] = 'Jul';
$lang['datetime']['Aug'] = 'Aug';
$lang['datetime']['Sep'] = 'Sep';
$lang['datetime']['Oct'] = 'Oct';
$lang['datetime']['Nov'] = 'Nov';
$lang['datetime']['Dec'] = 'Dec';

//
// Errors (not related to a
// specific failure on a page)
//
$lang['Information'] = 'Information';
$lang['Critical_Information'] = 'Critical Information';

$lang['General_Error'] = 'General Error';
$lang['Critical_Error'] = 'Critical Error';
$lang['An_error_occured'] = 'An Error Occurred';
$lang['A_critical_error'] = 'A Critical Error Occurred';
$lang['Admin_reauthenticate'] = 'ACP に入室するためには、あなた自身を再確証しなければなりません';

$lang['Login_attempts_exceeded'] = 'ログイン試行回数が最大である %s を超過しました。あなたは現在から %s 分間はログインすることができません。';
$lang['Please_remove_install_contrib'] = 'install/ および contrib/ の両方のフォルダが削除されているか確認してください。';

$lang['Session_invalid'] = '無効なセッションです。フォームを再送信してください。';


//
// That's all, Folks!
// -------------------------------------------------

?>