<?php
/* vim: set tabstop=4 shiftwidth=4: */

/*
 * Object (the root class of all classes)
 * (based on java.lang.Object)
 *
 *
 * PHP version 5
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   PHP
 * @package    Commons
 * @author     Yomei Komiya
 * @copyright  2007 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    SVN: $Id: Object.php 90 2008-01-04 05:18:05Z whitestar $
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      File available since Release 0.8.0
 */

//namespace Commons::Lang;

require_once 'Commons/Lang/System.php';
/*
use Commons::Lang::System;
*/

/**
 * Object
 *
 *
 * @category   PHP
 * @package    Commons.Lang
 * @author     Yomei Komiya
 * @copyright  2007 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    Release: 0.8.0
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      Class available since Release 0.8.0
 */
class Commons_Lang_Object {
//class Object {
	
	/**
	 * Constructor
	 */
	public function Commons_Lang_Object() {
		// do nothing.
	}
	
	
	/**
	 * Destructor
	 */
	public function __destruct() {
		// do nothing.
	}
	
	
	/**
	 * Equality test.
	 * Default implementatio is object identity test.
	 *
	 * @param object $obj other object
	 * @return bool true if this object and the other object are the same instance.
	 */
	public function equals($obj) {
		return $this === $obj;
	}
	
	
	/**
	 * Returns object ID hash code.
	 * This return value is available on PHP 5.2.0 or later.
	 *
	 * @return string object hash code
	 */
	public function hashCode() {
		return Commons_Lang_System::identityHashCode($this);
	}
	
	
	/**
	 * Gets the string representations of this object.
	 *
	 * @return string human recognized string representation
	 */
	public function __toString() {
		return get_class($this).'@'.$this->hashCode();
	}

}

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * c-hanging-comment-ender-p: nil
 * End:
 */
?>