<?php
/* vim: set tabstop=4 shiftwidth=4: */

/*
 * Type Utilities
 * 
 *
 * PHP version 5
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   PHP
 * @package    Commons
 * @author     Yomei Komiya
 * @copyright  2007 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    SVN: $Id: TypeUtils.php 107 2008-01-05 16:28:53Z whitestar $
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      File available since Release 0.8.0
 */

//namespace Commons::Lang;

/**
 * TypeUtils
 *
 *
 * @category   PHP
 * @package    Commons.Lang
 * @author     Yomei Komiya
 * @copyright  2007 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    Release: 0.8.0
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      Class available since Release 0.8.0
 */
class Commons_Lang_TypeUtils {

	private static $_instance = null;
	
	
	/**
	 * Constructor for use as bean.
	 */
	public function Commons_Lang_SystemUtils() {
		parent::__construct();
	}
	
	
	public function __destruct() {
	}
	
	
	public static function getInstance() {
		if (is_null(self::$_instance)) {
			self::$_instance = new self();
		}
		
		return self::$_instance;
	}
	
	
	
	/**
	 * Class sensitive type test
	 *
	 * @param mixed $lhs the left hand side parameter
	 * @param mixed $rhs the right hand side parameter
	 * @return bool
	 */
	public static function isSameType($lhs, $rhs) {
		if (is_null($lhs) || is_null($rhs)) {
			return false;
		}
		elseif (gettype($lhs) === gettype($rhs)) {
			if (is_object($lhs)) {
				if (get_class($lhs) === get_class($rhs)) {
				// parent-child relationship
				//if ($lhs instanceof $rhs || $rhs instanceof $lhs) {
					return true;
				}
				else {
					return false;
				}
			}
			else {
				return true;
			}
		}
		else {
			return false;
		}
	}
	
}

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * c-hanging-comment-ender-p: nil
 * End:
 */
?>