<?php
/* vim: set tabstop=4 shiftwidth=4: */

/*
 * PHPUnit Utilities
 * 
 *
 * PHP version 5
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   PHP
 * @package    Commons
 * @author     Yomei Komiya
 * @copyright  2007 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    SVN: $Id: PHPUnitUtils.php 61 2007-12-28 13:39:43Z whitestar $
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      File available since Release 0.8.0
 */

//namespace Commons::Test;

/**
 * PHPUnitUtils
 *
 *
 * @category   PHP
 * @package    Commons.Test
 * @author     Yomei Komiya
 * @copyright  2007 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    Release: 0.8.0
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      Class available since Release 0.8.0
 */
abstract class Commons_Test_PHPUnitUtils {
	
	/**
	 * Runs the test suite's main method
	 * if its method is able to be defined by 'PHPUnit_MAIN_METHOD'. 
	 *
	 * @param string $mainMethodName
	 */
	public static function run($mainMethodName) {
		self::defineMainMethod($mainMethodName);
		self::executeMainMethod($mainMethodName);
	}
	
	
	/**
	 * Defines test suite's main method.
	 *
	 * @param string $mainMethodName
	 */
	public static function defineMainMethod($mainMethodName) {
		if (!defined('PHPUnit_MAIN_METHOD')) {
			define('PHPUnit_MAIN_METHOD', $mainMethodName);
		}
	}
	
	
	/**
	 * Executes test suite's main method.
	 *
	 * @param string $mainMethodName
	 */
	public static function executeMainMethod($mainMethodName) {
		if (PHPUnit_MAIN_METHOD === $mainMethodName) {
			eval(PHPUnit_MAIN_METHOD . '();');
		}
	}
	
}

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * c-hanging-comment-ender-p: nil
 * End:
 */
?>