<?php
/* vim: set tabstop=4 shiftwidth=4: */

/*
 * Chained Closure
 * (based on org.apache.commons.collections.functors.ChainedClosure)
 * 
 *
 * PHP version 5
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   PHP
 * @package    Commons
 * @author     Yomei Komiya
 * @copyright  2007 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    SVN: $Id: ChainedClosure.php 106 2008-01-05 14:56:15Z whitestar $
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      File available since Release 0.8.0
 */

//namespace Commons::Cols::Functors;

require_once 'Commons/Lang/Object.php';
require_once 'Commons/Cols/Closure.php';
require_once 'Commons/Cols/Functors/FunctorUtils.php';
require_once 'Commons/IO/Serializable.php';
/*
use Commons::Lang::Object;
use Commons::Cols::Closure;
use Commons::Cols::Functors::FunctorUtils;
use Commons::IO::Serializable;
*/

/**
 * ChainedClosure
 *
 *
 * @category   PHP
 * @package    Commons.Cols.Functors
 * @author     Yomei Komiya
 * @copyright  2007 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    Release: 0.9.0
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      Class available since Release 0.8.0
 */
class Commons_Cols_Functors_ChainedClosure
	extends Commons_Lang_Object
	implements Commons_Cols_Closure, Commons_IO_Serializable {
	
	private $_iClosures = array();
	
	
	/**
	 * Factory method with validation.
	 *
	 * @param array $closures
	 * @return Commons_Cols_Closure
	 */
	public static function getInstance($closures) {
		Commons_Cols_Functors_FunctorUtils::validate($closures);
		if (count($closures) === 0) {
			return Commons_Cols_Functors_NOPClosure::getInstance();
		}
		
		$closures = Commons_Cols_Functors_FunctorUtils::copy($closures);
		return new Commons_Cols_Functors_ChainedClosure($closures);
	}


	/**
	 * Constructor that performs no validation.
	 * Use <code>getInstance</code> if you want that.
	 * 
	 * @param array $closures  the closures to chain, not copied, no nulls
	 */
	public function Commons_Cols_Functors_ChainedClosure($closures) {
		parent::__construct();
		$this->_iClosures = $closures;
	}
	
	
	/**
	 * Execute a list of closures.
	 *
	 * @param object $input
	 */
	public function execute($input) {
		foreach ($this->_iClosures as $closure) {
			$closure->execute($input);
		}
	}
	
	
	/**
	 * Gets closures
	 *
	 * @return array the list of closures
	 */
	public function getClosures() {
		return $this->_iClosures;
	}
	
}

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * c-hanging-comment-ender-p: nil
 * End:
 */
?>