<?php
/* vim: set tabstop=4 shiftwidth=4: */

/*
 * No Operation Closure
 * (based on org.apache.commons.collections.functors.NOPClosure)
 * 
 *
 * PHP version 5
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   PHP
 * @package    Commons
 * @author     Yomei Komiya
 * @copyright  2007 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    SVN: $Id: NOPClosure.php 97 2008-01-04 12:58:32Z whitestar $
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      File available since Release 0.8.0
 */

//namespace Commons::Cols::Functors;

require_once 'Commons/Lang/Object.php';
require_once 'Commons/Cols/Closure.php';
require_once 'Commons/IO/Serializable.php';
/*
use Commons::Lang::Object;
use Commons::Cols::Closure;
use Commons::IO::Serializable;
*/

/**
 * NOPClosure
 *
 *
 * @category   PHP
 * @package    Commons.Cols.Functors
 * @author     Yomei Komiya
 * @copyright  2007 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    Release: 0.9.0
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      Class available since Release 0.8.0
 */
class Commons_Cols_Functors_NOPClosure
	extends Commons_Lang_Object
	implements Commons_Cols_Closure, Commons_IO_Serializable {
	
	/**
	 * Singleton instance
	 * @var NOPClusure
	 */
	private static $_singleton = null;
	
	
	public static function getInstance() {
		if (is_null(self::$_singleton)) {
			self::$_singleton = new self();
		}
		
		return self::$_singleton;
	}
	
	
	/**
	 * Constructor
	 */
	private function Commons_Cols_Functors_NOPClosure() {
		parent::__construct();
	}
	

	public function __clone() {
		trigger_error('Clone is not allowed.', E_USER_ERROR);
	}
	
	
	/**
	 * Do nothing.
	 *
	 * @param object $input
	 */
	public function execute($input) {
		// do nothing
	}
	
}

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * c-hanging-comment-ender-p: nil
 * End:
 */
?>