<?php
/* vim: set tabstop=4 shiftwidth=4: */

/*
 * ToString Builder
 * (based on org.apache.commons.lang.builder.ToStringBuilder)
 *
 *
 * PHP version 5
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   PHP
 * @package    Commons
 * @author     Yomei Komiya
 * @copyright  2007 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    SVN: $Id: ToStringBuilder.php 69 2007-12-31 12:38:09Z whitestar $
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      File available since Release 0.8.0
 */

//namespace Commons::Lang::Builder;

require_once 'Commons/Lang/Object.php';
require_once 'Commons/Lang/StringBuffer.php';
require_once 'Commons/Lang/Builder/ToStringStyle.php';
/*
use Commons::Lang::Object;
use Commons::Lang::StringBuffer;
use Commons::Lang::Builder::ToStringStyle;
*/

/**
 * ToStringBuilder
 *
 *
 * @category   PHP
 * @package    Commons.Lang.Builder
 * @author     Yomei Komiya
 * @copyright  2007 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    Release: 0.9.0
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      Class available since Release 0.8.0
 */
class Commons_Lang_Builder_ToStringBuilder extends Commons_Lang_Object {
//class ToStringBuilder extends Object {
	
	/**
	 * Default ToString style
	 *
	 * @var Commons_Lang_Builder_ToStringStyle
	 */
	private static $_defaultStyle = null;
	
	/**
	 * Target object
	 *
	 * @var object
	 */
	private $_object = null;
	
	/**
	 * String buffer
	 *
	 * @var Commons_Lang_StringBuffer
	 */
	private $_buffer = null;
	
	/**
	 * Current ToString style
	 *
	 * @var Commons_Lang_Builder_ToStringStyle
	 */
	private $_style = null;
	
	
	public static function getDefaultStyle() {
		if (is_null(self::$_defaultStyle)) {
			self::$_defaultStyle = Commons_Lang_Builder_ToStringStyle::$DEFAULT_STYLE;
		}

		return self::$_defaultStyle;
	}
		
	
	/**
	 * Constructor
	 *
	 * @param object $object
	 * @param Commons_Lang_Builder_ToStringStyle $style
	 * @param Commons_Lang_StringBuffer $buffer
	 * @return Commons_Lang_Builder_ToStringBuilder
	 */
	public function Commons_Lang_Builder_ToStringBuilder(
		$object,
		Commons_Lang_Builder_ToStringStyle $style = null,
		Commons_Lang_StringBuffer $buffer = null) {

		if (is_null($style)) {
			$style = self::getDefaultStyle();
		}
		if (is_null($buffer)) {
			$buffer = new Commons_Lang_StringBuffer();
		}
		
		$this->_buffer = $buffer;
		$this->_style = $style;
		$this->_object = $object;
		
		$this->_style->appendStart($this->_buffer, $this->_object);
	}
	
	
	/**
	 * Appends the toString value.
	 *
	 * @param string $fieldName Field name
	 * @param mixed $value Field value
	 * @param bool $fullDetail Full detail flag (default: true)
	 * @return Commons_Lang_Builder_ToStringBuilder This instance.
	 */
	public function append($fieldName, $value, $fullDetail = true) {
		$this->_style->append($this->_buffer, $fieldName, $value, $fullDetail);
		return $this;
	}
	
	
	public function appendSuper($superToString) {
		if (!is_null($superToString)) {
			$this->_style->appendSuper($this->_buffer, $superToString);
		}
		return $this;
	}
	
	
	public function appendToString($toString) {
		if (!is_null($toString)) {
			$this->_style->appendToString($this->_buffer, $toString);
		}
		return $this;
	}
	
	
	// Accessors ---------------------------------------------------------------------------
	public function getObject() {
		return $this->_object;
	}
	
	
	public function getStringBuffer() {
		return $this->_buffer;
	}
	
	
	public function getStyle() {
		return $this->_style;
	}
	
	
	public function __toString() {
		if (is_null($this->_object)) {
			$this->_buffer->append($this->_style->getNullText());
		}
		else {
			$this->_style->appendEnd($this->_buffer, $this->_object);
		}
		return $this->_buffer->__toString();
	}
	
}

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * c-hanging-comment-ender-p: nil
 * End:
 */
?>