<?php
/* vim: set tabstop=4 shiftwidth=4: */

/*
 * Microsecond Time
 *
 *
 * PHP version 5
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   PHP
 * @package    Commons
 * @author     Yomei Komiya
 * @copyright  2007 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    SVN: $Id: MicrosecondTime.php 97 2008-01-04 12:58:32Z whitestar $
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      File available since Release 0.8.0
 */

//namespace Commons::Lang::Time;

require_once 'Commons/Lang/Object.php';
require_once 'Commons/Lang/IllegalArgumentException.php';
/*
use Commons::Lang::Object;
use Commons::Lang::IllegalArgumentException;
*/
/**
 * MicrosecondTime
 *
 *
 * @category   PHP
 * @package    Commons.Lang.Time
 * @author     Yomei Komiya
 * @copyright  2007 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    Release: 0.9.0
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      Class available since Release 0.8.0
 */
class Commons_Lang_Time_MicrosecondTime extends Commons_Lang_Object {
//class MicrosecondTime extends Object {
	
	/**
	 * @var float Microsecond part (sec), e.g. 0.29431200
	 */
	private $_usec = 0.0;
	
	/**
	 * @var float Second part (sec), e.g. 1197546962
	 */
	private $_sec = 0.0;
	
	
	/**
	 * Constructor
	 * 
	 * Pseudo overload
	 * 1. __construct(float $usec, float $sec)
	 * 2. __construct(string microtimeStr)
	 * 3. __construct(void)
	 * 
	 * @param mixed $arg1
	 * @param float $arg2
	 * @throws Commons_Lang_IllegalArgumentException
	 */
	public function Commons_Lang_Time_MicrosecondTime($arg1 = null, $arg2 = null) {
		try {
			parent::__construct();
			
			// Pseudo overload
			// 1. __construct(float $usec, float $sec)
			if (isset($arg1) && is_float($arg1)
				&& isset($arg2) && is_float($arg2)) {
				$this->_usec = $arg1;
				$this->_sec = $arg2;
			}
			// 2. __construct(string microtimeStr)
			elseif (isset($arg1) && is_string($arg1)
				&& is_null($arg2)) {
				$this->setMicrotimeStr($arg1);
			}
			// 3. __construct(void)
			elseif (is_null($arg1) && is_null($arg2)) {
				$this->setMicrotimeStr(microtime());
			}
			else {
				throw new Commons_Lang_IllegalArgumentException();
			}
		}
		catch (Commons_Lang_IllegalArgumentException $iae) {
			throw $iae;
		}
		catch (Exception $e) {
			throw new Commons_Lang_IllegalArgumentException($e->getMessage(), $e->getCode());
		}
	}
	
	
	/**
	 * Sets microtime() result string
	 * 
	 * @param string $microtimeStr
	 * @throws Commons_Lang_IllegalArgumentException
	 */
	protected function setMicrotimeStr($microtimeStr) {
		try {
			list($usec, $sec) = explode(" ", $microtimeStr);
			$this->_usec = (float)$usec;
			$this->_sec = (float)$sec;		
		}
		catch (Exception $e) {
			throw new Commons_Lang_IllegalArgumentException($e->getMessage(), $e->getCode());
		}
	}
	
	
	public function __destruct() {
		// do nothing.
	}
	
	
	public function __toString() {
		return $this->_usec . ' ' . $this->_sec;
	}
	
	
	/**
	 * Adds microseconds ($this + $microTime)
	 * 
	 * @param Commons_Lang_Time_MicrosecondTime $microTime
	 */
	public function add(self $microTime) {
		return new self(
				$this->_usec + $microTime->getUsec(),
				$this->_sec + $microTime->getSec());
	}
	
	
	/**
	 * Subtracts microseconds ($this - $microTime)
	 * 
	 * @param Commons_Lang_Time_MicrosecondTime $microTime
	 */
	public function subtract(self $microTime) {
		return new self(
				$this->_usec - $microTime->getUsec(),
				$this->_sec - $microTime->getSec());
	}
	
	
	/**
	 * To second
	 * 
	 * @return float Second
	 */
	public function toSecond() {
		return $this->_usec + $this->_sec;
	}
	
	
	/**
	 * To milli-second
	 * 
	 * @return float Milli-second
	 */
	public function toMillis() {
		return floor($this->_usec * 1000) + $this->_sec * 1000;
	}
	
	
	/**
	 * Gets Microsecond part (sec)
	 *
	 * @return float
	 */
	public function getUsec() {
		return $this->_usec;
	}
	
	
	/**
	 * Gets Second part (sec)
	 *
	 * @return float
	 */
	public function getSec() {
		return $this->_sec;
	}
	
}

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * c-hanging-comment-ender-p: nil
 * End:
 */
?>