<?php
/* vim: set tabstop=4 shiftwidth=4: */

/*
 * Test Case
 *
 *
 * PHP version 5
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   PHP
 * @package    Commons
 * @author     Yomei Komiya
 * @copyright  2008 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    SVN: $Id: TestCase.php 156 2008-01-20 13:03:34Z whitestar $
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      File available since Release 0.9.0
 */

//namespace Commons::Test;

require_once 'PHPUnit/Framework.php';

require_once 'Commons/Test/TestUtils.php';
/*
use Commons::Test::TestUtils;
*/

/**
 * TestCase
 *
 *
 * @category   PHP
 * @package    Commons.Test
 * @author     Yomei Komiya
 * @copyright  2008 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    Release: 0.9.0
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      Class available since Release 0.9.0
 */
abstract class Commons_Test_TestCase extends PHPUnit_Framework_TestCase {

	/**
	 * Tests whether runkit is available or not.
	 *
	 * @return bool true if runkit is available.
	 */
	public static function isRunkitEnabled() {
		return Commons_Test_TestUtils::isRunkitEnabled();
	}
	
	
	/**
	 * Invokes an invisible method.
	 *
	 * @param object $obj target object.
	 * @param string $methodName target private or protected method name
	 * @param array $params parameters
	 * @return mixed return value of the target method's invocation.
	 * @throws Commons_Lang_IllegalArgumentException
	 */
	public static function invokeInvisibleMethod($obj, $methodName, $params) {
		return Commons_Test_TestUtils::invokeInvisibleMethod($obj, $methodName, $params);
	}
	
}

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * c-hanging-comment-ender-p: nil
 * End:
 */
?>