<?php
/* vim: set tabstop=4 shiftwidth=4: */

/*
 * Test Utilities
 *
 *
 * PHP version 5
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   PHP
 * @package    Commons
 * @author     Yomei Komiya
 * @copyright  2008 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    SVN: $Id: TestUtils.php 156 2008-01-20 13:03:34Z whitestar $
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      File available since Release 0.9.0
 */

//namespace Commons::Test;

require_once 'Commons/Lang/Object.php';
/*
use Commons::Lang::Object;
*/

/**
 * TestUtils
 *
 *
 * @category   PHP
 * @package    Commons.Test
 * @author     Yomei Komiya
 * @copyright  2008 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    Release: 0.9.0
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      Class available since Release 0.9.0
 */
class Commons_Test_TestUtils extends Commons_Lang_Object {

	private static $_instance = null;
	
	
	public function Commons_Test_TestUtils() {
		parent::__construct();
	}
	
	
	public function __destruct() {
	}


	public static function getInstance() {
		if (is_null(self::$_instance)) {
			self::$_instance = new self();
		}
		
		return self::$_instance;
	}
	
	
	/**
	 * Tests whether runkit is available or not.
	 *
	 * @return bool true if runkit is available.
	 */
	public static function isRunkitEnabled() {
		if (function_exists('runkit_method_add')) {
			return true;
		}
		else {
			return false;
		}
	}
	
	
	/**
	 * Invokes an invisible method.
	 *
	 * @param object $obj target object.
	 * @param string $methodName target private or protected method name
	 * @param array $params parameters
	 * @return mixed return value of the target method's invocation.
	 * @throws Commons_Lang_IllegalArgumentException
	 */
	public static function invokeInvisibleMethod($obj, $methodName, $params) {
		$className = '';
		$argsStr = '';
		if (is_object($obj)) {
			$className = get_class($obj);
		}
		else {
			throw new Commons_Lang_IllegalArgumentException('1st argument must be a object.');
		}
		// strtolower for runkit's bug.
		$addedMethodName = strtolower($methodName . uniqid('ForTest'));
		$argc = count($params);
		for ($i = 1; $i <= $argc; $i++) {
			if ($argsStr !== '') {
				$argsStr .=  ', '; 
			}
			$argsStr .= '$p' . $i;
		}
		$code = 'return $this->' . $methodName . '(' . $argsStr . ');';

		runkit_method_add($className, $addedMethodName, $argsStr, $code, RUNKIT_ACC_PUBLIC);
		
		return call_user_func_array(array($obj, $addedMethodName), $params);
	}
	
}

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * c-hanging-comment-ender-p: nil
 * End:
 */
?>