<?php
/* vim: set tabstop=4 shiftwidth=4: */

/*
 * Null Predicate
 * (based on org.apache.commons.collections.functors.NullPredicate)
 *
 *
 * PHP version 5
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   PHP
 * @package    Commons
 * @author     Yomei Komiya
 * @copyright  2008 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    SVN: $Id: NullPredicate.php 271 2008-03-29 12:03:11Z whitestar $
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      File available since Release 1.0.1
 */

//namespace Commons::Cols::Functors;

require_once 'Commons/Lang/Object.php';
require_once 'Commons/Cols/Predicate.php';
require_once 'Commons/IO/Serializable.php';
/*
use Commons::Lang::Object;
use Commons::Cols::Predicate;
use Commons::IO::Serializable;
*/

/**
 * NullPredicate
 *
 *
 * @category   PHP
 * @package    Commons.Cols.Functors
 * @author     Yomei Komiya
 * @copyright  2008 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    Release: 1.0.1.1
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      Class available since Release 1.0.1
 */
final class Commons_Cols_Functors_NullPredicate
	extends Commons_Lang_Object
	implements Commons_Cols_Predicate, Commons_IO_Serializable {

	/**
	 * The singleton instance.
	 *
	 * @var Commons_Cols_Predicate
	 */
	public static $INSTANCE = null;
	
	
	/**
	 * Static initializer.
	 */
	public static function init() {
		self::$INSTANCE = new self();
	}
	
	
	/**
	 * Returns the singleton instance.
	 *
	 * @param object $object
	 * @return Commons_Cols_Predicate
	 */
	public static function getInstance() {
		return self::$INSTANCE;
	}
	
	
	/**
	 * Private constructor
	 */
	private function Commons_Cols_Functors_NullPredicate() {
		parent::__construct();
	}
	
	
	public function __destruct() {
	}
	
	
	/**
	 * Evaluates the predicate.
	 *
	 * @param object $object
	 * @return bool true if input is null
	 */
	public function evaluate($object) {
		return ($object === null);
	}
	
}

Commons_Cols_Functors_NullPredicate::init();

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * c-hanging-comment-ender-p: nil
 * End:
 */
?>