<?php
/* vim: set tabstop=4 shiftwidth=4: */

/*
 * Reverse Comparator
 * (based on org.apache.commons.collections.comparators.ReverseComparator)
 * 
 *
 * PHP version 5
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   PHP
 * @package    Commons
 * @author     Yomei Komiya
 * @copyright  2007 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    SVN: $Id: ReverseComparator.php 97 2008-01-04 12:58:32Z whitestar $
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      File available since Release 0.8.0
 */

//namespace Commons::Cols::Comps;

require_once 'Commons/Lang/Object.php';
require_once 'Commons/IO/Serializable.php';
require_once 'Commons/Util/Comparator.php';
require_once 'Commons/Cols/Comps/ComparableComparator.php';
/*
use Commons::Lang::Object;
use Commons::IO::Serializable;
use Commons::Util::Comparator;
use Commons::Cols::Comps::ComparableComparator;
*/

/**
 * ReverseComparator
 *
 *
 * @category   PHP
 * @package    Commons.Cols.Comps
 * @author     Yomei Komiya
 * @copyright  2007 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    Release: 1.0.1
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      Class available since Release 0.8.0
 */
class Commons_Cols_Comps_ReverseComparator
	extends Commons_Lang_Object
	implements Commons_Util_Comparator, Commons_IO_Serializable {
//class ReverseComparator extends Object implements Comparator, Serializable {
		
	/**
	 * Comparator
	 *
	 * @var Commons_Util_Comparator
	 */
	private $_comparator = null;
	
	
	/**
	 * Constructor
	 *
	 * @param Commons_Util_Comparator $comparator
	 */
	public function Commons_Cols_Comps_ReverseComparator(
		Commons_Util_Comparator $comparator = null) {

		if (!is_null($comparator)) {
			$this->_comparator = $comparator;
		}
		else {
			$this->_comparator = Commons_Cols_Comps_ComparableComparator::getInstance();
		}
	}


	public function compare($o1, $o2) {
		return $this->_comparator->compare($o2, $o1);
	}
	
	
	public function getComparator() {
		return $this->_comparator;
	}
	
}

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * c-hanging-comment-ender-p: nil
 * End:
 */
?>