<?php
/* vim: set tabstop=4 shiftwidth=4: */

/*
 * Chained Auto Loader
 * 
 *
 * PHP version 5
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   PHP
 * @package    Commons
 * @author     Yomei Komiya
 * @copyright  2008 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    SVN: $Id: ChainedAutoLoader.php 249 2008-03-06 11:46:54Z whitestar $
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      File available since Release 0.9.0
 */

//namespace Commons::Cols::Functors;

require_once 'Commons/Lang/Object.php';
require_once 'Commons/Cols/AutoLoader.php';
require_once 'Commons/IO/Serializable.php';
/*
use Commons::Lang::Object;
use Commons::Cols::AutoLoader;
use Commons::IO::Serializable;
*/

/**
 * ChainedAutoLoader
 *
 *
 * @category   PHP
 * @package    Commons.Cols.Functors
 * @author     Yomei Komiya
 * @copyright  2008 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    Release: 1.0.1
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      Class available since Release 0.9.0
 */
class Commons_Cols_Functors_ChainedAutoLoader
	extends Commons_Lang_Object
	implements Commons_IO_Serializable {
	
	/**
	 * Autoload functions.
	 *
	 * @var array
	 */
	private static $_iAutoLoaders = array();
	
	/**
	 * Whether the chained auto loader is active or not.
	 *
	 * @var bool
	 */
	private static $_isActive = false;
	
	/**
	 * Whether the existing __autoload function is registered or not.
	 *
	 * @var bool
	 */
	private static $_isExisting__autoloadRegistered = false;
	
	
	/**
	 * Registers autoloder.
	 *
	 * @param mixed $autoLoader Commons_Cols_AutoLoader type or callback type.
	 */
	public static function register($autoLoader) {
		self::$_iAutoLoaders[] = $autoLoader;
		
		if (function_exists('spl_autoload_register')) {
			// adds the existing __autoload.
			if (self::$_isExisting__autoloadRegistered === false
				&& function_exists('__autoload')) {
				spl_autoload_register('__autoload');
				self::$_isExisting__autoloadRegistered = true;
			}
			
			if ($autoLoader instanceof Commons_Cols_AutoLoader) {
				spl_autoload_register(array($autoLoader, 'autoload'));
			}
			// callback type
			elseif (is_array($autoLoader)) {
				spl_autoload_register($autoLoader);
			}
			else {
				// do nothing.
			}
			self::$_isActive = true;
		}
		else {
			if (!function_exists('__autolaod')) {
				function __autoload($name) {
					Commons_Cols_Functors_ChainedAutoLoader::autoload($name);
				}
				self::$_isActive = true;
			}
			else {
				// do nothing.
			}
		}
	}


	/**
	 * Private Constructor
	 */
	private function Commons_Cols_Functors_ChainedAutoLoader() {
	}
	
	
	/**
	 * Execute a list of autoloaders.
	 *
	 * @param string $name
	 */
	public static function autoload($name) {
		foreach (self::$_iAutoLoaders as $loader) {
			if ($loader instanceof Commons_Cols_AutoLoader) {
				$loader->autoload($name);
			}
			// callback type
			elseif (is_array($loader)) {
				call_user_func($loader, $name);
			}
			else {
				// do nothing.
			}
		}
	}
	
	
	/**
	 * Gets autoloaders
	 *
	 * @return array the list of autoloaders
	 */
	public static function getAutoLoaders() {
		return self::$_iAutoLoaders;
	}
	
	
	public static function isActive() {
		return self::$_isActive;
	}
	
	
	/**
	 * Resets the chained auto loder. clear all registered autoload functions.
	 */
	public static function reset() {
		self::$_iAutoLoaders = array();
		self::$_isActive = false;
		self::$_isExisting__autoloadRegistered = false;
		
		if (function_exists('spl_autoload_functions')) {
			$autoLoaders = spl_autoload_functions();
			if ($autoLoaders !== false) {
				foreach ($autoLoaders as $loader) {
					$ret = spl_autoload_unregister($loader);
				}
			}
		}
	}
	
}

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * c-hanging-comment-ender-p: nil
 * End:
 */
?>