<?php
/* vim: set tabstop=4 shiftwidth=4: */

/*
 * One Predicate
 *
 *
 * PHP version 5
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   PHP
 * @package    Commons
 * @author     Yomei Komiya
 * @copyright  2008 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    SVN: $Id: OnePredicate.php 284 2008-04-12 11:29:32Z whitestar $
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      File available since Release 1.0.1
 */

//namespace Commons::Cols::Functors;

require_once 'Commons/Lang/Object.php';
require_once 'Commons/Lang/IllegalArgumentException.php';
require_once 'Commons/Cols/Predicate.php';
require_once 'Commons/Cols/Functors/PredicateDecorator.php';
require_once 'Commons/Cols/Functors/FunctorUtils.php';
require_once 'Commons/IO/Serializable.php';
/*
use Commons::Lang::Object;
use Commons::Lang::IllegalArgumentException';
use Commons::Cols::Predicate;
use Commons::Cols::Functors::PredicateDecorator;
use Commons::Cols::Functors::FunctorUtils;
use Commons::IO::Serializable;
*/

/**
 * OnePredicate
 *
 *
 * @category   PHP
 * @package    Commons.Cols.Functors
 * @author     Yomei Komiya
 * @copyright  2008 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    Release: 1.0.1
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      Class available since Release 1.0.1
 */
class Commons_Cols_Functors_OnePredicate
	extends Commons_Lang_Object
	implements Commons_Cols_Functors_PredicateDecorator, Commons_IO_Serializable {

	private $iPredicates = array();
	
	
	/**
	 * Factory to create the predicate.
	 *
	 * @param array $predicates
	 * @return Commons_Cols_Predicate
	 * @throws Commons_Lang_IllegalArgumentException if either predicate is invalid.
	 */
	public static function getInstance($predicates) {
		Commons_Cols_Functors_FunctorUtils::validateMin2($predicates);
		$predicates = Commons_Cols_Functors_FunctorUtils::copy($predicates);
		return new self($predicates);
	}


	/**
	 * Constructor
	 *
	 * @param array $predicates
	 */
	public function Commons_Cols_Functors_OnePredicate($predicates) {
		parent::__construct();
		$this->iPredicates = $predicates;
	}
		
	
	public function __destruct() {
	}
	
	
	/**
	 * Evaluates the predicate returning true if only one decorated predicate returns true.
	 *
	 * @param object $object
	 * @return bool true if only one predicate returns true.
	 */
	public function evaluate($object) {
		$match = false;
		foreach ($this->iPredicates as $predicate) {
			if ($predicate->evaluate($object)) {
				if ($match) {
					return false;
				}
				$match = true;
			}
		}
		
		return $match;
	}	
	
	
	/**
	 * Gets predicates.
	 *
	 * @return array an array of all predicates.
	 */
	public function getPredicates() {
		return $this->iPredicates;
	}	

}

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * c-hanging-comment-ender-p: nil
 * End:
 */
?>