<?php
/* vim: set tabstop=4 shiftwidth=4: */

/*
 * Unique Predicate
 * (based on org.apache.commons.collections.functors.UniquePredicate)
 *
 *
 * PHP version 5
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   PHP
 * @package    Commons
 * @author     Yomei Komiya
 * @copyright  2008 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    SVN: $Id: UniquePredicate.php 287 2008-04-13 03:26:44Z whitestar $
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      File available since Release 1.0.1
 */

//namespace Commons::Cols::Functors;

require_once 'Commons/Lang/Object.php';
require_once 'Commons/Cols/Predicate.php';
require_once 'Commons/Cols/Functors/NullPredicate.php';
require_once 'Commons/IO/Serializable.php';
/*
use Commons::Lang::Object;
use Commons::Cols::Predicate;
use Commons::Cols::Functors/NullPredicate;
use Commons::IO::Serializable;
*/

/**
 * UniquePredicate
 *
 *
 * @category   PHP
 * @package    Commons.Cols.Functors
 * @author     Yomei Komiya
 * @copyright  2008 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    Release: 1.0.1
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      Class available since Release 1.0.1
 */
final class Commons_Cols_Functors_UniquePredicate
	extends Commons_Lang_Object
	implements Commons_Cols_Predicate, Commons_IO_Serializable {

	/**
	 * The set of previously seen objects
	 *
	 * @var array
	 */
	private $iSet = array();
	
	
	/**
	 * Factory method to create the unique predicate.
	 *
	 * @return Commons_Cols_Predicate
	 */
	public static function getInstance() {
		return new self();
	}
	
	
	/**
	 * Constructor
	 */
	public function Commons_Cols_Functors_UniquePredicate() {
		parent::__construct();
	}
	
	
	public function __destruct() {
	}
	
	
	/**
	 * Evaluates the predicate.
	 *
	 * @param object $object
	 * @return bool true if it is the first time to add the object.
	 */
	public function evaluate($object) {
		// TODO: strict hash set implementation.
		if (in_array($object, $this->iSet, true)) {
			return false;
		}
		else {
			$this->iSet[] = $object;
			return true;
		}
	}
	
}

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * c-hanging-comment-ender-p: nil
 * End:
 */
?>