<?php
/* vim: set tabstop=4 shiftwidth=4: */

/*
 * Class Utilities
 *
 *
 * PHP version 5
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   PHP
 * @package    Commons
 * @author     Yomei Komiya
 * @copyright  2007 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    SVN: $Id: ClassUtils.php 107 2008-01-05 16:28:53Z whitestar $
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      File available since Release 0.8.0
 */

//namespace Commons::Lang;

require_once 'Commons/Lang/Object.php';
/*
use Commons::Lang::Object;
*/
/**
 * ClassUtils
 *
 *
 * @category   PHP
 * @package    Commons.Lang
 * @author     Yomei Komiya
 * @copyright  2007 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    Release: 1.0.1
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      Class available since Release 0.8.0
 */
class Commons_Lang_ClassUtils extends Commons_Lang_Object {
	
	private static $_instance = null;
	

	/**
	 * Constructor
	 */
	public function Commons_Lang_ClassUtils() {
		parent::__construct();
	}
	
	
	public function __destruct() {
	}
	
	
	public static function getInstance() {
		if (is_null(self::$_instance)) {
			self::$_instance = new self();
		}
		
		return self::$_instance;
	}
	
	
	/**
	 * Gets the short class name of the passed class name
	 *
	 * @param string $className
	 * @return string short class name
	 */
	public static function getShortClassName($className) {
		$pos = strrpos($className, '_');
		if ($pos !== false && $pos > 0 && strlen($className) !== $pos + 1) {
			return substr($className, $pos + 1);
		}
		else {
			return $className;
		}
	}

}

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * c-hanging-comment-ender-p: nil
 * End:
 */
?>