<?php
/* vim: set tabstop=4 shiftwidth=4: */

/*
 * String Buffer
 * (based on java.lang.StringBuffer)
 * 
 *
 * PHP version 5
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   PHP
 * @package    Commons
 * @author     Yomei Komiya
 * @copyright  2007 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    SVN: $Id: StringBuffer.php 90 2008-01-04 05:18:05Z whitestar $
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      File available since Release 0.8.0
 */

//namespace Commons::Lang;

require_once 'Commons/Lang/Object.php';
require_once 'Commons/Lang/StringUtils.php';
require_once 'Commons/Lang/StringIndexOutOfBoundsException.php';
require_once 'Commons/IO/Serializable.php';
/*
use Commons::Lang::Object;
use Commons::Lang::StringUtils;
use Commons::Lang::StringIndexOutOfBoundsException;
use Commons::IO::Serializable;
*/

/**
 * StringBuffer
 * Pseudo implementation, not high performance buffer class as Java
 *
 * @category   PHP
 * @package    Commons.Lang
 * @author     Yomei Komiya
 * @copyright  2007 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    Release: 1.0.1
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      Class available since Release 0.8.0
 */
final class Commons_Lang_StringBuffer
	extends Commons_Lang_Object
	implements Commons_IO_Serializable {
// final class StringBuffer extends Object implements Serializable {
	
	/**
	 * String value variable
	 *
	 * @var string
	 */
	private $_value = '';
	
	
	/**
	 * Constructor
	 *
	 * @param mixed $str
	 */
	public function Commons_Lang_StringBuffer($str = '') {
		if (is_null($str)) {
			$this->_value = 'null';
		}
		else {
			$this->_value = (string)$str;
		}
	}
	
	
	/**
	 * Appends the string representation to the buffer
	 *
	 * @param mixed $str
	 * @return Commons_Lang_StringBuffer this buffer object
	 */
	public function append($str) {
		if (is_null($str)) {
			$this->_value .= 'null';
		}
		else {
			$this->_value .= (string)$str;
		}
		
		return $this;
	}
	
	
	/**
	 * Returns the length of this buffer.
	 *
	 * @return int
	 */
	public function length() {
		return Commons_Lang_StringUtils::strlen($this->_value);
	}
	
	
	/**
	 * Returns one-character string at the index with the buffer.
	 *
	 * @param int $index
	 * @return string one-character string.
	 */
	public function charAt($index) {
		return Commons_Lang_StringUtils::charAt($this->_value, $index);
	}
	
	
	/**
	 * Sets the new length of the buffer.
	 *
	 * @param int $newLength
	 */
	public function setLength($newLength) {
		if ($newLength < 0) {
			throw new Commons_Lang_StringIndexOutOfBoundsException($newLength);
		}
		
		$valueLength = $this->length();

		if ($newLength < $valueLength) {
			$this->_value = Commons_Lang_StringUtils::substr($this->_value, 0, $newLength);
		}
		else {
			// do nothing.
		}
	}
	
	
	public function __toString() {
		return $this->_value;
	}
	
}

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * c-hanging-comment-ender-p: nil
 * End:
 */
?>