<?php
/* vim: set tabstop=4 shiftwidth=4: */

/*
 * PEAR Log Category
 *
 *
 * PHP version 5
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   PHP
 * @package    Commons
 * @author     Yomei Komiya
 * @copyright  2008 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    SVN: $Id: PEARLogCategory.php 163 2008-01-24 14:44:49Z whitestar $
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      File available since Release 0.9.0
 */

//namespace Commons::Logging::Impl;

require_once 'Commons/Lang/Object.php';
require_once 'Commons/Lang/StringUtils.php';
/*
use Commons::Lang::Object;
use Commons::Lang::StringUtils;
*/

/**
 * PEARLogCategory
 *
 *
 * @category   PHP
 * @package    Commons.Logging.Impl
 * @author     Yomei Komiya
 * @copyright  2008 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    Release: 1.0.1
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      Class available since Release 0.9.0
 */
class Commons_Logging_Impl_PEARLogCategory extends Commons_Lang_Object {
	
	/**
	 * All categories.
	 *
	 * @var array
	 */
	private static $_categories = array();
	
	/**
	 * The parent category of this category.
	 *
	 * @var Commons_Logging_Impl_PEARLogCategory
	 */
	private $_parent = null;
	
	/**
	 * Category name
	 *
	 * @var string
	 */
	private $_name = null;
	
	/**
	 * Handler names of this category
	 *
	 * @var array
	 */
	private $_handlerNames = array();
	
	/**
	 * Actual handler names of this category
	 *
	 * @var array
	 */
	private $_actualHandlerNames = null;
	
	/**
	 * Additivity of this handlers.
	 *
	 * @var bool
	 */
	private $_additivity = true;
	
	/**
	 * Priority level
	 *
	 * @var int
	 */
	private $_priority = null;
	
	/**
	 * Actual priority level
	 *
	 * @var int
	 */
	private $_actualPriority = null;
	
	
	/**
	 * Private constructor
	 *
	 * @param string $name
	 */
	private function Commons_Logging_Impl_PEARLogCategory($name) {
		parent::__construct();
		
		$this->_name = $name;
	}
	
	
	public function __destruct() {
	}
	
	
	public static function getCategoryByConfName($name) {
		if (!isset(self::$_categories[$name])) {
			self::$_categories[$name] = new self($name);
		}
		
		return self::$_categories[$name];
	}
	

	public static function getCategoryByActualName($name) {
		if (isset(self::$_categories[$name])) {
			return self::$_categories[$name];
		}
		else {
			// search the parent category.
			$catName = $name;
			while (true) {
				$lastDotPos = Commons_Lang_StringUtils::lastIndexOf($catName, '.');
				// its parent is the root logger.
				if ($lastDotPos < 0) {
					return self::$_categories[
						Commons_Logging_Impl_PEARLogPropertyConfigurator::INTERNAL_ROOT_NAME];
				}
				else {
					$catName = Commons_Lang_StringUtils::substring($catName, 0, $lastDotPos);
					if (isset(self::$_categories[$catName])) {
						return self::$_categories[$catName];
					}
				}
			}
		}
	}
	
	
	public function getParent() {
		if (is_null($this->_parent)) {
			if ($this->_name === Commons_Logging_Impl_PEARLogPropertyConfigurator
				::INTERNAL_ROOT_NAME) {
				$this->_parent = $this;
			}
			else {
				$catName = $this->_name;
				while (true) {
					$lastDotPos = Commons_Lang_StringUtils::lastIndexOf($catName, '.');
					// its parent is the root logger.
					if ($lastDotPos < 0) {
						$this->_parent = self::$_categories[
							Commons_Logging_Impl_PEARLogPropertyConfigurator::INTERNAL_ROOT_NAME];
						break;
					}
					else {
						$catName = Commons_Lang_StringUtils::substring($catName, 0, $lastDotPos);
						if (isset(self::$_categories[$catName])) {
							$this->_parent = self::$_categories[$catName];
							break;
						}
					}
				}
			}
		}
		
		return $this->_parent;
	}
	
	
	public function getName() {
		return $this->_name;
	}
	
	
	public function setName($name) {
		$this->_name = $name;
	}
	
	
	public function getActualHandlerNames() {
		if (is_null($this->_actualHandlerNames)) {
			if ($this->_name === Commons_Logging_Impl_PEARLogPropertyConfigurator
				::INTERNAL_ROOT_NAME) {
				$this->_actualHandlerNames = $this->_handlerNames;
			}
			elseif ($this->_additivity === true) {
				$this->_actualHandlerNames = array_merge(
					$this->getParent()->getActualHandlerNames(), $this->_handlerNames);
			}
			else {
				$this->_actualHandlerNames = $this->_handlerNames;
			}
		}
		
		return $this->_actualHandlerNames;
	}
	
	
	public function getHandlerNames() {
		return $this->_handlerNames;
	}
	
	
	public function setHandlerNames($handlerNames) {
		$this->_handlerNames = $handlerNames;
	}
	
	
	public function getAdditivity() {
		return $this->_additivity;
	}
	
	
	public function setAdditivity($additive) {
		$this->_additivity = $additive;
	}
	
	
	public function getActualPriority() {
		if (is_null($this->_actualPriority)) {
			if ($this->_name === Commons_Logging_Impl_PEARLogPropertyConfigurator
				::INTERNAL_ROOT_NAME) {
				$this->_actualPriority = $this->_priority;
			}
			elseif ($this->_priority
				=== Commons_Logging_Impl_PEARLogPropertyConfigurator::INHERIT) {
				$this->_actualPriority = $this->getParent()->getActualPriority();
			}
			else {
				$this->_actualPriority = $this->_priority;
			}
		}
		
		return $this->_actualPriority;
	}
	
	
	public function getPriority() {
		return $this->_priority;
	}
	
	
	public function setPriority($priority) {
		$this->_priority = $priority;
	}
	
}

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * c-hanging-comment-ender-p: nil
 * End:
 */
?>