<?php
/* vim: set tabstop=4 shiftwidth=4: */

/*
 * PEAR Log Logger
 *
 *
 * PHP version 5
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   PHP
 * @package    Commons
 * @author     Yomei Komiya
 * @copyright  2008 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    SVN: $Id: PEARLogLogger.php 224 2008-02-14 13:38:15Z whitestar $
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      File available since Release 0.9.0
 */

//namespace Commons::Logging::Impl;

require_once 'Log.php';

require_once 'Commons/Lang/Object.php';
require_once 'Commons/IO/Serializable.php';
require_once 'Commons/Util/Properties.php';
require_once 'Commons/Logging/Log.php';
require_once 'Commons/Logging/LogConfigurationException.php';
require_once 'Commons/Logging/LogFactory.php';
require_once 'Commons/Logging/Impl/LogFactoryImpl.php';
require_once 'Commons/Logging/Impl/PEARLogCategory.php';
require_once 'Commons/Logging/Impl/PEARLogCompositeLogger.php';
require_once 'Commons/Logging/Impl/PEARLogPropertyConfigurator.php';
/*
use Commons::Lang::Object;
use Commons::IO::Serializable;
use Commons::Utils::Properties;
use Commons::Logging::Log;
use Commons::Logging::LogConfigurationException;
use Commons::Logging::LogFactory;
use Commons::Logging::Impl::LogFactoryImpl;
use Commons::Logging::Impl::PEARLogCategory;
use Commons::Logging::Impl::PEARLogCompositeLogger;
use Commons::Logging::Impl::PEARLogPropertyConfigurator;
*/

/**
 * PEARLogLogger
 *
 *
 * @category   PHP
 * @package    Commons.Logging.Impl
 * @author     Yomei Komiya
 * @copyright  2008 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    Release: 1.0.1
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      Class available since Release 0.9.0
 */
class Commons_Logging_Impl_PEARLogLogger extends Commons_Lang_Object
	implements Commons_Logging_Log, Commons_IO_Serializable {
	
	/**
	 * Log factory
	 *
	 * @var Commons_Logging_LogFactory
	 */
	private static $_factory = null;
	
	/**
	 * Log to this logger
	 * @var Log
	 */
	private $_logger = null;
	
	/**
	 * Logger name
	 * @var string
	 */
	private $_name = null;

	
	/**
	 * Constructor
	 *
	 * @param string $name logger name.
	 */
	public function Commons_Logging_Impl_PEARLogLogger($name) {
		$this->_name = $name;
		$this->_logger = $this->getLogger();
	}
	
	
	public function __destruct() {
	}

	
	/**
	 * Gets extended PEAR Log Composite Logger instance.
	 *
	 * @return Log
	 * @throws Commons_Logging_LogConfigurationException
	 */
	public function getLogger() {
		if (is_null($this->_logger)) {
			$this->_logger
				= Commons_Logging_Impl_PEARLogCompositeLogger::getInstance($this->_name);
			
			// Logger initialization is in setLogFactory().
		}
		return $this->_logger;
	}

	
	/**
	 * Sets the Commons_Logging_LogFactory
	 * This method is called by the log factory instance.
	 *
	 * @param Commons_Logging_LogFactory $factory
	 * @throws Commons_Logging_LogConfigurationException
	 */
	public function setLogFactory(Commons_Logging_LogFactory $factory) {
		if (is_null(self::$_factory)) {
			self::$_factory = $factory;
		}
		
		// Logger initialization.
		$confPath = self::$_factory->getAttribute(
				Commons_Logging_Impl_LogFactoryImpl::PEARLOG_CONF_PROPERTY);
		Commons_Logging_Impl_PEARLogPropertyConfigurator::configure($confPath);
		$this->buildHandlers();
	}
	
	
	/**
	 * Builds log handlers.
	 *
	 * @param Commons_Util_Properties $confProps configuration properties.
	 * @throws Commons_Logging_LogConfigurationException
	 */
	protected function buildHandlers() {
		$category
			= Commons_Logging_Impl_PEARLogCategory::getCategoryByActualName($this->_name);
		$mask = Log::MAX($category->getActualPriority());
		// The parent composite logger controls all the childs log output.
		$this->_logger->setMask($mask);
			
		$handlerProps
			= Commons_Logging_Impl_PEARLogPropertyConfigurator::getHandlerProperties();
		foreach ($category->getActualHandlerNames() as $handlerName) {
			if (isset($handlerProps[$handlerName])) {
				$handlerProp = $handlerProps[$handlerName];
				$this->_logger->addChild(
					Log::singleton(
						$handlerProp['type'],
						$handlerProp['resource'],
						$this->_name,
						$handlerProp['conf'],
						// == setMask(Log::MAX(PEAR_LOG_DEBUG)) == PEAR_LOG_ALL
						// controlled by the parent composite logger.
						PEAR_LOG_DEBUG)
						//$level)	// == setMask(Log::MAX($level))
				);
			}
		}
	}
	
	
	/**
	 * Builds the message string.
	 *
	 * @param mixed $message message object.
	 * @param Exception $e exception object.
	 * @return string message.
	 */
	protected function buildMessage($message, $e) {
		if (is_null($message)) {
			$message = '<null>';
		}
		
		if (!is_null($e)) {
			return (string)$message . ' <' . $e->__toString() . '>';
		}
		else {
			return (string)$message;
		}
	}
	
	
	public function trace($message, $e = null) {
		$this->getLogger()->log($this->buildMessage($message, $e), PEAR_LOG_DEBUG);
	}
	
	
	public function debug($message, $e = null) {
		$this->getLogger()->log($this->buildMessage($message, $e), PEAR_LOG_DEBUG);
	}
	
	
	public function info($message, $e = null) {
		$this->getLogger()->log($this->buildMessage($message, $e), PEAR_LOG_INFO);
	}
		
	
	public function warn($message, $e = null) {
		$this->getLogger()->log($this->buildMessage($message, $e), PEAR_LOG_WARNING);
	}
		
	
	public function error($message, $e = null) {
		$this->getLogger()->log($this->buildMessage($message, $e), PEAR_LOG_ERR);
	}
		
	
	public function fatal($message, $e = null) {
		$this->getLogger()->log($this->buildMessage($message, $e), PEAR_LOG_EMERG);
	}
		
	
	public function isTraceEnabled() {
		return (bool)$this->_logger->_isMasked(PEAR_LOG_DEBUG);
	}
		
	
	public function isDebugEnabled() {
		return (bool)$this->_logger->_isMasked(PEAR_LOG_DEBUG);
	}
	
	
	public function isInfoEnabled() {
		return (bool)$this->_logger->_isMasked(PEAR_LOG_INFO);
	}
	
	
	public function isWarnEnabled() {
		return (bool)$this->_logger->_isMasked(PEAR_LOG_WARNING);
	}
	
	
	public function isErrorEnabled() {
		return (bool)$this->_logger->_isMasked(PEAR_LOG_ERR);
	}
	
	
	public function isFatalEnabled() {
		return (bool)$this->_logger->_isMasked(PEAR_LOG_EMERG);
	}

	
	public function shutdown() {
		$this->_logger->close();
	}
	
}

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * c-hanging-comment-ender-p: nil
 * End:
 */
?>