<?php
/**
* formCreator.inc ϥե饤֥
*
* The MIT License
* Copyright (c) 2002-2003 phpcuppa project
*
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to dea
* l in the Software without restriction, including without limitation the righ
* ts to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is furni
* shed to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in a
* ll copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR I
* MPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITN
* ESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTH
* ORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILIT
* Y, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
*  OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFT
* WARE.
*
* ϥǡܤ򤹤ե
* @package aglib
* @access public
* @version 0.1
* @author Furukawa Atsushi <agl@violet.plala.or.jp>
* @since 2002/09/07
*/

class formCreator {
	/**
	 * @access private
	 * ܤͤꤹ
	*/
	function _set_value($item, $value)
	{
		$output = "";
		if (is_null($item) || $item=="")	return null;
		$output .= "name=\"" . $item . "\" ";
		$output .= "value=\"" . htmlspecialchars($value) . "\"";
		return $output;
	}


	/** Hiddenܽ
	 * hiddenιܤϤ
	 * @access public
	 * @param  $item               ̾(FORMϻλ̾)
	 * @param  $value              
	 * @param  $visible(&optional) ܽϥե饰(Default:off)<br>trueΤȤͤɽ
	 */
	function hidden($item, $value, $visible=false)
	{
		$output = "<input type=\"hidden\" ";
		if (is_null($item) || $item=="")	return null;
		// if (is_null($value) || $value=="")  return null;

		$output .= $this->_set_value($item, $value) . ">";
		if ($visible) {
			$output .= htmlspecialchars($value);
		}
		$output .= "\n";
		return $output;
	}

	/** Textܽ
	 * textιܤϤ
	 * @access public
	 * @param  $item            ̾(FORMϻλ̾)
	 * @param  $value           
	 * @param  $size=30			ܽϥե饰(Default:off)<br>trueΤȤͤɽ
	 */
	function text($item, $value, $size=30)
	{
		$output = "<input type=\"text\" ";
		if (is_null($item) || $item=="")	return null;

		$output = "<input type=\"text\" ";
		$output .= $this->_set_value($item, $value) . " size=\"$size\">\n";
		return $output;
	}

	/** ܥܥåꥹȽ
	 * ޥơ֥򻲾ȤꥹȡܥܥåǤ褦ˤ롣
	 * @access public
	 * @param  $item               ̾(FORMϻλ̾)
	 * @param  $values             ͥꥹ
	 * @param  $default(&optional) 
	 * @param  $size(&optional)    ɽܿ(1:combobox, >1:list)
	 * @param  $multi(&optional)   ʣĥե饰
	 */
	function select($item, $values, $default="", $size=1, $multi=false)
	{
		$output = null;
		if (is_null($item) || $item=="")    return null;
		$output ="<select name=\"" . $item;
		if ($size>1 || $multi)  $output .= "[]\"";
			else				$output .= "\"";
		if ($size>1) 			$output .= " size=$size multiple";
		$output .= ">\n";

		if ($size<2 && $default==""){
			$output .= "  <option value=\"\"> ---</option>\n";
		}
		for ($i=0; $i<count($values); $i++) {
			$key = $values[$i];
			if (is_array($key)){ $name = $key[1]; $key = $key[0]; }
				else {			 $name = $key; }
			$output .= "  <option value=\"" . htmlspecialchars($key) . "\"";
			if (is_array($default)) {
				if (in_array($key,  $default))	$output .= " selected";
			} else {
				if ($key==$default)				$output .= " selected";
			}
			$output .= "> ";
			$output .= htmlspecialchars($name) . "</option>\n";
		}
		$output .=  "</select>\n";
		return $output;
	}

	/** 
	 * åܥå饸ܥ
	 * @access public
	 * @param  $item               ̾(FORMϻλ̾)
	 * @param  $values             ͥꥹ
 	 * @param  $colmax(&optional)  1Ԥɽܤο(0:1ɽ) default:0
 	 * @param  $type   			   ܼ(radio/checkbox) default: checkbox
	 */
	function checkbox($item, $values, $default="", $colmax=0, $type="checkbox")
	{
		if (is_null($item) || $item=="")		 	return null;
		if (is_null($values) || !is_array($values))	return null;
		if ($type!="checkbox" && $type!="radio")	return null;

		$output = "<table>\n";
		$col = 0;
		for ($i=0; $i<count($values); $i++) {
			$value = $values[$i];
			if (is_array($value)) {
				$name = $value[1];
				$value = $value[0];
			} else {
				$name  = $value;
			}
			
			if ($col == 0){
				$output .= "<tr>\n";
			}
			// item string
			if ($value==$default)										$checked = " checked";
			elseif (is_array($default) && in_array($value, $default))	$checked = " checked";
			else														$checked = "";
			$itemstr = "<input type=\"$type\" ". $this->_set_value($item."[]", $value) . $checked . ">" . htmlspecialchars($name);
			
			$output .= "  <td>" . $itemstr . "</td>\n";
			$col++;
			if ($colmax>0 && $col>=$colmax) {
				$output .= "</tr>\n";
				$col = 0;
			}
		}
		if ($col > 0)	$output .= "</tr>\n";
		$output .= "</table>\n";
		return $output;
	}

	/** 
	 * åܥå(Yes/No)
	 * @access public
	 * @param  $item               ̾(FORMϻλ̾)
	 * @param  $value              	ͥꥹ
 	 * @param  $colmax(&optional)  1Ԥɽܤο(0:1ɽ) default:0
 	 * @param  $type   			   ܼ(radio/checkbox) default: checkbox
	 */
	function check1($item, $value="")
	{
		if (is_null($item) || $item=="")		 	return null;
		$output = "<input type=\"checkbox\" name=\"$item\"";
		if ($value!="" && $value!=0) $output .= " checked";
		$output .= ">";
		return $output;
	}

}
