<?php

class phpdao_cfg
{
  static $config = array();

  public static function __initialize() //{{{
  {
    self::$config['root'] = dirname(__FILE__);
    self::load_config_file();
  }//}}}
  public static function get($key) //{{{
  {
    return self::$config[$key];
  } //}}}
  
  public function load_config_file($filename=null) //{{{
  {
    if( null === $filename )
    {
      $filename = dirname(__FILE__)."/cfg/phpdao.ini";
    }
    foreach( file($filename) as $line )
    {
      list($line,$comment) = explode("#",$line);
      list($left,$right) = explode('=',$line);
      if( $left == "" )
        continue;

      self::$config[trim($left)] = trim($right);
    }
  }//}}}
}
phpdao_cfg::__initialize();
