<?php
  /**************************************************************************\
  * phpGroupWare - PHPWebHosting                                             *
  * http://www.phpgroupware.org                                              *
  * --------------------------------------------                             *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  \**************************************************************************/

	/* $Id: preferences.php,v 1.1.1.1 2004/04/06 21:57:15 kazuyan Exp $ */

	$GLOBALS['phpgw_info']["flags"] = array
	(
		"currentapp" => "filemanager",
		"enable_nextmatchs_class" => True,
		"noheader" => True,
		"nonavbar" => True
	);

	include("../header.inc.php");

	/*
	   To add an on/off preference, just add it here.  Key is internal name, value is displayed name
	*/
	$other_checkboxes = array("viewinnewwin" => lang("View documents in new window"),
								"viewonserver" => lang("View documents on server (if available)"),
								"viewtextplain" => lang("Unknown MIME-type defaults to text/plain when viewing"),
								"dotdot" => lang('Show ..'),
								"dotfiles" => lang('Show dotfiles'),
								"show_help" => lang('Show help'),
								"show_command_line" => lang('Show command line (EXPERIMENTAL. DANGEROUS)'));

	/*
	   To add a dropdown preferences, add it here.  Key is internal name, value key is
	   displayed name, value values are choices in the dropdown
	*/
	$other_dropdown = array ("show_upload_boxes" => array (lang("Default number of upload fields to show"), "1", "5", "10", "20", "30"));
	
	/*
	   To add a input field preferences, add it here.  Key is internal name, value key is
	   displayed name, value values are choices in the dropdown
	*/

	if ($_POST['save'])
	{
		$values = $_POST['values'];
		$select_values = $_POST['select_values'];
		$quota_value = '';
		//_debug_array($_POST);
		
		$repository = $GLOBALS['phpgw']->preferences->read();
		$quota_value = $repository['filemanager']['set_quota'];
		
		$GLOBALS['phpgw']->preferences->read_repository();
		$GLOBALS['phpgw']->preferences->delete('filemanager','');
		
		while (is_array($values) && list($internal) = each($values))
		{
			$GLOBALS['phpgw']->preferences->change('filemanager',$internal,(isset($internal)?$internal:''));
		}
		
		while (is_array($select_values) && list($internal,$displayed) = each($select_values))
		{
			$GLOBALS['phpgw']->preferences->change('filemanager',$internal,$displayed);
		}
		
		while (is_array($select_values) && list ($internal, $displayed) = each ($select_values))
		{
			echo 'drin';
			$GLOBALS['phpgw']->preferences->change('filemanager',$internal,$displayed);
		}
		
		$GLOBALS['phpgw']->preferences->change('filemanager','set_quota',$quota_value);
		
		$GLOBALS['phpgw']->preferences->save_repository();
     
		$GLOBALS['phpgw']->redirect_link('/preferences/index.php');
		$GLOBALS['phpgw']->common->phpgw_exit();
	}

	if ($_POST['cancel'])
	{
		$GLOBALS['phpgw']->redirect_link('/preferences/index.php');
		$GLOBALS['phpgw']->common->phpgw_exit();
	}

	function display_item($field,$data)
	{
		$tr_color = $GLOBALS['phpgw']->nextmatchs->alternate_row_color ($tr_color);
		$var = array (
			'bg_color'	=>	$tr_color,
			'field'		=>	$field,
			'data'		=>	$data
		);
		$GLOBALS['phpgw']->template->set_var($var);
		$GLOBALS['phpgw']->template->fp('row','normal',True);
	}

	$GLOBALS['phpgw_info']['flags']['app_header'] = lang('filemanager') . ': ' . lang('preferences');
	$GLOBALS['phpgw']->common->phpgw_header ();
	echo parse_navbar ();

	$GLOBALS['phpgw']->template->set_file(array('prefs' => 'pref.tpl'));
	$GLOBALS['phpgw']->template->set_block('prefs','normal');

	$var = array(
		'action_url'	=> $GLOBALS['phpgw']->link ('/' . $GLOBALS['phpgw_info']['flags']['currentapp'] . '/preferences.php'),
		'bg_color'		=> $GLOBALS['phpgw_info']['theme']['th_bg'],
		'lang_save'		=> lang ('save'),
		'lang_cancel'	=> lang('cancel')		
	);
	
	$GLOBALS['phpgw']->template->set_var ($var);

	if ($totalerrors)
	{
		echo '<p><center>' . $GLOBALS['phpgw']->common->error_list($errors) . '</center>';
	}

	display_item('<b>' . lang('Display attributes') . '</b>','&nbsp;');

	while (list($internal, $displayed) = each($file_attributes))
	{
		unset ($checked);
		if ($GLOBALS['phpgw_info']["user"]["preferences"]["filemanager"][$internal])
		{
			$checked = 1;
		}

		$str = html_form_input("checkbox", $internal, NULL, NULL, NULL, $checked, NULL, '', 1, True);
		display_item ($displayed, $str);
		//$str .= html_form_input("checkbox", $internal, NULL, NULL, NULL, $checked, NULL, 1) . " $displayed" . html_break (1, NULL, 1);
	}

	display_item ('<b>' . lang('other settings') . '</b>','&nbsp;');

	reset ($other_checkboxes);
	while (list ($internal, $displayed) = each ($other_checkboxes))
	{
		unset ($checked);
		if ($GLOBALS['phpgw_info']["user"]["preferences"]["filemanager"][$internal])
		{
			$checked = 1;
		}

		$str = html_form_input ("checkbox", $internal, NULL, NULL, NULL, $checked, NULL, '', 1, True);
		display_item ($displayed, $str);
	}

	reset ($other_dropdown);
	while (list($internal, $value_array) = each($other_dropdown))
	{
		reset($value_array);
		unset($options);
		while (list($num, $value) = each($value_array))
		{
			if ($num == 0)
			{
				$displayed = $value;
				continue;
			}

			$options .= html_form_option($value, $value,$GLOBALS['phpgw_info']["user"]["preferences"]["filemanager"][$internal] == $value, '', True);
		}

		$output = html_form_select_begin($internal, True, True, True);
		$output .= $options;
		$output .= html_form_select_end(True);

		display_item($displayed, $output);
	}

	$GLOBALS['phpgw']->template->set_var('normal','');
	$GLOBALS['phpgw']->template->pfp('out','prefs');
	$GLOBALS['phpgw']->common->phpgw_footer();
?>
