<?php
/***************************************************************************
* copyright            : (C) 2001-2003 Advanced Internet Designs Inc.
* email                : forum@prohost.org
* $Id: admcat.php,v 1.1.1.1.8.1 2004/11/24 14:42:20 kazuyan Exp $
*
* This program is free software; you can redistribute it and/or modify it 
* under the terms of the GNU General Public License as published by the 
* Free Software Foundation; either version 2 of the License, or 
* (at your option) any later version.
***************************************************************************/

	require('./GLOBALS.php'); fud_phpgw();

	fud_use('adm.inc', true);
	fud_use('cat.inc', true);
	fud_use('widgets.inc', true);

	$tbl = $GLOBALS['DBHOST_TBL_PREFIX'];

	$edit = isset($_GET['edit']) ? (int)$_GET['edit'] : (isset($_POST['edit']) ? (int)$_POST['edit'] : '');

	if (isset($_POST['cat_submit'])) {
		if (!empty($_POST['cat_description'])) {
			$_POST['cat_description'] = ' - ' . $_POST['cat_description'];
		}
		$_POST['cat_cat_opt'] = ($_POST['cat_allow_collapse'] == 'Y' ? 1 : 0) | ($_POST['cat_default_view'] == 'COLLAPSED' ? 2 : 0);
		unset($_POST['cat_allow_collapse'], $_POST['cat_allow_collapse']);

		$cat = new fud_cat;
		if ($edit) {
			$cat->sync($edit);
			$edit = '';
		} else {
			$cat->add($_POST['cat_pos']);
			rebuild_forum_cat_order();
		}
	}
	if ($edit && ($c = db_arr_assoc('SELECT name, description, cat_opt FROM '.$tbl.'cat WHERE id='.$edit))) {
		foreach ($c as $k => $v) {
			${'cat_'.$k} = $v;
		}
		if ($cat_description && !strncmp($cat_description, ' - ', 3)) {
			$cat_description = substr($cat_description, 3);
		}
		$cat_opt = $c['cat_opt'];
	} else {
		$tmp = new fud_cat;
		$c = get_object_vars($tmp);
		foreach ($c as $k => $v) {
			${'cat_'.$k} = '';
		}
		$cat_pos = 'LAST';
		$cat_opt = 1;
	}

	if (isset($_GET['del'])) {
		$del = (int)$_GET['del'];
		db_lock($tbl.'cat WRITE, '.$tbl.'cat c WRITE, '.$tbl.'forum WRITE, '.$tbl.'forum f WRITE, '.$tbl.'fc_view WRITE');
		q_singleval('DELETE FROM '.$tbl.'cat WHERE id='.$del);
		if (db_affected()) {
			q('UPDATE '.$tbl.'forum SET cat_id=0 WHERE cat_id='.$del);
			cat_rebuild_order();
			rebuild_forum_cat_order();
		}
		db_unlock();
	}
	if (isset($_GET['chpos'], $_GET['newpos'])) {
		cat_change_pos((int)$_GET['chpos'], (int)$_GET['newpos']);
		rebuild_forum_cat_order();
		unset($_GET['chpos'], $_GET['newpos']);
	}

	require($WWW_ROOT_DISK . 'adm/admpanel.php');
?>
<h2><?php echo lang('Category Management System') ?></h2>
<?php
	if (!isset($_GET['chpos'])) {
?>
<form method="post" action="admcat.php">
<?php echo _hs; ?>
<table border="0" cellspacing="1" cellpadding="3">
	<tr bgcolor="#bff8ff">
		<td><?php echo lang('Category Name') ?>:</td>
		<td><input type="text" name="cat_name" value="<?php echo htmlspecialchars($cat_name); ?>" maxLength="50"></td>
	</tr>

	<tr bgcolor="#bff8ff">
		<td><?php echo lang('Description') ?>:</td>
		<td><input type="text" name="cat_description" value="<?php echo htmlspecialchars($cat_description); ?>" maxLength="255"></td>
	</tr>

	<tr bgcolor="#bff8ff">
		<td><?php echo lang('Collapsible') ?></td>
		<td><?php draw_select('cat_allow_collapse', "Yes\nNo", "Y\nN", $cat_opt & 1); ?></td>
	</tr>

	<tr bgcolor="#bff8ff">
		<td><?php echo lang('Default view') ?>: </td>
		<td><?php draw_select('cat_default_view', "Open\nCollapsed", "OPEN\nCOLLAPSED", !($cat_opt & 2)); ?></td>
	</tr>

	<?php if (!$edit) { ?>

	<tr bgcolor="#bff8ff">
		<td><?php echo lang('Insert position') ?>:</td>
		<td><?php draw_select('cat_pos', "Last\nFirst", "LAST\nFIRST", $cat_pos); ?></td>
	</tr>

	<?php } ?>

	<tr bgcolor="#bff8ff">
		<td colspan="2" align="right">
<?php
	if ($edit) {
		echo '<input type="submit" name="btn_cancel" value="'.lang('Cancel').'">&nbsp;';
	}
?>
			<input type="submit" value="<?php echo ($edit ? lang('Update Category') : lang('Add Category')); ?>" name="cat_submit">
		</td>
	</tr>
</table>
<?php
		if ($edit) {
			echo '<input type="hidden" value="'.$edit.'" name="edit">';
		}
		echo '</form>';
	} else {
		echo '<a href="admcat.php?'._rsidl.'">'.lang('Cancel').'</a><br>';
	}
?>
<br>
<table border="0" cellspacing="3" cellpadding="2">
<tr bgcolor="#e5ffe7">
	<td><?php echo lang('Category Name') ?></td>
	<td><?php echo lang('Description') ?></td>
	<td><?php echo lang('Collapsible') ?></td>
	<td><?php echo lang('Default View') ?></td>
	<td align="center"><?php echo lang('Action') ?></td>
	<td><?php echo lang('Position') ?></td>
</tr>
<?php
	$c = uq('SELECT * FROM '.$tbl.'cat ORDER BY view_order');
	$i = 1;
	if (function_exists('mb_substr'))
		$substr_func = 'mb_substr';
	else
		$substr_func = 'substr';
	while ($r = db_rowobj($c)) {
		if ($edit == $r->id) {
			$bgcolor = ' bgcolor="#ffb5b5"';
		} else {
			$bgcolor = ($i++%2) ? ' bgcolor="#fffee5"' : '';
		}
		if (isset($_GET['chpos'])) {
			if ($_GET['chpos'] == $r->view_order) {
				$bgcolor = ' bgcolor="#ffb5b5"';
			} else if ($_GET['chpos'] != ($r->view_order - 1)) {
				echo '<tr bgcolor="#efefef"><td align="center" colspan="7"><font size="-1"><a href="admcat.php?chpos='.$_GET['chpos'].'&newpos='.($r->view_order - ($_GET['chpos'] < $r->view_order ? 1 : 0)).'&'._rsidl.'">'.lang('Place Here').'</a></font></td></tr>';
			}
			$lp = $r->view_order;
		}
		if ($r->description && !strncmp($r->description, ' - ', 3)) {
			$r->description = substr($r->description, 3);
		}

		echo '<tr '.$bgcolor.'>
			<td>'.$r->name.'</td>
			<td>'.$substr_func($r->description, 0, 30).'</td>
			<td>'.($r->cat_opt & 1 ? lang('Yes') : lang('No')).'</td>
			<td>'.($r->cat_opt & 2 ? 'Collapsed' : 'Open').'</td>
			<td nowrap>[<a href="admforum.php?cat_id='.$r->id.'&'._rsidl.'">'.lang('Edit Forums').'</a>] [<a href="admcat.php?edit='.$r->id.'&'._rsidl.'">'.lang('Edit Category').'</a>] [<a href="admcat.php?del='.$r->id.'&'._rsidl.'">'.lang('Delete').'</a>]</td>
			<td>[<a href="admcat.php?chpos='.$r->view_order.'&'._rsidl.'">'.lang('Change').'</a>]</td></tr>';

		if (isset($_GET['chpos']) && $_GET['chpos'] == ($r->view_order -1)) {

		}
	}
	if (isset($lp)) {
		echo '<tr bgcolor="#efefef"><td align="center" colspan="7"><font size="-1"><a href="admcat.php?chpos='.$_GET['chpos'].'&newpos='.($lp + 1).'&'._rsidl.'">'.lang('Place Here').'</a></font></td></tr>';
	}
?>
</table>
<?php require($WWW_ROOT_DISK . 'adm/admclose.php'); ?>
