<?php
  /**************************************************************************\
  * phpGroupWare - addressbook                                               *
  * http://www.phpgroupware.org                                              *
  * Written by Joseph Engo <jengo@phpgroupware.org>                          *
  * --------------------------------------------                             *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  \**************************************************************************/

  /* $Id: class.uiXport.inc.php,v 1.5.24.1 2007/09/14 01:55:21 kazuyan Exp $ */

	class uiXport
	{
		var $template;
		var $public_functions = array(
			'import' => True,
			'export' => True
		);
		var $bo;
		var $cat;

		var $start;
		var $limit;
		var $query;
		var $sort;
		var $order;
		var $filter;
		var $cat_id;

		function uiXport()
		{
			$this->template = $GLOBALS['phpgw']->template;
			$this->cat      = CreateObject('phpgwapi.categories');
			$this->bo       = CreateObject('addressbook.boXport',True);
			$this->browser  = CreateObject('phpgwapi.browser');

			$this->start    = $this->bo->start;
			$this->limit    = $this->bo->limit;
			$this->query    = $this->bo->query;
			$this->sort     = $this->bo->sort;
			$this->order    = $this->bo->order;
			$this->filter   = $this->bo->filter;
			$this->cat_id   = $this->bo->cat_id;
		}

		/* Return a select form element with the categories option dialog in it */
		function cat_option($cat_id='',$notall=False,$java=True,$multiple=False)
		{
			if ($java)
			{
				$jselect = ' onChange="this.form.submit();"';
			}
			/* Setup all and none first */
			$cats_link  = "\n" .'<select name="fcat_id'.($multiple?'[]':'').'"' .$jselect . ($multiple ? 'multiple size="3"' : '') . ">\n";
			if (!$notall)
			{
				$cats_link .= '<option value=""';
				if ($cat_id=='all')
				{
					$cats_link .= ' selected';
				}
				$cats_link .= '>'.lang('all').'</option>'."\n";
			}

			/* Get global and app-specific category listings */
			$cats_link .= $this->cat->formated_list('select','all',$cat_id,True);
			$cats_link .= '</select>'."\n";
			return $cats_link;
		}

		function import()
		{
			if ($_REQUEST['convert'] && !empty($_FILES['tsvfile']['name'])) //&& ($_FILES['tsvfile']['error'] == UPLOAD_ERR_OK))
			{
				$buffer = $this->bo->import($_FILES['tsvfile']['tmp_name'],$_REQUEST['conv_type'],$_REQUEST['private'],$_REQUEST['fcat_id']);

				if ($_REQUEST['download'] == '')
				{
					if($_REQUEST['conv_type'] == 'Debug LDAP' || $_REQUEST['conv_type'] == 'Debug SQL' )
					{
						// filename, default application/octet-stream, length of file, default nocache True
						$GLOBALS['phpgw']->browser->content_header($tsvfilename,'',strlen($buffer));
						echo $buffer;
					}
					else
					{
						$GLOBALS['phpgw']->common->phpgw_header();
						echo parse_navbar();
						echo "<pre>$buffer</pre>";
						echo '<p align="center"><a href="'.$GLOBALS['phpgw']->link('/index.php','menuaction=addressbook.uiaddressbook.index') . '">'.lang('Back').'</a></p>';
						//$GLOBALS['phpgw']->common->phpgw_footer();
					}
				}
				else
				{
					$GLOBALS['phpgw']->common->phpgw_header();
					echo parse_navbar();
					echo "<pre>$buffer</pre>";
					echo '<p align="center"><a href="'.$GLOBALS['phpgw']->link('/index.php','menuaction=addressbook.uiaddressbook.index'). '">'.lang('Back').'</a></p>';
					//$GLOBALS['phpgw']->common->phpgw_footer();
				}

			}
			else
			{
				$GLOBALS['phpgw']->common->phpgw_header();
				echo parse_navbar();

				set_time_limit(0);
				
				if ($GLOBALS['phpgw_info']['user']['preferences']['common']['lang'] == 'ja')
					$this->template->set_file(array('import' => 'import_ja.tpl'));
				else	
					$this->template->set_file(array('import' => 'import.tpl'));

				$dir_handle = opendir(PHPGW_APP_INC . SEP . 'import');
				$i=0; $myfilearray = '';
				while ($file = readdir($dir_handle))
				{
					if ((substr($file, 0, 1) != '.') && is_file(PHPGW_APP_INC . SEP . 'import' . SEP . $file) )
					{
						$myfilearray[$i] = $file;
						$i++;
					}
				}
				closedir($dir_handle);
				sort($myfilearray);
				for ($i=0;$i<count($myfilearray);$i++)
				{
					$fname = ereg_replace('_',' ',$myfilearray[$i]);
					$conv .= '<OPTION VALUE="' . $myfilearray[$i].'">' . $fname . '</OPTION>';
				}

				$this->template->set_var('lang_cancel',lang('Cancel'));
				$this->template->set_var('lang_cat',lang('Select Category'));
				$this->template->set_var('cancel_url',$GLOBALS['phpgw']->link('/index.php','menuaction=addressbook.uiaddressbook.index'));
				$this->template->set_var('navbar_bg',$GLOBALS['phpgw_info']['theme']['navbar_bg']);
				$this->template->set_var('navbar_text',$GLOBALS['phpgw_info']['theme']['navbar_text']);
				$this->template->set_var('import_text',lang('Import from LDIF, CSV, or VCard'));
				$this->template->set_var('action_url',$GLOBALS['phpgw']->link('/index.php','menuaction=addressbook.uiXport.import'));
				$this->template->set_var('cat_link',$this->cat_option($this->cat_id,False,False));
				//$this->template->set_var('cat_link',$this->cat_option($this->cat_id,True,False));
				$this->template->set_var('tsvfilename','');
				$this->template->set_var('conv',$conv);
				$this->template->set_var('debug',lang('Debug output in browser'));
				$this->template->set_var('filetype',lang('LDIF'));
				$this->template->set_var('download',lang('Submit'));
				$this->template->set_var('start',$this->start);
				$this->template->set_var('sort',$this->sort);
				$this->template->set_var('order',$this->order);
				$this->template->set_var('filter',$this->filter);
				$this->template->set_var('query',$this->query);
				$this->template->set_var('cat_id',$this->cat_id);
				$this->template->pparse('out','import');
			}
//			$GLOBALS['phpgw']->common->phpgw_footer();
		}

		function export()
		{
			//global $tsvfilename,$both_types,$sub_cats;
			$convert = get_var('convert', array('GET','POST'));
			$tsvfilename = get_var('tsvfilename', array('GET','POST'));
			$fcat_id = get_var('fcat_id', array('GET','POST'));
			$download = get_var('download', array('GET','POST'));
			$conv_type = get_var('conv_type', array('GET','POST'));
			$both_types = get_var('both_types', array('GET','POST'));
			$sub_cats = get_var('sub_cats', array('GET','POST'));
			
			// get the data to create the sql query used by the addressbook display 
			$export_vars = $GLOBALS['phpgw']->session->appsession('export_vars','addressbook');
			//echo "<pre>Export_vars: "; print_r($export_vars); echo "</pre>\n";
			
			//$entries = $this->bo->$get_data_function($fields, $this->limit, $this->start, $this->order, $this->sort, '', $criteria);
			
			if ($_REQUEST['convert'])
			{
				if ($_REQUEST['conv_type'] == 'none')
				{
					$GLOBALS['phpgw_info']['flags']['noheader'] = False;
					$GLOBALS['phpgw_info']['flags']['noheader'] = True;
					$GLOBALS['phpgw']->common->phpgw_header();
					echo parse_navbar();
					echo lang('<b>No conversion type &lt;none&gt; could be located.</b>  Please choose a conversion type from the list');
					echo '&nbsp<a href="'.$GLOBALS['phpgw']->link('/index.php','menuaction=addressbook.uiXport.export') . '">' . lang('OK') . '</a>';
					$GLOBALS['phpgw']->common->phpgw_footer();
					$GLOBALS['phpgw']->common->phpgw_exit();
				}

				$buffer = $this->bo->export($_REQUEST['conv_type'],$_REQUEST['fcat_id'],$both_types,$sub_cats);
				
				// Note our use of ===.  Simply == would not work as expected
				if(!(strpos($_REQUEST['conv_type'], 'OpenOffice') === false))
				{
					// filename, default application/octet-stream, length of file, default nocache True
					//$this->browser->content_header($tsvfilename,'application/x-octet-stream',strlen($buffer));
					//$this->browser->content_header($tsvfilename,'application/vnd.sun.xml.writer');
					//echo $tsvfilename;
					//echo $buffer;
					//echo basename($buffer);
					//$this->browser->content_header($tsvfilename,'');
					$this->browser->content_header(basename($buffer),'');//echo $buffer;
					readfile($buffer);
					//echo $tsvfilename;
					
				}
				elseif(($_REQUEST['download'] == 'on') || ($_REQUEST['conv_type'] == 'Palm_PDB') )
				{
					// filename, default application/octet-stream, length of file, default nocache True
					$this->browser->content_header($tsvfilename,'application/x-octet-stream',strlen($buffer));
					echo $buffer;
					$GLOBALS['phpgw']->common->phpgw_exit();
				}
				else
				{
					$GLOBALS['phpgw']->common->phpgw_header();
					echo parse_navbar();
					echo "<pre>\n";
					echo $buffer;
					echo "\n</pre>\n";
					echo '<a href="'.$GLOBALS['phpgw']->link('/index.php','menuaction=addressbook.uiXport.export') . '">' . lang('OK') . '</a>';
					$GLOBALS['phpgw']->common->phpgw_footer();
				}
			}
			else
			{
				$GLOBALS['phpgw']->common->phpgw_header();
				echo parse_navbar();

				set_time_limit(0);
				
				$this->template->set_file(array('export' => 'export.tpl'));

				$dir_handle = opendir(PHPGW_APP_INC. SEP . 'export');
				$i=0; $myfilearray = '';
				while ($file = readdir($dir_handle))
				{
					if ((substr($file, 0, 1) != '.') && is_file(PHPGW_APP_INC . SEP . 'export' . SEP . $file) )
					{
						$myfilearray[$i] = $file;
						$i++;
					}
				}
				closedir($dir_handle);
				sort($myfilearray);
				for ($i=0;$i<count($myfilearray);$i++)
				{
					$fname = ereg_replace('_',' ',$myfilearray[$i]);
					$conv .= '        <option value="'.$myfilearray[$i].'">'.$fname.'</option>'."\n";
				}

				$this->template->set_var('lang_cancel',lang('Cancel'));
				$this->template->set_var('lang_cat',lang('Select Category'));
				$this->template->set_var('cat_link',$this->cat_option($this->cat_id,False,False));
				$this->template->set_var('cancel_url',$GLOBALS['phpgw']->link('/addressbook/index.php'));
				$this->template->set_var('navbar_bg',$GLOBALS['phpgw_info']['theme']['navbar_bg']);
				$this->template->set_var('navbar_text',$GLOBALS['phpgw_info']['theme']['navbar_text']);
				$this->template->set_var('export_text',lang('Export from Addressbook'));
				$this->template->set_var('action_url',$GLOBALS['phpgw']->link('/index.php','menuaction=addressbook.uiXport.export'));
				$this->template->set_var('filename',lang('Export file name'));
				$this->template->set_var('conv',$conv);
				$this->template->set_var('debug',lang(''));
				$this->template->set_var('download',lang('Submit'));
				$this->template->set_var('start',$this->start);
				$this->template->set_var('sort',$this->sort);
				$this->template->set_var('order',$this->order);
				$this->template->set_var('filter',$this->filter);
				$this->template->set_var('query',$this->query);
				$this->template->set_var('cat_id',$this->cat_id);
				$this->template->set_var('lang_conv_type',lang('Select the type of conversion'));
				$this->template->set_var('lang_download',lang('Download export file (Uncheck to debug output in browser)'));
				$this->template->set_var('lang_option_openoffice',lang('OpenOffice export only uses the following options:'));
				$this->template->set_var('lang_option_openoffice_descr1',lang('OpenOffice.org only - Include fields from both types of contacts? (Uncheck to only include fields from previous screen)'));
				$this->template->set_var('lang_option_openoffice_descr2',lang('OpenOffice.org only - Include field for category names (only sub-categories if category is selected)'));
				$this->template->pparse('out','export');

				//$GLOBALS['phpgw']->common->phpgw_footer();
			}
		}
	}
?>
