<?php
  /**************************************************************************\
  * phpGroupWare - Email's Sidebox-Menu for idots-template                   *
  * http://www.phpgroupware.org                                              *
  * Written by Kazuya Nouchi <kazuya@phpgroupware.jp>                        *
  * --------------------------------------------                             *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  \**************************************************************************/

  /* $Id: hook_sidebox_menu.inc.php,v 1.1.20.1 2007/09/14 02:13:36 kazuyan Exp $ */
{
	$menu_title = $GLOBALS['phpgw_info']['apps'][$appname]['title'] . ' '. lang('Menu');
	if (!is_object($GLOBALS['phpgw']->msg))
	{
		$GLOBALS['phpgw']->msg = CreateObject('email.msg');
	}
	$mailacct = $GLOBALS['phpgw']->msg->get_acctnum();
	$has_folders = $GLOBALS['phpgw']->msg->get_mailsvr_supports_folders();
	$compose_link = $GLOBALS['phpgw']->link('/index.php',array(
		'menuaction' => 'email.uicompose.compose',
		// this data tells us where to return to after sending a message
		'fldball[folder]' => $GLOBALS['phpgw']->msg->prep_folder_out(),
		'fldball[acctnum]' => $mailacct,
		'sort' => $GLOBALS['phpgw']->msg->get_arg_value('sort'),
		'order' => $GLOBALS['phpgw']->msg->get_arg_value('order'),
		'start' => $GLOBALS['phpgw']->msg->get_arg_value('start')));

	$file = Array(array('text' => 'Compose Message', 'url' => $compose_link));
	if ($has_folders)
	{
		$folders_link = $GLOBALS['phpgw']->link('/index.php',array(
			'menuaction' => 'email.uifolder.folder',
			'fldball[folder]' => $GLOBALS['phpgw']->msg->prep_folder_out('INBOX'),
			'fldball[acctnum]' => $mailacct));
		$search_link = $GLOBALS['phpgw']->link('/index.php',array(
			'menuaction' => 'email.uisearch.form',
			'fldball[folder]' => $GLOBALS['phpgw']->msg->prep_folder_out(''),
			'fldball[acctnum]' => $mailacct));
		$file[] = array('text' => 'Folders', 'url' => $folders_link);
		$file[] = array('text' => 'Search', 'url' => $search_link);
	}
	$filters_link = $GLOBALS['phpgw']->link('/index.php',array(
		'menuaction' => 'email.uifilters.filters_list',
		'fldball[folder]' => $GLOBALS['phpgw']->msg->prep_folder_out(''),
		'fldball[acctnum]' => $mailacct));
	$file[] = array('text' => 'Filter', 'url' => $filters_link);
	$accounts_link = $GLOBALS['phpgw']->link('/index.php',array(
		'menuaction' => 'email.uipreferences.ex_accounts_list'));
	$file[] = array('text' => 'Accounts', 'url' => $accounts_link);
	$email_prefs_link = $GLOBALS['phpgw']->link('/index.php',array(
		'menuaction' => 'email.uipreferences.preferences',
		'ex_acctnum' => $mailacct));				
	$file[] = array('text' => 'Settings', 'url' => $email_prefs_link);
	
	display_sidebox($appname,$menu_title,$file);
	
	if ($GLOBALS['phpgw_info']['user']['apps']['admin'])
	{
        $menu_title = lang('Administration');
        $file = Array(
        	array('text'	=> 'Site Configuration',
        		'url'		=> $GLOBALS['phpgw']->link('/index.php','menuaction=admin.uiconfig.index&appname='.$appname))
        );
		display_sidebox($appname,$menu_title,$file);
	}
}
?>
