<?php
  /**************************************************************************\
  * phpGroupWare application (NNTP)                                          *
  * http://www.phpgroupware.org                                              *
  * Written by Mark Peters <mpeters@satx.rr.com>                             *
  * --------------------------------------------                             *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  \**************************************************************************/

	/* $Id: index.php,v 1.1.1.2 2007/09/10 19:17:03 kazuyan Exp $ */

	@set_time_limit(0);	

	$GLOBALS['phpgw_info']['flags'] = array
					(
						'currentapp' => 'nntp',
						'noheader'   => True,
						'nonavbar'   => True
					);
	include('../header.inc.php');

	/**
	* Shutdown function to close the connection to the NNTP server
	*/
	function close_routine()
	{
		$GLOBALS['nntp']->close_port();
	}

	$news = array();

	if ( is_array($GLOBALS['phpgw_info']['user']['preferences']['nntp']) )
	{
		foreach ( $GLOBALS['phpgw_info']['user']['preferences']['nntp'] as $db_id => $ignored)
		{
			$news[] = $db_id;
		}
	}

	if ( count($news) == 0 )
	{
		header('Location: '.$GLOBALS['phpgw']->link('/nntp/preferences.php'));
		$GLOBALS['phpgw']->common->phpgw_exit();
	}

	$GLOBALS['nntp']->display = $GLOBALS['phpgw_info']['user']['preferences']['common']['maxmatchs'];
	if ( $GLOBALS['nntp']->errorset )
	{
		echo "{$GLOBALS['nntp']->error['msg']} : {$GLOBALS['nntp']->error['desc']}<br>\n";
		$GLOBALS['phpgw']->common->phpgw_exit();
	}
	else
	{
		$GLOBALS['phpgw']->common->phpgw_header();
		echo parse_navbar();
	}

	register_shutdown_function('close_routine');

	$p =& $GLOBALS['phpgw']->template;
	$p->set_root( $GLOBALS['phpgw']->common->get_tpl_dir('nntp') );

	$p->set_file('index_form', 'index.tpl');
	$p->set_block('index_form','index','index');
	$p->set_block('index_form','layout_table','layout_table');
	$p->set_block('index_form','basic_row','basic_row');

	$j = 0;
	$i = count($news);

	foreach ( $news as $group )
	{
		$j++;
		$s = '';
		if ( $GLOBALS['nntp']->read_table($group) )
		{
			$channel_url = '<a href="'.$GLOBALS['phpgw']->link('/nntp/viewgroup.php', array('folder' => $group) ).'" target="new" style="text-decoration: none; color: #000000; text-align: center">';
			$channel_title = $GLOBALS['nntp']->mailbox.'</a>';
		}
		else
		{
			$channel_url = '';
			$channel_title = $GLOBALS['nntp']->error['msg'].':'.$GLOBALS['nntp']->error['desc'];
		}
		
		$var = Array(
			'channel_url'   => $channel_url,
			'channel_title' => $channel_title
		);

		$p->set_var($var);

		if ($nntp->errorset)
		{
//			echo 'Found an error reading group: '.$group[1]."<br>\n";
			$p->set_var('item_link','');
			$p->set_var('item_label',$GLOBALS['nntp']->error['msg'].':'.$GLOBALS['nntp']->error['desc']);
			$s .= $p->fp('o_','basic_row');
		}
		elseif ($GLOBALS['nntp']->active == 'N')
		{
			$p->set_var('item_link','');
			$p->set_var('item_label',lang('%1 not active',$GLOBALS['nntp']->mailbox));
			$s .= $p->fp('o_','basic_row');
		}
		else
		{
			$links = $GLOBALS['nntp']->get_subjects();
			if (count($links)==0 || $links == 0)
			{
				$p->set_var('channel_url','');
				$p->set_var('channel_title',$GLOBALS['nntp']->mailbox);
				$p->set_var('item_link','');
				$p->set_var('item_label','No articles found!');
				$s .= $p->fp('o_','basic_row');
			}
			else
			{
				krsort($links);
				$clinks = count($links);
				for ($k=0,reset($links); $k<$clinks; $k++,next($links))
				{
					$key = key($links);
					$link_url = 
					$p->set_var('item_link', '<a href="' . $GLOBALS['phpgw']->link('/nntp/read_article.php', array('folder' => $group, 'msgnum' => $key) ) . "\">\n");
					$p->set_var('item_label', $links[$key] . '</a>');
					$s .= $p->fp('o_','basic_row');
				}
			}
		}
		$p->set_var('rows',$s);
		$p->set_var('section_' . $j,$p->fp('o','layout_table'));

		if ($j == 3 || $i == 1)
		{
			$p->pfp('out','index');
			$p->set_var('section_1', '');
			$p->set_var('section_2', '');
			$p->set_var('section_3', '');
			$j = 0;
		}
		$i--;
	}
	$GLOBALS['phpgw']->common->phpgw_footer();
?>
