<?php
  /**************************************************************************\
  * phpGroupWare application (NNTP)                                          *
  * http://www.phpgroupware.org                                              *
  * Written by Mark Peters <mpeters@satx.rr.com>                             *
  * --------------------------------------------                             *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  \**************************************************************************/

  /* $Id: viewgroup.php,v 1.1.1.2 2007/09/10 19:17:03 kazuyan Exp $ */

	$GLOBALS['phpgw_info']['flags'] = array
				(
					'currentapp'       => 'nntp',
					'enable_nextmatchs_class' => True,
					'enable_vfs_class' => True
				);
	include('../header.inc.php');

	function close_routine()
	{
		$GLOBALS['nntp']->close_port();
	}

	$folder = (int) isset($_GET['folder']) ? $_GET['folder'] : 0;
	$msgnum = (int) isset($_GET['msgnum']) ? $_GET['msgnum'] : 0;
	
	@set_time_limit(0);

	$GLOBALS['phpgw']->translation->add_app('email');

	$GLOBALS['phpgw']->db->query("SELECT active FROM newsgroups WHERE con = {$folder} AND active = 'Y'", __LINE__, __FILE__);
	if (($GLOBALS['phpgw']->db->num_rows() == 0) || !isset($GLOBALS['phpgw_info']['user']['preferences']['nntp'][$folder]) )
	{
		echo 'You do not have access to this newsgroup!'."<br>\n";
		$GLOBALS['phpgw']->common->phpgw_exit();
	}

	if(!$GLOBALS['folder'])
	{
		echo lang('Cannot display the requested newsgroup')."<br>\n";
		$GLOBALS['phpgw']->common->phpgw_exit();
	}

	$GLOBALS['nntp']->display = $GLOBALS['phpgw_info']['user']['preferences']['common']['maxmatchs'];
	if ($GLOBALS['nntp']->errorset)
	{
		echo $GLOBALS['nntp']->error['msg'].':'.$GLOBALS['nntp']->error['desc']."<br>\n";
		$GLOBALS['phpgw']->common->phpgw_exit();
	}
 
	register_shutdown_function("close_routine");

	$p =& $GLOBALS['phpgw']->template;
	$p->set_root( $GLOBALS['phpgw']->common->get_tpl_dir('nntp') );
	
	$p->set_file('view_group', 'view_group.tpl');
	$p->set_block('view_group','vg','vg');
	$p->set_block('view_group','vg_row','vg_row');

	$nntp->read_table($folder);

	$start = intval($_REQUEST['start']); 

	if( !isset($_REQUEST['tm']) )
	{
		$tm = ($GLOBALS['nntp']->highmsg - $GLOBALS['nntp']->lowmsg);
	}
	else
	{
		$tm = $_REQUEST['tm'];
	}
	
	if( !isset($_REQUEST['fm']) )
	{
		$fm = $GLOBALS['nntp']->lowmsg;
	}
	else
	{
		$fm = $_REQUEST['fm'];
	}

	$p->set_var(array
		(
			'th_bg'		=> $GLOBALS['phpgw_info']['theme']['th_bg'],
			'th_font'	=> $GLOBALS['phpgw_info']['theme']['font'],
			'th_text'	=> $GLOBALS['phpgw_info']['theme']['th_text'],
			'th_em_folder'	=> $GLOBALS['phpgw_info']['theme']['em_folder'],
			'th_em_text'	=> $GLOBALS['phpgw_info']['theme']['em_folder_text'],
			'folder'	=> $GLOBALS['nntp']->folder,
			'nml'		=> $GLOBALS['phpgw']->nextmatchs->left('/nntp/viewgroup.php',$start,$tm,'&folder='.$GLOBALS['folder'].'&tm='.$tm.'&fm='.$fm),
			'nmr'		=> $GLOBALS['phpgw']->nextmatchs->right('/nntp/viewgroup.php',$start,$tm,'&folder='.$GLOBALS['folder'].'&tm='.$tm.'&fm='.$fm),
			'row_color'	=> $GLOBALS['phpgw_info']['theme']['th_bg'],
			'from'		=> '<font size="2"><b>'.lang('from').'</b></font>',
			'subject'	=> '<font size="2"><b>'.lang('subject').'</b></font>',
			'date'		=> '<font size="2"><b>'.lang('date').'</b></font>'
			//'size'	=> '<font size="2"><b>'.lang('size').'</b></font>'
		));

	$p->set_var($var);
	$p->parse('rows','vg_row',True);

	if ( $GLOBALS['phpgw_info']['user']['preferences']['common']['maxmatchs'] <= ($tm - $start) )
	{
		$totaltodisplay = $GLOBALS['phpgw_info']['user']['preferences']['common']['maxmatchs'];
	}
	else
	{
		$totaltodisplay = ($tm - $start) - 1;
	}

	$firstmessage = ($fm + $start);
	$list = $GLOBALS['nntp']->get_list('from', $firstmessage, $totaltodisplay);
//	$subject = $GLOBALS['nntp']->get_list('subject',$firstmessage,$firstmessage+$totaltodisplay);
//	$date = $GLOBALS['nntp']->get_list('date',$firstmessage,$firstmessage+$totaltodisplay);

	for ( $i = 0; $i < $totaltodisplay; ++$i)
	{
		$tr_color = $GLOBALS['phpgw']->nextmatchs->alternate_row_color($tr_color);

		$subject_url = $GLOBALS['phpgw']->link('/nntp/read_article.php', array('folder' => $GLOBALS['nntp']->con, 'msgnum' => $list[$i]['Msgnum']) );

		$p->set_var(array
				(
					'row_color' => $tr_color,
					'from'      => '<font size="-1">'.$list[$i]['From'].'</font>',
					'subject'   => '<font size="-1"><a href="'.$subject_url.'">'.$list[$i]['Subject'].'</a></font>',
					'date'      => '<font size="-2">'.$GLOBALS['phpgw']->common->show_date($list[$i]['Date']).'</font>'
					//'size'      => ''
				));
		$p->parse('rows','vg_row',True);
	}        

	$p->pparse('out','vg');
	$GLOBALS['phpgw']->common->phpgw_footer();
?>
