<?php
	/**
	* Countries
	* @author Mark Peters <skeeter@phpgroupware.org>
	* @auhtor Dave Hall skwashd at phpGroupWare.org
	* @copyright Copyright (C) 2001 - 2006 Free Software Foundation http://www.fsf.org/
	* @license http://www.gnu.org/licenses/gpl.html GNU General Public License
	* @interal do not edit, edit and run phpgwapi/doc/generate-class-country.php to regenerate this class
	* @package phpgwapi
	* @subpackage contacts
	* @version $Id: class.country.inc.php,v 1.1.1.4.2.1 2007/09/14 02:58:33 kazuyan Exp $
	*/

	/**
	* Countries
	*
	* @package phpgwapi
	* @subpackage contacts
	*/
	class country
	{

		/**
		* @var array $country_array list of ISO 3166 country codes
		*/
		var $country_array = array
		(
			'  '	=> 'Select One',
			'AF'	=> 'AFGHANISTAN',
			'AL'	=> 'ALBANIA',
			'DZ'	=> 'ALGERIA',
			'AS'	=> 'AMERICAN SAMOA',
			'AD'	=> 'ANDORRA',
			'AO'	=> 'ANGOLA',
			'AI'	=> 'ANGUILLA',
			'AQ'	=> 'ANTARCTICA',
			'AG'	=> 'ANTIGUA AND BARBUDA',
			'AR'	=> 'ARGENTINA',
			'AM'	=> 'ARMENIA',
			'AW'	=> 'ARUBA',
			'AU'	=> 'AUSTRALIA',
			'AT'	=> 'AUSTRIA',
			'AZ'	=> 'AZERBAIJAN',
			'BS'	=> 'BAHAMAS',
			'BH'	=> 'BAHRAIN',
			'BD'	=> 'BANGLADESH',
			'BB'	=> 'BARBADOS',
			'BY'	=> 'BELARUS',
			'BE'	=> 'BELGIUM',
			'BZ'	=> 'BELIZE',
			'BJ'	=> 'BENIN',
			'BM'	=> 'BERMUDA',
			'BT'	=> 'BHUTAN',
			'BO'	=> 'BOLIVIA',
			'BA'	=> 'BOSNIA AND HERZEGOVINA',
			'BW'	=> 'BOTSWANA',
			'BV'	=> 'BOUVET ISLAND',
			'BR'	=> 'BRAZIL',
			'IO'	=> 'BRITISH INDIAN OCEAN TERRITORY',
			'BN'	=> 'BRUNEI DARUSSALAM',
			'BG'	=> 'BULGARIA',
			'BF'	=> 'BURKINA FASO',
			'BI'	=> 'BURUNDI',
			'KH'	=> 'CAMBODIA',
			'CM'	=> 'CAMEROON',
			'CA'	=> 'CANADA',
			'CV'	=> 'CAPE VERDE',
			'KY'	=> 'CAYMAN ISLANDS',
			'CF'	=> 'CENTRAL AFRICAN REPUBLIC',
			'TD'	=> 'CHAD',
			'CL'	=> 'CHILE',
			'CN'	=> 'CHINA',
			'CX'	=> 'CHRISTMAS ISLAND',
			'CC'	=> 'COCOS (KEELING) ISLANDS',
			'CO'	=> 'COLOMBIA',
			'KM'	=> 'COMOROS',
			'CG'	=> 'CONGO',
			'CD'	=> 'CONGO, THE DEMOCRATIC REPUBLIC OF THE',
			'CK'	=> 'COOK ISLANDS',
			'CR'	=> 'COSTA RICA',
			'CI'	=> 'COTE D\'IVOIRE',
			'HR'	=> 'CROATIA',
			'CU'	=> 'CUBA',
			'CY'	=> 'CYPRUS',
			'CZ'	=> 'CZECH REPUBLIC',
			'DK'	=> 'DENMARK',
			'DJ'	=> 'DJIBOUTI',
			'DM'	=> 'DOMINICA',
			'DO'	=> 'DOMINICAN REPUBLIC',
			'EC'	=> 'ECUADOR',
			'EG'	=> 'EGYPT',
			'SV'	=> 'EL SALVADOR',
			'GQ'	=> 'EQUATORIAL GUINEA',
			'ER'	=> 'ERITREA',
			'EE'	=> 'ESTONIA',
			'ET'	=> 'ETHIOPIA',
			'FK'	=> 'FALKLAND ISLANDS (MALVINAS)',
			'FO'	=> 'FAROE ISLANDS',
			'FJ'	=> 'FIJI',
			'FI'	=> 'FINLAND',
			'FR'	=> 'FRANCE',
			'GF'	=> 'FRENCH GUIANA',
			'PF'	=> 'FRENCH POLYNESIA',
			'TF'	=> 'FRENCH SOUTHERN TERRITORIES',
			'GA'	=> 'GABON',
			'GM'	=> 'GAMBIA',
			'GE'	=> 'GEORGIA',
			'DE'	=> 'GERMANY',
			'GH'	=> 'GHANA',
			'GI'	=> 'GIBRALTAR',
			'GR'	=> 'GREECE',
			'GL'	=> 'GREENLAND',
			'GD'	=> 'GRENADA',
			'GP'	=> 'GUADELOUPE',
			'GU'	=> 'GUAM',
			'GT'	=> 'GUATEMALA',
			'GG'	=> 'GUERNSEY',
			'GW'	=> 'GUINEA-BISSAU',
			'GN'	=> 'GUINEA',
			'GY'	=> 'GUYANA',
			'HT'	=> 'HAITI',
			'HM'	=> 'HEARD ISLAND AND MCDONALD ISLANDS',
			'VA'	=> 'HOLY SEE (VATICAN CITY STATE)',
			'HN'	=> 'HONDURAS',
			'HK'	=> 'HONG KONG',
			'HU'	=> 'HUNGARY',
			'IS'	=> 'ICELAND',
			'IN'	=> 'INDIA',
			'ID'	=> 'INDONESIA',
			'IR'	=> 'IRAN, ISLAMIC REPUBLIC OF',
			'IQ'	=> 'IRAQ',
			'IE'	=> 'IRELAND',
			'IM'	=> 'ISLE OF MAN',
			'IL'	=> 'ISRAEL',
			'IT'	=> 'ITALY',
			'JM'	=> 'JAMAICA',
			'JP'	=> 'JAPAN',
			'JE'	=> 'JERSEY',
			'JO'	=> 'JORDAN',
			'KZ'	=> 'KAZAKHSTAN',
			'KE'	=> 'KENYA',
			'KI'	=> 'KIRIBATI',
			'KP'	=> 'KOREA, DEMOCRATIC PEOPLE\'S REPUBLIC OF',
			'KR'	=> 'KOREA, REPUBLIC OF',
			'KW'	=> 'KUWAIT',
			'KG'	=> 'KYRGYZSTAN',
			'AX'	=> 'ÅLAND ISLANDS',
			'LA'	=> 'LAO PEOPLE\'S DEMOCRATIC REPUBLIC',
			'LV'	=> 'LATVIA',
			'LB'	=> 'LEBANON',
			'LS'	=> 'LESOTHO',
			'LR'	=> 'LIBERIA',
			'LY'	=> 'LIBYAN ARAB JAMAHIRIYA',
			'LI'	=> 'LIECHTENSTEIN',
			'LT'	=> 'LITHUANIA',
			'LU'	=> 'LUXEMBOURG',
			'MO'	=> 'MACAO',
			'MK'	=> 'MACEDONIA, THE FORMER YUGOSLAV REPUBLIC OF',
			'MG'	=> 'MADAGASCAR',
			'MW'	=> 'MALAWI',
			'MY'	=> 'MALAYSIA',
			'MV'	=> 'MALDIVES',
			'ML'	=> 'MALI',
			'MT'	=> 'MALTA',
			'MH'	=> 'MARSHALL ISLANDS',
			'MQ'	=> 'MARTINIQUE',
			'MR'	=> 'MAURITANIA',
			'MU'	=> 'MAURITIUS',
			'YT'	=> 'MAYOTTE',
			'MX'	=> 'MEXICO',
			'FM'	=> 'MICRONESIA, FEDERATED STATES OF',
			'MD'	=> 'MOLDOVA, REPUBLIC OF',
			'MC'	=> 'MONACO',
			'MN'	=> 'MONGOLIA',
			'ME'	=> 'MONTENEGRO',
			'MS'	=> 'MONTSERRAT',
			'MA'	=> 'MOROCCO',
			'MZ'	=> 'MOZAMBIQUE',
			'MM'	=> 'MYANMAR',
			'NA'	=> 'NAMIBIA',
			'NR'	=> 'NAURU',
			'NP'	=> 'NEPAL',
			'AN'	=> 'NETHERLANDS ANTILLES',
			'NL'	=> 'NETHERLANDS',
			'NC'	=> 'NEW CALEDONIA',
			'NZ'	=> 'NEW ZEALAND',
			'NI'	=> 'NICARAGUA',
			'NG'	=> 'NIGERIA',
			'NE'	=> 'NIGER',
			'NU'	=> 'NIUE',
			'NF'	=> 'NORFOLK ISLAND',
			'MP'	=> 'NORTHERN MARIANA ISLANDS',
			'NO'	=> 'NORWAY',
			'OM'	=> 'OMAN',
			'PK'	=> 'PAKISTAN',
			'PW'	=> 'PALAU',
			'PS'	=> 'PALESTINIAN TERRITORY, OCCUPIED',
			'PA'	=> 'PANAMA',
			'PG'	=> 'PAPUA NEW GUINEA',
			'PY'	=> 'PARAGUAY',
			'PE'	=> 'PERU',
			'PH'	=> 'PHILIPPINES',
			'PN'	=> 'PITCAIRN',
			'PL'	=> 'POLAND',
			'PT'	=> 'PORTUGAL',
			'PR'	=> 'PUERTO RICO',
			'QA'	=> 'QATAR',
			'RE'	=> 'REUNION',
			'RO'	=> 'ROMANIA',
			'RU'	=> 'RUSSIAN FEDERATION',
			'RW'	=> 'RWANDA',
			'SH'	=> 'SAINT HELENA',
			'KN'	=> 'SAINT KITTS AND NEVIS',
			'LC'	=> 'SAINT LUCIA',
			'PM'	=> 'SAINT PIERRE AND MIQUELON',
			'VC'	=> 'SAINT VINCENT AND THE GRENADINES',
			'WS'	=> 'SAMOA',
			'SM'	=> 'SAN MARINO',
			'ST'	=> 'SAO TOME AND PRINCIPE',
			'SA'	=> 'SAUDI ARABIA',
			'SN'	=> 'SENEGAL',
			'RS'	=> 'SERBIA',
			'SC'	=> 'SEYCHELLES',
			'SL'	=> 'SIERRA LEONE',
			'SG'	=> 'SINGAPORE',
			'SK'	=> 'SLOVAKIA',
			'SI'	=> 'SLOVENIA',
			'SB'	=> 'SOLOMON ISLANDS',
			'SO'	=> 'SOMALIA',
			'ZA'	=> 'SOUTH AFRICA',
			'GS'	=> 'SOUTH GEORGIA AND THE SOUTH SANDWICH ISLANDS',
			'ES'	=> 'SPAIN',
			'LK'	=> 'SRI LANKA',
			'SD'	=> 'SUDAN',
			'SR'	=> 'SURINAME',
			'SJ'	=> 'SVALBARD AND JAN MAYEN',
			'SZ'	=> 'SWAZILAND',
			'SE'	=> 'SWEDEN',
			'CH'	=> 'SWITZERLAND',
			'SY'	=> 'SYRIAN ARAB REPUBLIC',
			'TW'	=> 'TAIWAN, PROVINCE OF CHINA',
			'TJ'	=> 'TAJIKISTAN',
			'TZ'	=> 'TANZANIA, UNITED REPUBLIC OF',
			'TH'	=> 'THAILAND',
			'TL'	=> 'TIMOR-LESTE',
			'TG'	=> 'TOGO',
			'TK'	=> 'TOKELAU',
			'TO'	=> 'TONGA',
			'TT'	=> 'TRINIDAD AND TOBAGO',
			'TN'	=> 'TUNISIA',
			'TR'	=> 'TURKEY',
			'TM'	=> 'TURKMENISTAN',
			'TC'	=> 'TURKS AND CAICOS ISLANDS',
			'TV'	=> 'TUVALU',
			'UG'	=> 'UGANDA',
			'UA'	=> 'UKRAINE',
			'AE'	=> 'UNITED ARAB EMIRATES',
			'GB'	=> 'UNITED KINGDOM',
			'UM'	=> 'UNITED STATES MINOR OUTLYING ISLANDS',
			'US'	=> 'UNITED STATES',
			'UY'	=> 'URUGUAY',
			'UZ'	=> 'UZBEKISTAN',
			'VU'	=> 'VANUATU',
			'VE'	=> 'VENEZUELA',
			'VN'	=> 'VIET NAM',
			'VG'	=> 'VIRGIN ISLANDS, BRITISH',
			'VI'	=> 'VIRGIN ISLANDS, U.S.',
			'WF'	=> 'WALLIS AND FUTUNA',
			'EH'	=> 'WESTERN SAHARA',
			'YE'	=> 'YEMEN',
			'ZM'	=> 'ZAMBIA',
			'ZW'	=> 'ZIMBABWE',
		);

		/**
		* @constructor
		*/
		function country()
		{
			$this->country_array = array(
			   '  '=>lang('Select One'),
				'AF'=>lang('AFGHANISTAN'), 
				'AL'=>lang('ALBANIA'), 
				'DZ'=>lang('ALGERIA'), 
				'AS'=>lang('AMERICAN SAMOA'), 
				'AD'=>lang('ANDORRA'), 
				'AO'=>lang('ANGOLA'), 
				'AI'=>lang('ANGUILLA'), 
				'AQ'=>lang('ANTARCTICA'), 
				'AG'=>lang('ANTIGUA AND BARBUDA'), 
				'AR'=>lang('ARGENTINA'), 
				'AM'=>lang('ARMENIA'), 
				'AW'=>lang('ARUBA'), 
				'AU'=>lang('AUSTRALIA'), 
				'AT'=>lang('AUSTRIA'), 
				'AZ'=>lang('AZERBAIJAN'), 
				'BS'=>lang('BAHAMAS'), 
				'BH'=>lang('BAHRAIN'), 
				'BD'=>lang('BANGLADESH'), 
				'BB'=>lang('BARBADOS'), 
				'BY'=>lang('BELARUS'), 
				'BE'=>lang('BELGIUM'), 
				'BZ'=>lang('BELIZE'), 
				'BJ'=>lang('BENIN'), 
				'BM'=>lang('BERMUDA'), 
				'BT'=>lang('BHUTAN'), 
				'BO'=>lang('BOLIVIA'), 
				'BA'=>lang('BOSNIA AND HERZEGOVINA'), 
				'BW'=>lang('BOTSWANA'), 
				'BV'=>lang('BOUVET ISLAND'), 
				'BR'=>lang('BRAZIL'), 
				'IO'=>lang('BRITISH INDIAN OCEAN TERRITORY'), 
				'BN'=>lang('BRUNEI DARUSSALAM'), 
				'BG'=>lang('BULGARIA'), 
				'BF'=>lang('BURKINA FASO'), 
				'BI'=>lang('BURUNDI'), 
				'KH'=>lang('CAMBODIA'), 
				'CM'=>lang('CAMEROON'), 
				'CA'=>lang('CANADA'), 
				'CV'=>lang('CAPE VERDE'), 
				'KY'=>lang('CAYMAN ISLANDS'), 
				'CF'=>lang('CENTRAL AFRICAN REPUBLIC'), 
				'TD'=>lang('CHAD'), 
				'CL'=>lang('CHILE'), 
				'CN'=>lang('CHINA'), 
				'CX'=>lang('CHRISTMAS ISLAND'), 
				'CC'=>lang('COCOS (KEELING) ISLANDS'), 
				'CO'=>lang('COLOMBIA'), 
				'KM'=>lang('COMOROS'), 
				'CG'=>lang('CONGO'), 
				'CD'=>lang('CONGO, THE DEMOCRATIC REPUBLIC OF THE'), 
				'CK'=>lang('COOK ISLANDS'), 
				'CR'=>lang('COSTA RICA'), 
				'CI'=>lang('COTE D IVOIRE'), 
				'HR'=>lang('CROATIA'), 
				'CU'=>lang('CUBA'), 
				'CY'=>lang('CYPRUS'), 
				'CZ'=>lang('CZECH REPUBLIC'), 
				'DK'=>lang('DENMARK'), 
				'DJ'=>lang('DJIBOUTI'), 
				'DM'=>lang('DOMINICA'), 
				'DO'=>lang('DOMINICAN REPUBLIC'), 
				'TP'=>lang('EAST TIMOR'), 
				'EC'=>lang('ECUADOR'), 
				'EG'=>lang('EGYPT'), 
				'SV'=>lang('EL SALVADOR'), 
				'GQ'=>lang('EQUATORIAL GUINEA'), 
				'ER'=>lang('ERITREA'), 
				'EE'=>lang('ESTONIA'), 
				'ET'=>lang('ETHIOPIA'), 
				'FK'=>lang('FALKLAND ISLANDS (MALVINAS)'), 
				'FO'=>lang('FAROE ISLANDS'), 
				'FJ'=>lang('FIJI'), 
				'FI'=>lang('FINLAND'), 
				'FR'=>lang('FRANCE'), 
				'GF'=>lang('FRENCH GUIANA'), 
				'PF'=>lang('FRENCH POLYNESIA'), 
				'TF'=>lang('FRENCH SOUTHERN TERRITORIES'), 
				'GA'=>lang('GABON'), 
				'GM'=>lang('GAMBIA'), 
				'GE'=>lang('GEORGIA'), 
				'DE'=>lang('GERMANY'), 
				'GH'=>lang('GHANA'), 
				'GI'=>lang('GIBRALTAR'), 
				'GR'=>lang('GREECE'), 
				'GL'=>lang('GREENLAND'), 
				'GD'=>lang('GRENADA'), 
				'GP'=>lang('GUADELOUPE'), 
				'GU'=>lang('GUAM'), 
				'GT'=>lang('GUATEMALA'), 
				'GN'=>lang('GUINEA'), 
				'GW'=>lang('GUINEA-BISSAU'), 
				'GY'=>lang('GUYANA'), 
				'HT'=>lang('HAITI'), 
				'HM'=>lang('HEARD ISLAND AND MCDONALD ISLANDS'), 
				'VA'=>lang('HOLY SEE (VATICAN CITY STATE)'), 
				'HN'=>lang('HONDURAS'), 
				'HK'=>lang('HONG KONG'), 
				'HU'=>lang('HUNGARY'), 
				'IS'=>lang('ICELAND'), 
				'IN'=>lang('INDIA'), 
				'ID'=>lang('INDONESIA'), 
				'IR'=>lang('IRAN, ISLAMIC REPUBLIC OF'), 
				'IQ'=>lang('IRAQ'), 
				'IE'=>lang('IRELAND'), 
				'IL'=>lang('ISRAEL'), 
				'IT'=>lang('ITALY'), 
				'JM'=>lang('JAMAICA'), 
				'JP'=>lang('JAPAN'), 
				'JO'=>lang('JORDAN'), 
				'KZ'=>lang('KAZAKSTAN'), 
				'KE'=>lang('KENYA'), 
				'KI'=>lang('KIRIBATI'), 
				'KP'=>lang('KOREA, DEMOCRATIC PEOPLES REPUBLIC OF'), 
				'KR'=>lang('KOREA, REPUBLIC OF'),
				'KW'=>lang('KUWAIT'), 
				'KG'=>lang('KYRGYZSTAN'), 
				'LA'=>lang('LAO PEOPLES DEMOCRATIC REPUBLIC'), 
				'LV'=>lang('LATVIA'), 
				'LB'=>lang('LEBANON'), 
				'LS'=>lang('LESOTHO'), 
				'LR'=>lang('LIBERIA'), 
				'LY'=>lang('LIBYAN ARAB JAMAHIRIYA'), 
				'LI'=>lang('LIECHTENSTEIN'), 
				'LT'=>lang('LITHUANIA'), 
				'LU'=>lang('LUXEMBOURG'), 
				'MO'=>lang('MACAU'), 
				'MK'=>lang('MACEDONIA, THE FORMER YUGOSLAV REPUBLIC OF'), 
				'MG'=>lang('MADAGASCAR'), 
				'MW'=>lang('MALAWI'), 
				'MY'=>lang('MALAYSIA'), 
				'MV'=>lang('MALDIVES'), 
				'ML'=>lang('MALI'), 
				'MT'=>lang('MALTA'), 
				'MH'=>lang('MARSHALL ISLANDS'), 
				'MQ'=>lang('MARTINIQUE'), 
				'MR'=>lang('MAURITANIA'), 
				'MU'=>lang('MAURITIUS'), 
				'YT'=>lang('MAYOTTE'), 
				'MX'=>lang('MEXICO'), 
				'FM'=>lang('MICRONESIA, FEDERATED STATES OF'), 
				'MD'=>lang('MOLDOVA, REPUBLIC OF'), 
				'MC'=>lang('MONACO'), 
				'MN'=>lang('MONGOLIA'), 
				'MS'=>lang('MONTSERRAT'), 
				'MA'=>lang('MOROCCO'), 
				'MZ'=>lang('MOZAMBIQUE'), 
				'MM'=>lang('MYANMAR'), 
				'NA'=>lang('NAMIBIA'), 
				'NR'=>lang('NAURU'), 
				'NP'=>lang('NEPAL'), 
				'NL'=>lang('NETHERLANDS'), 
				'AN'=>lang('NETHERLANDS ANTILLES'), 
				'NC'=>lang('NEW CALEDONIA'), 
				'NZ'=>lang('NEW ZEALAND'), 
				'NI'=>lang('NICARAGUA'), 
				'NE'=>lang('NIGER'), 
				'NG'=>lang('NIGERIA'), 
				'NU'=>lang('NIUE'), 
				'NF'=>lang('NORFOLK ISLAND'), 
				'MP'=>lang('NORTHERN MARIANA ISLANDS'), 
				'NO'=>lang('NORWAY'), 
				'OM'=>lang('OMAN'), 
				'PK'=>lang('PAKISTAN'), 
				'PW'=>lang('PALAU'), 
				'PS'=>lang('PALESTINIAN TERRITORY, OCCUPIED'), 
				'PA'=>lang('PANAMA'), 
				'PG'=>lang('PAPUA NEW GUINEA'), 
				'PY'=>lang('PARAGUAY'), 
				'PE'=>lang('PERU'), 
				'PH'=>lang('PHILIPPINES'), 
				'PN'=>lang('PITCAIRN'), 
				'PL'=>lang('POLAND'), 
				'PT'=>lang('PORTUGAL'), 
				'PR'=>lang('PUERTO RICO'), 
				'QA'=>lang('QATAR'), 
				'RE'=>lang('REUNION'), 
				'RO'=>lang('ROMANIA'), 
				'RU'=>lang('RUSSIAN FEDERATION'), 
				'RW'=>lang('RWANDA'), 
				'SH'=>lang('SAINT HELENA'), 
				'KN'=>lang('SAINT KITTS AND NEVIS'), 
				'LC'=>lang('SAINT LUCIA'), 
				'PM'=>lang('SAINT PIERRE AND MIQUELON'), 
				'VC'=>lang('SAINT VINCENT AND THE GRENADINES'), 
				'WS'=>lang('SAMOA'), 
				'SM'=>lang('SAN MARINO'), 
				'ST'=>lang('SAO TOME AND PRINCIPE'), 
				'SA'=>lang('SAUDI ARABIA'), 
				'SN'=>lang('SENEGAL'), 
				'SC'=>lang('SEYCHELLES'), 
				'SL'=>lang('SIERRA LEONE'), 
				'SG'=>lang('SINGAPORE'), 
				'SK'=>lang('SLOVAKIA'), 
				'SI'=>lang('SLOVENIA'), 
				'SB'=>lang('SOLOMON ISLANDS'), 
				'SO'=>lang('SOMALIA'), 
				'ZA'=>lang('SOUTH AFRICA'), 
				'GS'=>lang('SOUTH GEORGIA AND THE SOUTH SANDWICH ISLANDS'), 
				'ES'=>lang('SPAIN'), 
				'LK'=>lang('SRI LANKA'), 
				'SD'=>lang('SUDAN'), 
				'SR'=>lang('SURINAME'), 
				'SJ'=>lang('SVALBARD AND JAN MAYEN'), 
				'SZ'=>lang('SWAZILAND'), 
				'SE'=>lang('SWEDEN'), 
				'CH'=>lang('SWITZERLAND'), 
				'SY'=>lang('SYRIAN ARAB REPUBLIC'), 
				'TW'=>lang('TAIWAN, PROVINCE OF CHINA'), 
				'TJ'=>lang('TAJIKISTAN'), 
				'TZ'=>lang('TANZANIA, UNITED REPUBLIC OF'), 
				'TH'=>lang('THAILAND'), 
				'TG'=>lang('TOGO'), 
				'TK'=>lang('TOKELAU'), 
				'TO'=>lang('TONGA'), 
				'TT'=>lang('TRINIDAD AND TOBAGO'), 
				'TN'=>lang('TUNISIA'), 
				'TR'=>lang('TURKEY'), 
				'TM'=>lang('TURKMENISTAN'), 
				'TC'=>lang('TURKS AND CAICOS ISLANDS'), 
				'TV'=>lang('TUVALU'), 
				'UG'=>lang('UGANDA'), 
				'UA'=>lang('UKRAINE'), 
				'AE'=>lang('UNITED ARAB EMIRATES'), 
				'GB'=>lang('UNITED KINGDOM'), 
				'US'=>lang('UNITED STATES'), 
				'UM'=>lang('UNITED STATES MINOR OUTLYING ISLANDS'), 
				'UY'=>lang('URUGUAY'), 
				'UZ'=>lang('UZBEKISTAN'), 
				'VU'=>lang('VANUATU'), 
				'VE'=>lang('VENEZUELA'), 
				'VN'=>lang('VIET NAM'), 
				'VG'=>lang('VIRGIN ISLANDS, BRITISH'), 
				'VI'=>lang('VIRGIN ISLANDS, U.S.'), 
				'WF'=>lang('WALLIS AND FUTUNA'), 
				'EH'=>lang('WESTERN SAHARA'), 
				'YE'=>lang('YEMEN'), 
				'YU'=>lang('YUGOSLAVIA'), 
				'ZM'=>lang('ZAMBIA'), 
				'ZW'=>lang('ZIMBABWE')
			); 
		}

		/**
		* Create a select box filled with countries
		*
		* @param string $selected the currently selected country
		* @param string $name the name of the select box element in the form, used for both the id and name attributes
		* @return string the html for a select box form element
		*/
		function form_select($selected,$name='')
		{
			if($name=='')
			{
				$name = 'country';
			}
			$str = "<select name=\"$name\" id=\"$name\">\n";
			reset($this->country_array);
			while(list($key,$value) = each($this->country_array))
			{
				$str .= ' <option value="'.$key.'"'.($selected == $key?' selected="selected"':'').'>'.$value.'</option>'."\n";
			}
			$str .= '</select>'."\n";
			return $str;
		}

		/**
		* Get the name of a country from the 2 letter iso 3166 country code
		*
		* @param string $code the 2 letter iso 3166 code
		* @return string the country name, empty string if invalid
		*/
		function get_full_name($selected)
		{
			if ( isset($this->country_array[$selected]) )
			{
				return($this->country_array[$selected]);
			}
			return '';
		}
	}
?>
