<?php
	/**
	* Handles multi-language support use SQL tables
	* @author Joseph Engo <jengo@phpgroupware.org>
	* @author Dan Kuykendall <seek3r@phpgroupware.org>
	* @copyright Portions Copyright (C) 2000-2004 Free Software Foundation, Inc. http://www.fsf.org/
	* @license http://www.fsf.org/licenses/lgpl.html GNU Lesser General Public License
	* @package phpgwapi
	* @subpackage application
	* @version $Id: class.translation_sql.inc.php,v 1.1.1.3.24.1 2007/09/14 02:55:38 kazuyan Exp $
	*/

	/**
	* define the maximal length of a message_id, all message_ids have to be unique 
	* in this length, our column is varchar 255, but addslashes might add some length
	*/
	define('MAX_MESSAGE_ID_LENGTH',230);	
	
	/**
	* Handles multi-language support use SQL tables
	* 
	* @package phpgwapi
	* @subpackage application
	*/
	class translation
	{
		function translate($key, $vars=false ) 
		{
			if (!$vars)
			{
				$vars = array();
			}
			$ret = $key;
			// check also if $GLOBALS['lang'] is a array
			// php-nuke and postnuke are using $GLOBALS['lang'] too
			// as string
			// this makes many problems
			if (!isset($GLOBALS['lang']) || !$GLOBALS['lang'] || !is_array($GLOBALS['lang']))
			{
				$GLOBALS['lang'] = array();
        if (isset($GLOBALS['phpgw_info']['user']['preferences']['common']['lang']) &&
					$GLOBALS['phpgw_info']['user']['preferences']['common']['lang'])
				{
					$userlang = $GLOBALS['phpgw_info']['user']['preferences']['common']['lang'];
				}
				else
				{
					$userlang = $_SERVER['HTTP_ACCEPT_LANGUAGE'];
					$lang_array =explode(',', $userlang);
					@reset($lang_array);
					while (list(, $userlang) = @each($lang_array))
					{
						if (ereg('(.*);(.*)|(.*)-(.*)', $userlang, $regs))	// For Opera Browser
							$userlang = $regs[1];
						break;
					}
					$supportedLanguages = $GLOBALS['phpgw']->common->getInstalledLanguages();
					if (@array_key_exists('ja', $supportedLanguages))
						$default_lang = 'ja';
					else
						$default_lang = 'en';
					$userlang = $userlang ? $userlang : $default_lang;
				}
				$sql = "select message_id,content from phpgw_lang where lang = '".$userlang."' ".
					"and (app_name = '".$GLOBALS['phpgw_info']['flags']['currentapp']."' or app_name = 'common' or app_name = 'all')";

				if (strcasecmp ($GLOBALS['phpgw_info']['flags']['currentapp'], 'common')>0)
				{
					$sql .= ' order by app_name asc';
				}
				else
				{
					$sql .= ' order by app_name desc';
				}
        
        $db = $GLOBALS['phpgw']->db;				
        $db->query($sql,__LINE__,__FILE__);
        while ($db->next_record())
        {
          // directly access of the Record is not the best design, but improves
          // speed of the whole function by 25% 
          $GLOBALS['lang'][strtolower($db->Record['message_id'])] = $db->Record['content'];
          // $GLOBALS['lang'][strtolower($db->f('message_id'))] = $db->f('content');        
				}
			}
			$ret = $key.'*';	// save key if we dont find a translation
			$key = strtolower(trim(substr($key,0,MAX_MESSAGE_ID_LENGTH)));

			if (isset($GLOBALS['lang'][$key]))
			{
				$ret = $GLOBALS['lang'][$key];
			}
			$ndx = 1;
			while( list($key,$val) = each( $vars ) )
			{
				$ret = preg_replace( "/%$ndx/", $val, $ret );
				++$ndx;
			}
			return $ret;
		}

		function add_app($app) 
		{
			// post-nuke and php-nuke are using $GLOBALS['lang'] too
			// but not as array!
			// this produces very strange results
			if (!is_array($GLOBALS['lang']))
			{
				$GLOBALS['lang'] = array();
			}
			
			if ($GLOBALS['phpgw_info']['user']['preferences']['common']['lang'])
			{
				$userlang = $GLOBALS['phpgw_info']['user']['preferences']['common']['lang'];
			}
			else
			{
				$userlang = 'en';
			}
			$sql = "select message_id,content from phpgw_lang where lang like '".$userlang."' and app_name like '".$app."'";
			$GLOBALS['phpgw']->db->query($sql,__LINE__,__FILE__);
			$GLOBALS['phpgw']->db->next_record();
			$count = $GLOBALS['phpgw']->db->num_rows();
			for ($idx = 0; $idx < $count; ++$idx)
			{
				$GLOBALS['lang'][strtolower ($GLOBALS['phpgw']->db->f('message_id'))] = $GLOBALS['phpgw']->db->f('content');
				$GLOBALS['phpgw']->db->next_record();
			}
		}
		
		function get_installed_langs()
		{
			$GLOBALS['phpgw']->db->query("SELECT DISTINCT l.lang,ln.lang_name FROM phpgw_lang l,phpgw_languages ln WHERE l.lang = ln.lang_id",__LINE__,__FILE__);
			if (!$GLOBALS['phpgw']->db->num_rows())
			{
				return False;
			}
			while ($GLOBALS['phpgw']->db->next_record())
			{
				$langs[$GLOBALS['phpgw']->db->f('lang')] = $GLOBALS['phpgw']->db->f('lang_name');
			}
			return $langs;
		}
	}
