<?php
	/**************************************************************************\
	* phpGroupWare - phpSysInfo Administration                                 *
	* http://www.phpgroupware.org                                              *
	* Written by Joseph Engo <jengo@phpgroupware.org>                          *
	* --------------------------------------------                             *
	*  This program is free software; you can redistribute it and/or modify it *
	*  under the terms of the GNU General Public License as published by the   *
	*  Free Software Foundation; either version 2 of the License, or (at your  *
	*  option) any later version.                                              *
	\**************************************************************************/

	/* $Id: admin.php,v 1.1.1.1.26.1 2007/09/14 03:57:17 kazuyan Exp $ */

	$GLOBALS['phpgw_info']['flags'] = array(
		'admin_only'              => True,
		'currentapp'              => 'phpsysinfo',
		'enable_nextmatchs_class' => True
	);
	include('../header.inc.php');
	// reassign HTTP variables (incase register_globals is off)
	if (!empty($_GET) && is_array($_GET))
	{
		foreach($_GET as $name => $value)
		{
			$$name = $value;
		}
	}
	if (!empty($_POST) && @is_array($_POST))
	{
		foreach($_POST as $name => $value)
		{
			$$name = $value;
		}
	}

	$GLOBALS['phpgw']->template->set_root($GLOBALS['phpgw']->common->get_tpl_dir('phpsysinfo'));
	$GLOBALS['phpgw']->template->set_file(array(
		'admin' => 'admin.tpl'
	));

	$sql_check = "SELECT config_value FROM phpgw_config"
		. " WHERE config_app='phpsysinfo'"
		. " AND config_name='theme'";
	$GLOBALS['phpgw']->db->query($sql_check,__LINE__,__FILE__);
	$GLOBALS['phpgw']->db->next_record();
	$current_theme = $GLOBALS['phpgw']->db->f('config_value');

	if ($submit) {
		if (!$current_theme) {
			$sql = "INSERT INTO phpgw_config"
				. "(config_app,config_name,config_value)"
				. " VALUES ('phpsysinfo','theme','".$theme."')";
		} else {
			$sql = "UPDATE phpgw_config SET"
				. " config_value='".$theme."'"
				. " WHERE config_app='phpsysinfo' AND"
				. " config_name='theme'";
		}
		$GLOBALS['phpgw']->db->query($sql,__LINE__,__FILE__);
	}

	// Need this again to set the right SELECTED in the SELECT below
	$GLOBALS['phpgw']->db->query($sql_check,__LINE__,__FILE__);
	$GLOBALS['phpgw']->db->next_record();
	$current_theme = $GLOBALS['phpgw']->db->f('config_value');

	$GLOBALS['phpgw']->template->set_var('title',lang('phpSysInfo Theme Selection'));
	$GLOBALS['phpgw']->template->set_var('save_url',$GLOBALS['phpgw']->link('/phpsysinfo/admin.php'));
	$GLOBALS['phpgw']->template->set_var('lang_theme',lang('Theme'));
	$GLOBALS['phpgw']->template->set_var('lang_save',lang('Save'));

	$selection = '';
	$selection .= "<SELECT NAME='theme'>\n";

	$themes = ARRAY();
	$themes = get_themes();
	foreach ($themes as $theme) {
		$selected = "";
		if ($theme == $current_theme) {
			$selected = "SELECTED ";
		}
		$selection .= "<OPTION ".$selected."VALUE='".$theme."'> ".$theme." </OPTION>\n";
	}

	$selection .= "</SELECT>\n";

	$GLOBALS['phpgw']->template->set_var('select_box', $selection);

	$GLOBALS['phpgw']->template->pfp('out','admin');

	$GLOBALS['phpgw']->common->phpgw_footer();

	function get_themes() {
		$themes = ARRAY();

		$dir = $GLOBALS['phpgw']->common->get_app_dir('phpsysinfo') . "/templates";
		$d = dir($dir) or die($php_errormsg);
		while (false !== ($f = $d->read())) {
			if (!preg_match('/^\s*\./', $f) and
			    !preg_match('/^\s*CVS\s*$/', strtoupper($f))) {
				if (is_dir($dir."/".$f)) {
					array_push($themes, $f);
				}
			}
		}
		$d->close();

		sort($themes);

		return $themes;
	}
?>
