<?php
	/*************************************************************************\
	* phpGroupWare - Todo list                                                *
	* http://www.phpgroupware.org                                             *
	* This program is part of the GNU project, see http://www.gnu.org/        *
	*                                                                         *
	* Written by Joseph Engo <jengo@phpgroupware.org>                         *
	*            Bettina Gille [ceb@phpgroupware.org]                         *
	* -----------------------------------------------                         *
	* Copyright 2000 - 2003 Free Software Foundation, Inc                     *
	*                                                                         *
	* This program is free software; you can redistribute it and/or modify it *
	* under the terms of the GNU General Public License as published by the   *
	* Free Software Foundation; either version 2 of the License, or (at your  *
	* option) any later version.                                              *
	\*************************************************************************/
	/* $Id: class.bo.inc.php,v 1.1.1.3.18.2 2007/09/16 22:21:32 kazuyan Exp $ */

	class bo
	{
		var $start;
		var $query;
		var $filter;
		var $order;
		var $sort;
		var $cat_id;
		var $debug = False;

		var $public_functions = array
		(
			'cached_accounts'  => True,
			'_list'            => True,
			'check_perms'      => True,
			'check_values'     => True,
			'select_todo_list' => True,
			'save'             => True,
			'_read'            => True,
			'delete'           => True,
			'exists'           => True,
			'list_methods'     => True
		);

		function bo($session=False)
		{
			$this->sotodo	= CreateObject('todo.so');
			$this->datetime	= CreateObject('phpgwapi.phpgw_datetime');

			if ($session)
			{
				$this->read_sessiondata();
				$this->use_session = True;
			}

			$_start		= $GLOBALS['HTTP_POST_VARS']['start'] ? $GLOBALS['HTTP_POST_VARS']['start'] : $GLOBALS['HTTP_GET_VARS']['start'];
			$_query		= $GLOBALS['HTTP_POST_VARS']['query'] ? $GLOBALS['HTTP_POST_VARS']['query'] : $GLOBALS['HTTP_GET_VARS']['query'];
			$_sort		= $GLOBALS['HTTP_POST_VARS']['sort'] ? $GLOBALS['HTTP_POST_VARS']['sort'] : $GLOBALS['HTTP_GET_VARS']['sort'];
			$_order		= $GLOBALS['HTTP_POST_VARS']['order'] ? $GLOBALS['HTTP_POST_VARS']['order'] : $GLOBALS['HTTP_GET_VARS']['order'];
			$_filter	= $GLOBALS['HTTP_POST_VARS']['filter'] ? $GLOBALS['HTTP_POST_VARS']['filter'] : $GLOBALS['HTTP_GET_VARS']['filter'];
			$_cat_id	= $GLOBALS['HTTP_POST_VARS']['cat_id'] ? $GLOBALS['HTTP_POST_VARS']['cat_id'] : $GLOBALS['HTTP_GET_VARS']['cat_id'];

			if (is_numeric($_start))
			{
				if($this->debug) { echo '<br />overriding $start: "' . $this->start . '" now "' . $_start . '"'; }
				$this->start = $_start;
			}

			if((empty($_query) && !empty($this->query)) || !empty($_query))
			{
				$this->query  = $_query;
			}

			if(isset($_cat_id) && !empty($_cat_id))
			{
				$this->cat_id = $_cat_id;
			}
			if((isset($GLOBALS['HTTP_POST_VARS']['cat_id']) || isset($GLOBALS['HTTP_GET_VARS']['cat_id'])) &&
				($_cat_id == '0' || $_cat_id == 0 || $_cat_id == ''))
			{
				$this->cat_id = 0;
			}

			if(isset($_sort)   && !empty($_sort))
			{
				if($this->debug) { echo '<br />overriding $sort: "' . $this->sort . '" now "' . $_sort . '"'; }
				$this->sort   = $_sort;
			}

			if(isset($_order)  && !empty($_order))
			{
				if($this->debug) { echo '<br />overriding $order: "' . $this->order . '" now "' . $_order . '"'; }
				$this->order  = $_order;
			}

			if(isset($_filter) && !empty($_filter))
			{
				if($this->debug) { echo '<br />overriding $filter: "' . $this->filter . '" now "' . $_filter . '"'; }
				$this->filter = $_filter;
			}
			
			if ($_POST['Reset'])
			{
				unset($this->start);
				unset($this->query);
				unset($this->cat_id);
				unset($this->sort);
				unset($this->order);
				unset($this->filter);
			}
		}

		function list_methods($_type)
		{
			if (is_array($_type))
			{
				$_type = $_type['type'];
			}

			switch($_type)
			{
				case 'xmlrpc':
					$xml_functions = array(
						'list_methods' => array(
							'function'  => 'list_methods',
							'signature' => array(array(xmlrpcStruct,xmlrpcString)),
							'docstring' => lang('Read this list of methods.')
						),
						'list' => array(
							'function'  => '_list',
							'signature' => array(array(xmlrpcStruct,xmlrpcStruct)),
							'docstring' => lang('Returns an array of todo items')
						),
						'save' => array(
							'function'  => 'save',
							'signature' => array(array(xmlrpcBoolean,xmlrpcStruct)),
							'docstring' => lang('Adds or edits a todo item')
						),
						'delete' => array(
							'function'  => 'delete',
							'signature' => array(array(xmlrpcBoolean,xmlrpcInt)),
							'docstring' => lang('Deletes a todo item')
						),
						'total_records' => array(
							'function'  => 'total_records',
							'signature' => array(array(xmlrpcInt)),
							'docstring' => lang('Returns a the total number of records in the database, must call list_todos first')
						)
					);
					return $xml_functions;
					break;

				case 'soap':
					return $this->soap_functions;
					break;

				default:
					return array();
					break;
			}
		}

		function get_grants()
		{
			return $this->so->grants;
		}

		function save_sessiondata($data)
		{
			if ($this->use_session)
			{
				$GLOBALS['phpgw']->session->appsession('session_data','todo',$data);
			}
			if($this->debug)
			{
				echo '<br />Saving: ';
				_debug_array($data);
			}
		}

		function read_sessiondata()
		{
			$data = $GLOBALS['phpgw']->session->appsession('session_data','todo');
			if($this->debug)
			{
				echo '<br />Read: ';
				_debug_array($data);
			}
			$this->start	= $data['start'];
			$this->query	= $data['query'];
			$this->filter	= $data['filter'];
			$this->order	= $data['order'];
			$this->sort		= $data['sort'];
			$this->cat_id	= $data['cat_id'];
		}

		function check_perms($has, $needed)
		{
			return (!!($has & $needed) == True);
		}

		function cached_accounts($account_id)
		{
			$this->accounts = CreateObject('phpgwapi.accounts',$account_id);
			$this->accounts->read_repository();

			$cached_data[$this->accounts->data['account_id']]['account_lid'] = $this->accounts->data['account_lid'];
			$cached_data[$this->accounts->data['account_id']]['firstname']   = $this->accounts->data['firstname'];
			$cached_data[$this->accounts->data['account_id']]['lastname']    = $this->accounts->data['lastname'];

			return $cached_data;
		}

		function _list($start = 0, $limit = '', $query = '', $filter = '', $order = '', $sort = '', $cat_id = 0, $tree = '', $parent = '', $lastmod=-1)
		{
			if (is_array($start))
			{
				$params = $start;

				$start  = $params['start'];
				$limit  = $params['limit'];
				$query  = $params['query'];
				$filter = $params['filter'];
				$order  = $params['order'];
				$sort   = $params['sort'];
				$cat_id = $params['cat_id'];
				$tree   = $params['tree'];
				$parent = $params['parent'];
				$lastmod= $params['lastmod'];
			}

			if (empty($order))
			{
				$todos = $this->sotodo->read_todos($start, False, $query, $filter, $order, $sort, $cat_id, $tree, $parent, $lastmod);
				if (is_array($todos))
				{
					foreach ($todos as $key => $val)
					{
						$tmp_todos[] = $val;
						if ($val['parent'] == 0)
							continue;
						$subs = $this->sotodo->find_subs($val['id']);
						if (empty($subs))
							continue;
						$todo_ids = explode(',', $subs);
						for ($i = 0;$i < count($todo_ids); $i++)
						{
							$tmp_todos[] = $this->sotodo->read_single_todo($todo_ids[$i]);
							$idx = count($tmp_todos) - 1;
							$tmp_todos[$idx]['sdate_epoch'] = (int)$tmp_todos[$idx]['sdate'];
							$tmp_todos[$idx]['edate_epoch'] = (int)$tmp_todos[$idx]['edate'];
							$tmp_todos[$idx]['owner_id'] = $tmp_todos[$idx]['owner'];
							$tmp_todos[$idx]['grants'] = (int)$this->sotodo->grants[$tmp_todos[$idx]['owner']];
						}
					}
					$remove_ctr = count($tmp_todos) - count($todos);
					for ($i = 0;$i < $remove_ctr; $i++)
						array_pop($tmp_todos);
					for ($i = 0;$i < $start; $i++)
						array_shift($tmp_todos);
					$remove_ctr = count($tmp_todos) - $GLOBALS['phpgw_info']['user']['preferences']['common']['maxmatchs'];
					for ($i = 0;$i < $remove_ctr; $i++)
						array_pop($tmp_todos);
					$todos = array();
					$todos = $tmp_todos;
				}
			}
			else
				$todos = $this->sotodo->read_todos($start, $limit, $query, $filter, $order, $sort, $cat_id, $tree, $parent, $lastmod);
			$this->total_records = $this->sotodo->total_records;

			while (is_array($todos) && list(,$v) = each($todos))
			{

				$sdate		= $v['sdate'] - $this->datetime->tz_offset;
				$v['sdate'] = $GLOBALS['phpgw']->common->show_date($sdate,$GLOBALS['phpgw_info']['user']['preferences']['common']['dateformat']);

				if ($v['edate'] && $v['edate'] != 0)
				{
					$edate		= $v['edate'] - $this->datetime->tz_offset;
					$v['edate'] = $GLOBALS['phpgw']->common->show_date($edate,$GLOBALS['phpgw_info']['user']['preferences']['common']['dateformat']);
				}
				else
				{
					$v['edate'] = '';
				}

				$cached_data = $this->cached_accounts($v['owner']);

				$v['owner']  = $GLOBALS['phpgw']->common->display_fullname($cached_data[$v['owner']]['account_lid'],
					$cached_data[$v['owner']]['firstname'],$cached_data[$v['owner']]['lastname']);

				$r[] = array(
					'id'       => (int)$v['id'],
					'main'     => (int)$v['main'],
					'parent'   => (int)$v['parent'],
					'level'    => (int)$v['level'],
					'owner'    => $v['owner'],
					'owner_id' => (int)$v['owner_id'],
					'access'   => $v['access'],
					'cat'      => (int)$v['cat'],
					'title'    => $v['title'],
					'descr'    => $v['descr'],
					'pri'      => (int)$v['pri'],
					'status'   => (int)$v['status'],
					'sdate'    => $v['sdate'],
					'edate'    => $v['edate'],
					'grants'   => (int)$v['grants'],
					'sdate_epoch' => (int)$v['sdate_epoch'],
					'edate_epoch' => (int)$v['edate_epoch']
				);
			}

			return $r;
		}

		function read($todo_id)
		{
			$todo = $this->sotodo->read_single_todo($todo_id);

			return $todo;
		}

		function check_values($values)
		{
			if (!$values['title'])
			{
				$error[] = lang('Please enter a title');
			}

			if (strlen($values['descr']) >= 8000)
			{
				$error[] = lang('Description can not exceed 8000 characters in length');
			}

			if ($values['daysfromstart'] && ! ereg('^[0-9]+$',$values[daysfromstart]))
			{
				$error[] = lang('You can only enter numbers for days from now');
			}

			if ($values['smonth'] || $values['sday'] || $values['syear'])
			{
				if(! $this->datetime->date_valid($values['syear'],$values['smonth'],$values['sday']))
				{
					$error[] = lang('You have entered an starting invalid date');
				}
			}

			if ($values['emonth'] || $values['eday'] || $values['eyear'])
			{
				if(! $this->datetime->date_valid($values['eyear'],$values['emonth'],$values['eday']))
				{
					$error[] = lang('You have entered an ending invalid date');
				}
			}

			if ($values['edate'] < $values['sdate'] && $values['edate'] && $values['sdate'])
			{
				$error[] = lang('Ending date can not be before start date');
			}

			if (($values['smonth'] || $values['sday'] || $values['syear']) && ($values['emonth'] || $values['eday'] || $values['eyear']))
			{
				if($this->datetime->date_compare($values['eyear'],$values['emonth'],$values['eday'],$values['syear'],$values['smonth'],$values['sday']) == -1)
				{
					$error[] = lang('Ending date can not be before start date');
				}
			}

			if (is_array($error))
			{
				return $error;
			}
		}

		function save($values)
		{
			if ($values['access'])
			{
				$values['access'] = 'private';
			}
			else
			{
				$values['access'] = 'public';
			}

			if ($values['seltoday'])
			{
				$values['sdate'] = time();
			}
			else
			{
				if ($values['smonth'] || $values['sday'] || $values['syear'])
				{
					$values['sdate'] = mktime(0,0,0,$values['smonth'], $values['sday'], $values['syear']);
				}
			}

			if (!$values['sdate'])
			{
				$values['sdate'] = time();
			}

			if ($values['emonth'] || $values['eday'] || $values['eyear'])
			{
				$values['edate'] = mktime(2,0,0,$values['emonth'],$values['eday'],$values['eyear']);
			}
			else if ($values['daysfromstart'] > 0)
			{
				$values['edate'] = mktime(0,0,0,date('m',$values['sdate']), date('d',$values['sdate'])+$values['daysfromstart'], date('Y',$values['sdate']));
			}

			if ($values['id'])
			{
				if ($values['id'] != 0)
				{
					$this->sotodo->edit_todo($values);
					$todo_id = $values['id'];
				}
			}
			else
			{
				$todo_id = $this->sotodo->add_todo($values);
			}
			return $todo_id;
		}

		function select_todo_list($parent)
		{
			$list = $this->sotodo->select_todo_list($parent);

			return $list;
		}

		function exists($todo_id)
		{
			$exists = $this->sotodo->exists($todo_id);

			if ($exists)
			{
				return True;
			}
			else
			{
				return False;
			}
		}

		function delete($todo_id, $subs = False)
		{
			if (is_array($todo_id))
			{
				$todo_id = $todo_id[0];
			}

			if ($subs)
			{
				$this->sotodo->delete_todo($todo_id,True);
			}
			else
			{
				$this->sotodo->delete_todo($todo_id);
			}
			return True;
		}
	}
?>
