<?php
/**
 * phpoot - template engine for php
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @author Haruki Setoyama <haruki@planewave.org>
 * @copyright Copyright &copy; 2003-2004, Haruki SETOYAMA <haruki@planewave.org>
 * @license http://www.opensource.org/licenses/lgpl-license.php LGPL
 * @version 0.6- $Id: printf.php,v 1.1 2004/05/11 05:36:51 haruki Exp $
 * @link http://phpoot.sourceforge.jp/
 * @package phpoot
 * @subpackage _format
 */
/**
 * print formated date
 */
function phpoot_format_printf($val, $var, $format, $quiet =true)
{
    if (is_string($val) || is_numeric($val)) {
        printf ($format, phpoot_htmlspecialchars($val));
    }
    elseif (is_array($val)
    && (is_string($val[$var]) || is_numeric($val[$var]))) {
        printf ($format, phpoot_htmlspecialchars($val[$var]));
    }
    else {
        echo (! $quiet) ? "<!-- NON STRING DATA '$var' -->" : '';
    }
}
?>