<?php
/**
 * phpoot - template engine for php
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @author Haruki Setoyama <haruki@planewave.org>
 * @copyright Copyright &copy; 2003-2004, Haruki SETOYAMA <haruki@planewave.org>
 * @license http://www.opensource.org/licenses/lgpl-license.php LGPL
 * @version 0.6- $Id: phpoot.handler.php,v 1.4 2004/05/12 10:52:01 haruki Exp $
 * @link http://phpoot.sourceforge.jp/
 * @package phpoot
 * @subpackage _parser
 */
/**
 * Requires PEAR
 */
require_once 'PEAR.php';
/**
 * directory where PHPOOT library is in
 */
if (!defined('PHPOOT_DIR')) {
    define('PHPOOT_DIR', dirname(__FILE__));
}
/**
* require phpoot.parser.php
*/
require_once PHPOOT_DIR . '/phpoot.parser.php';
/**
* handler for HTMLSax
* parse of template is done with phpoot_parser classes actually
* @package phpoot
* @subpackage _parser
*/
class phpoot_handler extends PEAR {

    /**
     * options
     * <pre>
     * 'pi''remove'         when true, remove all the <? ... ?>
     * 'jasp''remove'       when true, remove all the <% ... %>
     * 'tag''empty'         names of empty tag which should be < /> style
     * 'tag''raw'           extention of model data with HTML.
     * </pre>
     * @var array
     */
    var $option;

    /**
     * template text
     * @var string
     * @access private
     */
    var $_template = '';
    /**
     * blanc phpoot_parser_tag object
     * @var array of phpoot_parser_tag
     * @access private
     */
    var $_parsers_tag = array();
    /**
     * @access private
     */
    var $_level = 0;
    /**
     * @access private
     */
    var $_stack = array();
    /**
     * @access private
     */
    var $_common = array();

    /**
     * the number of error
     */
    var $error = 0;

    /**
     * constructor
     * @access public
     */
    function phpoot_handler(&$option)
    {
        // option
        if (! isset($this->option['_merged'])) {
            $default = array(
                'tag' => array(
                    'empty' => array(
                        'br' => 1,
                        'param' => 1,
                        'hr' => 1,
                        'input' => 1,
                        'col' => 1,
                        'img' => 1,
                        'area' => 1,
                        'frame' => 1,
                        'meta' => 1,
                        'link' => 1,
                        'base' => 1,
                        'basefont' => 1,
                        'isindex' => 1
                    ),
                    'raw' => array()
                ),
                'data' => array(),
                'escape' => array(),
                'pi' => array(
                    'remove' => true
                ),
                'jasp' => array(
                    'remove' => true
                ),
                '_merged' => 1
            );
            $this->option =& $option;
            $this->option = array_merge_recursive($default, $this->option);
        }
    }

    /**
     * initialize before HTMLSax parse
     * @param string &$template
     * @access public
     */
    function init(&$template)
    {
        // template
        $this->_template =& $template;
        $template = str_replace(array("\r\n", "\r"), array("\n", "\n"), $template);

        // private prop.
        $this->_level = 0;
        $this->_stack = array();
        $this->_stack[0] = new phpoot_parser_tag_root;
        $this->_common = array('format' => array());
        $this->_stack[0]->common =& $this->_common;

        // _parsers_tag[]
        $this->_parsers_tag = array();
        $parsers = array('variable', 'num', 'notop', 'static');
        $num = count($parsers);
        for ($i=0; $i<$num; $i++) {
            $class = 'phpoot_parser_tag_' . $parsers[$i];
            $this->_parsers_tag[$i] = new $class;
            $this->_parsers_tag[$i]->common =& $this->_common;
            $this->_parsers_tag[$i]->option = $this->option['tag'];
        }

        // errors
        $this->error = 0;
    }

    /**
     * set handler on HTMLSax parser
     * @param XML_HTMLSax &$parser
     * @access public
     */
    function configParser(&$parser)
    {
        $parser->set_element_handler('openHandler', 'closeHandler');
        $parser->set_data_handler('dataHandler');
        $parser->set_escape_handler('escapeHandler');
        $parser->set_pi_handler('piHandler');
        $parser->set_jasp_handler('jaspHandler');
        $parser->set_option('XML_OPTION_FULL_ESCAPES');
    }

    /**
     * get parsed template, that is PHP script
     * @access public
     */
    function getParsed()
    {
        while($this->_level > 0) {
            $tag = $this->_stack[$this->_level]->open_tag();
            $pos = $this->_get_line($this->_stack[$this->_level]->open_position());
            $this->raiseError(
                "Tag '$tag' on line $pos is not closed.. ", PHPOOT_WARN_TEMPLATE);
            $this->_stack[$this->_level]->close(strlen($this->_template));
            $this->_level--;
        }

        return $this->_stack[$this->_level]->parse();
    }

    /**
     * handler method for tag open
     * @access public
     */
    function openHandler(&$parser, $name, $attrs)
    {
        //echo 'open: '.$name.' '.$this->_level.'<br>';
        $name = strtolower($name);
        $attrs = array_change_key_case($attrs, CASE_LOWER);

        $i=0;
        while($this->_parsers_tag[$i]->accept($name, $attrs) === false){
            $i++;
        }

        $this->_level++;
        unset($this->_stack[$this->_level]);
        $this->_stack[$this->_level] = $this->_parsers_tag[$i]; // copy

        $this->_stack[$this->_level]->open(
            $parser->get_current_position()
            , $name
            , $attrs
            , $this->_stack[$this->_level -1]->info
        );

        $this->_stack[$this->_level -1]->data[] =& $this->_stack[$this->_level];
    }

    /**
     * handler method for tag close
     * @access public
     */
    function closeHandler(&$parser, $close_tag)
    {
        //echo 'close: '.$close_tag.' '.$this->_level.'<br>';
        $close_tag = strtolower($close_tag);

        if ($this->_level > 0) {
            $this->_stack[$this->_level]->close($parser->get_current_position());
            $this->_level--;
            if ($this->_stack[$this->_level +1]->open_tag() != $close_tag) {
                $tag = $this->_stack[$this->_level +1]->open_tag();
                $pos = $this->_get_line($this->_stack[$this->_level +1]->open_position());
                $this->raiseError(
                    "Tag '$tag' on line $pos is not closed. Close tag is '$close_tag'. ", PHPOOT_WARN_TEMPLATE);
                $this->closeHandler($parser, $close_tag);
            }
        }
        else {
            $pos = $this->_get_line($parser->get_current_position());
            $this->raiseError(
                "Tag '$close_tag' on line $pos is not opened. ", PHPOOT_WARN_TEMPLATE);
        }
    }

    function _get_line($position)
    {
        return count(explode("\n", substr($this->_template, 0, $position)));
    }

    /**
     * handler method for data
     * @access public
     */
    function dataHandler(&$parser, $data)
    {
        $this->_stack[$this->_level]->data[]
                = new phpoot_parser_data($data);
    }

    /**
     * handler method for escape
     * @access public
     */
    function escapeHandler(&$parser, $data)
    {
        if (! preg_match('/^--\s*#/', $data)) {
            $this->_stack[$this->_level]->data[]
                = new phpoot_parser_escape($data);
        }
        else {
            $this->_stack[$this->_level]->data[]
                = new phpoot_parser_empty;
        }
    }

    /**
     * handler method for pi
     * @access public
     */
    function piHandler(&$parser, $target, $data)
    {
        if (! $this->option['pi']['remove']) {
            $this->_stack[$this->_level]->data[]
                = new phpoot_parser_pi($target, $data);
        }
        else {
            $this->_stack[$this->_level]->data[]
                = new phpoot_parser_remove;
        }
    }

    /**
     * handler method for jasp
     * @access public
     */
    function jaspHandler(&$parser, $data)
    {
        if (! $this->option['jasp']['remove']) {
            $this->_stack[$this->_level]->data[]
                = new phpoot_parser_jasp($data);
        }
        else {
            $this->_stack[$this->_level]->data[]
                = new phpoot_parser_remove;
        }
    }

    /**
     * raiseError(). Counts the number of error.
     */
    function raiseError($msg, $code)
    {
        $this->error++;
        parent::raiseError($msg, $code);
    }
}
?>