/***************************************************************
 * MPFSImg2.c
 * Defines an MPFS2 image to be stored in program memory.
 *
 * NOT FOR HAND MODIFICATION
 * This file is automatically generated by the MPFS2 Utility
 * ALL MODIFICATIONS WILL BE OVERWRITTEN BY THE MPFS2 GENERATOR
 * Generated  10 31 2011 10:21:25 
 ***************************************************************/

#define __MPFSIMG2_C

#include "TCPIPConfig.h"
#if !defined(MPFS_USE_EEPROM) && !defined(MPFS_USE_SPI_FLASH)

#include "TCPIP Stack/TCPIP.h"
#if defined(STACK_USE_MPFS2)


/**************************************
 * MPFS2 Image Data
 **************************************/
#define DATACHUNK000000 \
	0x4d,0x50,0x46,0x53,0x02,0x01,0x16,0x00,0x6a,0x55,0x5e,0x2a,0x26,0x4f,0x26,0x2d, /* MPFS....jU^.&O&- */ \
	0x0a,0xa3,0xff,0xff,0x6a,0x83,0xff,0xff,0xea,0x72,0xff,0xff,0x4a,0xe3,0xff,0xff, /* ....j....r..J... */ \
	0xea,0x92,0xff,0xff,0x0a,0x4f,0xff,0xff,0x26,0xb6,0xff,0xff,0x8a,0xb6,0xff,0xff, /* .....O..&....... */ \
	0xca,0xb4,0xff,0xff,0x18,0x02,0x00,0x00,0xec,0x02,0x00,0x00,0x91,0x03,0x00,0x00, /* ................ */ \
	0xac,0xf2,0xad,0x4e,0x00,0x00,0x00,0x00,0x01,0x00,0x23,0x02,0x00,0x00,0x7d,0x06, /* ...N......#...}. */ \
	0x00,0x00,0xc2,0x05,0x00,0x00,0x91,0x1b,0x15,0x4e,0x00,0x00,0x00,0x00,0x01,0x00, /* .........N...... */ \
	0x2d,0x02,0x00,0x00,0x3f,0x0c,0x00,0x00,0xa0,0x00,0x00,0x00,0xc3,0x42,0x9b,0x4e, /* -...?........B.N */ \
	0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x02,0x00,0x00,0xdf,0x0c,0x00,0x00,0xa1,0x03, /* ......8......... */ \
	0x00,0x00,0x26,0xf2,0xab,0x4e,0x00,0x00,0x00,0x00,0x00,0x00,0x43,0x02,0x00,0x00, /* ..&..N......C... */ \
	0x80,0x10,0x00,0x00,0x1b,0x04,0x00,0x00,0x27,0x7c,0xab,0x4e,0x00,0x00,0x00,0x00, /* ........'|.N.... */ \
	0x02,0x00,0x4d,0x02,0x00,0x00,0x9b,0x14,0x00,0x00,0x68,0x00,0x00,0x00,0x27,0x7c, /* ..M.......h...'| */ \
	0xab,0x4e,0x00,0x00,0x00,0x00,0x00,0x00,0x4e,0x02,0x00,0x00,0x03,0x15,0x00,0x00, /* .N......N....... */ \
	0xcf,0x02,0x00,0x00,0x4a,0xb7,0xa4,0x4e,0x00,0x00,0x00,0x00,0x02,0x00,0x59,0x02, /* ....J..N......Y. */ \
	0x00,0x00,0xd2,0x17,0x00,0x00,0x48,0x00,0x00,0x00,0x4a,0xb7,0xa4,0x4e,0x00,0x00, /* ......H...J..N.. */ \
	0x00,0x00,0x00,0x00,0x5a,0x02,0x00,0x00,0x1a,0x18,0x00,0x00,0xf8,0x08,0x00,0x00, /* ....Z........... */ \
	0xda,0xef,0xa4,0x4e,0x00,0x00,0x00,0x00,0x02,0x00,0x71,0x02,0x00,0x00,0x12,0x21, /* ...N......q....! */ \
	0x00,0x00,0x80,0x00,0x00,0x00,0xda,0xef,0xa4,0x4e,0x00,0x00,0x00,0x00,0x00,0x00, /* .........N...... */ \
	0x72,0x02,0x00,0x00,0x92,0x21,0x00,0x00,0x03,0x02,0x00,0x00,0x86,0x22,0xac,0x4e, /* r....!.......".N */ \
	0x00,0x00,0x00,0x00,0x02,0x00,0x8a,0x02,0x00,0x00,0x95,0x23,0x00,0x00,0x20,0x00, /* ...........#.. . */ \
	0x00,0x00,0x86,0x22,0xac,0x4e,0x00,0x00,0x00,0x00,0x00,0x00,0x8b,0x02,0x00,0x00, /* ...".N.......... */ \
	0xb5,0x23,0x00,0x00,0x55,0x0b,0x00,0x00,0x81,0x6e,0xab,0x4e,0x00,0x00,0x00,0x00, /* .#..U....n.N.... */ \
	0x02,0x00,0x9e,0x02,0x00,0x00,0x0a,0x2f,0x00,0x00,0x98,0x00,0x00,0x00,0x81,0x6e, /* ......./.......n */ \
	0xab,0x4e,0x00,0x00,0x00,0x00,0x00,0x00,0x9f,0x02,0x00,0x00,0xa2,0x2f,0x00,0x00, /* .N.........../.. */ \
	0xc6,0x03,0x00,0x00,0x91,0x1b,0x15,0x4e,0x00,0x00,0x00,0x00,0x02,0x00,0xb1,0x02, /* .......N........ */ \
	0x00,0x00,0x68,0x33,0x00,0x00,0x18,0x00,0x00,0x00,0x91,0x1b,0x15,0x4e,0x00,0x00, /* ..h3.........N.. */ \
	0x00,0x00,0x00,0x00,0xb2,0x02,0x00,0x00,0x80,0x33,0x00,0x00,0x08,0x00,0x00,0x00, /* .........3...... */ \
	0x91,0x1b,0x15,0x4e,0x00,0x00,0x00,0x00,0x02,0x00,0xc5,0x02,0x00,0x00,0x88,0x33, /* ...N...........3 */ \
	0x00,0x00,0x08,0x00,0x00,0x00,0x91,0x1b,0x15,0x4e,0x00,0x00,0x00,0x00,0x00,0x00, /* .........N...... */ \
	0xc6,0x02,0x00,0x00,0x90,0x33,0x00,0x00,0x8e,0x01,0x00,0x00,0x11,0x0c,0x9c,0x4e, /* .....3.........N */ \
	0x00,0x00,0x00,0x00,0x02,0x00,0xd9,0x02,0x00,0x00,0x1e,0x35,0x00,0x00,0x10,0x00, /* ...........5.... */ \
	0x00,0x00,0x11,0x0c,0x9c,0x4e,0x00,0x00,0x00,0x00,0x00,0x00,0xda,0x02,0x00,0x00, /* .....N.......... */ \
	0x2e,0x35,0x00,0x00,0x6c,0x03,0x00,0x00,0xc3,0xf2,0xad,0x4e,0x00,0x00,0x00,0x00, /* .5..l......N.... */ \
	0x02,0x00,0xeb,0x02,0x00,0x00,0x9a,0x38,0x00,0x00,0x30,0x00,0x00,0x00,0xc3,0xf2, /* .......8..0..... */ \
	0xad,0x4e,0x00,0x00,0x00,0x00,0x00,0x00,0x37,0x6d,0x33,0x74,0x6a,0x7a,0x2e,0x63, /* .N......7m3tjz.c */ \
	0x73,0x73,0x00,0x37,0x6d,0x33,0x74,0x6a,0x7a,0x2e,0x6a,0x73,0x00,0x66,0x6f,0x6f, /* ss.7m3tjz.js.foo */ \
	0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x00,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69, /* ter.inc.header.i */ \
	0x6e,0x63,0x00,0x69,0x6e,0x64,0x65,0x78,0x2e,0x68,0x74,0x6d,0x00,0x00,0x73,0x74, /* nc.index.htm..st */ \
	0x61,0x74,0x75,0x73,0x2e,0x68,0x74,0x6d,0x00,0x00,0x6e,0x6f,0x64,0x65,0x61,0x64, /* atus.htm..nodead */ \
	0x61,0x70,0x74,0x65,0x72,0x2f,0x63,0x6f,0x6e,0x66,0x69,0x67,0x2e,0x68,0x74,0x6d, /* apter/config.htm */ \
	0x00,0x00,0x6e,0x6f,0x64,0x65,0x61,0x64,0x61,0x70,0x74,0x65,0x72,0x2f,0x63,0x6f, /* ..nodeadapter/co */ \
	0x6e,0x66,0x69,0x67,0x32,0x2e,0x68,0x74,0x6d,0x00,0x00,0x70,0x72,0x6f,0x74,0x65, /* nfig2.htm..prote */ \
	0x63,0x74,0x2f,0x63,0x6f,0x6e,0x66,0x69,0x67,0x2e,0x68,0x74,0x6d,0x00,0x00,0x70, /* ct/config.htm..p */ \
	0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x69,0x6e,0x64,0x65,0x78,0x2e,0x68,0x74,0x6d, /* rotect/index.htm */ \
	0x00,0x00,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x72,0x65,0x62,0x6f,0x6f,0x74, /* ..protect/reboot */ \
	0x2e,0x63,0x67,0x69,0x00,0x00,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x72,0x65, /* .cgi..protect/re */ \
	0x62,0x6f,0x6f,0x74,0x2e,0x68,0x74,0x6d,0x00,0x00,0x70,0x72,0x6f,0x74,0x65,0x63, /* boot.htm..protec */ \
	0x74,0x2f,0x75,0x73,0x65,0x72,0x2e,0x68,0x74,0x6d,0x00,0x00,0x1f,0x8b,0x08,0x00, /* t/user.htm...... */ \
	0x00,0x00,0x00,0x00,0x00,0x00,0xad,0x56,0x4d,0x6f,0x9c,0x30,0x10,0x3d,0x67,0xa5, /* .......VMo.0.=g. */ \
	0xfd,0x0f,0x48,0xb9,0x06,0xc4,0xc7,0x42,0x12,0x72,0xaa,0xd2,0x73,0x8f,0xbd,0x1b, /* ..H....B.r..s... */ \
	0x3c,0x2c,0x56,0xbc,0x18,0x19,0x93,0xdd,0x34,0xea,0x7f,0xaf,0x6d,0x0c,0x18,0xf0, /* <,V.....4...m... */ \
	0x6e,0xd4,0xaa,0x42,0x4a,0x16,0xdb,0xf3,0xde,0x78,0xe6,0xcd,0x0c,0x05,0xc3,0x1f, /* n..BJ....x...... */ \
	0xde,0xe7,0x7e,0x77,0x57,0xb1,0x46,0xf8,0x15,0x3a,0x11,0xfa,0x91,0x7b,0x3f,0x81, /* ..~wW.F..:...{?. */ \
	0x63,0xd4,0xa0,0x07,0xef,0x1b,0x27,0x88,0x3e,0x78,0x1d,0x6a,0x3a,0xbf,0x03,0x4e, /* c.....'.>x.j:..N */ \
	0xaa,0x17,0x79,0xb4,0x40,0xe5,0xdb,0x91,0xb3,0xbe,0xc1,0xb9,0x77,0x9f,0x16,0xea, /* ..y.@.......w... */ \
	0x51,0xcb,0x27,0xc4,0x8f,0xa4,0xc9,0xbd,0xb0,0xbd,0x78,0xa8,0x17,0x4c,0xad,0xb5, /* Q.'.......x..L.. */ \
	0x08,0x63,0xd2,0x1c,0xe5,0xa2,0x7c,0x62,0xb5,0x13,0xca,0xe5,0xdf,0xfb,0xdd,0x7e, /* .c....|b.......~ */ \
	0x77,0xdf,0xd5,0x08,0xb3,0xb3,0xcf,0x1a,0xd0,0x0e,0x9c,0x09,0x16,0x75,0xee,0x3d, /* w............u.= */ \
	0x66,0xf2,0x94,0x66,0x61,0x1c,0x03,0xcf,0xbd,0x48,0x1a,0x75,0x8c,0x12,0x2c,0xb9, /* f..fa....H.u..,. */ \
	0xd2,0x74,0xde,0xf1,0x05,0x6b,0x73,0x0d,0xe7,0x62,0xfe,0x3d,0x13,0x88,0x33,0xd3, /* .t...ks..b.=..3. */ \
	0x04,0x0e,0xc0,0x43,0xa1,0x1e,0x17,0xa6,0x6d,0x5f,0x73,0x80,0xab,0x08,0x87,0xc3, /* ...C....m_s..... */ \
	0x17,0xe6,0x15,0xeb,0xf9,0x35,0xeb,0x04,0xa9,0xe7,0x0a,0x80,0x84,0x68,0xd1,0xf1, /* .....5.......h.. */ \
	0x2a,0x73,0x92,0x24,0x9b,0x64,0x54,0x55,0xe5,0x0c,0xd0,0x94,0x86,0xd8,0x04,0x57, /* .s.$.dTU.......W */ \
	0x67,0xbb,0x23,0xbf,0x40,0x42,0x86,0xad,0x58,0x12,0x0a,0x3c,0x2b,0xc2,0x71,0x46, /* g.#.@B..X..<+.qF */ \
	0x10,0x41,0x8d,0x57,0x36,0x77,0x12,0xbf,0x7e,0x4f,0xe2,0x05,0xdb,0xc1,0x22,0x3b  /* .A.W6w..~O...."; */
#define DATACHUNK000001 \
	0x03,0x39,0xd6,0x22,0xf7,0x0a,0x46,0xb1,0x5a,0x2c,0x19,0x65,0x7c,0x76,0x79,0x48, /* .9."..F.Z,.e|vyH */ \
	0xa1,0x5f,0x30,0x21,0xd8,0x49,0x12,0xa6,0x83,0x69,0x6d,0xac,0xa2,0x4c,0xbf,0xdb, /* ._0!.I...im..L.. */ \
	0x0e,0x04,0x5c,0x6d,0x0d,0x9e,0x52,0x86,0xe4,0x21,0xbd,0xf0,0x32,0x4b,0x29,0x09, /* ..\m..R..!..2K). */ \
	0xcd,0x6d,0x05,0x5c,0x84,0x8f,0x28,0x39,0x36,0xf3,0xa1,0x01,0xea,0x04,0x4d,0x6f, /* .m.\..(96.....Mo */ \
	0x43,0x50,0xa8,0x6c,0x84,0x28,0x35,0x08,0xe6,0x4a,0x3e,0x1f,0xdc,0x31,0x61,0xb4, /* CP.l.(5..J>..1a. */ \
	0x30,0x90,0xad,0xe1,0xe8,0x60,0xcc,0x30,0xe9,0x5a,0x8a,0x64,0x41,0x15,0x94,0x95, /* 0....`.0.Z.dA... */ \
	0x6f,0x9b,0x74,0xcd,0x21,0x33,0xd1,0x38,0xd7,0x44,0xc0,0x22,0x84,0x4f,0x37,0x42, /* o.t.!3.8.D.".O7B */ \
	0x68,0xd2,0x3c,0xc5,0x6c,0xd6,0x86,0x09,0xaa,0xbe,0x37,0x86,0x92,0x71,0x24,0x08, /* h.<.l.....7..q$. */ \
	0x93,0x97,0x6f,0x64,0xb1,0xad,0xfc,0xce,0x6b,0xf6,0x0e,0x7c,0x9b,0x4e,0xac,0xe5, /* ..od....k..|.N.. */ \
	0x35,0x9c,0x2c,0x25,0x3b,0x34,0xc2,0xbe,0x62,0x1a,0x9b,0x0c,0xad,0x63,0xbf,0x8a, /* 5.,%;4..b....c.. */ \
	0x54,0x64,0x47,0x6a,0xc4,0x19,0x82,0x35,0x2a,0xa0,0x0c,0xc3,0xaf,0x9d,0x9d,0x4c, /* TdGj...5.......L */ \
	0x2d,0x7f,0x47,0x80,0xc1,0xd5,0x2d,0x80,0xbc,0x08,0x70,0x4a,0x1c,0x28,0x75,0xa4, /* -.G...-...pJ.(u. */ \
	0x01,0x8c,0xe8,0x86,0x3a,0x99,0xfd,0x0c,0xba,0x16,0x95,0x23,0x07,0x05,0xc4,0x55, /* ....:......#...U */ \
	0xc8,0x45,0x3d,0xa1,0x54,0x8c,0x09,0xb3,0x6d,0xd5,0x48,0x18,0x3c,0xc1,0xc9,0x56, /* .E=.T...m.H.<..V */ \
	0x76,0x96,0x65,0x6b,0xf1,0x95,0x92,0x1c,0xb8,0xdd,0xb2,0x54,0x7c,0xbc,0x54,0x37, /* v.ek.......T|.T7 */ \
	0x46,0x6f,0x2d,0x36,0xed,0x57,0xb4,0x68,0x87,0x66,0x4d,0x1e,0xc7,0x32,0xeb,0x80, /* Fo-6.W.h.fM..2.. */ \
	0x47,0x16,0xd3,0x51,0x05,0x12,0x7d,0xb7,0x50,0xe2,0xe3,0xed,0x34,0xcd,0xf8,0xb6, /* G..Q..}.P...4... */ \
	0x43,0xeb,0xf6,0xbb,0xe4,0x72,0x8a,0x71,0xe1,0x40,0xab,0x5d,0x98,0x28,0xd2,0xe1, /* C....r.q.@.].(.. */ \
	0x76,0xf2,0x6f,0x64,0x17,0x24,0x91,0xe9,0x69,0x24,0x82,0xbf,0x76,0x61,0xea,0x7f, /* v.od.$..i$..va.. */ \
	0x01,0x5c,0xd0,0xa9,0xa5,0x50,0xb0,0x8b,0x95,0xaf,0x5c,0xc7,0x4c,0x95,0x98,0x37, /* .\...P....\.L..7 */ \
	0xfd,0x72,0xd5,0x8c,0xeb,0x06,0x89,0x25,0x95,0x21,0x27,0x73,0x4a,0x2c,0xf9,0xdf, /* .r.....%.!'sJ,.. */ \
	0x63,0x3c,0x5d,0x2a,0x28,0x19,0x86,0xed,0x88,0x7c,0x95,0x6d,0x9d,0x48,0x15,0xfc, /* c<].(....|.m.H.. */ \
	0x80,0xf3,0xc3,0xf8,0xf2,0xe0,0x55,0xe4,0x02,0xd8,0xd7,0xc1,0x37,0x2f,0xd6,0x5d, /* ......U.....7/.] */ \
	0x80,0x97,0xa4,0x73,0x74,0xce,0x0a,0x9e,0x5f,0x56,0xf1,0xb2,0x5a,0xa2,0x6a,0x49, /* ...st..._V..Z.jI */ \
	0x1b,0x19,0x0c,0x8b,0xf1,0x5c,0xf1,0x50,0x24,0x33,0x13,0xe7,0x8c,0xdb,0x02,0x5f, /* .....\.P$3....._ */ \
	0x42,0x6c,0x52,0xbf,0x74,0x06,0xe3,0x5b,0x3c,0xcf,0xe1,0x3c,0x9d,0xa6,0x6a,0xca, /* BlR.t..[<..<..j. */ \
	0xac,0x19,0x65,0x29,0x14,0x75,0xb5,0x15,0xf3,0x49,0x60,0xe9,0xca,0x8d,0x70,0xd5, /* ..e).u...I`...p. */ \
	0xea,0xad,0x42,0xb4,0xf2,0x6f,0x86,0x92,0x95,0xb9,0xb1,0x57,0xaf,0x3b,0x4e,0x3a, /* ..B..o.....W.;N: */ \
	0x03,0x54,0x04,0x28,0xee,0x40,0xfc,0x5f,0xf5,0x5c,0x11,0xca,0x44,0x86,0xc9,0xfb, /* .T.(.@._.\..D... */ \
	0xb2,0x00,0x54,0xfc,0x14,0x97,0xfa,0x3f,0x8e,0x94,0xad,0x09,0x45,0x05,0xd0,0x6d, /* ..T....?....E..m */ \
	0xda,0xfc,0xe8,0xe0,0xea,0x0b,0xf1,0xb0,0x36,0xd6,0x79,0x16,0xde,0x18,0x14,0x2d, /* ........6.y....- */ \
	0xeb,0xc8,0xd0,0x12,0x51,0x21,0xf3,0xd8,0x0b,0xd8,0x38,0x40,0x9a,0xb6,0x17,0x5b, /* ....Q!....8@...[ */ \
	0xf2,0xb1,0x25,0x8d,0x34,0xb1,0xcb,0x79,0x6d,0x1b,0x74,0x27,0xbb,0xf1,0xcc,0x9f, /* ..%.4..ym.t'.... */ \
	0x61,0x9b,0x83,0x08,0x47,0x8e,0x93,0xd7,0x87,0xf4,0x64,0x5e,0xf4,0x72,0xd0,0x35, /* a...G.....d^.r.5 */ \
	0xca,0xbe,0xf8,0x37,0x00,0x75,0x02,0x71,0x58,0xcc,0xea,0xd8,0xce,0x47,0xc0,0xa1, /* ...7.u.qX....G.. */ \
	0xeb,0xa9,0xd8,0xef,0x3e,0xf7,0xab,0x16,0xfd,0x77,0x82,0x59,0x7e,0xa2,0xb9,0x27, /* ....>....w.Y~..' */ \
	0x80,0x7b,0xa4,0xdb,0xa5,0x08,0x30,0xe5,0xe9,0x2e,0x60,0x6f,0xda,0xeb,0xb1,0xca, /* .{....0...`o.... */ \
	0xa6,0x21,0x53,0xe8,0x96,0xbc,0x32,0xac,0xf4,0x47,0x84,0xb4,0xbc,0x53,0xa6,0x15, /* .!S...2..G...S.. */ \
	0x22,0xd4,0x69,0x5c,0x64,0x0e,0xe3,0x0a,0x16,0xc6,0x7d,0xe3,0x26,0x2e,0x4b,0x97, /* ".i\d.....}.&.K. */ \
	0x6d,0x85,0x8d,0xed,0x1f,0x12,0x81,0x9f,0x29,0x58,0x0c,0x00,0x00,0x1f,0x8b,0x08, /* m.......)X...... */ \
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xd5,0x57,0x5d,0x6f,0xdb,0x36,0x14,0x7d,0x56, /* ........W]o.6.}V */ \
	0x80,0xfc,0x87,0x3b,0x3f,0x2c,0x32,0xe0,0x38,0x4e,0xb1,0xee,0xa1,0x81,0x3b,0xa4, /* ...;?,2.8N....;. */ \
	0x49,0xb1,0x66,0x48,0x97,0x20,0x71,0x87,0x02,0xdb,0x1e,0x68,0x89,0x8e,0xd9,0xc8, /* I.fH. q....h.... */ \
	0xa2,0x4a,0x52,0x76,0x8d,0x22,0x3f,0x68,0xff,0x72,0xe7,0x92,0x94,0x2c,0xbb,0x69, /* .JRv."?h.r...,.i */ \
	0x51,0xac,0x7d,0x59,0x02,0x58,0x1f,0xbc,0xf7,0xf0,0xf2,0xdc,0x4f,0x1d,0x1d,0xd1, /* Q.}Y.X......O... */ \
	0x99,0xae,0xd6,0x46,0xdd,0xcd,0x1d,0xfd,0x43,0x4f,0x46,0xa3,0x27,0x87,0x4f,0x46, /* ...F....COF.'.OF */ \
	0xc7,0x23,0x7a,0xad,0x32,0xa3,0xb3,0xb9,0xaa,0x68,0x22,0xb3,0x79,0xa9,0x0b,0x7d, /* .#z.2....h".y..} */ \
	0xb7,0xa6,0x8b,0x32,0x1b,0x12,0x9d,0x16,0x05,0x79,0x05,0x4b,0x46,0x5a,0x69,0x96, /* ...2.....y.KFZi. */ \
	0x32,0x1f,0xee,0xef,0x1d,0x1d,0xd1,0xad,0x94,0x5d,0xbd,0xb3,0xeb,0xa3,0x8b,0x6b, /* 2........].....k */ \
	0xba,0x75,0x22,0xbb,0xa7,0x5c,0x67,0xf5,0x42,0x96,0x4e,0x38,0xa5,0x4b,0x9a,0x69, /* .u"..\g.B.N8.K.i */ \
	0x43,0x85,0xca,0x64,0x69,0x25,0xa9,0x12,0x4f,0x0b,0xff,0x1e,0x28,0xfc,0x0f,0xa4, /* C..di%..O...(... */ \
	0x73,0xe9,0xa4,0x59,0xa8,0x52,0x5a,0x5a,0xcd,0x65,0x49,0x02,0x3b,0xbd,0xaf,0xa5, /* s..Y.RZZ.eI.;... */ \
	0x75,0xa4,0x2c,0x65,0xba,0xb4,0x2a,0x97,0x46,0xe6,0xd4,0x73,0x6a,0x81,0x8b,0xae, /* u.,e....F..sj... */ \
	0x5d,0x6f,0x7f,0x6f,0x29,0x0c,0xf1,0xf3,0x55,0xed,0x5e,0xdf,0xd2,0x98,0x9e,0x8e, /* ]o.o)...U.^..... */ \
	0x46,0xa3,0x13,0x3a,0x3a,0x5a,0xd8,0xfd,0x3d,0x0a,0x06,0x3a,0x0d,0x8b,0x81,0x06, /* F..::Z..=..:.... */ \
	0xac,0x5a,0x92,0x9e,0xd1,0xe9,0x6f,0xa7,0x6f,0x49,0x2e,0x61,0x99,0x25,0xa7,0xa9, /* .Z....o.oI.a.%.. */ \
	0x82,0xed,0xd2,0xda,0x80,0x25,0xde,0x89,0x0f,0x97,0x0a,0x7b,0x8e,0xa9,0x94,0x2b, /* .....%.....{...+ */ \
	0x3a,0x35,0x46,0xac,0xd3,0xfe,0x49,0x34,0xf1,0xa2,0x54,0x4e,0x09,0xe7,0xe1,0xfc, /* :5F...I4..TN.... */ \
	0x32,0x23,0x65,0x7a,0xb1,0x10,0x65,0xce,0x02,0x49,0x6d,0x8a,0x67,0xe4,0xe6,0x92, /* 2#ez..e..Im.g... */ \
	0x70,0xc3,0xd8,0x22,0x0b,0xd0,0x58,0xc2,0x09,0x9c,0xc0,0xe9,0x4c,0x10,0x68,0xc8, /* p.."..X.....L.h. */ \
	0xa1,0x8b,0x73,0x16,0x9c,0xa9,0xa2,0x18,0x10,0x28,0x12,0x34,0xab,0xcb,0xcc,0x33, /* ..s......(.4...3 */ \
	0x86,0xd7,0x99,0x00,0xef,0x2b,0xe5,0xe6,0xcc,0x7a,0xa5,0x99,0xbb,0xb7,0xaf,0x2f, /* .....+...z...../ */ \
	0x29,0xd5,0x15,0x4b,0x88,0xa2,0xef,0xa1,0x8d,0xac,0xa4,0x70,0xc0,0x35,0x38,0x20, /* )..K.......p.58  */ \
	0xb4,0xc2,0x33,0xb6,0x61,0xe2,0x18,0x41,0x95,0xb9,0x9c,0x29,0x18,0x2f,0x8b,0xf5  /* ..3.a..A...)./.. */
#define DATACHUNK000002 \
	0xae,0x72,0x2e,0x9c,0x78,0x46,0xa2,0xa4,0x37,0x37,0x97,0x24,0xcb,0x4c,0xe7,0x20, /* .r..xF..77.$.L.  */ \
	0xd7,0x3a,0xa3,0xca,0x3b,0xc6,0x9a,0x4a,0xb2,0xf5,0x74,0xa1,0x9c,0xc3,0x6b,0x61, /* .:..;..J..t...ka */ \
	0xe9,0xfa,0xea,0x76,0x42,0xac,0xb3,0x85,0xd3,0xda,0x0c,0x56,0x98,0x94,0xb3,0xc0, /* ...vB......V.... */ \
	0x49,0x0a,0x1a,0x06,0xd4,0x9e,0x7c,0x10,0x2d,0x1b,0x78,0x00,0xa8,0x7d,0xdc,0xdf, /* I.....|.-.x..}.. */ \
	0x4b,0x7c,0x0c,0x39,0xaa,0x2b,0x78,0xd4,0x90,0x9e,0xbe,0x93,0x99,0xc3,0x6b,0x76, /* K|.9.+x.......kv */ \
	0x06,0x83,0xc1,0x1f,0xd1,0x17,0x57,0x7e,0xc9,0x3b,0xc3,0xaf,0x82,0xc5,0x09,0x3c, /* ......W~.;.....< */ \
	0x6f,0xe2,0xf2,0x39,0xfc,0x12,0x16,0xa3,0xda,0x90,0x7d,0x30,0x66,0x4f,0x74,0x5f, /* o..9......}0fOt_ */ \
	0xb6,0xc6,0x60,0xa9,0xbd,0xef,0x0a,0x44,0xf2,0xc6,0xd1,0xd6,0xee,0x12,0x07,0xc7, /* ..`....D........ */ \
	0x8d,0x7c,0xcf,0x1b,0xd6,0x85,0x47,0x0d,0xf6,0x9f,0x19,0x08,0x4a,0x70,0x08,0xe2, /* .|....G.....Jp.. */ \
	0x24,0x7e,0xd8,0xbf,0x31,0x76,0x21,0xa0,0x66,0xe9,0x0a,0x0e,0xd0,0xab,0x21,0x5c, /* $~..1v!.f.....!\ */ \
	0xf7,0xca,0xb9,0xea,0x26,0x2c,0xf5,0x09,0xc7,0xa7,0xf8,0xf7,0xc8,0x16,0x38,0xd3, /* ....&,........8. */ \
	0xb6,0x82,0x3f,0xdd,0x67,0x14,0x86,0xba,0x92,0x65,0x9a,0x32,0xaf,0xe3,0x31,0x5b, /* ..?.g....e.2..1[ */ \
	0xd7,0xff,0xa5,0xf7,0xeb,0xcb,0x49,0xef,0x59,0x8f,0x1d,0xd6,0x1b,0x50,0x87,0x94, /* ......I.Y....P.. */ \
	0x81,0x0f,0x94,0x2f,0x81,0xf1,0x29,0x3c,0x56,0x23,0xc4,0xb1,0x3f,0xa3,0x95,0x3c, /* .../..)<V#..?..< */ \
	0x30,0x08,0x6d,0xcb,0xa1,0x71,0xf1,0xf2,0x67,0x44,0xc9,0xba,0x90,0x94,0x2e,0xc4, /* 0.m..q..gD...... */ \
	0x1a,0x51,0xf2,0x74,0xf8,0x94,0x53,0xa1,0x42,0x56,0x4f,0x0b,0x0e,0x43,0xdd,0x0f, /* .Q.t..S.BVO..C.. */ \
	0xba,0x0f,0x24,0x0b,0xce,0xf9,0x96,0x86,0x53,0x84,0xca,0x52,0xbe,0x0d,0xfe,0xfc, /* ..$.....S..R.... */ \
	0x0a,0x16,0xb6,0xe4,0xd3,0x9e,0xaf,0x36,0x56,0xcf,0x9c,0xe7,0x73,0x32,0xb9,0xee, /* .......6V...s2.. */ \
	0x75,0x8f,0x82,0x6d,0x76,0x50,0xb6,0x76,0xf8,0xee,0xd4,0x7d,0x15,0x7d,0x9e,0x86, /* u..mvP.v...}.}.. */ \
	0xc8,0x46,0xb8,0x84,0xdf,0x46,0xb1,0x10,0xd6,0x9d,0x21,0x51,0x91,0x62,0xe3,0x36, /* .F...F....!Q.b.6 */ \
	0xae,0x87,0x77,0xd2,0xf1,0x4d,0xeb,0xf6,0xd6,0x15,0xbe,0xa4,0x21,0xa9,0x7d,0xc6, /* ..w..M......!.}. */ \
	0x08,0x2e,0x51,0x61,0xa9,0x29,0x5e,0xc3,0xaa,0xb6,0xf3,0x86,0x06,0xd6,0x7e,0x88, /* ..Qa.)^.......~. */ \
	0xf5,0xeb,0x52,0xeb,0xca,0x92,0x5e,0x22,0xfa,0xb9,0x2c,0xe0,0xdc,0x39,0xfb,0x72, /* ..R...^"..,..9.r */ \
	0xa7,0x20,0xe6,0x4d,0x21,0x06,0x99,0x08,0xea,0x35,0xaa,0x98,0xcf,0x6d,0x65,0x7d, /* . .M!....5...me} */ \
	0x54,0x2b,0x14,0xe1,0x4e,0xc6,0x57,0xba,0x28,0x18,0x20,0x05,0xcf,0x49,0x4c,0xcd, /* T+..N.W.(. ..IL. */ \
	0xac,0x36,0xff,0x25,0x71,0x79,0x51,0x16,0xa2,0xb2,0x32,0xdf,0x24,0xd7,0x8d,0x14, /* .6.%qyQ...2.$... */ \
	0x28,0xf6,0xb3,0x99,0xcf,0xaa,0xb6,0x3c,0x87,0x3a,0x81,0xb3,0xc0,0xca,0xe9,0x9a, /* (......<.:...... */ \
	0x2f,0x90,0x46,0x53,0x49,0x15,0x50,0x5b,0x1e,0x0a,0x59,0xde,0xb9,0xf9,0x09,0x29, /* /.FSI.P[..Y....) */ \
	0x7a,0x4e,0x68,0x0b,0xea,0xf0,0x10,0x31,0x99,0x70,0xd5,0x49,0x36,0x26,0xb6,0xd2, /* zNh....1.p.I6&.. */ \
	0x76,0xae,0x66,0xd1,0x4c,0x4e,0xda,0x1f,0xa2,0x08,0xab,0x24,0xbe,0x7c,0xab,0xb2, /* v.f.LN.....$.|.. */ \
	0x96,0x7e,0x35,0x1a,0xf9,0xa8,0xb3,0xe8,0xb0,0x39,0x7e,0xc7,0xad,0x5e,0x2b,0xe1, /* .~5......9~..^+. */ \
	0x13,0x25,0x4d,0x2a,0xa1,0xac,0x66,0x52,0xe6,0xcc,0xa5,0xdf,0xae,0x51,0x6a,0x82, /* .%M...fR.....Qj. */ \
	0x08,0x35,0x25,0x5f,0xa3,0x91,0xa2,0xb0,0x8c,0xc7,0xf4,0x13,0xfd,0xf8,0x23,0xed, /* .5%_..........#. */ \
	0x8a,0x58,0xac,0xd6,0x96,0x97,0xd1,0xc3,0x7d,0x98,0x27,0x0d,0xbe,0x72,0x34,0x17, /* .X......}.'..r4. */ \
	0xdc,0xa6,0x3a,0xc5,0x77,0x65,0xd0,0x00,0x62,0x71,0xb2,0x75,0xe1,0xbc,0x38,0x76, /* ..:.we..bq.u..8v */ \
	0x76,0xeb,0x4a,0xea,0x8d,0x01,0xad,0x46,0x9f,0x91,0x0f,0x1a,0x47,0x1f,0xf4,0x03, /* v.J....F....G... */ \
	0x7e,0xf2,0x89,0xdc,0x23,0xa6,0x87,0x5e,0x85,0xfc,0x1c,0x36,0x7d,0xee,0x65,0x21, /* ~...#..^...6}.e! */ \
	0xf9,0x12,0xd8,0x4d,0x36,0x35,0xe1,0xcb,0x9b,0x87,0x3e,0x74,0xd0,0x9c,0x2d,0x69, /* ...M65....>t..-i */ \
	0xd0,0x98,0xee,0x88,0xf8,0x62,0x7d,0x91,0x3f,0xa2,0x3e,0x54,0x25,0x2e,0xaf,0x26, /* .....b}.?.>T%..& */ \
	0xe8,0x96,0xe3,0x4f,0x88,0x6b,0x0c,0x9c,0xc8,0x0f,0xae,0x31,0x08,0xbc,0xa5,0x1a, /* ...O.k.....1.... */ \
	0xe4,0x98,0x95,0xb2,0xdc,0x9e,0xa9,0xc4,0x13,0x67,0x07,0x0f,0x2e,0x5c,0x16,0x68, /* .........g...\.h */ \
	0x29,0x0a,0x94,0xe1,0x10,0x0e,0xf8,0xe1,0x8c,0x4b,0x76,0x91,0xc5,0x54,0x9b,0x18, /* )........Kv..T.. */ \
	0x43,0x8f,0xad,0x6f,0x5a,0xc7,0x96,0xaf,0x0e,0xac,0x9f,0x76,0xb8,0xdf,0x08,0x2e, /* C..oZ......v.... */ \
	0x9e,0xb1,0x79,0x0c,0xd8,0x59,0x25,0xdb,0x62,0x75,0xe3,0xac,0x06,0x30,0x48,0x07, /* ..y..Y%.bu...0H. */ \
	0x63,0x92,0x9d,0xae,0xdb,0xc8,0x84,0xee,0xbb,0x4b,0xcd,0xe6,0x55,0xc4,0x38,0xf9, /* c........K..U.8. */ \
	0x34,0xc0,0x1f,0xf8,0xa7,0x1b,0xad,0x07,0x4b,0x49,0x2b,0xa1,0x78,0x08,0xf0,0xe5, /* 4.......KI+.x... */ \
	0xe3,0x18,0x9d,0x0e,0x1a,0x79,0x34,0x11,0xe1,0xdc,0x4e,0x65,0x31,0x9e,0x9b,0x1c, /* .....y4...Ne1... */ \
	0x79,0xbe,0x99,0xcf,0xba,0x21,0x5a,0x2e,0xf5,0x7d,0x08,0xc6,0x1a,0xe3,0xe4,0x66, /* y....!Z..}.....f */ \
	0xe8,0xf1,0xc3,0x8e,0xa7,0x5b,0x95,0x55,0xfd,0xfd,0x62,0xd4,0x17,0xf6,0xad,0xe0, /* .....[.U..b..... */ \
	0x8b,0xa2,0x30,0xe6,0xb4,0x90,0xc6,0xb5,0xb6,0x84,0xd7,0x82,0xdf,0xa5,0xbd,0x48, /* ..0............H */ \
	0x29,0xcd,0x84,0x42,0x1a,0x0f,0xff,0x2a,0xcf,0x34,0xe2,0xaa,0x9d,0xcf,0x72,0x54, /* )..B.....4....rT */ \
	0xcd,0x42,0x57,0x7e,0x90,0x9b,0x6a,0x61,0x72,0x90,0x64,0xa9,0xd0,0xa8,0x26,0xbd, /* .BW~..jar.d...&. */ \
	0x66,0x37,0xef,0xeb,0x6f,0x0b,0x96,0x58,0x3a,0xfe,0x1f,0xf1,0x72,0xd5,0x24,0xd1, /* f7..o..X:...r.$. */ \
	0x80,0xde,0xd5,0x28,0xd5,0xf7,0x52,0x56,0x3e,0x76,0x90,0x4c,0x2c,0xb2,0xdd,0xa5, /* ...(..RV>v.L,... */ \
	0x9a,0x22,0xcb,0x30,0x0f,0x9b,0x89,0x8a,0xdb,0x13,0xba,0x9b,0x95,0xc5,0x92,0xa7, /* .".0............ */ \
	0xed,0x3b,0x58,0xc2,0x0d,0xef,0x78,0xc4,0x83,0x7d,0x62,0x43,0xb1,0x45,0xb0,0xa5, /* .;X...x..}bC.E.. */ \
	0xbd,0x4d,0xff,0xe9,0x0d,0x8e,0x47,0xfd,0xd0,0x38,0x1e,0x22,0x67,0x80,0xba,0x16, /* .M....G..8."g... */ \
	0x40,0xb1,0xde,0xbb,0x1f,0x16,0xc5,0x4d,0x33,0x46,0x1b,0xe9,0x6a,0x53,0x22,0x3e, /* @......M3F..jS"> */ \
	0xd1,0x3d,0x30,0xfc,0xc6,0x51,0x22,0x4e,0x5a,0xed,0x18,0x8a,0xf9,0x18,0x4a,0xe7, /* .=0..Q"NZ.....J. */ \
	0x7e,0x44,0x8e,0x08,0xfc,0xd0,0x6a,0xfb,0x1d,0x30,0xbc,0xcb,0x22,0x0f,0x02,0xfe, /* ~D....j..0.."... */ \
	0x96,0x23,0xc3,0x4a,0x61,0xb2,0x39,0x17,0x8f,0x4e,0xaf,0x44,0xd5,0xc2,0x46,0x7f, /* .#.Ja.9..N.D..F. */ \
	0x70,0x1d,0x49,0x23,0xd4,0x20,0xa8,0x84,0xd4,0x70,0x66,0x1d,0xc2,0x12,0x8e,0x8b, /* p.I#. ...pf..... */ \
	0xeb,0x9d,0x4a,0x67,0x5f,0xac,0x27,0xe2,0xee,0x77,0x81,0x2e,0x13,0x74,0xfe,0x1c, /* ..Jg_.'..w...t.. */ \
	0xfd,0x3d,0x9c,0x29,0x83,0x26,0x33,0x57,0x45,0x3e,0x2c,0x31,0xba,0x7b,0xec,0xe0  /* .=.).&3WE>,1.{.. */
#define DATACHUNK000003 \
	0xe5,0x60,0x23,0x7d,0x03,0x4e,0xec,0x75,0x56,0x76,0xf1,0x9a,0x90,0x7c,0xc0,0xa7, /* .`#}.N.uVv...|.. */ \
	0x85,0xcb,0xe6,0xa9,0x34,0x48,0xc2,0x8f,0xd4,0x5d,0xe5,0x21,0x27,0x8e,0x1c,0xf7, /* ....4H...].!'... */ \
	0x0a,0x1f,0x82,0x4d,0xf7,0xf6,0x73,0xc6,0x9b,0x0a,0x93,0x11,0x67,0xd9,0xe7,0x9c, /* ...M..s.....g... */ \
	0x88,0x4f,0xb8,0xf0,0xc1,0xf5,0x2f,0xde,0xe8,0x9b,0x2d,0xa8,0x0e,0x00,0x00,0x3c, /* .O..../...-....< */ \
	0x64,0x69,0x76,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x73,0x70,0x61,0x63,0x65, /* div class="space */ \
	0x72,0x22,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d, /* r">&nbsp;</div>. */ \
	0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x66,0x6f,0x6f,0x74,0x65,0x72, /* .<div id="footer */ \
	0x22,0x3e,0x43,0x6f,0x70,0x79,0x72,0x69,0x67,0x68,0x74,0x20,0x26,0x63,0x6f,0x70, /* ">Copyright &cop */ \
	0x79,0x3b,0x20,0x32,0x30,0x31,0x31,0x20,0x53,0x61,0x74,0x6f,0x73,0x68,0x69,0x20, /* y; 2011 Satoshi  */ \
	0x59,0x61,0x73,0x75,0x64,0x61,0x20,0x37,0x6d,0x33,0x74,0x6a,0x7a,0x2f,0x61,0x64, /* Yasuda 7m3tjz/ad */ \
	0x36,0x67,0x7a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x64, /* 6gz</div>....</d */ \
	0x69,0x76,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x3c, /* iv></div></div>< */ \
	0x2f,0x64,0x69,0x76,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c, /* /div></div>....< */ \
	0x2f,0x62,0x6f,0x64,0x79,0x3e,0x0d,0x0a,0x3c,0x2f,0x68,0x74,0x6d,0x6c,0x3e,0x3c, /* /body>..</html>< */ \
	0x21,0x44,0x4f,0x43,0x54,0x59,0x50,0x45,0x20,0x68,0x74,0x6d,0x6c,0x20,0x50,0x55, /* !DOCTYPE html PU */ \
	0x42,0x4c,0x49,0x43,0x20,0x22,0x2d,0x2f,0x2f,0x57,0x33,0x43,0x2f,0x2f,0x44,0x54, /* BLIC "-//W3C//DT */ \
	0x44,0x20,0x58,0x48,0x54,0x4d,0x4c,0x20,0x31,0x2e,0x30,0x20,0x53,0x74,0x72,0x69, /* D XHTML 1.0 Stri */ \
	0x63,0x74,0x2f,0x2f,0x45,0x4e,0x22,0x0d,0x0a,0x20,0x20,0x22,0x68,0x74,0x74,0x70, /* ct//EN"..  "http */ \
	0x3a,0x2f,0x2f,0x77,0x77,0x77,0x2e,0x77,0x33,0x2e,0x6f,0x72,0x67,0x2f,0x54,0x52, /* ://www.w3.org/TR */ \
	0x2f,0x78,0x68,0x74,0x6d,0x6c,0x31,0x2f,0x44,0x54,0x44,0x2f,0x78,0x68,0x74,0x6d, /* /xhtml1/DTD/xhtm */ \
	0x6c,0x31,0x2d,0x73,0x74,0x72,0x69,0x63,0x74,0x2e,0x64,0x74,0x64,0x22,0x3e,0x0d, /* l1-strict.dtd">. */ \
	0x0a,0x3c,0x68,0x74,0x6d,0x6c,0x20,0x78,0x6d,0x6c,0x6e,0x73,0x3d,0x22,0x68,0x74, /* .<html xmlns="ht */ \
	0x74,0x70,0x3a,0x2f,0x2f,0x77,0x77,0x77,0x2e,0x77,0x33,0x2e,0x6f,0x72,0x67,0x2f, /* tp://www.w3.org/ */ \
	0x31,0x39,0x39,0x39,0x2f,0x78,0x68,0x74,0x6d,0x6c,0x22,0x20,0x78,0x6d,0x6c,0x3a, /* 1999/xhtml" xml: */ \
	0x6c,0x61,0x6e,0x67,0x3d,0x22,0x65,0x6e,0x22,0x20,0x6c,0x61,0x6e,0x67,0x3d,0x22, /* lang="en" lang=" */ \
	0x65,0x6e,0x22,0x3e,0x0d,0x0a,0x3c,0x68,0x65,0x61,0x64,0x3e,0x0d,0x0a,0x3c,0x74, /* en">..<head>..<t */ \
	0x69,0x74,0x6c,0x65,0x3e,0x44,0x2d,0x53,0x54,0x41,0x52,0x20,0x64,0x53,0x71,0x75, /* itle>D-STAR dSqu */ \
	0x72,0x65,0x20,0x43,0x6c,0x69,0x65,0x6e,0x74,0x20,0x50,0x72,0x6f,0x67,0x72,0x61, /* re Client Progra */ \
	0x6d,0x3c,0x2f,0x74,0x69,0x74,0x6c,0x65,0x3e,0x0d,0x0a,0x3c,0x6c,0x69,0x6e,0x6b, /* m</title>..<link */ \
	0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x37,0x6d,0x33,0x74,0x6a,0x7a,0x2e,0x63, /*  href="/7m3tjz.c */ \
	0x73,0x73,0x22,0x20,0x72,0x65,0x6c,0x3d,0x22,0x73,0x74,0x79,0x6c,0x65,0x73,0x68, /* ss" rel="stylesh */ \
	0x65,0x65,0x74,0x22,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x2f, /* eet" type="text/ */ \
	0x63,0x73,0x73,0x22,0x20,0x2f,0x3e,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74, /* css" />..<script */ \
	0x20,0x73,0x72,0x63,0x3d,0x22,0x2f,0x37,0x6d,0x33,0x74,0x6a,0x7a,0x2e,0x6a,0x73, /*  src="/7m3tjz.js */ \
	0x22,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x2f,0x6a,0x61,0x76, /* " type="text/jav */ \
	0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70, /* ascript"></scrip */ \
	0x74,0x3e,0x0d,0x0a,0x3c,0x2f,0x68,0x65,0x61,0x64,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c, /* t>..</head>....< */ \
	0x62,0x6f,0x64,0x79,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22, /* body>..<div id=" */ \
	0x73,0x68,0x61,0x64,0x6f,0x77,0x2d,0x6f,0x6e,0x65,0x22,0x3e,0x3c,0x64,0x69,0x76, /* shadow-one"><div */ \
	0x20,0x69,0x64,0x3d,0x22,0x73,0x68,0x61,0x64,0x6f,0x77,0x2d,0x74,0x77,0x6f,0x22, /*  id="shadow-two" */ \
	0x3e,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x73,0x68,0x61,0x64,0x6f,0x77, /* ><div id="shadow */ \
	0x2d,0x74,0x68,0x72,0x65,0x65,0x22,0x3e,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d, /* -three"><div id= */ \
	0x22,0x73,0x68,0x61,0x64,0x6f,0x77,0x2d,0x66,0x6f,0x75,0x72,0x22,0x3e,0x0d,0x0a, /* "shadow-four">.. */ \
	0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x70,0x61,0x67,0x65,0x22,0x3e,0x0d, /* <div id="page">. */ \
	0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x74,0x69,0x74,0x6c, /* ...<div id="titl */ \
	0x65,0x22,0x3e,0x3c,0x64,0x69,0x76,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x72, /* e"><div class="r */ \
	0x69,0x67,0x68,0x74,0x22,0x3e,0x44,0x2d,0x53,0x54,0x41,0x52,0x20,0x64,0x53,0x71, /* ight">D-STAR dSq */ \
	0x75,0x72,0x65,0x20,0x43,0x6c,0x69,0x65,0x6e,0x74,0x3c,0x2f,0x64,0x69,0x76,0x3e, /* ure Client</div> */ \
	0x3c,0x73,0x70,0x61,0x6e,0x20,0x69,0x64,0x3d,0x22,0x68,0x65,0x6c,0x6c,0x6f,0x22, /* <span id="hello" */ \
	0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x73,0x70,0x61,0x6e,0x3e,0x3c,0x2f, /* >&nbsp;</span></ */ \
	0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d, /* div>....<div id= */ \
	0x22,0x6d,0x65,0x6e,0x75,0x22,0x3e,0x0d,0x0a,0x3c,0x61,0x20,0x68,0x72,0x65,0x66, /* "menu">..<a href */ \
	0x3d,0x22,0x2f,0x69,0x6e,0x64,0x65,0x78,0x2e,0x68,0x74,0x6d,0x22,0x3e,0x4f,0x76, /* ="/index.htm">Ov */ \
	0x65,0x72,0x76,0x69,0x65,0x77,0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x3c,0x61,0x20,0x68, /* erview</a>..<a h */ \
	0x72,0x65,0x66,0x3d,0x22,0x2f,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x63,0x6f, /* ref="/protect/co */ \
	0x6e,0x66,0x69,0x67,0x2e,0x68,0x74,0x6d,0x22,0x3e,0x4e,0x65,0x74,0x77,0x6f,0x72, /* nfig.htm">Networ */ \
	0x6b,0x20,0x43,0x6f,0x6e,0x66,0x69,0x67,0x75,0x72,0x61,0x74,0x69,0x6f,0x6e,0x3c, /* k Configuration< */ \
	0x2f,0x61,0x3e,0x0d,0x0a,0x3c,0x61,0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x6e, /* /a>..<a href="/n */ \
	0x6f,0x64,0x65,0x61,0x64,0x61,0x70,0x74,0x65,0x72,0x2f,0x63,0x6f,0x6e,0x66,0x69, /* odeadapter/confi */ \
	0x67,0x2e,0x68,0x74,0x6d,0x22,0x3e,0x4e,0x6f,0x64,0x65,0x20,0x41,0x64,0x61,0x70, /* g.htm">Node Adap */ \
	0x74,0x65,0x72,0x20,0x43,0x6f,0x6e,0x66,0x69,0x67,0x75,0x72,0x61,0x74,0x69,0x6f, /* ter Configuratio */ \
	0x6e,0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x3c,0x61,0x20,0x68,0x72,0x65,0x66,0x3d,0x22, /* n</a>..<a href=" */ \
	0x2f,0x6e,0x6f,0x64,0x65,0x61,0x64,0x61,0x70,0x74,0x65,0x72,0x2f,0x63,0x6f,0x6e, /* /nodeadapter/con */ \
	0x66,0x69,0x67,0x32,0x2e,0x68,0x74,0x6d,0x22,0x3e,0x42,0x65,0x61,0x63,0x6f,0x6e  /* fig2.htm">Beacon */
#define DATACHUNK000004 \
	0x20,0x43,0x6f,0x6e,0x66,0x69,0x67,0x75,0x72,0x61,0x74,0x69,0x6f,0x6e,0x3c,0x2f, /*  Configuration</ */ \
	0x61,0x3e,0x0d,0x0a,0x3c,0x61,0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x70,0x72, /* a>..<a href="/pr */ \
	0x6f,0x74,0x65,0x63,0x74,0x2f,0x75,0x73,0x65,0x72,0x2e,0x68,0x74,0x6d,0x22,0x3e, /* otect/user.htm"> */ \
	0x55,0x73,0x65,0x72,0x20,0x49,0x44,0x20,0x26,0x20,0x50,0x61,0x73,0x73,0x77,0x6f, /* User ID & Passwo */ \
	0x72,0x64,0x20,0x73,0x65,0x74,0x74,0x69,0x6e,0x67,0x3c,0x2f,0x61,0x3e,0x0d,0x0a, /* rd setting</a>.. */ \
	0x3c,0x61,0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x73,0x74,0x61,0x74,0x75,0x73, /* <a href="/status */ \
	0x2e,0x68,0x74,0x6d,0x22,0x3e,0x43,0x75,0x72,0x72,0x65,0x6e,0x74,0x20,0x53,0x74, /* .htm">Current St */ \
	0x61,0x74,0x75,0x73,0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e, /* atus</a>..</div> */ \
	0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e, /* ~inc:header.inc~ */ \
	0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65, /* ..<div id="conte */ \
	0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x44,0x2d,0x53,0x54, /* nt">....<h1>D-ST */ \
	0x41,0x52,0x20,0x64,0x53,0x71,0x75,0x72,0x65,0x20,0x43,0x6c,0x69,0x65,0x6e,0x74, /* AR dSqure Client */ \
	0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x74,0x61,0x62,0x6c,0x65,0x20, /* </h1>....<table  */ \
	0x73,0x74,0x79,0x6c,0x65,0x3d,0x22,0x70,0x61,0x64,0x64,0x69,0x6e,0x67,0x2d,0x6c, /* style="padding-l */ \
	0x65,0x66,0x74,0x3a,0x20,0x31,0x30,0x70,0x78,0x3b,0x22,0x3e,0x0d,0x0a,0x3c,0x74, /* eft: 10px;">..<t */ \
	0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x64,0x53,0x71,0x75,0x72,0x65,0x20, /* r><td><b>dSqure  */ \
	0x53,0x65,0x72,0x76,0x65,0x72,0x20,0x44,0x6f,0x6d,0x61,0x69,0x6e,0x20,0x4e,0x61, /* Server Domain Na */ \
	0x6d,0x65,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64, /* me :</b></td><td */ \
	0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e, /* >&nbsp;</td><td> */ \
	0x7e,0x73,0x65,0x72,0x76,0x65,0x72,0x5f,0x6e,0x61,0x6d,0x65,0x7e,0x3c,0x2f,0x74, /* ~server_name~</t */ \
	0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64, /* d></tr>..<tr><td */ \
	0x3e,0x3c,0x62,0x3e,0x4f,0x75,0x74,0x20,0x62,0x6f,0x75,0x6e,0x64,0x20,0x50,0x6f, /* ><b>Out bound Po */ \
	0x72,0x74,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64, /* rt :</b></td><td */ \
	0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e, /* >&nbsp;</td><td> */ \
	0x7e,0x6f,0x75,0x74,0x5f,0x70,0x6f,0x72,0x74,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c, /* ~out_port~</td>< */ \
	0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62, /* /tr>..<tr><td><b */ \
	0x3e,0x49,0x6e,0x20,0x62,0x6f,0x75,0x6e,0x64,0x20,0x50,0x6f,0x72,0x74,0x20,0x3a, /* >In bound Port : */ \
	0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62, /* </b></td><td>&nb */ \
	0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x69,0x6e,0x5f, /* sp;</td><td>~in_ */ \
	0x70,0x6f,0x72,0x74,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d, /* port~</td></tr>. */ \
	0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x43,0x6f,0x6e,0x66, /* .<tr><td><b>Conf */ \
	0x65,0x72,0x65,0x6e,0x63,0x65,0x20,0x52,0x6f,0x6f,0x6d,0x20,0x4e,0x61,0x6d,0x65, /* erence Room Name */ \
	0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26, /*  :</b></td><td>& */ \
	0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x52, /* nbsp;</td><td>~R */ \
	0x6f,0x6f,0x6d,0x4e,0x61,0x6d,0x65,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74, /* oomName~</td></t */ \
	0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x4e, /* r>..<tr><td><b>N */ \
	0x6f,0x64,0x65,0x20,0x43,0x61,0x6c,0x6c,0x73,0x69,0x67,0x6e,0x20,0x3a,0x3c,0x2f, /* ode Callsign :</ */ \
	0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70, /* b></td><td>&nbsp */ \
	0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x4e,0x6f,0x64,0x65,0x4e, /* ;</td><td>~NodeN */ \
	0x61,0x6d,0x65,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a, /* ame~</td></tr>.. */ \
	0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x41,0x63,0x63,0x65,0x73, /* <tr><td><b>Acces */ \
	0x73,0x20,0x43,0x6f,0x6e,0x74,0x72,0x6f,0x6c,0x20,0x46,0x69,0x6c,0x65,0x20,0x4e, /* s Control File N */ \
	0x61,0x6d,0x65,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74, /* ame :</b></td><t */ \
	0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64, /* d>&nbsp;</td><td */ \
	0x3e,0x7e,0x41,0x63,0x63,0x43,0x74,0x72,0x6c,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c, /* >~AccCtrl~</td>< */ \
	0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62, /* /tr>..<tr><td><b */ \
	0x3e,0x4e,0x54,0x50,0x20,0x53,0x65,0x72,0x76,0x65,0x72,0x20,0x44,0x6f,0x6d,0x61, /* >NTP Server Doma */ \
	0x69,0x6e,0x20,0x4e,0x61,0x6d,0x65,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74, /* in Name :</b></t */ \
	0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64, /* d><td>&nbsp;</td */ \
	0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x4e,0x74,0x70,0x4e,0x61,0x6d,0x65,0x7e,0x3c,0x2f, /* ><td>~NtpName~</ */ \
	0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74, /* td></tr>..<tr><t */ \
	0x64,0x3e,0x3c,0x62,0x3e,0x54,0x69,0x6d,0x65,0x20,0x5a,0x6f,0x6e,0x65,0x20,0x3a, /* d><b>Time Zone : */ \
	0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62, /* </b></td><td>&nb */ \
	0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x54,0x69,0x6d, /* sp;</td><td>~Tim */ \
	0x65,0x5a,0x6f,0x6e,0x65,0x7e,0x20,0x26,0x6e,0x62,0x73,0x70,0x3b,0x68,0x6f,0x75, /* eZone~ &nbsp;hou */ \
	0x72,0x73,0x26,0x6e,0x62,0x73,0x70,0x3b,0x7e,0x54,0x69,0x6d,0x65,0x5a,0x6f,0x6e, /* rs&nbsp;~TimeZon */ \
	0x65,0x4d,0x69,0x6e,0x75,0x74,0x65,0x73,0x7e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x6d, /* eMinutes~&nbsp;m */ \
	0x69,0x6e,0x75,0x74,0x65,0x73,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e, /* inutes</td></tr> */ \
	0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x4a,0x69,0x74, /* ..<tr><td><b>Jit */ \
	0x74,0x65,0x72,0x20,0x42,0x75,0x66,0x66,0x65,0x72,0x20,0x57,0x61,0x69,0x74,0x20, /* ter Buffer Wait  */ \
	0x50,0x61,0x63,0x6b,0x65,0x74,0x73,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64, /* Packets:</b></td */ \
	0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e, /* ><td>&nbsp;</td> */ \
	0x3c,0x74,0x64,0x3e,0x7e,0x4a,0x69,0x74,0x74,0x65,0x72,0x53,0x69,0x7a,0x65,0x7e, /* <td>~JitterSize~ */ \
	0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x2f,0x74,0x61  /* </td></tr>..</ta */
#define DATACHUNK000005 \
	0x62,0x6c,0x65,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a, /* ble>....</div>.. */ \
	0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22, /* ..<script type=" */ \
	0x74,0x65,0x78,0x74,0x2f,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22, /* text/javascript" */ \
	0x3e,0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e, /* >..<!--..documen */ \
	0x74,0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64, /* t.getElementById */ \
	0x28,0x27,0x68,0x65,0x6c,0x6c,0x6f,0x27,0x29,0x2e,0x69,0x6e,0x6e,0x65,0x72,0x48, /* ('hello').innerH */ \
	0x54,0x4d,0x4c,0x20,0x3d,0x20,0x22,0x7e,0x68,0x65,0x6c,0x6c,0x6f,0x6d,0x73,0x67, /* TML = "~hellomsg */ \
	0x7e,0x22,0x3b,0x0d,0x0a,0x2f,0x2f,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63, /* ~";..//-->..</sc */ \
	0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f, /* ript>....~inc:fo */ \
	0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x00,0x00,0x00,0x00,0x33, /* oter.inc~......3 */ \
	0x00,0x00,0x00,0xb0,0x00,0x00,0x00,0x4a,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x4b, /* .......J.......K */ \
	0x00,0x00,0x00,0x4c,0x01,0x00,0x00,0x4c,0x00,0x00,0x00,0x9e,0x01,0x00,0x00,0x4d, /* ...L...L.......M */ \
	0x00,0x00,0x00,0xea,0x01,0x00,0x00,0x4e,0x00,0x00,0x00,0x41,0x02,0x00,0x00,0x5f, /* .......N...A..._ */ \
	0x00,0x00,0x00,0x95,0x02,0x00,0x00,0x60,0x00,0x00,0x00,0xdc,0x02,0x00,0x00,0x61, /* .......`.......a */ \
	0x00,0x00,0x00,0xf8,0x02,0x00,0x00,0x6d,0x00,0x00,0x00,0x64,0x03,0x00,0x00,0x6e, /* .......m...d...n */ \
	0x00,0x00,0x00,0xe7,0x03,0x00,0x00,0x01,0x00,0x00,0x00,0x09,0x04,0x00,0x00,0x02, /* ................ */ \
	0x00,0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69, /* ...~inc:header.i */ \
	0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f, /* nc~..<div id="co */ \
	0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x44, /* ntent">....<h1>D */ \
	0x2d,0x53,0x54,0x41,0x52,0x20,0x64,0x53,0x71,0x75,0x72,0x65,0x20,0x53,0x74,0x61, /* -STAR dSqure Sta */ \
	0x74,0x75,0x73,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x74,0x61,0x62, /* tus</h1>....<tab */ \
	0x6c,0x65,0x20,0x73,0x74,0x79,0x6c,0x65,0x3d,0x22,0x70,0x61,0x64,0x64,0x69,0x6e, /* le style="paddin */ \
	0x67,0x2d,0x6c,0x65,0x66,0x74,0x3a,0x20,0x31,0x30,0x70,0x78,0x3b,0x22,0x3e,0x0d, /* g-left: 10px;">. */ \
	0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x44,0x61,0x74,0x65, /* .<tr><td><b>Date */ \
	0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26, /*  :</b></td><td>& */ \
	0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x43, /* nbsp;</td><td>~C */ \
	0x75,0x72,0x44,0x61,0x74,0x65,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72, /* urDate~</td></tr */ \
	0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x54,0x69, /* >..<tr><td><b>Ti */ \
	0x6d,0x65,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64, /* me :</b></td><td */ \
	0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e, /* >&nbsp;</td><td> */ \
	0x7e,0x43,0x75,0x72,0x54,0x69,0x6d,0x65,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f, /* ~CurTime~</td></ */ \
	0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e, /* tr>..<tr><td><b> */ \
	0x50,0x54,0x54,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74, /* PTT :</b></td><t */ \
	0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64, /* d>&nbsp;</td><td */ \
	0x3e,0x7e,0x43,0x75,0x72,0x50,0x54,0x54,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f, /* >~CurPTT~</td></ */ \
	0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e, /* tr>..<tr><td><b> */ \
	0x43,0x4f,0x53,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74, /* COS :</b></td><t */ \
	0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64, /* d>&nbsp;</td><td */ \
	0x3e,0x7e,0x43,0x75,0x72,0x43,0x4f,0x53,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f, /* >~CurCOS~</td></ */ \
	0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e, /* tr>..<tr><td><b> */ \
	0x4e,0x6f,0x64,0x65,0x20,0x55,0x73,0x65,0x72,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c, /* Node User :</b>< */ \
	0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f, /* /td><td>&nbsp;</ */ \
	0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x43,0x75,0x72,0x55,0x73,0x65,0x72,0x7e, /* td><td>~CurUser~ */ \
	0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e, /* </td></tr>..<tr> */ \
	0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x53,0x53,0x4e,0x20,0x3a,0x3c,0x2f,0x62,0x3e, /* <td><b>SSN :</b> */ \
	0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c, /* </td><td>&nbsp;< */ \
	0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x43,0x75,0x72,0x53,0x53,0x4e,0x7e, /* /td><td>~CurSSN~ */ \
	0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x2f,0x74,0x61, /* </td></tr>..</ta */ \
	0x62,0x6c,0x65,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a, /* ble>....</div>.. */ \
	0x3c,0x2f,0x62,0x6f,0x64,0x79,0x3e,0x0d,0x0a,0x3c,0x6d,0x65,0x74,0x61,0x20,0x68, /* </body>..<meta h */ \
	0x74,0x74,0x70,0x2d,0x65,0x71,0x75,0x69,0x76,0x3d,0x22,0x72,0x65,0x66,0x72,0x65, /* ttp-equiv="refre */ \
	0x73,0x68,0x22,0x20,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x3d,0x22,0x31,0x30,0x22, /* sh" content="10" */ \
	0x3e,0x0d,0x0a,0x3c,0x62,0x6f,0x64,0x79,0x3e,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69, /* >..<body>..<scri */ \
	0x70,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x2f,0x6a,0x61, /* pt type="text/ja */ \
	0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x21,0x2d,0x2d, /* vascript">..<!-- */ \
	0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c, /* ..document.getEl */ \
	0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x68,0x65,0x6c,0x6c,0x6f, /* ementById('hello */ \
	0x27,0x29,0x2e,0x69,0x6e,0x6e,0x65,0x72,0x48,0x54,0x4d,0x4c,0x20,0x3d,0x20,0x22, /* ').innerHTML = " */ \
	0x7e,0x68,0x65,0x6c,0x6c,0x6f,0x6d,0x73,0x67,0x7e,0x22,0x3b,0x0d,0x0a,0x2f,0x2f, /* ~hellomsg~";..// */ \
	0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a, /* -->..</script>.. */ \
	0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e, /* ~inc:footer.inc~ */ \
	0x0d,0x0a,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0x9b,0x00,0x00,0x00,0x63,0x00, /* ......3.......c. */ \
	0x00,0x00,0xdd,0x00,0x00,0x00,0x64,0x00,0x00,0x00,0x1e,0x01,0x00,0x00,0x66,0x00, /* ......d.......f. */ \
	0x00,0x00,0x5e,0x01,0x00,0x00,0x67,0x00,0x00,0x00,0xa4,0x01,0x00,0x00,0x69,0x00  /* ..^...g.......i. */
#define DATACHUNK000006 \
	0x00,0x00,0xe5,0x01,0x00,0x00,0x68,0x00,0x00,0x00,0x9d,0x02,0x00,0x00,0x01,0x00, /* ......h......... */ \
	0x00,0x00,0xbd,0x02,0x00,0x00,0x02,0x00,0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68, /* ..........~inc:h */ \
	0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76, /* eader.inc~..<div */ \
	0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a, /*  id="content">.. */ \
	0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x4e,0x6f,0x64,0x65,0x20,0x41,0x64,0x61,0x70,0x74, /* ..<h1>Node Adapt */ \
	0x65,0x72,0x20,0x43,0x6f,0x6e,0x66,0x69,0x67,0x75,0x72,0x61,0x74,0x69,0x6f,0x6e, /* er Configuration */ \
	0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x66,0x6f,0x72,0x6d,0x20,0x6d, /* </h1>....<form m */ \
	0x65,0x74,0x68,0x6f,0x64,0x3d,0x22,0x70,0x6f,0x73,0x74,0x22,0x20,0x61,0x63,0x74, /* ethod="post" act */ \
	0x69,0x6f,0x6e,0x3d,0x22,0x2f,0x6e,0x6f,0x64,0x65,0x61,0x64,0x61,0x70,0x74,0x65, /* ion="/nodeadapte */ \
	0x72,0x2f,0x63,0x6f,0x6e,0x66,0x69,0x67,0x2e,0x68,0x74,0x6d,0x22,0x20,0x6e,0x61, /* r/config.htm" na */ \
	0x6d,0x65,0x3d,0x22,0x6e,0x6f,0x64,0x65,0x63,0x66,0x67,0x22,0x3e,0x0d,0x0a,0x3c, /* me="nodecfg">..< */ \
	0x66,0x69,0x65,0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e, /* fieldset>..<div> */ \
	0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x54,0x58,0x20,0x44,0x65,0x6c,0x61,0x79,0x20, /* <label>TX Delay  */ \
	0x54,0x69,0x6d,0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c, /* Time:</label>..< */ \
	0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74, /* input type="text */ \
	0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x64,0x65,0x6c,0x79,0x22,0x20,0x76,0x61, /* " name="dely" va */ \
	0x6c,0x75,0x65,0x3d,0x22,0x7e,0x64,0x65,0x6c,0x61,0x79,0x5f,0x74,0x69,0x6d,0x65, /* lue="~delay_time */ \
	0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x34,0x22,0x20,0x63,0x6c,0x61,0x73, /* ~" size="4" clas */ \
	0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x20,0x2f,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b, /* s="ad1" />&nbsp; */ \
	0x6d,0x53,0x65,0x63,0x2e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69, /* mSec.</div>..<di */ \
	0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x54,0x58,0x20,0x54,0x69,0x6d,0x65, /* v><label>TX Time */ \
	0x20,0x6f,0x75,0x74,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c, /*  out:</label>..< */ \
	0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74, /* input type="text */ \
	0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x74,0x6f,0x75,0x74,0x22,0x20,0x76,0x61, /* " name="tout" va */ \
	0x6c,0x75,0x65,0x3d,0x22,0x7e,0x74,0x69,0x6d,0x65,0x5f,0x6f,0x75,0x74,0x7e,0x22, /* lue="~time_out~" */ \
	0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x34,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d, /*  size="4" class= */ \
	0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x53,0x65,0x63, /* "ad1"/>&nbsp;Sec */ \
	0x2e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c, /* .</div>..<div><l */ \
	0x61,0x62,0x65,0x6c,0x3e,0x52,0x58,0x20,0x4b,0x65,0x65,0x70,0x20,0x41,0x6c,0x69, /* abel>RX Keep Ali */ \
	0x76,0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e, /* ve:</label>..<in */ \
	0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20, /* put type="text"  */ \
	0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6b,0x65,0x65,0x70,0x22,0x20,0x76,0x61,0x6c,0x75, /* name="keep" valu */ \
	0x65,0x3d,0x22,0x7e,0x6b,0x65,0x65,0x70,0x5f,0x61,0x6c,0x69,0x76,0x65,0x7e,0x22, /* e="~keep_alive~" */ \
	0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x34,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d, /*  size="4" class= */ \
	0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x6d,0x53,0x65, /* "ad1"/>&nbsp;mSe */ \
	0x63,0x2e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c, /* c.</div>..<div>< */ \
	0x6c,0x61,0x62,0x65,0x6c,0x3e,0x4a,0x69,0x74,0x74,0x65,0x72,0x20,0x42,0x75,0x66, /* label>Jitter Buf */ \
	0x66,0x65,0x72,0x20,0x73,0x69,0x7a,0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c, /* fer size:</label */ \
	0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22, /* >..<input type=" */ \
	0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6a,0x69,0x74,0x74, /* text" name="jitt */ \
	0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x6a,0x69,0x74,0x74,0x74,0x65, /* " value="~jittte */ \
	0x72,0x5f,0x73,0x69,0x7a,0x65,0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x33, /* r_size~" size="3 */ \
	0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x26, /* " class="ad1"/>& */ \
	0x6e,0x62,0x73,0x70,0x3b,0x30,0x3a,0x20,0x6e,0x6f,0x74,0x20,0x65,0x66,0x66,0x65, /* nbsp;0: not effe */ \
	0x63,0x74,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c, /* ct</div>..<div>< */ \
	0x6c,0x61,0x62,0x65,0x6c,0x3e,0x52,0x58,0x20,0x41,0x75,0x74,0x6f,0x20,0x50,0x6f, /* label>RX Auto Po */ \
	0x6c,0x61,0x72,0x69,0x74,0x79,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d, /* larity:</label>. */ \
	0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68, /* .<input type="ch */ \
	0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x72,0x78, /* eckbox" name="rx */ \
	0x70,0x6c,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x52,0x58, /* pl" value="" ~RX */ \
	0x5f,0x41,0x75,0x74,0x6f,0x50,0x6f,0x6c,0x61,0x72,0x69,0x74,0x79,0x7e,0x20,0x63, /* _AutoPolarity~ c */ \
	0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x3c,0x2f,0x64,0x69, /* lass="ad1"/></di */ \
	0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e, /* v>..<div><label> */ \
	0x52,0x58,0x20,0x50,0x6f,0x6c,0x61,0x72,0x69,0x74,0x79,0x3a,0x3c,0x2f,0x6c,0x61, /* RX Polarity:</la */ \
	0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70, /* bel>..<input typ */ \
	0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d, /* e="checkbox" nam */ \
	0x65,0x3d,0x22,0x72,0x78,0x70,0x6f,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22, /* e="rxpo" value=" */ \
	0x22,0x20,0x7e,0x52,0x58,0x5f,0x50,0x6f,0x6c,0x61,0x72,0x69,0x74,0x79,0x7e,0x20, /* " ~RX_Polarity~  */ \
	0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x3c,0x2f, /*  class="ad1"/></ */ \
	0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65, /* div>..<div><labe */ \
	0x6c,0x3e,0x54,0x58,0x20,0x50,0x6f,0x6c,0x61,0x72,0x69,0x74,0x79,0x3a,0x3c,0x2f, /* l>TX Polarity:</ */ \
	0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70, /* label>..<td><inp */ \
	0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f, /* ut type="checkbo */ \
	0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x74,0x78,0x70,0x6f,0x22,0x20,0x76  /* x" name="txpo" v */
#define DATACHUNK000007 \
	0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x54,0x58,0x5f,0x50,0x6f,0x6c,0x61, /* alue="" ~TX_Pola */ \
	0x72,0x69,0x74,0x79,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31, /* rity~ class="ad1 */ \
	0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76, /* " /></div>..<div */ \
	0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x43,0x4f,0x53,0x20,0x43,0x68,0x65,0x63, /* ><label>COS Chec */ \
	0x6b,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e, /* k:</label>..<td> */ \
	0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65, /* <input type="che */ \
	0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x63,0x6f,0x73, /* ckbox" name="cos */ \
	0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x43,0x4f,0x53,0x5f, /* " value="" ~COS_ */ \
	0x43,0x68,0x65,0x63,0x6b,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64, /* Check~ class="ad */ \
	0x31,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69, /* 1" /></div>..<di */ \
	0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x53,0x2f,0x4e,0x20,0x53,0x71,0x75, /* v><label>S/N Squ */ \
	0x65,0x6c,0x63,0x68,0x20,0x56,0x61,0x6c,0x75,0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62, /* elch Value:</lab */ \
	0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20, /* el>..<td><input  */ \
	0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65, /* type="text" name */ \
	0x3d,0x22,0x73,0x6e,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x53,0x4e, /* ="sn" value="~SN */ \
	0x5f,0x53,0x71,0x75,0x65,0x6c,0x63,0x68,0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d, /* _Squelch~" size= */ \
	0x22,0x35,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f, /* "5" class="ad1"/ */ \
	0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x30,0x3a,0x20,0x6e,0x6f,0x74,0x20,0x65,0x66, /* >&nbsp;0: not ef */ \
	0x66,0x65,0x63,0x74,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76, /* fect</div>..<div */ \
	0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x43,0x52,0x43,0x20,0x43,0x68,0x65,0x63, /* ><label>CRC Chec */ \
	0x6b,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e, /* k:</label>..<td> */ \
	0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65, /* <input type="che */ \
	0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x63,0x72,0x63, /* ckbox" name="crc */ \
	0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x43,0x52,0x43,0x5f, /* " value="" ~CRC_ */ \
	0x43,0x68,0x65,0x63,0x6b,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64, /* Check~ class="ad */ \
	0x31,0x22,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76, /* 1"/></div>..<div */ \
	0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x4c,0x61,0x73,0x74,0x20,0x46,0x72,0x61, /* ><label>Last Fra */ \
	0x6d,0x65,0x20,0x53,0x65,0x6e,0x64,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e, /* me Send:</label> */ \
	0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70, /* ..<td><input typ */ \
	0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d, /* e="checkbox" nam */ \
	0x65,0x3d,0x22,0x6c,0x61,0x73,0x74,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22, /* e="last" value=" */ \
	0x22,0x20,0x7e,0x4c,0x61,0x73,0x74,0x46,0x72,0x61,0x6d,0x65,0x7e,0x20,0x63,0x6c, /* " ~LastFrame~ cl */ \
	0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69, /* ass="ad1" /></di */ \
	0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e, /* v>..<div><label> */ \
	0x48,0x65,0x61,0x64,0x65,0x72,0x20,0x47,0x65,0x6e,0x65,0x72,0x61,0x74,0x69,0x6f, /* Header Generatio */ \
	0x6e,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e, /* n:</label>..<td> */ \
	0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65, /* <input type="che */ \
	0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x68,0x64,0x72, /* ckbox" name="hdr */ \
	0x67,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x48,0x65,0x61, /* g" value="" ~Hea */ \
	0x64,0x65,0x72,0x47,0x65,0x6e,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61, /* derGen~ class="a */ \
	0x64,0x31,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64, /* d1" /></div>..<d */ \
	0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x48,0x65,0x61,0x64,0x65,0x72, /* iv><label>Header */ \
	0x20,0x47,0x65,0x6e,0x2e,0x20,0x54,0x79,0x70,0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62, /*  Gen. Type:</lab */ \
	0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20, /* el>..<td><input  */ \
	0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20, /* type="checkbox"  */ \
	0x6e,0x61,0x6d,0x65,0x3d,0x22,0x68,0x64,0x72,0x74,0x22,0x20,0x76,0x61,0x6c,0x75, /* name="hdrt" valu */ \
	0x65,0x3d,0x22,0x22,0x20,0x7e,0x48,0x65,0x61,0x64,0x65,0x72,0x47,0x65,0x6e,0x54, /* e="" ~HeaderGenT */ \
	0x79,0x70,0x65,0x7e,0x20,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31, /* ype~  class="ad1 */ \
	0x22,0x2f,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x43,0x68,0x65,0x63,0x6b,0x65,0x64, /* "/>&nbsp;Checked */ \
	0x3a,0x20,0x53,0x70,0x61,0x63,0x65,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c, /* : Space</div>..< */ \
	0x64,0x69,0x76,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b, /* div>&nbsp;&nbsp; */ \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73, /* &nbsp;&nbsp;&nbs */ \
	0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e, /* p;&nbsp;&nbsp;&n */ \
	0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b, /* bsp;&nbsp;&nbsp; */ \
	0x0d,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62, /* .&nbsp;&nbsp;&nb */ \
	0x73,0x70,0x3b,0x0a,0x55,0x6e,0x63,0x68,0x65,0x63,0x6b,0x65,0x64,0x3a,0x20,0x4c, /* sp;.Unchecked: L */ \
	0x61,0x73,0x74,0x20,0x52,0x46,0x20,0x48,0x65,0x61,0x64,0x65,0x72,0x3c,0x2f,0x64, /* ast RF Header</d */ \
	0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c, /* iv>..<div><label */ \
	0x3e,0x48,0x61,0x6c,0x66,0x2f,0x46,0x75,0x6c,0x6c,0x20,0x44,0x75,0x70,0x6c,0x65, /* >Half/Full Duple */ \
	0x78,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e, /* x:</label>..<td> */ \
	0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65, /* <input type="che */ \
	0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x68,0x5f,0x66, /* ckbox" name="h_f */ \
	0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x48,0x61,0x6c,0x66, /* " value="" ~Half */ \
	0x46,0x75,0x6c,0x6c,0x7e,0x20,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64  /* Full~  class="ad */
#define DATACHUNK000008 \
	0x31,0x22,0x2f,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x43,0x68,0x65,0x63,0x6b,0x65, /* 1"/>&nbsp;Checke */ \
	0x64,0x3a,0x26,0x6e,0x62,0x73,0x70,0x3b,0x48,0x61,0x6c,0x66,0x3c,0x2f,0x64,0x69, /* d:&nbsp;Half</di */ \
	0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26, /* v>..<div>&nbsp;& */ \
	0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70, /* nbsp;&nbsp;&nbsp */ \
	0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62, /* ;&nbsp;&nbsp;&nb */ \
	0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26, /* sp;&nbsp;&nbsp;& */ \
	0x6e,0x62,0x73,0x70,0x3b,0x0d,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73, /* nbsp;.&nbsp;&nbs */ \
	0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x0a,0x55,0x6e,0x63,0x68,0x65,0x63,0x6b, /* p;&nbsp;.Uncheck */ \
	0x65,0x64,0x3a,0x20,0x46,0x75,0x6c,0x6c,0x20,0x44,0x75,0x70,0x6c,0x65,0x78,0x3c, /* ed: Full Duplex< */ \
	0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e, /* /div>......<div> */ \
	0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x73,0x75,0x62, /* <input type="sub */ \
	0x6d,0x69,0x74,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x70,0x31,0x22, /* mit" class="ap1" */ \
	0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x53,0x61,0x76,0x65,0x20,0x42,0x61,0x73, /*  value="Save Bas */ \
	0x69,0x63,0x20,0x49,0x6e,0x66,0x6f,0x2e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69, /* ic Info." /></di */ \
	0x76,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x69,0x65,0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d, /* v>..</fieldset>. */ \
	0x0a,0x3c,0x2f,0x66,0x6f,0x72,0x6d,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e, /* .</form>..</div> */ \
	0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e, /* ..~inc:footer.in */ \
	0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0xeb,0x00,0x00,0x00,0x51,0x00, /* c~....3.......Q. */ \
	0x00,0x00,0x6b,0x01,0x00,0x00,0x52,0x00,0x00,0x00,0xe9,0x01,0x00,0x00,0x53,0x00, /* ..k...R.......S. */ \
	0x00,0x00,0x6f,0x02,0x00,0x00,0x54,0x00,0x00,0x00,0x03,0x03,0x00,0x00,0x55,0x00, /* ..o...T.......U. */ \
	0x00,0x00,0x78,0x03,0x00,0x00,0x5e,0x00,0x00,0x00,0xee,0x03,0x00,0x00,0x56,0x00, /* ..x...^.......V. */ \
	0x00,0x00,0x61,0x04,0x00,0x00,0x57,0x00,0x00,0x00,0xd3,0x04,0x00,0x00,0x58,0x00, /* ..a...W.......X. */ \
	0x00,0x00,0x61,0x05,0x00,0x00,0x59,0x00,0x00,0x00,0xd8,0x05,0x00,0x00,0x5a,0x00, /* ..a...Y.......Z. */ \
	0x00,0x00,0x52,0x06,0x00,0x00,0x5b,0x00,0x00,0x00,0xcb,0x06,0x00,0x00,0x5c,0x00, /* ..R...[.......\. */ \
	0x00,0x00,0xd1,0x07,0x00,0x00,0x5d,0x00,0x00,0x00,0xe8,0x08,0x00,0x00,0x02,0x00, /* ......]......... */ \
	0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e, /* ..~inc:header.in */ \
	0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e, /* c~..<div id="con */ \
	0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x42,0x65, /* tent">....<h1>Be */ \
	0x61,0x63,0x6f,0x6e,0x20,0x43,0x6f,0x6e,0x66,0x69,0x67,0x75,0x72,0x61,0x74,0x69, /* acon Configurati */ \
	0x6f,0x6e,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x66,0x6f,0x72,0x6d, /* on</h1>....<form */ \
	0x20,0x6d,0x65,0x74,0x68,0x6f,0x64,0x3d,0x22,0x70,0x6f,0x73,0x74,0x22,0x20,0x61, /*  method="post" a */ \
	0x63,0x74,0x69,0x6f,0x6e,0x3d,0x22,0x2f,0x6e,0x6f,0x64,0x65,0x61,0x64,0x61,0x70, /* ction="/nodeadap */ \
	0x74,0x65,0x72,0x2f,0x63,0x6f,0x6e,0x66,0x69,0x67,0x32,0x2e,0x68,0x74,0x6d,0x22, /* ter/config2.htm" */ \
	0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x62,0x65,0x61,0x63,0x6f,0x6e,0x22,0x3e,0x0d, /*  name="beacon">. */ \
	0x0a,0x3c,0x66,0x69,0x65,0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a,0x3c,0x64,0x69, /* .<fieldset>..<di */ \
	0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x42,0x65,0x61,0x63,0x6f,0x6e,0x20, /* v><label>Beacon  */ \
	0x4d,0x65,0x73,0x73,0x61,0x67,0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e, /* Message:</label> */ \
	0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74, /* ..<input type="t */ \
	0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x62,0x65,0x61,0x63,0x22, /* ext" name="beac" */ \
	0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x42,0x65,0x61,0x63,0x6f,0x6e,0x4d, /*  value="~BeaconM */ \
	0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x32,0x30,0x22,0x20,0x63,0x6c,0x61, /* ~" size="20" cla */ \
	0x73,0x73,0x3d,0x22,0x73,0x6d,0x22,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d, /* ss="sm"/></div>. */ \
	0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x49,0x6e,0x65, /* .<div><label>Ine */ \
	0x72,0x76,0x61,0x6c,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c, /* rval:</label>..< */ \
	0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74, /* input type="text */ \
	0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x69,0x6e,0x74,0x76,0x22,0x20,0x76,0x61, /* " name="intv" va */ \
	0x6c,0x75,0x65,0x3d,0x22,0x7e,0x42,0x65,0x61,0x63,0x6f,0x6e,0x49,0x6e,0x74,0x76, /* lue="~BeaconIntv */ \
	0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x33,0x22,0x20,0x63,0x6c,0x61,0x73, /* ~" size="3" clas */ \
	0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x53, /* s="ad1"/>&nbsp;S */ \
	0x65,0x63,0x2e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69, /* ec.</div>....<di */ \
	0x76,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x73, /* v><input type="s */ \
	0x75,0x62,0x6d,0x69,0x74,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x70, /* ubmit" class="ap */ \
	0x31,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x53,0x61,0x76,0x65,0x20,0x42, /* 1" value="Save B */ \
	0x65,0x61,0x63,0x6f,0x6e,0x20,0x49,0x6e,0x66,0x6f,0x2e,0x22,0x20,0x2f,0x3e,0x3c, /* eacon Info." />< */ \
	0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x69,0x65,0x6c,0x64,0x73,0x65, /* /div>..</fieldse */ \
	0x74,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x6f,0x72,0x6d,0x3e,0x0d,0x0a,0x3c,0x2f,0x64, /* t>..</form>..</d */ \
	0x69,0x76,0x3e,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72, /* iv>..~inc:footer */ \
	0x2e,0x69,0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0xe6,0x00,0x00, /* .inc~....3...... */ \
	0x00,0x71,0x00,0x00,0x00,0x53,0x01,0x00,0x00,0x72,0x00,0x00,0x00,0xf3,0x01,0x00, /* .q...S...r...... */ \
	0x00,0x02,0x00,0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72, /* .....~inc:header */ \
	0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22, /* .inc~..<div id=" */ \
	0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31, /* content">....<h1 */ \
	0x3e,0x4e,0x65,0x74,0x77,0x6f,0x72,0x6b,0x20,0x43,0x6f,0x6e,0x66,0x69,0x67,0x75, /* >Network Configu */ \
	0x72,0x61,0x74,0x69,0x6f,0x6e,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c  /* ration</h1>....< */
#define DATACHUNK000009 \
	0x66,0x6f,0x72,0x6d,0x20,0x6d,0x65,0x74,0x68,0x6f,0x64,0x3d,0x22,0x70,0x6f,0x73, /* form method="pos */ \
	0x74,0x22,0x20,0x61,0x63,0x74,0x69,0x6f,0x6e,0x3d,0x22,0x2f,0x70,0x72,0x6f,0x74, /* t" action="/prot */ \
	0x65,0x63,0x74,0x2f,0x63,0x6f,0x6e,0x66,0x69,0x67,0x2e,0x68,0x74,0x6d,0x22,0x20, /* ect/config.htm"  */ \
	0x6e,0x61,0x6d,0x65,0x3d,0x22,0x63,0x6f,0x6e,0x66,0x69,0x67,0x22,0x3e,0x0d,0x0a, /* name="config">.. */ \
	0x3c,0x66,0x69,0x65,0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76, /* <fieldset>..<div */ \
	0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x4d,0x41,0x43,0x20,0x41,0x64,0x64,0x72, /* ><label>MAC Addr */ \
	0x65,0x73,0x73,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69, /* ess:</label>..<i */ \
	0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22, /* nput type="text" */ \
	0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6d,0x61,0x63,0x22,0x20,0x76,0x61,0x6c,0x75, /*  name="mac" valu */ \
	0x65,0x3d,0x22,0x7e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x5f,0x6d,0x61,0x63,0x7e,0x22, /* e="~config_mac~" */ \
	0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e, /*  /></div>..<div> */ \
	0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x53,0x65,0x72,0x76,0x65,0x72,0x20,0x4e,0x61, /* <label>Server Na */ \
	0x6d,0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e, /* me:</label>..<in */ \
	0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20, /* put type="text"  */ \
	0x6e,0x61,0x6d,0x65,0x3d,0x22,0x68,0x6f,0x73,0x74,0x22,0x20,0x76,0x61,0x6c,0x75, /* name="host" valu */ \
	0x65,0x3d,0x22,0x7e,0x73,0x65,0x72,0x76,0x65,0x72,0x5f,0x6e,0x61,0x6d,0x65,0x7e, /* e="~server_name~ */ \
	0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76, /* " /></div>..<div */ \
	0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x4f,0x75,0x74,0x20,0x42,0x6f,0x75,0x6e, /* ><label>Out Boun */ \
	0x64,0x20,0x50,0x6f,0x72,0x74,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d, /* d Port:</label>. */ \
	0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65, /* .<input type="te */ \
	0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6f,0x70,0x72,0x74,0x22,0x20, /* xt" name="oprt"  */ \
	0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x6f,0x75,0x74,0x5f,0x70,0x6f,0x72,0x74, /* value="~out_port */ \
	0x7e,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x20,0x73, /* ~" class="ad1" s */ \
	0x69,0x7a,0x65,0x3d,0x22,0x35,0x22,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d, /* ize="5"/></div>. */ \
	0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x49,0x6e,0x20, /* .<div><label>In  */ \
	0x42,0x6f,0x75,0x6e,0x64,0x20,0x50,0x6f,0x72,0x74,0x3a,0x3c,0x2f,0x6c,0x61,0x62, /* Bound Port:</lab */ \
	0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65, /* el>..<input type */ \
	0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x69,0x70, /* ="text" name="ip */ \
	0x72,0x74,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x69,0x6e,0x5f,0x70, /* rt" value="~in_p */ \
	0x6f,0x72,0x74,0x7e,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31, /* ort~" class="ad1 */ \
	0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x35,0x22,0x2f,0x3e,0x3c,0x2f,0x64,0x69, /* " size="5"/></di */ \
	0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e, /* v>..<div><label> */ \
	0x52,0x6f,0x6f,0x6d,0x20,0x4e,0x61,0x6d,0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65, /* Room Name:</labe */ \
	0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d, /* l>..<input type= */ \
	0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x52,0x6d,0x4e, /* "text" name="RmN */ \
	0x6d,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x52,0x6f,0x6f,0x6d,0x4e, /* m" value="~RoomN */ \
	0x61,0x6d,0x65,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a, /* ame~" /></div>.. */ \
	0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x4e,0x6f,0x64,0x65, /* <div><label>Node */ \
	0x20,0x43,0x61,0x6c,0x6c,0x73,0x69,0x67,0x6e,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65, /*  Callsign:</labe */ \
	0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d, /* l>..<input type= */ \
	0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x4e,0x64,0x4e, /* "text" name="NdN */ \
	0x6d,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x4e,0x6f,0x64,0x65,0x4e, /* m" value="~NodeN */ \
	0x61,0x6d,0x65,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a, /* ame~" /></div>.. */ \
	0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x4a,0x69,0x74,0x74, /* <div><label>Jitt */ \
	0x65,0x72,0x20,0x42,0x75,0x66,0x66,0x65,0x72,0x20,0x57,0x61,0x69,0x74,0x3a,0x3c, /* er Buffer Wait:< */ \
	0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20, /* /label>..<input  */ \
	0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65, /* type="text" name */ \
	0x3d,0x22,0x6a,0x69,0x74,0x74,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e, /* ="jitt" value="~ */ \
	0x4a,0x69,0x74,0x74,0x65,0x72,0x53,0x69,0x7a,0x65,0x7e,0x22,0x20,0x73,0x69,0x7a, /* JitterSize~" siz */ \
	0x65,0x3d,0x22,0x32,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31, /* e="2" class="ad1 */ \
	0x22,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e, /* "/></div>..<div> */ \
	0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x4e,0x54,0x50,0x20,0x53,0x65,0x72,0x76,0x65, /* <label>NTP Serve */ \
	0x72,0x20,0x4e,0x61,0x6d,0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x26, /* r Name:</label>& */ \
	0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70, /* nbsp;&nbsp;&nbsp */ \
	0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62, /* ;&nbsp;&nbsp;&nb */ \
	0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26, /* sp;&nbsp;&nbsp;& */ \
	0x6e,0x62,0x73,0x70,0x3b,0x0d,0x0a,0x3c,0x73,0x65,0x6c,0x65,0x63,0x74,0x20,0x6e, /* nbsp;..<select n */ \
	0x61,0x6d,0x65,0x3d,0x22,0x6e,0x74,0x70,0x22,0x3e,0x0d,0x0a,0x3c,0x6f,0x70,0x74, /* ame="ntp">..<opt */ \
	0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x70,0x6f,0x6f,0x6c,0x2e, /* ion value="pool. */ \
	0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x22,0x3e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74, /* ntp.org">pool.nt */ \
	0x70,0x2e,0x6f,0x72,0x67,0x0d,0x0a,0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x20,0x76, /* p.org..<option v */ \
	0x61,0x6c,0x75,0x65,0x3d,0x22,0x65,0x75,0x72,0x6f,0x70,0x65,0x2e,0x70,0x6f,0x6f, /* alue="europe.poo */ \
	0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x22,0x3e,0x65,0x75,0x72,0x6f,0x70, /* l.ntp.org">europ */ \
	0x65,0x2e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x0d,0x0a  /* e.pool.ntp.org.. */
#define DATACHUNK00000a \
	0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x61, /* <option value="a */ \
	0x73,0x69,0x61,0x2e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67, /* sia.pool.ntp.org */ \
	0x22,0x3e,0x61,0x73,0x69,0x61,0x2e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e, /* ">asia.pool.ntp. */ \
	0x6f,0x72,0x67,0x0d,0x0a,0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c, /* org..<option val */ \
	0x75,0x65,0x3d,0x22,0x6f,0x63,0x65,0x61,0x6e,0x69,0x61,0x2e,0x70,0x6f,0x6f,0x6c, /* ue="oceania.pool */ \
	0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x22,0x3e,0x6f,0x63,0x65,0x61,0x6e,0x69, /* .ntp.org">oceani */ \
	0x61,0x2e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x0d,0x0a, /* a.pool.ntp.org.. */ \
	0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x6e, /* <option value="n */ \
	0x6f,0x72,0x74,0x68,0x2d,0x61,0x6d,0x65,0x72,0x69,0x63,0x61,0x2e,0x70,0x6f,0x6f, /* orth-america.poo */ \
	0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x22,0x3e,0x6e,0x6f,0x72,0x74,0x68, /* l.ntp.org">north */ \
	0x2d,0x61,0x6d,0x65,0x72,0x69,0x63,0x61,0x2e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74, /* -america.pool.nt */ \
	0x70,0x2e,0x6f,0x72,0x67,0x0d,0x0a,0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x20,0x76, /* p.org..<option v */ \
	0x61,0x6c,0x75,0x65,0x3d,0x22,0x73,0x6f,0x75,0x74,0x68,0x2d,0x61,0x6d,0x65,0x72, /* alue="south-amer */ \
	0x69,0x63,0x61,0x2e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67, /* ica.pool.ntp.org */ \
	0x22,0x3e,0x73,0x6f,0x75,0x74,0x68,0x2d,0x61,0x6d,0x65,0x72,0x69,0x63,0x61,0x2e, /* ">south-america. */ \
	0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x0d,0x0a,0x3c,0x6f, /* pool.ntp.org..<o */ \
	0x70,0x74,0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x61,0x66,0x72, /* ption value="afr */ \
	0x69,0x63,0x61,0x2e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67, /* ica.pool.ntp.org */ \
	0x22,0x3e,0x61,0x66,0x72,0x69,0x63,0x61,0x2e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74, /* ">africa.pool.nt */ \
	0x70,0x2e,0x6f,0x72,0x67,0x0d,0x0a,0x3c,0x2f,0x73,0x65,0x6c,0x65,0x63,0x74,0x3e, /* p.org..</select> */ \
	0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c, /* ..</div>..<div>< */ \
	0x6c,0x61,0x62,0x65,0x6c,0x3e,0x54,0x69,0x6d,0x65,0x20,0x5a,0x6f,0x6e,0x65,0x3a, /* label>Time Zone: */ \
	0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74, /* </label>..<input */ \
	0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d, /*  type="text" nam */ \
	0x65,0x3d,0x22,0x7a,0x6f,0x6e,0x65,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22, /* e="zone" value=" */ \
	0x7e,0x54,0x69,0x6d,0x65,0x5a,0x6f,0x6e,0x65,0x7e,0x22,0x20,0x63,0x6c,0x61,0x73, /* ~TimeZone~" clas */ \
	0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x33,0x22, /* s="ad1" size="3" */ \
	0x2f,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x68,0x6f,0x75,0x72,0x73,0x26,0x6e,0x62, /* />&nbsp;hours&nb */ \
	0x73,0x70,0x3b,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65, /* sp;..<input type */ \
	0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x7a,0x6e, /* ="text" name="zn */ \
	0x65,0x4d,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x54,0x69,0x6d,0x65, /* eM" value="~Time */ \
	0x5a,0x6f,0x6e,0x65,0x4d,0x69,0x6e,0x75,0x74,0x65,0x73,0x7e,0x22,0x20,0x63,0x6c, /* ZoneMinutes~" cl */ \
	0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22, /* ass="ad1" size=" */ \
	0x32,0x22,0x2f,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x6d,0x69,0x6e,0x75,0x74,0x65, /* 2"/>&nbsp;minute */ \
	0x73,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e, /* s</div>....<div> */ \
	0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x41,0x63,0x63,0x65,0x73,0x73,0x20,0x43,0x6f, /* <label>Access Co */ \
	0x6e,0x74,0x72,0x6f,0x6c,0x20,0x46,0x69,0x6c,0x65,0x20,0x4e,0x61,0x6d,0x65,0x3a, /* ntrol File Name: */ \
	0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74, /* </label>..<input */ \
	0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d, /*  type="text" nam */ \
	0x65,0x3d,0x22,0x61,0x63,0x74,0x6c,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22, /* e="actl" value=" */ \
	0x7e,0x41,0x63,0x63,0x43,0x74,0x72,0x6c,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64, /* ~AccCtrl~" /></d */ \
	0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b, /* iv>..<div>&nbsp; */ \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64, /* &nbsp;</div>..<d */ \
	0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65, /* iv>..<input type */ \
	0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x63,0x6c,0x61,0x73, /* ="checkbox" clas */ \
	0x73,0x3d,0x22,0x73,0x6d,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x64,0x68,0x63, /* s="sm" name="dhc */ \
	0x70,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x31,0x22,0x20,0x6f,0x6e,0x63, /* p" value="1" onc */ \
	0x6c,0x69,0x63,0x6b,0x3d,0x22,0x63,0x6f,0x6e,0x66,0x69,0x67,0x49,0x50,0x42,0x6f, /* lick="configIPBo */ \
	0x78,0x65,0x73,0x28,0x29,0x22,0x20,0x7e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x5f,0x64, /* xes()" ~config_d */ \
	0x68,0x63,0x70,0x63,0x68,0x65,0x63,0x6b,0x65,0x64,0x7e,0x20,0x2f,0x3e,0x20,0x45, /* hcpchecked~ /> E */ \
	0x6e,0x61,0x62,0x6c,0x65,0x20,0x44,0x48,0x43,0x50,0x3c,0x2f,0x64,0x69,0x76,0x3e, /* nable DHCP</div> */ \
	0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x49,0x50, /* ..<div><label>IP */ \
	0x20,0x41,0x64,0x64,0x72,0x65,0x73,0x73,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c, /*  Address:</label */ \
	0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79, /* >..<td><input ty */ \
	0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22, /* pe="text" name=" */ \
	0x69,0x70,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x63,0x6f,0x6e,0x66, /* ip" value="~conf */ \
	0x69,0x67,0x5f,0x69,0x70,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e, /* ig_ip~" /></div> */ \
	0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x47,0x61, /* ..<div><label>Ga */ \
	0x74,0x65,0x77,0x61,0x79,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a, /* teway:</label>.. */ \
	0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d, /* <td><input type= */ \
	0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x67,0x77,0x22, /* "text" name="gw" */ \
	0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x5f, /*  value="~config_ */ \
	0x67,0x77,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c, /* gw~" /></div>..< */ \
	0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x53,0x75,0x62,0x6e,0x65  /* div><label>Subne */
#define DATACHUNK00000b \
	0x74,0x20,0x4d,0x61,0x73,0x6b,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d, /* t Mask:</label>. */ \
	0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65, /* .<td><input type */ \
	0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x73,0x75, /* ="text" name="su */ \
	0x62,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x63,0x6f,0x6e,0x66,0x69, /* b" value="~confi */ \
	0x67,0x5f,0x73,0x75,0x62,0x6e,0x65,0x74,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64, /* g_subnet~" /></d */ \
	0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c, /* iv>..<div><label */ \
	0x3e,0x50,0x72,0x69,0x6d,0x61,0x72,0x79,0x20,0x44,0x4e,0x53,0x3a,0x3c,0x2f,0x6c, /* >Primary DNS:</l */ \
	0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75, /* abel>..<td><inpu */ \
	0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61, /* t type="text" na */ \
	0x6d,0x65,0x3d,0x22,0x64,0x6e,0x73,0x31,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d, /* me="dns1" value= */ \
	0x22,0x7e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x5f,0x64,0x6e,0x73,0x31,0x7e,0x22,0x20, /* "~config_dns1~"  */ \
	0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c, /* /></div>..<div>< */ \
	0x6c,0x61,0x62,0x65,0x6c,0x3e,0x53,0x65,0x63,0x6f,0x6e,0x64,0x61,0x72,0x79,0x20, /* label>Secondary  */ \
	0x44,0x4e,0x53,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69, /* DNS:</label>..<i */ \
	0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22, /* nput type="text" */ \
	0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x64,0x6e,0x73,0x32,0x22,0x20,0x76,0x61,0x6c, /*  name="dns2" val */ \
	0x75,0x65,0x3d,0x22,0x7e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x5f,0x64,0x6e,0x73,0x32, /* ue="~config_dns2 */ \
	0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69, /* ~" /></div>..<di */ \
	0x76,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x73, /* v><input type="s */ \
	0x75,0x62,0x6d,0x69,0x74,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x73,0x6d, /* ubmit" class="sm */ \
	0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x53,0x61,0x76,0x65,0x20,0x43,0x6f, /* " value="Save Co */ \
	0x6e,0x66,0x69,0x67,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a, /* nfig" /></div>.. */ \
	0x3c,0x2f,0x66,0x69,0x65,0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a,0x3c,0x2f,0x66, /* </fieldset>..</f */ \
	0x6f,0x72,0x6d,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a, /* orm>..</div>.... */ \
	0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x6c,0x61,0x6e,0x67,0x75,0x61,0x67,0x65, /* <script language */ \
	0x3d,0x22,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a, /* ="javascript">.. */ \
	0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x63, /* <!--..function c */ \
	0x6f,0x6e,0x66,0x69,0x67,0x49,0x50,0x42,0x6f,0x78,0x65,0x73,0x28,0x29,0x20,0x7b, /* onfigIPBoxes() { */ \
	0x0d,0x0a,0x09,0x65,0x20,0x3d,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e, /* ...e = document. */ \
	0x66,0x6f,0x72,0x6d,0x73,0x2e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x3b,0x0d,0x0a,0x09, /* forms.config;... */ \
	0x73,0x74,0x20,0x3d,0x20,0x65,0x2e,0x64,0x68,0x63,0x70,0x2e,0x63,0x68,0x65,0x63, /* st = e.dhcp.chec */ \
	0x6b,0x65,0x64,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x69,0x70,0x2e,0x64,0x69,0x73,0x61, /* ked;...e.ip.disa */ \
	0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x67, /* bled = st;...e.g */ \
	0x77,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b, /* w.disabled = st; */ \
	0x0d,0x0a,0x09,0x65,0x2e,0x73,0x75,0x62,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65, /* ...e.sub.disable */ \
	0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x64,0x6e,0x73,0x31, /* d = st;...e.dns1 */ \
	0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d, /* .disabled = st;. */ \
	0x0a,0x09,0x65,0x2e,0x64,0x6e,0x73,0x32,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65, /* ..e.dns2.disable */ \
	0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x7d,0x0d,0x0a,0x64,0x6f,0x63,0x75, /* d = st;..}..docu */ \
	0x6d,0x65,0x6e,0x74,0x2e,0x66,0x6f,0x72,0x6d,0x73,0x2e,0x63,0x6f,0x6e,0x66,0x69, /* ment.forms.confi */ \
	0x67,0x2e,0x6d,0x61,0x63,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d, /* g.mac.disabled = */ \
	0x20,0x74,0x72,0x75,0x65,0x3b,0x0d,0x0a,0x0d,0x0a,0x63,0x6f,0x6e,0x66,0x69,0x67, /*  true;....config */ \
	0x49,0x50,0x42,0x6f,0x78,0x65,0x73,0x28,0x29,0x3b,0x0d,0x0a,0x64,0x6f,0x63,0x75, /* IPBoxes();..docu */ \
	0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42, /* ment.getElementB */ \
	0x79,0x49,0x64,0x28,0x27,0x68,0x65,0x6c,0x6c,0x6f,0x27,0x29,0x2e,0x69,0x6e,0x6e, /* yId('hello').inn */ \
	0x65,0x72,0x48,0x54,0x4d,0x4c,0x20,0x3d,0x20,0x22,0x7e,0x68,0x65,0x6c,0x6c,0x6f, /* erHTML = "~hello */ \
	0x6d,0x73,0x67,0x7e,0x22,0x3b,0x0d,0x0a,0x2f,0x2f,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c, /* msg~";..//-->..< */ \
	0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66, /* /script>..~inc:f */ \
	0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00, /* ooter.inc~....3. */ \
	0x00,0x00,0xde,0x00,0x00,0x00,0x25,0x00,0x00,0x00,0x3e,0x01,0x00,0x00,0x4a,0x00, /* ......%...>...J. */ \
	0x00,0x00,0xa2,0x01,0x00,0x00,0x4b,0x00,0x00,0x00,0x16,0x02,0x00,0x00,0x4c,0x00, /* ......K.......L. */ \
	0x00,0x00,0x85,0x02,0x00,0x00,0x4d,0x00,0x00,0x00,0xe5,0x02,0x00,0x00,0x4e,0x00, /* ......M.......N. */ \
	0x00,0x00,0x4a,0x03,0x00,0x00,0x6e,0x00,0x00,0x00,0xdb,0x05,0x00,0x00,0x61,0x00, /* ..J...n.......a. */ \
	0x00,0x00,0x36,0x06,0x00,0x00,0x6d,0x00,0x00,0x00,0xcb,0x06,0x00,0x00,0x5f,0x00, /* ..6...m......._. */ \
	0x00,0x00,0x52,0x07,0x00,0x00,0x27,0x00,0x00,0x00,0xc6,0x07,0x00,0x00,0x28,0x00, /* ..R...'.......(. */ \
	0x00,0x00,0x23,0x08,0x00,0x00,0x29,0x00,0x00,0x00,0x85,0x08,0x00,0x00,0x2a,0x00, /* ..#...)......... */ \
	0x00,0x00,0xec,0x08,0x00,0x00,0x2b,0x00,0x00,0x00,0x4f,0x09,0x00,0x00,0x2c,0x00, /* ......+...O...,. */ \
	0x00,0x00,0x25,0x0b,0x00,0x00,0x01,0x00,0x00,0x00,0x45,0x0b,0x00,0x00,0x02,0x00, /* ..%.......E..... */ \
	0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e, /* ..~inc:header.in */ \
	0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e, /* c~..<div id="con */ \
	0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x4c,0x6f, /* tent">....<h1>Lo */ \
	0x67,0x69,0x6e,0x20,0x53,0x75,0x63,0x63,0x65,0x73,0x73,0x66,0x75,0x6c,0x3c,0x2f, /* gin Successful</ */ \
	0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x59,0x6f,0x75,0x20,0x68,0x61, /* h1>....<p>You ha */ \
	0x76,0x65,0x20,0x73,0x75,0x63,0x63,0x65,0x73,0x73,0x66,0x75,0x6c,0x6c,0x79,0x20  /* ve successfully  */
#define DATACHUNK00000c \
	0x6c,0x6f,0x67,0x67,0x65,0x64,0x20,0x69,0x6e,0x20,0x74,0x6f,0x20,0x74,0x68,0x65, /* logged in to the */ \
	0x20,0x77,0x65,0x62,0x20,0x73,0x65,0x72,0x76,0x65,0x72,0x2e,0x20,0x20,0x54,0x68, /*  web server.  Th */ \
	0x69,0x73,0x20,0x61,0x75,0x74,0x68,0x65,0x6e,0x74,0x69,0x63,0x61,0x74,0x69,0x6f, /* is authenticatio */ \
	0x6e,0x20,0x0d,0x0a,0x69,0x73,0x20,0x76,0x61,0x6c,0x69,0x64,0x20,0x75,0x6e,0x74, /* n ..is valid unt */ \
	0x69,0x6c,0x20,0x79,0x6f,0x75,0x20,0x63,0x6c,0x6f,0x73,0x65,0x20,0x79,0x6f,0x75, /* il you close you */ \
	0x72,0x20,0x62,0x72,0x6f,0x77,0x73,0x65,0x72,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a, /* r browser.</p>.. */ \
	0x0d,0x0a,0x3c,0x70,0x3e,0x43,0x72,0x65,0x64,0x65,0x6e,0x74,0x69,0x61,0x6c,0x73, /* ..<p>Credentials */ \
	0x20,0x61,0x72,0x65,0x20,0x76,0x65,0x72,0x69,0x66,0x69,0x65,0x64,0x20,0x69,0x6e, /*  are verified in */ \
	0x20,0x79,0x6f,0x75,0x72,0x20,0x6f,0x77,0x6e,0x20,0x63,0x75,0x73,0x74,0x6f,0x6d, /*  your own custom */ \
	0x20,0x63,0x61,0x6c,0x6c,0x62,0x61,0x63,0x6b,0x20,0x66,0x75,0x6e,0x63,0x74,0x69, /*  callback functi */ \
	0x6f,0x6e,0x20,0x63,0x61,0x6c,0x6c,0x65,0x64,0x20,0x0d,0x0a,0x3c,0x63,0x6f,0x64, /* on called ..<cod */ \
	0x65,0x3e,0x48,0x54,0x54,0x50,0x41,0x75,0x74,0x68,0x65,0x6e,0x74,0x69,0x63,0x61, /* e>HTTPAuthentica */ \
	0x74,0x65,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x2e,0x20,0x20,0x49,0x6e,0x20,0x68, /* te</code>.  In h */ \
	0x65,0x72,0x65,0x2c,0x20,0x79,0x6f,0x75,0x20,0x63,0x61,0x6e,0x20,0x64,0x65,0x74, /* ere, you can det */ \
	0x65,0x72,0x6d,0x69,0x6e,0x65,0x20,0x69,0x66,0x20,0x74,0x68,0x65,0x20,0x73,0x75, /* ermine if the su */ \
	0x70,0x70,0x6c,0x69,0x65,0x64,0x0d,0x0a,0x75,0x73,0x65,0x72,0x20,0x6e,0x61,0x6d, /* pplied..user nam */ \
	0x65,0x20,0x61,0x6e,0x64,0x20,0x70,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x20,0x61, /* e and password a */ \
	0x72,0x65,0x20,0x76,0x61,0x6c,0x69,0x64,0x20,0x66,0x6f,0x72,0x20,0x61,0x63,0x63, /* re valid for acc */ \
	0x65,0x73,0x73,0x20,0x74,0x6f,0x20,0x74,0x68,0x65,0x20,0x72,0x65,0x71,0x75,0x65, /* ess to the reque */ \
	0x73,0x74,0x65,0x64,0x20,0x70,0x61,0x67,0x65,0x2e,0x20,0x20,0x59,0x6f,0x75,0x20, /* sted page.  You  */ \
	0x63,0x61,0x6e,0x20,0x0d,0x0a,0x61,0x64,0x64,0x20,0x6d,0x75,0x6c,0x74,0x69,0x70, /* can ..add multip */ \
	0x6c,0x65,0x20,0x75,0x73,0x65,0x72,0x73,0x20,0x61,0x6e,0x64,0x20,0x72,0x65,0x73, /* le users and res */ \
	0x74,0x72,0x69,0x63,0x74,0x20,0x64,0x69,0x66,0x66,0x65,0x72,0x65,0x6e,0x74,0x20, /* trict different  */ \
	0x75,0x73,0x65,0x72,0x73,0x20,0x74,0x6f,0x20,0x64,0x69,0x66,0x66,0x65,0x72,0x65, /* users to differe */ \
	0x6e,0x74,0x20,0x70,0x61,0x67,0x65,0x73,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d, /* nt pages.</p>... */ \
	0x0a,0x3c,0x70,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x65,0x78,0x65,0x72,0x63, /* .<p class="exerc */ \
	0x69,0x73,0x65,0x22,0x3e,0x3c,0x62,0x3e,0x45,0x78,0x65,0x72,0x63,0x69,0x73,0x65, /* ise"><b>Exercise */ \
	0x3a,0x3c,0x2f,0x62,0x3e,0x20,0x43,0x68,0x61,0x6e,0x67,0x65,0x20,0x74,0x68,0x65, /* :</b> Change the */ \
	0x20,0x75,0x73,0x65,0x72,0x20,0x6e,0x61,0x6d,0x65,0x20,0x61,0x6e,0x64,0x20,0x70, /*  user name and p */ \
	0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x20,0x69,0x6e,0x0d,0x0a,0x3c,0x63,0x6f,0x64, /* assword in..<cod */ \
	0x65,0x3e,0x48,0x54,0x54,0x50,0x41,0x75,0x74,0x68,0x65,0x6e,0x74,0x69,0x63,0x61, /* e>HTTPAuthentica */ \
	0x74,0x65,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x20,0x74,0x6f,0x20,0x6f,0x6e,0x65, /* te</code> to one */ \
	0x20,0x6f,0x66,0x20,0x79,0x6f,0x75,0x72,0x20,0x63,0x68,0x6f,0x6f,0x73,0x69,0x6e, /*  of your choosin */ \
	0x67,0x2e,0x20,0x20,0x28,0x54,0x68,0x65,0x20,0x63,0x61,0x6c,0x6c,0x62,0x61,0x63, /* g.  (The callbac */ \
	0x6b,0x20,0x69,0x73,0x20,0x0d,0x0a,0x6c,0x6f,0x63,0x61,0x74,0x65,0x64,0x20,0x69, /* k is ..located i */ \
	0x6e,0x20,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x43,0x75,0x73,0x74,0x6f,0x6d,0x48,0x54, /* n <code>CustomHT */ \
	0x54,0x50,0x41,0x70,0x70,0x2e,0x63,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x2e,0x29, /* TPApp.c</code>.) */ \
	0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x63,0x6c,0x61, /* </p>....<div cla */ \
	0x73,0x73,0x3d,0x22,0x65,0x78,0x61,0x6d,0x70,0x6c,0x65,0x62,0x6f,0x78,0x22,0x3e, /* ss="examplebox"> */ \
	0x0d,0x0a,0x57,0x68,0x65,0x6e,0x20,0x79,0x6f,0x75,0x20,0x66,0x69,0x6e,0x69,0x73, /* ..When you finis */ \
	0x68,0x2c,0x20,0x72,0x65,0x66,0x72,0x65,0x73,0x68,0x20,0x74,0x68,0x69,0x73,0x20, /* h, refresh this  */ \
	0x70,0x61,0x67,0x65,0x20,0x74,0x6f,0x20,0x74,0x65,0x73,0x74,0x20,0x79,0x6f,0x75, /* page to test you */ \
	0x72,0x20,0x6e,0x65,0x77,0x20,0x75,0x73,0x65,0x72,0x20,0x6e,0x61,0x6d,0x65,0x20, /* r new user name  */ \
	0x61,0x6e,0x64,0x20,0x70,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x20,0x0d,0x0a,0x63, /* and password ..c */ \
	0x6f,0x6d,0x62,0x69,0x6e,0x61,0x74,0x69,0x6f,0x6e,0x2e,0x0d,0x0a,0x3c,0x2f,0x64, /* ombination...</d */ \
	0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d, /* iv>....</div>... */ \
	0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74, /* .<script type="t */ \
	0x65,0x78,0x74,0x2f,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e, /* ext/javascript"> */ \
	0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74, /* ..<!--..document */ \
	0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28, /* .getElementById( */ \
	0x27,0x68,0x65,0x6c,0x6c,0x6f,0x27,0x29,0x2e,0x69,0x6e,0x6e,0x65,0x72,0x48,0x54, /* 'hello').innerHT */ \
	0x4d,0x4c,0x20,0x3d,0x20,0x22,0x7e,0x68,0x65,0x6c,0x6c,0x6f,0x6d,0x73,0x67,0x7e, /* ML = "~hellomsg~ */ \
	0x22,0x3b,0x0d,0x0a,0x2f,0x2f,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72, /* ";..//-->..</scr */ \
	0x69,0x70,0x74,0x3e,0x0d,0x0a,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f, /* ipt>....~inc:foo */ \
	0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00, /* ter.inc~....3... */ \
	0x94,0x03,0x00,0x00,0x01,0x00,0x00,0x00,0xb6,0x03,0x00,0x00,0x02,0x00,0x00,0x00, /* ................ */ \
	0x7e,0x72,0x65,0x62,0x6f,0x6f,0x74,0x7e,0x00,0x00,0x00,0x00,0x2d,0x00,0x00,0x00, /* ~reboot~....-... */ \
	0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e, /* ~inc:header.inc~ */ \
	0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65, /* ..<div id="conte */ \
	0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x52,0x65,0x62,0x6f, /* nt">....<h1>Rebo */ \
	0x6f,0x74,0x20,0x49,0x6e,0x20,0x50,0x72,0x6f,0x67,0x72,0x65,0x73,0x73,0x2e,0x2e, /* ot In Progress.. */ \
	0x2e,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x59,0x6f,0x75, /* .</h1>....<p>You */ \
	0x72,0x20,0x73,0x65,0x74,0x74,0x69,0x6e,0x67,0x73,0x20,0x77,0x65,0x72,0x65,0x20, /* r settings were  */ \
	0x73,0x75,0x63,0x63,0x65,0x73,0x73,0x66,0x75,0x6c,0x6c,0x79,0x20,0x73,0x61,0x76  /* successfully sav */
#define DATACHUNK00000d \
	0x65,0x64,0x2c,0x20,0x61,0x6e,0x64,0x20,0x74,0x68,0x65,0x20,0x62,0x6f,0x61,0x72, /* ed, and the boar */ \
	0x64,0x20,0x69,0x73,0x20,0x6e,0x6f,0x77,0x20,0x72,0x65,0x62,0x6f,0x6f,0x74,0x69, /* d is now rebooti */ \
	0x6e,0x67,0x20,0x0d,0x0a,0x74,0x6f,0x20,0x63,0x6f,0x6e,0x66,0x69,0x67,0x75,0x72, /* ng ..to configur */ \
	0x65,0x20,0x69,0x74,0x73,0x65,0x6c,0x66,0x20,0x77,0x69,0x74,0x68,0x20,0x74,0x68, /* e itself with th */ \
	0x65,0x20,0x6e,0x65,0x77,0x20,0x73,0x65,0x74,0x74,0x69,0x6e,0x67,0x73,0x2e,0x3c, /* e new settings.< */ \
	0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x36,0x3e,0x3c,0x2f,0x68,0x36,0x3e, /* /p>....<h6></h6> */ \
	0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x73, /* ....</div>....<s */ \
	0x63,0x72,0x69,0x70,0x74,0x20,0x6c,0x61,0x6e,0x67,0x75,0x61,0x67,0x65,0x3d,0x22, /* cript language=" */ \
	0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x21, /* javascript">..<! */ \
	0x2d,0x2d,0x0d,0x0a,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x72,0x65,0x62, /* --..function reb */ \
	0x6f,0x6f,0x74,0x44,0x75,0x6d,0x6d,0x79,0x28,0x78,0x29,0x7b,0x7d,0x0d,0x0a,0x73, /* ootDummy(x){}..s */ \
	0x65,0x74,0x54,0x69,0x6d,0x65,0x6f,0x75,0x74,0x28,0x22,0x6e,0x65,0x77,0x41,0x4a, /* etTimeout("newAJ */ \
	0x41,0x58,0x43,0x6f,0x6d,0x6d,0x61,0x6e,0x64,0x28,0x27,0x2f,0x70,0x72,0x6f,0x74, /* AXCommand('/prot */ \
	0x65,0x63,0x74,0x2f,0x72,0x65,0x62,0x6f,0x6f,0x74,0x2e,0x63,0x67,0x69,0x27,0x2c, /* ect/reboot.cgi', */ \
	0x72,0x65,0x62,0x6f,0x6f,0x74,0x44,0x75,0x6d,0x6d,0x79,0x2c,0x66,0x61,0x6c,0x73, /* rebootDummy,fals */ \
	0x65,0x29,0x3b,0x22,0x2c,0x35,0x30,0x30,0x29,0x3b,0x0d,0x0a,0x2f,0x2f,0x2d,0x2d, /* e);",500);..//-- */ \
	0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a,0x7e,0x69, /* >..</script>..~i */ \
	0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x00,0x00, /* nc:footer.inc~.. */ \
	0x00,0x00,0x33,0x00,0x00,0x00,0x7e,0x01,0x00,0x00,0x02,0x00,0x00,0x00,0x7e,0x69, /* ..3...~.......~i */ \
	0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a, /* nc:header.inc~.. */ \
	0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74, /* <div id="content */ \
	0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x55,0x73,0x65,0x72,0x20,0x49, /* ">....<h1>User I */ \
	0x44,0x20,0x61,0x6e,0x64,0x20,0x50,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x20,0x53, /* D and Password S */ \
	0x65,0x74,0x74,0x69,0x6e,0x67,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c, /* etting</h1>....< */ \
	0x66,0x6f,0x72,0x6d,0x20,0x6d,0x65,0x74,0x68,0x6f,0x64,0x3d,0x22,0x70,0x6f,0x73, /* form method="pos */ \
	0x74,0x22,0x20,0x61,0x63,0x74,0x69,0x6f,0x6e,0x3d,0x22,0x2f,0x70,0x72,0x6f,0x74, /* t" action="/prot */ \
	0x65,0x63,0x74,0x2f,0x75,0x73,0x65,0x72,0x2e,0x68,0x74,0x6d,0x22,0x20,0x6e,0x61, /* ect/user.htm" na */ \
	0x6d,0x65,0x3d,0x22,0x75,0x73,0x65,0x72,0x22,0x3e,0x0d,0x0a,0x3c,0x66,0x69,0x65, /* me="user">..<fie */ \
	0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61, /* ldset>..<div><la */ \
	0x62,0x65,0x6c,0x3e,0x55,0x73,0x65,0x72,0x20,0x49,0x44,0x3a,0x3c,0x2f,0x6c,0x61, /* bel>User ID:</la */ \
	0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70, /* bel>..<input typ */ \
	0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x75, /* e="text" name="u */ \
	0x73,0x65,0x72,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x75,0x73,0x65, /* ser" value="~use */ \
	0x72,0x5f,0x69,0x64,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d, /* r_id~" /></div>. */ \
	0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x50,0x61,0x73, /* .<div><label>Pas */ \
	0x73,0x77,0x6f,0x72,0x64,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a, /* sword:</label>.. */ \
	0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x70,0x61,0x73, /* <input type="pas */ \
	0x73,0x77,0x6f,0x72,0x64,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x70,0x77,0x64, /* sword" name="pwd */ \
	0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x75,0x73,0x65,0x72,0x5f,0x70, /* " value="~user_p */ \
	0x61,0x73,0x73,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a, /* ass~" /></div>.. */ \
	0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x50,0x61,0x73,0x73, /* <div><label>Pass */ \
	0x77,0x6f,0x72,0x64,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c, /* word:</label>..< */ \
	0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x70,0x61,0x73,0x73, /* input type="pass */ \
	0x77,0x6f,0x72,0x64,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x70,0x77,0x64,0x43, /* word" name="pwdC */ \
	0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x75,0x73,0x65,0x72,0x5f,0x70, /* " value="~user_p */ \
	0x61,0x73,0x73,0x43,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d, /* assC~" /></div>. */ \
	0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70, /* .<div><input typ */ \
	0x65,0x3d,0x22,0x62,0x75,0x74,0x74,0x6f,0x6e,0x22,0x20,0x20,0x6f,0x6e,0x43,0x6c, /* e="button"  onCl */ \
	0x69,0x63,0x6b,0x3d,0x22,0x70,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x43,0x68,0x65, /* ick="passwordChe */ \
	0x63,0x6b,0x28,0x29,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31, /* ck()" class="ad1 */ \
	0x62,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x53,0x61,0x76,0x65,0x20,0x49, /* b" value="Save I */ \
	0x44,0x20,0x26,0x20,0x50,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x22,0x2f,0x3e,0x3c, /* D & Password"/>< */ \
	0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x69,0x65,0x6c,0x64,0x73,0x65, /* /div>..</fieldse */ \
	0x74,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x6f,0x72,0x6d,0x3e,0x0d,0x0a,0x3c,0x2f,0x64, /* t>..</form>..</d */ \
	0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x74, /* iv>....<script t */ \
	0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x2f,0x6a,0x61,0x76,0x61,0x73,0x63, /* ype="text/javasc */ \
	0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x2f,0x2f, /* ript">..<!--..// */ \
	0x2d,0x2d,0x3e,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65, /* -->..document.ge */ \
	0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x68,0x65, /* tElementById('he */ \
	0x6c,0x6c,0x6f,0x27,0x29,0x2e,0x69,0x6e,0x6e,0x65,0x72,0x48,0x54,0x4d,0x4c,0x20, /* llo').innerHTML  */ \
	0x3d,0x20,0x22,0x7e,0x68,0x65,0x6c,0x6c,0x6f,0x6d,0x73,0x67,0x7e,0x22,0x3b,0x0d, /* = "~hellomsg~";. */ \
	0x0a,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x70,0x61,0x73,0x73,0x77,0x6f, /* .function passwo */ \
	0x72,0x64,0x43,0x68,0x65,0x63,0x6b,0x28,0x29,0x0d,0x0a,0x7b,0x0d,0x0a,0x09,0x69, /* rdCheck()..{...i */ \
	0x66,0x20,0x28,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x75,0x73,0x65,0x72  /* f (document.user */
#define DATACHUNK00000e \
	0x2e,0x70,0x77,0x64,0x2e,0x76,0x61,0x6c,0x75,0x65,0x20,0x21,0x3d,0x20,0x64,0x6f, /* .pwd.value != do */ \
	0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x75,0x73,0x65,0x72,0x2e,0x70,0x77,0x64,0x43, /* cument.user.pwdC */ \
	0x2e,0x76,0x61,0x6c,0x75,0x65,0x29,0x0d,0x0a,0x09,0x7b,0x0d,0x0a,0x09,0x09,0x61, /* .value)...{....a */ \
	0x6c,0x65,0x72,0x74,0x20,0x28,0x22,0x50,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x20, /* lert ("Password  */ \
	0x6d,0x69,0x73,0x73,0x6d,0x61,0x74,0x63,0x68,0x21,0x22,0x29,0x3b,0x0d,0x0a,0x09, /* missmatch!");... */ \
	0x09,0x72,0x65,0x74,0x75,0x72,0x6e,0x3b,0x0d,0x0a,0x09,0x7d,0x0d,0x0a,0x09,0x64, /* .return;...}...d */ \
	0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x75,0x73,0x65,0x72,0x2e,0x73,0x75,0x62, /* ocument.user.sub */ \
	0x6d,0x69,0x74,0x28,0x29,0x3b,0x0d,0x0a,0x0d,0x0a,0x7d,0x0d,0x0a,0x3c,0x2f,0x73, /* mit();....}..</s */ \
	0x63,0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66, /* cript>....~inc:f */ \
	0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00, /* ooter.inc~....3. */ \
	0x00,0x00,0xde,0x00,0x00,0x00,0x6a,0x00,0x00,0x00,0x3b,0x01,0x00,0x00,0x6b,0x00, /* ......j...;...k. */ \
	0x00,0x00,0x9b,0x01,0x00,0x00,0x6c,0x00,0x00,0x00,0x95,0x02,0x00,0x00,0x01,0x00, /* ......l......... */ \
	0x00,0x00,0x5c,0x03,0x00,0x00,0x02,0x00,0x00,0x00                                /* ..\.......       */


/**************************************
 * MPFS2 C linkable symbols
 **************************************/
// For C18, these are split into seperate arrays because it speeds up compilation a lot.  
// For other compilers, the entire data array must be defined as a single variable to 
// ensure that the linker does not reorder the data chunks in Flash when compiler 
// optimizations are turned on.
#if defined(__18CXX)
	ROM BYTE MPFS_Start[] = {DATACHUNK000000};
	ROM BYTE MPFS_000001[] = {DATACHUNK000001};
	ROM BYTE MPFS_000002[] = {DATACHUNK000002};
	ROM BYTE MPFS_000003[] = {DATACHUNK000003};
	ROM BYTE MPFS_000004[] = {DATACHUNK000004};
	ROM BYTE MPFS_000005[] = {DATACHUNK000005};
	ROM BYTE MPFS_000006[] = {DATACHUNK000006};
	ROM BYTE MPFS_000007[] = {DATACHUNK000007};
	ROM BYTE MPFS_000008[] = {DATACHUNK000008};
	ROM BYTE MPFS_000009[] = {DATACHUNK000009};
	ROM BYTE MPFS_00000a[] = {DATACHUNK00000a};
	ROM BYTE MPFS_00000b[] = {DATACHUNK00000b};
	ROM BYTE MPFS_00000c[] = {DATACHUNK00000c};
	ROM BYTE MPFS_00000d[] = {DATACHUNK00000d};
	ROM BYTE MPFS_00000e[] = {DATACHUNK00000e};
#else
	ROM BYTE MPFS_Start[] = {DATACHUNK000000, DATACHUNK000001, DATACHUNK000002, DATACHUNK000003, DATACHUNK000004, DATACHUNK000005, DATACHUNK000006, DATACHUNK000007, DATACHUNK000008, DATACHUNK000009, DATACHUNK00000a, DATACHUNK00000b, DATACHUNK00000c, DATACHUNK00000d, DATACHUNK00000e};
#endif


/**************************************************************
 * End of MPFS
 **************************************************************/
#endif // #if defined(STACK_USE_MPFS2)
#endif // #if !defined(MPFS_USE_EEPROM) && !defined(MPFS_USE_SPI_FLASH)
