/***************************************************************
 * MPFSImg2.c
 * Defines an MPFS2 image to be stored in program memory.
 *
 * NOT FOR HAND MODIFICATION
 * This file is automatically generated by the MPFS2 Utility
 * ALL MODIFICATIONS WILL BE OVERWRITTEN BY THE MPFS2 GENERATOR
 * Generated y 11 05 2011 10:02:48 
 ***************************************************************/

#define __MPFSIMG2_C

#include "TCPIPConfig.h"
#if !defined(MPFS_USE_EEPROM) && !defined(MPFS_USE_SPI_FLASH)

#include "TCPIP Stack/TCPIP.h"
#if defined(STACK_USE_MPFS2)


/**************************************
 * MPFS2 Image Data
 **************************************/
#define DATACHUNK000000 \
	0x4d,0x50,0x46,0x53,0x02,0x01,0x18,0x00,0x6a,0x55,0x5e,0x2a,0x26,0x4f,0x26,0x2d, /* MPFS....jU^.&O&- */ \
	0x0a,0xa3,0xff,0xff,0x6a,0x83,0xff,0xff,0xea,0x72,0xff,0xff,0x4a,0xe3,0xff,0xff, /* ....j....r..J... */ \
	0x6a,0xe3,0xff,0xff,0xea,0x92,0xff,0xff,0x0a,0x4f,0xff,0xff,0x26,0xb6,0xff,0xff, /* j........O..&... */ \
	0x8a,0xb6,0xff,0xff,0xca,0xb4,0xff,0xff,0x48,0x02,0x00,0x00,0x35,0x03,0x00,0x00, /* ........H...5... */ \
	0x99,0x03,0x00,0x00,0xb3,0x77,0xb0,0x4e,0x00,0x00,0x00,0x00,0x01,0x00,0x53,0x02, /* .....w.N......S. */ \
	0x00,0x00,0xce,0x06,0x00,0x00,0xc2,0x05,0x00,0x00,0x91,0x1b,0x15,0x4e,0x00,0x00, /* .............N.. */ \
	0x00,0x00,0x01,0x00,0x5d,0x02,0x00,0x00,0x90,0x0c,0x00,0x00,0xa0,0x00,0x00,0x00, /* ....]........... */ \
	0xc3,0x42,0x9b,0x4e,0x00,0x00,0x00,0x00,0x00,0x00,0x68,0x02,0x00,0x00,0x30,0x0d, /* .B.N......h...0. */ \
	0x00,0x00,0xe9,0x03,0x00,0x00,0x70,0x38,0xaf,0x4e,0x00,0x00,0x00,0x00,0x00,0x00, /* ......p8.N...... */ \
	0x73,0x02,0x00,0x00,0x19,0x11,0x00,0x00,0x1b,0x04,0x00,0x00,0x27,0x7c,0xab,0x4e, /* s...........'|.N */ \
	0x00,0x00,0x00,0x00,0x02,0x00,0x7d,0x02,0x00,0x00,0x34,0x15,0x00,0x00,0x68,0x00, /* ......}...4...h. */ \
	0x00,0x00,0x27,0x7c,0xab,0x4e,0x00,0x00,0x00,0x00,0x00,0x00,0x7e,0x02,0x00,0x00, /* ..'|.N......~... */ \
	0x9c,0x15,0x00,0x00,0xcf,0x02,0x00,0x00,0x4a,0xb7,0xa4,0x4e,0x00,0x00,0x00,0x00, /* ........J..N.... */ \
	0x02,0x00,0x89,0x02,0x00,0x00,0x6b,0x18,0x00,0x00,0x48,0x00,0x00,0x00,0x4a,0xb7, /* ......k...H...J. */ \
	0xa4,0x4e,0x00,0x00,0x00,0x00,0x00,0x00,0x8a,0x02,0x00,0x00,0xb3,0x18,0x00,0x00, /* .N.............. */ \
	0xf8,0x08,0x00,0x00,0xe9,0x38,0xaf,0x4e,0x00,0x00,0x00,0x00,0x02,0x00,0xa1,0x02, /* .....8.N........ */ \
	0x00,0x00,0xab,0x21,0x00,0x00,0x80,0x00,0x00,0x00,0xe9,0x38,0xaf,0x4e,0x00,0x00, /* ...!.......8.N.. */ \
	0x00,0x00,0x00,0x00,0xa2,0x02,0x00,0x00,0x2b,0x22,0x00,0x00,0x03,0x02,0x00,0x00, /* ........+"...... */ \
	0x86,0x22,0xac,0x4e,0x00,0x00,0x00,0x00,0x02,0x00,0xba,0x02,0x00,0x00,0x2e,0x24, /* .".N...........$ */ \
	0x00,0x00,0x20,0x00,0x00,0x00,0x86,0x22,0xac,0x4e,0x00,0x00,0x00,0x00,0x00,0x00, /* .. ....".N...... */ \
	0xbb,0x02,0x00,0x00,0x4e,0x24,0x00,0x00,0x9f,0x0a,0x00,0x00,0xd7,0x33,0xb5,0x4e, /* ....N$.......3.N */ \
	0x00,0x00,0x00,0x00,0x02,0x00,0xd3,0x02,0x00,0x00,0xed,0x2e,0x00,0x00,0xb0,0x00, /* ................ */ \
	0x00,0x00,0xd7,0x33,0xb5,0x4e,0x00,0x00,0x00,0x00,0x00,0x00,0xd4,0x02,0x00,0x00, /* ...3.N.......... */ \
	0x9d,0x2f,0x00,0x00,0xf8,0x0b,0x00,0x00,0x72,0x7f,0xb3,0x4e,0x00,0x00,0x00,0x00, /* ./......r..N.... */ \
	0x02,0x00,0xe7,0x02,0x00,0x00,0x95,0x3b,0x00,0x00,0xa0,0x00,0x00,0x00,0x72,0x7f, /* .......;......r. */ \
	0xb3,0x4e,0x00,0x00,0x00,0x00,0x00,0x00,0xe8,0x02,0x00,0x00,0x35,0x3c,0x00,0x00, /* .N..........5<.. */ \
	0xc6,0x03,0x00,0x00,0x91,0x1b,0x15,0x4e,0x00,0x00,0x00,0x00,0x02,0x00,0xfa,0x02, /* .......N........ */ \
	0x00,0x00,0xfb,0x3f,0x00,0x00,0x18,0x00,0x00,0x00,0x91,0x1b,0x15,0x4e,0x00,0x00, /* ...?.........N.. */ \
	0x00,0x00,0x00,0x00,0xfb,0x02,0x00,0x00,0x13,0x40,0x00,0x00,0x08,0x00,0x00,0x00, /* .........@...... */ \
	0x91,0x1b,0x15,0x4e,0x00,0x00,0x00,0x00,0x02,0x00,0x0e,0x03,0x00,0x00,0x1b,0x40, /* ...N...........@ */ \
	0x00,0x00,0x08,0x00,0x00,0x00,0x91,0x1b,0x15,0x4e,0x00,0x00,0x00,0x00,0x00,0x00, /* .........N...... */ \
	0x0f,0x03,0x00,0x00,0x23,0x40,0x00,0x00,0x8e,0x01,0x00,0x00,0x11,0x0c,0x9c,0x4e, /* ....#@.........N */ \
	0x00,0x00,0x00,0x00,0x02,0x00,0x22,0x03,0x00,0x00,0xb1,0x41,0x00,0x00,0x10,0x00, /* ......"....A.... */ \
	0x00,0x00,0x11,0x0c,0x9c,0x4e,0x00,0x00,0x00,0x00,0x00,0x00,0x23,0x03,0x00,0x00, /* .....N......#... */ \
	0xc1,0x41,0x00,0x00,0x6c,0x03,0x00,0x00,0xc3,0xf2,0xad,0x4e,0x00,0x00,0x00,0x00, /* .A..l......N.... */ \
	0x02,0x00,0x34,0x03,0x00,0x00,0x2d,0x45,0x00,0x00,0x30,0x00,0x00,0x00,0xc3,0xf2, /* ..4...-E..0..... */ \
	0xad,0x4e,0x00,0x00,0x00,0x00,0x00,0x00,0x37,0x6d,0x33,0x74,0x6a,0x7a,0x2e,0x63, /* .N......7m3tjz.c */ \
	0x73,0x73,0x00,0x37,0x6d,0x33,0x74,0x6a,0x7a,0x2e,0x6a,0x73,0x00,0x66,0x6f,0x6f, /* ss.7m3tjz.js.foo */ \
	0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x00,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69, /* ter.inc.header.i */ \
	0x6e,0x63,0x00,0x69,0x6e,0x64,0x65,0x78,0x2e,0x68,0x74,0x6d,0x00,0x00,0x73,0x74, /* nc.index.htm..st */ \
	0x61,0x74,0x75,0x73,0x2e,0x68,0x74,0x6d,0x00,0x00,0x6e,0x6f,0x64,0x65,0x61,0x64, /* atus.htm..nodead */ \
	0x61,0x70,0x74,0x65,0x72,0x2f,0x63,0x6f,0x6e,0x66,0x69,0x67,0x2e,0x68,0x74,0x6d, /* apter/config.htm */ \
	0x00,0x00,0x6e,0x6f,0x64,0x65,0x61,0x64,0x61,0x70,0x74,0x65,0x72,0x2f,0x63,0x6f, /* ..nodeadapter/co */ \
	0x6e,0x66,0x69,0x67,0x32,0x2e,0x68,0x74,0x6d,0x00,0x00,0x6e,0x6f,0x64,0x65,0x61, /* nfig2.htm..nodea */ \
	0x64,0x61,0x70,0x74,0x65,0x72,0x2f,0x63,0x6f,0x6e,0x66,0x69,0x67,0x33,0x2e,0x68, /* dapter/config3.h */ \
	0x74,0x6d,0x00,0x00,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x63,0x6f,0x6e,0x66, /* tm..protect/conf */ \
	0x69,0x67,0x2e,0x68,0x74,0x6d,0x00,0x00,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f, /* ig.htm..protect/ */ \
	0x69,0x6e,0x64,0x65,0x78,0x2e,0x68,0x74,0x6d,0x00,0x00,0x70,0x72,0x6f,0x74,0x65, /* index.htm..prote */ \
	0x63,0x74,0x2f,0x72,0x65,0x62,0x6f,0x6f,0x74,0x2e,0x63,0x67,0x69,0x00,0x00,0x70, /* ct/reboot.cgi..p */ \
	0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x72,0x65,0x62,0x6f,0x6f,0x74,0x2e,0x68,0x74, /* rotect/reboot.ht */ \
	0x6d,0x00,0x00,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x75,0x73,0x65,0x72,0x2e, /* m..protect/user. */ \
	0x68,0x74,0x6d,0x00,0x00,0x1f,0x8b,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xad, /* htm............. */ \
	0x56,0xc1,0x6e,0xa3,0x30,0x10,0x3d,0x37,0x52,0xfe,0x01,0xa9,0xd7,0x80,0x20,0x84, /* V.n.0.=7R..... . */ \
	0xb4,0xa5,0xa7,0xd5,0xde,0xf7,0xb8,0x77,0x83,0x87,0x60,0xd5,0xc1,0xc8,0x98,0x26, /* .......w..`....& */ \
	0xdd,0x6a,0xff,0x7d,0x6d,0x63,0xb0,0x01,0x27,0xd5,0xae,0xb6,0x48,0x6d,0x31,0x9e, /* .j.}mc..'...Hm1. */ \
	0xf7,0xc6,0x33,0x6f,0x66,0x5c,0x30,0xfc,0x11,0x7c,0x6e,0x37,0x0f,0x15,0x6b,0x44, /* ..3of\0..|n7..kD */ \
	0x58,0xa1,0x33,0xa1,0x1f,0x79,0xf0,0x13,0x38,0x46,0x0d,0xda,0x05,0xdf,0x38,0x41, /* X.3..y..8F....8A */ \
	0x74,0x17,0x74,0xa8,0xe9,0xc2,0x0e,0x38,0xa9,0x5e,0xe5,0xd6,0x02,0x95,0x6f,0x27, /* t.t....8.^....o' */ \
	0xce,0xfa,0x06,0xe7,0xc1,0x63,0x56,0xa8,0x47,0x2d,0x9f,0x11,0x3f,0x91,0x26,0x0f, /* .....cV.G-..?.&. */ \
	0xe2,0xf6,0x1a,0xa0,0x5e,0x30,0xb5,0xd6,0x22,0x8c,0x49,0x73,0x92,0x8b,0xf2,0xd9, /* ....^0..".Is.... */ \
	0xab,0x2f,0xb1,0x5c,0xfe,0xbd,0xdd,0x6c,0x37,0x8f,0x5d,0x8d,0x30,0xbb,0x84,0xac, /* ./.\...l7.].0... */ \
	0x01,0xed,0xc0,0x85,0x60,0x51,0xe7,0xc1,0xd3,0x51,0xee,0xd2,0x2c,0x8c,0x63,0xe0, /* ....`Q...Q..,.c. */ \
	0x79,0x90,0x48,0xa3,0x8e,0x51,0x82,0x25,0x57,0x96,0xd9,0x2f,0xa1,0x60,0x6d,0xae, /* y.H..Q.%W../.`m. */ \
	0xe1,0x7c,0xcc,0xbf,0x2d,0x81,0xb8,0x30,0x4d,0xe0,0x01,0x3c,0x14,0xea,0xf1,0x61  /* .|..-..0M..<...a */
#define DATACHUNK000001 \
	0xba,0xf6,0x35,0x07,0xb8,0x89,0x70,0x38,0x7c,0x61,0x5e,0xb1,0x9e,0xdf,0xb2,0x4e, /* ..5...p8|a^....N */ \
	0x91,0x7a,0x6e,0x00,0x48,0x88,0x16,0x9d,0x6e,0x32,0xa7,0x69,0xba,0x4a,0x46,0x55, /* .zn.H...n2.i.JFU */ \
	0x55,0xde,0x00,0x4d,0x69,0xd8,0x9b,0xe0,0xea,0x6c,0x77,0xe4,0x17,0x48,0xc8,0xb8, /* U..Mi....lw..H.. */ \
	0x15,0x73,0x42,0x81,0xad,0x22,0x3c,0x7b,0x04,0x11,0xd4,0x78,0xe5,0x72,0xc7,0xf2, /* .sB.."<{...x.r.. */ \
	0x67,0xa0,0x9f,0xd8,0x0e,0x0e,0xd9,0x05,0xc8,0xa9,0x16,0x79,0x50,0x30,0x8a,0xd5, /* g..........yP0.. */ \
	0x62,0xc9,0x28,0xe3,0xd6,0xe5,0x21,0x85,0x61,0xc1,0x84,0x60,0x67,0x49,0x98,0x0d, /* b.(...!.a..`gI.. */ \
	0xa6,0xb5,0xb1,0x4a,0x8e,0xfa,0xdd,0x75,0x20,0xe2,0xea,0xd3,0xe0,0x29,0x65,0x48, /* ...J...u ....)eH */ \
	0x6e,0xd2,0x0b,0xaf,0x56,0x4a,0x69,0x6c,0x4e,0x2b,0xe0,0x2a,0x42,0x44,0xc9,0xa9, /* n...VJilN+..BD.. */ \
	0xb1,0x9b,0x06,0xa8,0x33,0x34,0xbd,0x0b,0x41,0xa1,0x72,0x11,0x92,0xcc,0x20,0x98, /* ....34..A.r... . */ \
	0x23,0x85,0x7c,0x70,0xc7,0x84,0xd1,0xc1,0x40,0xae,0x86,0x93,0x83,0x31,0xc3,0xa4, /* #.|p....@....1.. */ \
	0x6b,0x29,0x92,0x05,0x55,0x50,0x56,0xbe,0xad,0xd2,0x65,0x43,0x66,0xa2,0x71,0xa9, /* k)..UPV...eCf.q. */ \
	0x89,0x80,0x59,0x08,0x9f,0xef,0x84,0xd0,0xa4,0x79,0x8a,0x99,0xd5,0x86,0x09,0xaa, /* ..Y......y...... */ \
	0x3e,0x37,0x86,0x92,0x71,0x24,0x08,0x93,0x87,0x6f,0x64,0xb1,0x2d,0xfc,0xce,0x6b, /* >7..q$...od.-..k */ \
	0xf6,0x0e,0x7c,0x9d,0x4e,0xac,0xe5,0x35,0xec,0x2c,0x25,0x3b,0x34,0xc2,0x3d,0x62, /* ..|.N..5.,%;4.=b */ \
	0xb6,0x37,0x19,0x5a,0xc6,0x7e,0x11,0xa9,0xc4,0x8d,0xd4,0x88,0x33,0x04,0x6b,0x54, /* .7.Z.~......3.kT */ \
	0x40,0x19,0xc7,0x5f,0x3b,0x3b,0x99,0x3a,0xfe,0x8e,0x00,0x83,0xab,0x6b,0x00,0x79, /* @.._;;.:.....k.y */ \
	0x10,0xe0,0x94,0x78,0x50,0xea,0x44,0x03,0x18,0xd1,0x0d,0x75,0x62,0xfd,0x8c,0xba, /* ...xP.D....ub... */ \
	0x16,0x95,0x23,0x07,0x05,0xc4,0x55,0xc8,0x45,0x3d,0xa1,0x54,0x8c,0x09,0xf3,0xd9, /* ..#...U.E=.T.... */ \
	0xa9,0x91,0x38,0x7a,0x86,0xb3,0xab,0xec,0xe3,0xf1,0xb8,0x14,0x5f,0x29,0xc9,0x81, /* ..8z........_).. */ \
	0xbb,0x2d,0x4b,0xc5,0x27,0xc8,0x74,0x63,0x0c,0x96,0x62,0xd3,0x7e,0x25,0xb3,0x76, /* .-K.'.tc..b.~%.v */ \
	0x68,0xd6,0xe4,0x76,0x2c,0xb3,0x0e,0x78,0x64,0x31,0x1d,0x55,0x20,0xd1,0x77,0x33, /* h..v,..xd1.U .w3 */ \
	0x25,0x3e,0xdd,0x4f,0x93,0xc5,0x77,0x1d,0x5a,0xb6,0xdf,0x39,0x97,0x57,0x8c,0x33, /* %>.O..w.Z..9.W.3 */ \
	0x07,0x5a,0xed,0xc2,0x44,0x91,0x0d,0xa7,0x93,0xbf,0x13,0xb7,0x20,0x89,0x4c,0x4f, /* .Z..D....... .LO */ \
	0x23,0x11,0xc2,0xa5,0x0b,0x53,0xff,0x8b,0xe0,0x8a,0xce,0x2d,0x85,0x82,0x5d,0x9d, /* #....S.....-..]. */ \
	0x7c,0xe5,0x3a,0x66,0xaa,0xc4,0x82,0xe9,0x3f,0x5f,0xcd,0xf8,0x4e,0x90,0x3a,0x52, /* |.:f....?_..N.:R */ \
	0x19,0x72,0x62,0x53,0xe2,0xc8,0xff,0x11,0xe3,0xe9,0x50,0x51,0xc9,0x30,0xac,0x47, /* .rbS......PQ.0.G */ \
	0xe4,0x77,0xd9,0xd6,0x89,0x54,0xc1,0x0f,0xb8,0xec,0xc6,0x97,0x5d,0x50,0x91,0x2b, /* .w...T......]P.+ */ \
	0xe0,0x50,0x07,0xdf,0xbc,0x38,0x67,0x01,0x5e,0x92,0xce,0xd3,0x39,0x2b,0x78,0x79, /* .P...8g.^...9+xy */ \
	0x5d,0xc4,0xcb,0x69,0x89,0xaa,0x25,0xad,0x64,0x30,0x2c,0xee,0x6d,0xc5,0x43,0x91, /* ]..i..%.d0,.m.C. */ \
	0x5a,0x26,0xce,0x19,0x77,0x05,0x3e,0x87,0x58,0xa5,0x7e,0xee,0x0c,0xc6,0xf7,0x78, /* Z&..w.>.X.~....x */ \
	0x5e,0x62,0x3b,0x9d,0xa6,0x6a,0x3a,0x3a,0x33,0xca,0x51,0x28,0xea,0x6a,0x27,0xe6, /* ^b;..j::3.Q(.j'. */ \
	0x93,0xc0,0xb2,0x85,0x1b,0xf1,0xa2,0xd5,0x3b,0x85,0xe8,0xe4,0xdf,0x0c,0x25,0x27, /* ........;.....%' */ \
	0x73,0x63,0xaf,0x5e,0x76,0x9c,0xcc,0x02,0x54,0x04,0x28,0xee,0x40,0xfc,0x5f,0xf5, /* sc.^v...T.(.@._. */ \
	0xdc,0x10,0xca,0x44,0x86,0xc9,0xfb,0xbc,0x00,0x54,0xfc,0x14,0x97,0xfa,0x3b,0x8e, /* ...D.....T....;. */ \
	0x94,0xb5,0x09,0x45,0x05,0xd0,0x75,0xda,0xc2,0xe4,0xe0,0xeb,0x0b,0xfb,0x61,0x6d, /* ...E..u.......am */ \
	0xac,0xf3,0x63,0x7c,0x67,0x50,0xb4,0xac,0x23,0x43,0x4b,0x44,0x85,0xcc,0x63,0x2f, /* ..c|gP..#CKD..c/ */ \
	0x60,0xe5,0x00,0x69,0xda,0x5e,0xac,0xc9,0xc7,0x96,0x34,0xd2,0xec,0x7d,0xce,0x6b, /* `..i.^....4..}.k */ \
	0xdb,0xa8,0x3b,0xbb,0x8d,0xc7,0x5e,0xc3,0x56,0x1b,0x11,0x4e,0x3c,0x3b,0x6f,0x0f, /* ..;...^.V..N<;o. */ \
	0xe9,0xc9,0xbc,0xe8,0xe5,0xa0,0x6b,0x94,0x7d,0xf1,0x6f,0x00,0x6a,0x07,0xe2,0x30, /* ......k.}.o.j..0 */ \
	0x9b,0xd5,0x7b,0x6f,0x3e,0x46,0x4f,0x53,0x1f,0x91,0x73,0xdd,0xbc,0xcb,0x1b,0x71, /* ..{o>FOS..s....q */ \
	0xe8,0x7a,0x2a,0xb6,0x9b,0xcf,0xed,0xa2,0xe1,0xff,0x9d,0xfc,0xe6,0x17,0x3e,0xff, /* .z............>. */ \
	0x3c,0xf1,0x5f,0x10,0xdc,0xc2,0x06,0x98,0xb2,0xfe,0x10,0xb1,0x37,0x7d,0xb0,0xb1, /* <._.........7}.. */ \
	0x66,0xa7,0x91,0x55,0xe8,0x06,0xbf,0x30,0xac,0xf4,0x95,0x44,0x5a,0x3e,0x28,0xd3, /* f..U...0...DZ>(. */ \
	0x0a,0x11,0xea,0x35,0x2e,0x8e,0x1e,0xe3,0x0a,0x66,0xc6,0x7d,0xe3,0x27,0x2e,0x4b, /* ...5.....f.}.'.K */ \
	0x9f,0x6d,0x85,0x8d,0xed,0x1f,0xa8,0x06,0xc4,0x04,0xa6,0x0c,0x00,0x00,0x1f,0x8b, /* .m.............. */ \
	0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xd5,0x57,0x5d,0x6f,0xdb,0x36,0x14,0x7d, /* .........W]o.6.} */ \
	0x56,0x80,0xfc,0x87,0x3b,0x3f,0x2c,0x32,0xe0,0x38,0x4e,0xb1,0xee,0xa1,0x81,0x3b, /* V...;?,2.8N....; */ \
	0xa4,0x49,0xb1,0x66,0x48,0x97,0x20,0x71,0x87,0x02,0xdb,0x1e,0x68,0x89,0x8e,0xd9, /* .I.fH. q....h... */ \
	0xc8,0xa2,0x4a,0x52,0x76,0x8d,0x22,0x3f,0x68,0xff,0x72,0xe7,0x92,0x94,0x2c,0xbb, /* ..JRv."?h.r...,. */ \
	0x69,0x51,0xac,0x7d,0x59,0x02,0x58,0x1f,0xbc,0xf7,0xf0,0xf2,0xdc,0x4f,0x1d,0x1d, /* iQ.}Y.X......O.. */ \
	0xd1,0x99,0xae,0xd6,0x46,0xdd,0xcd,0x1d,0xfd,0x43,0x4f,0x46,0xa3,0x27,0x87,0x4f, /* ....F....COF.'.O */ \
	0x46,0xc7,0x23,0x7a,0xad,0x32,0xa3,0xb3,0xb9,0xaa,0x68,0x22,0xb3,0x79,0xa9,0x0b, /* F.#z.2....h".y.. */ \
	0x7d,0xb7,0xa6,0x8b,0x32,0x1b,0x12,0x9d,0x16,0x05,0x79,0x05,0x4b,0x46,0x5a,0x69, /* }...2.....y.KFZi */ \
	0x96,0x32,0x1f,0xee,0xef,0x1d,0x1d,0xd1,0xad,0x94,0x5d,0xbd,0xb3,0xeb,0xa3,0x8b, /* .2........]..... */ \
	0x6b,0xba,0x75,0x22,0xbb,0xa7,0x5c,0x67,0xf5,0x42,0x96,0x4e,0x38,0xa5,0x4b,0x9a, /* k.u"..\g.B.N8.K. */ \
	0x69,0x43,0x85,0xca,0x64,0x69,0x25,0xa9,0x12,0x4f,0x0b,0xff,0x1e,0x28,0xfc,0x0f, /* iC..di%..O...(.. */ \
	0xa4,0x73,0xe9,0xa4,0x59,0xa8,0x52,0x5a,0x5a,0xcd,0x65,0x49,0x02,0x3b,0xbd,0xaf, /* .s..Y.RZZ.eI.;.. */ \
	0xa5,0x75,0xa4,0x2c,0x65,0xba,0xb4,0x2a,0x97,0x46,0xe6,0xd4,0x73,0x6a,0x81,0x8b, /* .u.,e....F..sj.. */ \
	0xae,0x5d,0x6f,0x7f,0x6f,0x29,0x0c,0xf1,0xf3,0x55,0xed,0x5e,0xdf,0xd2,0x98,0x9e, /* .]o.o)...U.^.... */ \
	0x8e,0x46,0xa3,0x13,0x3a,0x3a,0x5a,0xd8,0xfd,0x3d,0x0a,0x06,0x3a,0x0d,0x8b,0x81, /* .F..::Z..=..:... */ \
	0x06,0xac,0x5a,0x92,0x9e,0xd1,0xe9,0x6f,0xa7,0x6f,0x49,0x2e,0x61,0x99,0x25,0xa7, /* ..Z....o.oI.a.%. */ \
	0xa9,0x82,0xed,0xd2,0xda,0x80,0x25,0xde,0x89,0x0f,0x97,0x0a,0x7b,0x8e,0xa9,0x94, /* ......%.....{... */ \
	0x2b,0x3a,0x35,0x46,0xac,0xd3,0xfe,0x49,0x34,0xf1,0xa2,0x54,0x4e,0x09,0xe7,0xe1, /* +:5F...I4..TN... */ \
	0xfc,0x32,0x23,0x65,0x7a,0xb1,0x10,0x65,0xce,0x02,0x49,0x6d,0x8a,0x67,0xe4,0xe6  /* .2#ez..e..Im.g.. */
#define DATACHUNK000002 \
	0x92,0x70,0xc3,0xd8,0x22,0x0b,0xd0,0x58,0xc2,0x09,0x9c,0xc0,0xe9,0x4c,0x10,0x68, /* .p.."..X.....L.h */ \
	0xc8,0xa1,0x8b,0x73,0x16,0x9c,0xa9,0xa2,0x18,0x10,0x28,0x12,0x34,0xab,0xcb,0xcc, /* ...s......(.4... */ \
	0x33,0x86,0xd7,0x99,0x00,0xef,0x2b,0xe5,0xe6,0xcc,0x7a,0xa5,0x99,0xbb,0xb7,0xaf, /* 3.....+...z..... */ \
	0x2f,0x29,0xd5,0x15,0x4b,0x88,0xa2,0xef,0xa1,0x8d,0xac,0xa4,0x70,0xc0,0x35,0x38, /* /)..K.......p.58 */ \
	0x20,0xb4,0xc2,0x33,0xb6,0x61,0xe2,0x18,0x41,0x95,0xb9,0x9c,0x29,0x18,0x2f,0x8b, /*  ..3.a..A...)./. */ \
	0xf5,0xae,0x72,0x2e,0x9c,0x78,0x46,0xa2,0xa4,0x37,0x37,0x97,0x24,0xcb,0x4c,0xe7, /* ..r..xF..77.$.L. */ \
	0x20,0xd7,0x3a,0xa3,0xca,0x3b,0xc6,0x9a,0x4a,0xb2,0xf5,0x74,0xa1,0x9c,0xc3,0x6b, /*  .:..;..J..t...k */ \
	0x61,0xe9,0xfa,0xea,0x76,0x42,0xac,0xb3,0x85,0xd3,0xda,0x0c,0x56,0x98,0x94,0xb3, /* a...vB......V... */ \
	0xc0,0x49,0x0a,0x1a,0x06,0xd4,0x9e,0x7c,0x10,0x2d,0x1b,0x78,0x00,0xa8,0x7d,0xdc, /* .I.....|.-.x..}. */ \
	0xdf,0x4b,0x7c,0x0c,0x39,0xaa,0x2b,0x78,0xd4,0x90,0x9e,0xbe,0x93,0x99,0xc3,0x6b, /* .K|.9.+x.......k */ \
	0x76,0x06,0x83,0xc1,0x1f,0xd1,0x17,0x57,0x7e,0xc9,0x3b,0xc3,0xaf,0x82,0xc5,0x09, /* v......W~.;..... */ \
	0x3c,0x6f,0xe2,0xf2,0x39,0xfc,0x12,0x16,0xa3,0xda,0x90,0x7d,0x30,0x66,0x4f,0x74, /* <o..9......}0fOt */ \
	0x5f,0xb6,0xc6,0x60,0xa9,0xbd,0xef,0x0a,0x44,0xf2,0xc6,0xd1,0xd6,0xee,0x12,0x07, /* _..`....D....... */ \
	0xc7,0x8d,0x7c,0xcf,0x1b,0xd6,0x85,0x47,0x0d,0xf6,0x9f,0x19,0x08,0x4a,0x70,0x08, /* ..|....G.....Jp. */ \
	0xe2,0x24,0x7e,0xd8,0xbf,0x31,0x76,0x21,0xa0,0x66,0xe9,0x0a,0x0e,0xd0,0xab,0x21, /* .$~..1v!.f.....! */ \
	0x5c,0xf7,0xca,0xb9,0xea,0x26,0x2c,0xf5,0x09,0xc7,0xa7,0xf8,0xf7,0xc8,0x16,0x38, /* \....&,........8 */ \
	0xd3,0xb6,0x82,0x3f,0xdd,0x67,0x14,0x86,0xba,0x92,0x65,0x9a,0x32,0xaf,0xe3,0x31, /* ...?.g....e.2..1 */ \
	0x5b,0xd7,0xff,0xa5,0xf7,0xeb,0xcb,0x49,0xef,0x59,0x8f,0x1d,0xd6,0x1b,0x50,0x87, /* [......I.Y....P. */ \
	0x94,0x81,0x0f,0x94,0x2f,0x81,0xf1,0x29,0x3c,0x56,0x23,0xc4,0xb1,0x3f,0xa3,0x95, /* ..../..)<V#..?.. */ \
	0x3c,0x30,0x08,0x6d,0xcb,0xa1,0x71,0xf1,0xf2,0x67,0x44,0xc9,0xba,0x90,0x94,0x2e, /* <0.m..q..gD..... */ \
	0xc4,0x1a,0x51,0xf2,0x74,0xf8,0x94,0x53,0xa1,0x42,0x56,0x4f,0x0b,0x0e,0x43,0xdd, /* ..Q.t..S.BVO..C. */ \
	0x0f,0xba,0x0f,0x24,0x0b,0xce,0xf9,0x96,0x86,0x53,0x84,0xca,0x52,0xbe,0x0d,0xfe, /* ...$.....S..R... */ \
	0xfc,0x0a,0x16,0xb6,0xe4,0xd3,0x9e,0xaf,0x36,0x56,0xcf,0x9c,0xe7,0x73,0x32,0xb9, /* ........6V...s2. */ \
	0xee,0x75,0x8f,0x82,0x6d,0x76,0x50,0xb6,0x76,0xf8,0xee,0xd4,0x7d,0x15,0x7d,0x9e, /* .u..mvP.v...}.}. */ \
	0x86,0xc8,0x46,0xb8,0x84,0xdf,0x46,0xb1,0x10,0xd6,0x9d,0x21,0x51,0x91,0x62,0xe3, /* ..F...F....!Q.b. */ \
	0x36,0xae,0x87,0x77,0xd2,0xf1,0x4d,0xeb,0xf6,0xd6,0x15,0xbe,0xa4,0x21,0xa9,0x7d, /* 6..w..M......!.} */ \
	0xc6,0x08,0x2e,0x51,0x61,0xa9,0x29,0x5e,0xc3,0xaa,0xb6,0xf3,0x86,0x06,0xd6,0x7e, /* ...Qa.)^.......~ */ \
	0x88,0xf5,0xeb,0x52,0xeb,0xca,0x92,0x5e,0x22,0xfa,0xb9,0x2c,0xe0,0xdc,0x39,0xfb, /* ...R...^"..,..9. */ \
	0x72,0xa7,0x20,0xe6,0x4d,0x21,0x06,0x99,0x08,0xea,0x35,0xaa,0x98,0xcf,0x6d,0x65, /* r. .M!....5...me */ \
	0x7d,0x54,0x2b,0x14,0xe1,0x4e,0xc6,0x57,0xba,0x28,0x18,0x20,0x05,0xcf,0x49,0x4c, /* }T+..N.W.(. ..IL */ \
	0xcd,0xac,0x36,0xff,0x25,0x71,0x79,0x51,0x16,0xa2,0xb2,0x32,0xdf,0x24,0xd7,0x8d, /* ..6.%qyQ...2.$.. */ \
	0x14,0x28,0xf6,0xb3,0x99,0xcf,0xaa,0xb6,0x3c,0x87,0x3a,0x81,0xb3,0xc0,0xca,0xe9, /* .(......<.:..... */ \
	0x9a,0x2f,0x90,0x46,0x53,0x49,0x15,0x50,0x5b,0x1e,0x0a,0x59,0xde,0xb9,0xf9,0x09, /* ./.FSI.P[..Y.... */ \
	0x29,0x7a,0x4e,0x68,0x0b,0xea,0xf0,0x10,0x31,0x99,0x70,0xd5,0x49,0x36,0x26,0xb6, /* )zNh....1.p.I6&. */ \
	0xd2,0x76,0xae,0x66,0xd1,0x4c,0x4e,0xda,0x1f,0xa2,0x08,0xab,0x24,0xbe,0x7c,0xab, /* .v.f.LN.....$.|. */ \
	0xb2,0x96,0x7e,0x35,0x1a,0xf9,0xa8,0xb3,0xe8,0xb0,0x39,0x7e,0xc7,0xad,0x5e,0x2b, /* ..~5......9~..^+ */ \
	0xe1,0x13,0x25,0x4d,0x2a,0xa1,0xac,0x66,0x52,0xe6,0xcc,0xa5,0xdf,0xae,0x51,0x6a, /* ..%M...fR.....Qj */ \
	0x82,0x08,0x35,0x25,0x5f,0xa3,0x91,0xa2,0xb0,0x8c,0xc7,0xf4,0x13,0xfd,0xf8,0x23, /* ..5%_..........# */ \
	0xed,0x8a,0x58,0xac,0xd6,0x96,0x97,0xd1,0xc3,0x7d,0x98,0x27,0x0d,0xbe,0x72,0x34, /* ..X......}.'..r4 */ \
	0x17,0xdc,0xa6,0x3a,0xc5,0x77,0x65,0xd0,0x00,0x62,0x71,0xb2,0x75,0xe1,0xbc,0x38, /* ...:.we..bq.u..8 */ \
	0x76,0x76,0xeb,0x4a,0xea,0x8d,0x01,0xad,0x46,0x9f,0x91,0x0f,0x1a,0x47,0x1f,0xf4, /* vv.J....F....G.. */ \
	0x03,0x7e,0xf2,0x89,0xdc,0x23,0xa6,0x87,0x5e,0x85,0xfc,0x1c,0x36,0x7d,0xee,0x65, /* .~...#..^...6}.e */ \
	0x21,0xf9,0x12,0xd8,0x4d,0x36,0x35,0xe1,0xcb,0x9b,0x87,0x3e,0x74,0xd0,0x9c,0x2d, /* !...M65....>t..- */ \
	0x69,0xd0,0x98,0xee,0x88,0xf8,0x62,0x7d,0x91,0x3f,0xa2,0x3e,0x54,0x25,0x2e,0xaf, /* i.....b}.?.>T%.. */ \
	0x26,0xe8,0x96,0xe3,0x4f,0x88,0x6b,0x0c,0x9c,0xc8,0x0f,0xae,0x31,0x08,0xbc,0xa5, /* &...O.k.....1... */ \
	0x1a,0xe4,0x98,0x95,0xb2,0xdc,0x9e,0xa9,0xc4,0x13,0x67,0x07,0x0f,0x2e,0x5c,0x16, /* ..........g...\. */ \
	0x68,0x29,0x0a,0x94,0xe1,0x10,0x0e,0xf8,0xe1,0x8c,0x4b,0x76,0x91,0xc5,0x54,0x9b, /* h)........Kv..T. */ \
	0x18,0x43,0x8f,0xad,0x6f,0x5a,0xc7,0x96,0xaf,0x0e,0xac,0x9f,0x76,0xb8,0xdf,0x08, /* .C..oZ......v... */ \
	0x2e,0x9e,0xb1,0x79,0x0c,0xd8,0x59,0x25,0xdb,0x62,0x75,0xe3,0xac,0x06,0x30,0x48, /* ...y..Y%.bu...0H */ \
	0x07,0x63,0x92,0x9d,0xae,0xdb,0xc8,0x84,0xee,0xbb,0x4b,0xcd,0xe6,0x55,0xc4,0x38, /* .c........K..U.8 */ \
	0xf9,0x34,0xc0,0x1f,0xf8,0xa7,0x1b,0xad,0x07,0x4b,0x49,0x2b,0xa1,0x78,0x08,0xf0, /* .4.......KI+.x.. */ \
	0xe5,0xe3,0x18,0x9d,0x0e,0x1a,0x79,0x34,0x11,0xe1,0xdc,0x4e,0x65,0x31,0x9e,0x9b, /* ......y4...Ne1.. */ \
	0x1c,0x79,0xbe,0x99,0xcf,0xba,0x21,0x5a,0x2e,0xf5,0x7d,0x08,0xc6,0x1a,0xe3,0xe4, /* .y....!Z..}..... */ \
	0x66,0xe8,0xf1,0xc3,0x8e,0xa7,0x5b,0x95,0x55,0xfd,0xfd,0x62,0xd4,0x17,0xf6,0xad, /* f.....[.U..b.... */ \
	0xe0,0x8b,0xa2,0x30,0xe6,0xb4,0x90,0xc6,0xb5,0xb6,0x84,0xd7,0x82,0xdf,0xa5,0xbd, /* ...0............ */ \
	0x48,0x29,0xcd,0x84,0x42,0x1a,0x0f,0xff,0x2a,0xcf,0x34,0xe2,0xaa,0x9d,0xcf,0x72, /* H)..B.....4....r */ \
	0x54,0xcd,0x42,0x57,0x7e,0x90,0x9b,0x6a,0x61,0x72,0x90,0x64,0xa9,0xd0,0xa8,0x26, /* T.BW~..jar.d...& */ \
	0xbd,0x66,0x37,0xef,0xeb,0x6f,0x0b,0x96,0x58,0x3a,0xfe,0x1f,0xf1,0x72,0xd5,0x24, /* .f7..o..X:...r.$ */ \
	0xd1,0x80,0xde,0xd5,0x28,0xd5,0xf7,0x52,0x56,0x3e,0x76,0x90,0x4c,0x2c,0xb2,0xdd, /* ....(..RV>v.L,.. */ \
	0xa5,0x9a,0x22,0xcb,0x30,0x0f,0x9b,0x89,0x8a,0xdb,0x13,0xba,0x9b,0x95,0xc5,0x92, /* ..".0........... */ \
	0xa7,0xed,0x3b,0x58,0xc2,0x0d,0xef,0x78,0xc4,0x83,0x7d,0x62,0x43,0xb1,0x45,0xb0, /* ..;X...x..}bC.E. */ \
	0xa5,0xbd,0x4d,0xff,0xe9,0x0d,0x8e,0x47,0xfd,0xd0,0x38,0x1e,0x22,0x67,0x80,0xba, /* ..M....G..8."g.. */ \
	0x16,0x40,0xb1,0xde,0xbb,0x1f,0x16,0xc5,0x4d,0x33,0x46,0x1b,0xe9,0x6a,0x53,0x22, /* .@......M3F..jS" */ \
	0x3e,0xd1,0x3d,0x30,0xfc,0xc6,0x51,0x22,0x4e,0x5a,0xed,0x18,0x8a,0xf9,0x18,0x4a  /* >.=0..Q"NZ.....J */
#define DATACHUNK000003 \
	0xe7,0x7e,0x44,0x8e,0x08,0xfc,0xd0,0x6a,0xfb,0x1d,0x30,0xbc,0xcb,0x22,0x0f,0x02, /* .~D....j..0..".. */ \
	0xfe,0x96,0x23,0xc3,0x4a,0x61,0xb2,0x39,0x17,0x8f,0x4e,0xaf,0x44,0xd5,0xc2,0x46, /* ..#.Ja.9..N.D..F */ \
	0x7f,0x70,0x1d,0x49,0x23,0xd4,0x20,0xa8,0x84,0xd4,0x70,0x66,0x1d,0xc2,0x12,0x8e, /* .p.I#. ...pf.... */ \
	0x8b,0xeb,0x9d,0x4a,0x67,0x5f,0xac,0x27,0xe2,0xee,0x77,0x81,0x2e,0x13,0x74,0xfe, /* ...Jg_.'..w...t. */ \
	0x1c,0xfd,0x3d,0x9c,0x29,0x83,0x26,0x33,0x57,0x45,0x3e,0x2c,0x31,0xba,0x7b,0xec, /* ..=.).&3WE>,1.{. */ \
	0xe0,0xe5,0x60,0x23,0x7d,0x03,0x4e,0xec,0x75,0x56,0x76,0xf1,0x9a,0x90,0x7c,0xc0, /* ..`#}.N.uVv...|. */ \
	0xa7,0x85,0xcb,0xe6,0xa9,0x34,0x48,0xc2,0x8f,0xd4,0x5d,0xe5,0x21,0x27,0x8e,0x1c, /* .....4H...].!'.. */ \
	0xf7,0x0a,0x1f,0x82,0x4d,0xf7,0xf6,0x73,0xc6,0x9b,0x0a,0x93,0x11,0x67,0xd9,0xe7, /* ....M..s.....g.. */ \
	0x9c,0x88,0x4f,0xb8,0xf0,0xc1,0xf5,0x2f,0xde,0xe8,0x9b,0x2d,0xa8,0x0e,0x00,0x00, /* ..O..../...-.... */ \
	0x3c,0x64,0x69,0x76,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x73,0x70,0x61,0x63, /* <div class="spac */ \
	0x65,0x72,0x22,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x64,0x69,0x76,0x3e, /* er">&nbsp;</div> */ \
	0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x66,0x6f,0x6f,0x74,0x65, /* ..<div id="foote */ \
	0x72,0x22,0x3e,0x43,0x6f,0x70,0x79,0x72,0x69,0x67,0x68,0x74,0x20,0x26,0x63,0x6f, /* r">Copyright &co */ \
	0x70,0x79,0x3b,0x20,0x32,0x30,0x31,0x31,0x20,0x53,0x61,0x74,0x6f,0x73,0x68,0x69, /* py; 2011 Satoshi */ \
	0x20,0x59,0x61,0x73,0x75,0x64,0x61,0x20,0x37,0x6d,0x33,0x74,0x6a,0x7a,0x2f,0x61, /*  Yasuda 7m3tjz/a */ \
	0x64,0x36,0x67,0x7a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f, /* d6gz</div>....</ */ \
	0x64,0x69,0x76,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e, /* div></div></div> */ \
	0x3c,0x2f,0x64,0x69,0x76,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a, /* </div></div>.... */ \
	0x3c,0x2f,0x62,0x6f,0x64,0x79,0x3e,0x0d,0x0a,0x3c,0x2f,0x68,0x74,0x6d,0x6c,0x3e, /* </body>..</html> */ \
	0x3c,0x21,0x44,0x4f,0x43,0x54,0x59,0x50,0x45,0x20,0x68,0x74,0x6d,0x6c,0x20,0x50, /* <!DOCTYPE html P */ \
	0x55,0x42,0x4c,0x49,0x43,0x20,0x22,0x2d,0x2f,0x2f,0x57,0x33,0x43,0x2f,0x2f,0x44, /* UBLIC "-//W3C//D */ \
	0x54,0x44,0x20,0x58,0x48,0x54,0x4d,0x4c,0x20,0x31,0x2e,0x30,0x20,0x53,0x74,0x72, /* TD XHTML 1.0 Str */ \
	0x69,0x63,0x74,0x2f,0x2f,0x45,0x4e,0x22,0x0d,0x0a,0x20,0x20,0x22,0x68,0x74,0x74, /* ict//EN"..  "htt */ \
	0x70,0x3a,0x2f,0x2f,0x77,0x77,0x77,0x2e,0x77,0x33,0x2e,0x6f,0x72,0x67,0x2f,0x54, /* p://www.w3.org/T */ \
	0x52,0x2f,0x78,0x68,0x74,0x6d,0x6c,0x31,0x2f,0x44,0x54,0x44,0x2f,0x78,0x68,0x74, /* R/xhtml1/DTD/xht */ \
	0x6d,0x6c,0x31,0x2d,0x73,0x74,0x72,0x69,0x63,0x74,0x2e,0x64,0x74,0x64,0x22,0x3e, /* ml1-strict.dtd"> */ \
	0x0d,0x0a,0x3c,0x68,0x74,0x6d,0x6c,0x20,0x78,0x6d,0x6c,0x6e,0x73,0x3d,0x22,0x68, /* ..<html xmlns="h */ \
	0x74,0x74,0x70,0x3a,0x2f,0x2f,0x77,0x77,0x77,0x2e,0x77,0x33,0x2e,0x6f,0x72,0x67, /* ttp://www.w3.org */ \
	0x2f,0x31,0x39,0x39,0x39,0x2f,0x78,0x68,0x74,0x6d,0x6c,0x22,0x20,0x78,0x6d,0x6c, /* /1999/xhtml" xml */ \
	0x3a,0x6c,0x61,0x6e,0x67,0x3d,0x22,0x65,0x6e,0x22,0x20,0x6c,0x61,0x6e,0x67,0x3d, /* :lang="en" lang= */ \
	0x22,0x65,0x6e,0x22,0x3e,0x0d,0x0a,0x3c,0x68,0x65,0x61,0x64,0x3e,0x0d,0x0a,0x3c, /* "en">..<head>..< */ \
	0x74,0x69,0x74,0x6c,0x65,0x3e,0x44,0x2d,0x53,0x54,0x41,0x52,0x20,0x64,0x53,0x71, /* title>D-STAR dSq */ \
	0x75,0x72,0x65,0x20,0x43,0x6c,0x69,0x65,0x6e,0x74,0x20,0x50,0x72,0x6f,0x67,0x72, /* ure Client Progr */ \
	0x61,0x6d,0x3c,0x2f,0x74,0x69,0x74,0x6c,0x65,0x3e,0x0d,0x0a,0x3c,0x6c,0x69,0x6e, /* am</title>..<lin */ \
	0x6b,0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x37,0x6d,0x33,0x74,0x6a,0x7a,0x2e, /* k href="/7m3tjz. */ \
	0x63,0x73,0x73,0x22,0x20,0x72,0x65,0x6c,0x3d,0x22,0x73,0x74,0x79,0x6c,0x65,0x73, /* css" rel="styles */ \
	0x68,0x65,0x65,0x74,0x22,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74, /* heet" type="text */ \
	0x2f,0x63,0x73,0x73,0x22,0x20,0x2f,0x3e,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70, /* /css" />..<scrip */ \
	0x74,0x20,0x73,0x72,0x63,0x3d,0x22,0x2f,0x37,0x6d,0x33,0x74,0x6a,0x7a,0x2e,0x6a, /* t src="/7m3tjz.j */ \
	0x73,0x22,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x2f,0x6a,0x61, /* s" type="text/ja */ \
	0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x3c,0x2f,0x73,0x63,0x72,0x69, /* vascript"></scri */ \
	0x70,0x74,0x3e,0x0d,0x0a,0x3c,0x2f,0x68,0x65,0x61,0x64,0x3e,0x0d,0x0a,0x0d,0x0a, /* pt>..</head>.... */ \
	0x3c,0x62,0x6f,0x64,0x79,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d, /* <body>..<div id= */ \
	0x22,0x73,0x68,0x61,0x64,0x6f,0x77,0x2d,0x6f,0x6e,0x65,0x22,0x3e,0x3c,0x64,0x69, /* "shadow-one"><di */ \
	0x76,0x20,0x69,0x64,0x3d,0x22,0x73,0x68,0x61,0x64,0x6f,0x77,0x2d,0x74,0x77,0x6f, /* v id="shadow-two */ \
	0x22,0x3e,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x73,0x68,0x61,0x64,0x6f, /* "><div id="shado */ \
	0x77,0x2d,0x74,0x68,0x72,0x65,0x65,0x22,0x3e,0x3c,0x64,0x69,0x76,0x20,0x69,0x64, /* w-three"><div id */ \
	0x3d,0x22,0x73,0x68,0x61,0x64,0x6f,0x77,0x2d,0x66,0x6f,0x75,0x72,0x22,0x3e,0x0d, /* ="shadow-four">. */ \
	0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x70,0x61,0x67,0x65,0x22,0x3e, /* .<div id="page"> */ \
	0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x74,0x69,0x74, /* ....<div id="tit */ \
	0x6c,0x65,0x22,0x3e,0x3c,0x64,0x69,0x76,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22, /* le"><div class=" */ \
	0x72,0x69,0x67,0x68,0x74,0x22,0x3e,0x44,0x2d,0x53,0x54,0x41,0x52,0x20,0x64,0x53, /* right">D-STAR dS */ \
	0x71,0x75,0x72,0x65,0x20,0x43,0x6c,0x69,0x65,0x6e,0x74,0x3c,0x2f,0x64,0x69,0x76, /* qure Client</div */ \
	0x3e,0x3c,0x73,0x70,0x61,0x6e,0x20,0x69,0x64,0x3d,0x22,0x68,0x65,0x6c,0x6c,0x6f, /* ><span id="hello */ \
	0x22,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x73,0x70,0x61,0x6e,0x3e,0x3c, /* ">&nbsp;</span>< */ \
	0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64, /* /div>....<div id */ \
	0x3d,0x22,0x6d,0x65,0x6e,0x75,0x22,0x3e,0x0d,0x0a,0x3c,0x61,0x20,0x68,0x72,0x65, /* ="menu">..<a hre */ \
	0x66,0x3d,0x22,0x2f,0x69,0x6e,0x64,0x65,0x78,0x2e,0x68,0x74,0x6d,0x22,0x3e,0x4f, /* f="/index.htm">O */ \
	0x76,0x65,0x72,0x76,0x69,0x65,0x77,0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x3c,0x61,0x20, /* verview</a>..<a  */ \
	0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x63, /* href="/protect/c */ \
	0x6f,0x6e,0x66,0x69,0x67,0x2e,0x68,0x74,0x6d,0x22,0x3e,0x4e,0x65,0x74,0x77,0x6f, /* onfig.htm">Netwo */ \
	0x72,0x6b,0x20,0x43,0x6f,0x6e,0x66,0x69,0x67,0x75,0x72,0x61,0x74,0x69,0x6f,0x6e, /* rk Configuration */ \
	0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x3c,0x61,0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x2f, /* </a>..<a href="/ */ \
	0x6e,0x6f,0x64,0x65,0x61,0x64,0x61,0x70,0x74,0x65,0x72,0x2f,0x63,0x6f,0x6e,0x66  /* nodeadapter/conf */
#define DATACHUNK000004 \
	0x69,0x67,0x2e,0x68,0x74,0x6d,0x22,0x3e,0x4e,0x6f,0x64,0x65,0x20,0x41,0x64,0x61, /* ig.htm">Node Ada */ \
	0x70,0x74,0x65,0x72,0x20,0x43,0x6f,0x6e,0x66,0x69,0x67,0x75,0x72,0x61,0x74,0x69, /* pter Configurati */ \
	0x6f,0x6e,0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x3c,0x61,0x20,0x68,0x72,0x65,0x66,0x3d, /* on</a>..<a href= */ \
	0x22,0x2f,0x6e,0x6f,0x64,0x65,0x61,0x64,0x61,0x70,0x74,0x65,0x72,0x2f,0x63,0x6f, /* "/nodeadapter/co */ \
	0x6e,0x66,0x69,0x67,0x32,0x2e,0x68,0x74,0x6d,0x22,0x3e,0x42,0x65,0x61,0x63,0x6f, /* nfig2.htm">Beaco */ \
	0x6e,0x20,0x43,0x6f,0x6e,0x66,0x69,0x67,0x75,0x72,0x61,0x74,0x69,0x6f,0x6e,0x3c, /* n Configuration< */ \
	0x2f,0x61,0x3e,0x0d,0x0a,0x3c,0x61,0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x6e, /* /a>..<a href="/n */ \
	0x6f,0x64,0x65,0x61,0x64,0x61,0x70,0x74,0x65,0x72,0x2f,0x63,0x6f,0x6e,0x66,0x69, /* odeadapter/confi */ \
	0x67,0x33,0x2e,0x68,0x74,0x6d,0x22,0x3e,0x54,0x58,0x20,0x48,0x65,0x61,0x64,0x65, /* g3.htm">TX Heade */ \
	0x72,0x20,0x52,0x65,0x70,0x6c,0x61,0x63,0x65,0x20,0x43,0x6f,0x6e,0x66,0x69,0x67, /* r Replace Config */ \
	0x75,0x72,0x61,0x74,0x69,0x6f,0x6e,0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x3c,0x61,0x20, /* uration</a>..<a  */ \
	0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x75, /* href="/protect/u */ \
	0x73,0x65,0x72,0x2e,0x68,0x74,0x6d,0x22,0x3e,0x55,0x73,0x65,0x72,0x20,0x49,0x44, /* ser.htm">User ID */ \
	0x20,0x26,0x20,0x50,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x20,0x73,0x65,0x74,0x74, /*  & Password sett */ \
	0x69,0x6e,0x67,0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x3c,0x61,0x20,0x68,0x72,0x65,0x66, /* ing</a>..<a href */ \
	0x3d,0x22,0x2f,0x73,0x74,0x61,0x74,0x75,0x73,0x2e,0x68,0x74,0x6d,0x22,0x3e,0x43, /* ="/status.htm">C */ \
	0x75,0x72,0x72,0x65,0x6e,0x74,0x20,0x53,0x74,0x61,0x74,0x75,0x73,0x3c,0x2f,0x61, /* urrent Status</a */ \
	0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65, /* >..</div>~inc:he */ \
	0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20, /* ader.inc~..<div  */ \
	0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d, /* id="content">... */ \
	0x0a,0x3c,0x68,0x31,0x3e,0x44,0x2d,0x53,0x54,0x41,0x52,0x20,0x64,0x53,0x71,0x75, /* .<h1>D-STAR dSqu */ \
	0x72,0x65,0x20,0x43,0x6c,0x69,0x65,0x6e,0x74,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a, /* re Client</h1>.. */ \
	0x0d,0x0a,0x3c,0x74,0x61,0x62,0x6c,0x65,0x20,0x73,0x74,0x79,0x6c,0x65,0x3d,0x22, /* ..<table style=" */ \
	0x70,0x61,0x64,0x64,0x69,0x6e,0x67,0x2d,0x6c,0x65,0x66,0x74,0x3a,0x20,0x31,0x30, /* padding-left: 10 */ \
	0x70,0x78,0x3b,0x22,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c, /* px;">..<tr><td>< */ \
	0x62,0x3e,0x64,0x53,0x71,0x75,0x72,0x65,0x20,0x53,0x65,0x72,0x76,0x65,0x72,0x20, /* b>dSqure Server  */ \
	0x44,0x6f,0x6d,0x61,0x69,0x6e,0x20,0x4e,0x61,0x6d,0x65,0x20,0x3a,0x3c,0x2f,0x62, /* Domain Name :</b */ \
	0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b, /* ></td><td>&nbsp; */ \
	0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x73,0x65,0x72,0x76,0x65,0x72, /* </td><td>~server */ \
	0x5f,0x6e,0x61,0x6d,0x65,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e, /* _name~</td></tr> */ \
	0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x4f,0x75,0x74, /* ..<tr><td><b>Out */ \
	0x20,0x62,0x6f,0x75,0x6e,0x64,0x20,0x50,0x6f,0x72,0x74,0x20,0x3a,0x3c,0x2f,0x62, /*  bound Port :</b */ \
	0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b, /* ></td><td>&nbsp; */ \
	0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x6f,0x75,0x74,0x5f,0x70,0x6f, /* </td><td>~out_po */ \
	0x72,0x74,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c, /* rt~</td></tr>..< */ \
	0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x49,0x6e,0x20,0x62,0x6f,0x75, /* tr><td><b>In bou */ \
	0x6e,0x64,0x20,0x50,0x6f,0x72,0x74,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74, /* nd Port :</b></t */ \
	0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64, /* d><td>&nbsp;</td */ \
	0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x69,0x6e,0x5f,0x70,0x6f,0x72,0x74,0x7e,0x3c,0x2f, /* ><td>~in_port~</ */ \
	0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74, /* td></tr>..<tr><t */ \
	0x64,0x3e,0x3c,0x62,0x3e,0x43,0x6f,0x6e,0x66,0x65,0x72,0x65,0x6e,0x63,0x65,0x20, /* d><b>Conference  */ \
	0x52,0x6f,0x6f,0x6d,0x20,0x4e,0x61,0x6d,0x65,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c, /* Room Name :</b>< */ \
	0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f, /* /td><td>&nbsp;</ */ \
	0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x52,0x6f,0x6f,0x6d,0x4e,0x61,0x6d,0x65, /* td><td>~RoomName */ \
	0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72, /* ~</td></tr>..<tr */ \
	0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x4e,0x6f,0x64,0x65,0x20,0x43,0x61,0x6c, /* ><td><b>Node Cal */ \
	0x6c,0x73,0x69,0x67,0x6e,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e, /* lsign :</b></td> */ \
	0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c, /* <td>&nbsp;</td>< */ \
	0x74,0x64,0x3e,0x7e,0x4e,0x6f,0x64,0x65,0x4e,0x61,0x6d,0x65,0x7e,0x3c,0x2f,0x74, /* td>~NodeName~</t */ \
	0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64, /* d></tr>..<tr><td */ \
	0x3e,0x3c,0x62,0x3e,0x41,0x63,0x63,0x65,0x73,0x73,0x20,0x43,0x6f,0x6e,0x74,0x72, /* ><b>Access Contr */ \
	0x6f,0x6c,0x20,0x46,0x69,0x6c,0x65,0x20,0x4e,0x61,0x6d,0x65,0x20,0x3a,0x3c,0x2f, /* ol File Name :</ */ \
	0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70, /* b></td><td>&nbsp */ \
	0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x41,0x63,0x63,0x43,0x74, /* ;</td><td>~AccCt */ \
	0x72,0x6c,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c, /* rl~</td></tr>..< */ \
	0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x4e,0x54,0x50,0x20,0x53,0x65, /* tr><td><b>NTP Se */ \
	0x72,0x76,0x65,0x72,0x20,0x44,0x6f,0x6d,0x61,0x69,0x6e,0x20,0x4e,0x61,0x6d,0x65, /* rver Domain Name */ \
	0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26, /*  :</b></td><td>& */ \
	0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x4e, /* nbsp;</td><td>~N */ \
	0x74,0x70,0x4e,0x61,0x6d,0x65,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72, /* tpName~</td></tr */ \
	0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x54,0x69, /* >..<tr><td><b>Ti */ \
	0x6d,0x65,0x20,0x5a,0x6f,0x6e,0x65,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74, /* me Zone :</b></t */ \
	0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64, /* d><td>&nbsp;</td */ \
	0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x54,0x69,0x6d,0x65,0x5a,0x6f,0x6e,0x65,0x7e,0x20  /* ><td>~TimeZone~  */
#define DATACHUNK000005 \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x68,0x6f,0x75,0x72,0x73,0x26,0x6e,0x62,0x73,0x70, /* &nbsp;hours&nbsp */ \
	0x3b,0x7e,0x54,0x69,0x6d,0x65,0x5a,0x6f,0x6e,0x65,0x4d,0x69,0x6e,0x75,0x74,0x65, /* ;~TimeZoneMinute */ \
	0x73,0x7e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x6d,0x69,0x6e,0x75,0x74,0x65,0x73,0x3c, /* s~&nbsp;minutes< */ \
	0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c, /* /td></tr>..<tr>< */ \
	0x74,0x64,0x3e,0x3c,0x62,0x3e,0x4a,0x69,0x74,0x74,0x65,0x72,0x20,0x42,0x75,0x66, /* td><b>Jitter Buf */ \
	0x66,0x65,0x72,0x20,0x57,0x61,0x69,0x74,0x20,0x50,0x61,0x63,0x6b,0x65,0x74,0x73, /* fer Wait Packets */ \
	0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e, /* :</b></td><td>&n */ \
	0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x4a,0x69, /* bsp;</td><td>~Ji */ \
	0x74,0x74,0x65,0x72,0x53,0x69,0x7a,0x65,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f, /* tterSize~</td></ */ \
	0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x2f,0x74,0x61,0x62,0x6c,0x65,0x3e,0x0d,0x0a,0x0d, /* tr>..</table>... */ \
	0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69, /* .</div>....<scri */ \
	0x70,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x2f,0x6a,0x61, /* pt type="text/ja */ \
	0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x21,0x2d,0x2d, /* vascript">..<!-- */ \
	0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c, /* ..document.getEl */ \
	0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x68,0x65,0x6c,0x6c,0x6f, /* ementById('hello */ \
	0x27,0x29,0x2e,0x69,0x6e,0x6e,0x65,0x72,0x48,0x54,0x4d,0x4c,0x20,0x3d,0x20,0x22, /* ').innerHTML = " */ \
	0x7e,0x68,0x65,0x6c,0x6c,0x6f,0x6d,0x73,0x67,0x7e,0x22,0x3b,0x0d,0x0a,0x2f,0x2f, /* ~hellomsg~";..// */ \
	0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a, /* -->..</script>.. */ \
	0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e, /* ..~inc:footer.in */ \
	0x63,0x7e,0x0d,0x0a,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0xb0,0x00,0x00,0x00, /* c~......3....... */ \
	0x4a,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x4b,0x00,0x00,0x00,0x4c,0x01,0x00,0x00, /* J.......K...L... */ \
	0x4c,0x00,0x00,0x00,0x9e,0x01,0x00,0x00,0x4d,0x00,0x00,0x00,0xea,0x01,0x00,0x00, /* L.......M....... */ \
	0x4e,0x00,0x00,0x00,0x41,0x02,0x00,0x00,0x5f,0x00,0x00,0x00,0x95,0x02,0x00,0x00, /* N...A..._....... */ \
	0x60,0x00,0x00,0x00,0xdc,0x02,0x00,0x00,0x61,0x00,0x00,0x00,0xf8,0x02,0x00,0x00, /* `.......a....... */ \
	0x6d,0x00,0x00,0x00,0x64,0x03,0x00,0x00,0x6e,0x00,0x00,0x00,0xe7,0x03,0x00,0x00, /* m...d...n....... */ \
	0x01,0x00,0x00,0x00,0x09,0x04,0x00,0x00,0x02,0x00,0x00,0x00,0x7e,0x69,0x6e,0x63, /* ............~inc */ \
	0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64, /* :header.inc~..<d */ \
	0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e, /* iv id="content"> */ \
	0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x44,0x2d,0x53,0x54,0x41,0x52,0x20,0x64, /* ....<h1>D-STAR d */ \
	0x53,0x71,0x75,0x72,0x65,0x20,0x53,0x74,0x61,0x74,0x75,0x73,0x3c,0x2f,0x68,0x31, /* Squre Status</h1 */ \
	0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x74,0x61,0x62,0x6c,0x65,0x20,0x73,0x74,0x79,0x6c, /* >....<table styl */ \
	0x65,0x3d,0x22,0x70,0x61,0x64,0x64,0x69,0x6e,0x67,0x2d,0x6c,0x65,0x66,0x74,0x3a, /* e="padding-left: */ \
	0x20,0x31,0x30,0x70,0x78,0x3b,0x22,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74, /*  10px;">..<tr><t */ \
	0x64,0x3e,0x3c,0x62,0x3e,0x44,0x61,0x74,0x65,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c, /* d><b>Date :</b>< */ \
	0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f, /* /td><td>&nbsp;</ */ \
	0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x43,0x75,0x72,0x44,0x61,0x74,0x65,0x7e, /* td><td>~CurDate~ */ \
	0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e, /* </td></tr>..<tr> */ \
	0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x54,0x69,0x6d,0x65,0x20,0x3a,0x3c,0x2f,0x62, /* <td><b>Time :</b */ \
	0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b, /* ></td><td>&nbsp; */ \
	0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x43,0x75,0x72,0x54,0x69,0x6d, /* </td><td>~CurTim */ \
	0x65,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74, /* e~</td></tr>..<t */ \
	0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x50,0x54,0x54,0x20,0x3a,0x3c,0x2f, /* r><td><b>PTT :</ */ \
	0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70, /* b></td><td>&nbsp */ \
	0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x43,0x75,0x72,0x50,0x54, /* ;</td><td>~CurPT */ \
	0x54,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74, /* T~</td></tr>..<t */ \
	0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x43,0x4f,0x53,0x20,0x3a,0x3c,0x2f, /* r><td><b>COS :</ */ \
	0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70, /* b></td><td>&nbsp */ \
	0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x43,0x75,0x72,0x43,0x4f, /* ;</td><td>~CurCO */ \
	0x53,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74, /* S~</td></tr>..<t */ \
	0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x4e,0x6f,0x64,0x65,0x20,0x55,0x73, /* r><td><b>Node Us */ \
	0x65,0x72,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64, /* er :</b></td><td */ \
	0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e, /* >&nbsp;</td><td> */ \
	0x7e,0x43,0x75,0x72,0x55,0x73,0x65,0x72,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f, /* ~CurUser~</td></ */ \
	0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e, /* tr>..<tr><td><b> */ \
	0x53,0x53,0x4e,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74, /* SSN :</b></td><t */ \
	0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64, /* d>&nbsp;</td><td */ \
	0x3e,0x7e,0x43,0x75,0x72,0x53,0x53,0x4e,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f, /* >~CurSSN~</td></ */ \
	0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x2f,0x74,0x61,0x62,0x6c,0x65,0x3e,0x0d,0x0a,0x0d, /* tr>..</table>... */ \
	0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x2f,0x62,0x6f,0x64,0x79,0x3e, /* .</div>..</body> */ \
	0x0d,0x0a,0x3c,0x6d,0x65,0x74,0x61,0x20,0x68,0x74,0x74,0x70,0x2d,0x65,0x71,0x75, /* ..<meta http-equ */ \
	0x69,0x76,0x3d,0x22,0x72,0x65,0x66,0x72,0x65,0x73,0x68,0x22,0x20,0x63,0x6f,0x6e, /* iv="refresh" con */ \
	0x74,0x65,0x6e,0x74,0x3d,0x22,0x31,0x30,0x22,0x3e,0x0d,0x0a,0x3c,0x62,0x6f,0x64, /* tent="10">..<bod */ \
	0x79,0x3e,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x74,0x79,0x70,0x65, /* y>..<script type */ \
	0x3d,0x22,0x74,0x65,0x78,0x74,0x2f,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70  /* ="text/javascrip */
#define DATACHUNK000006 \
	0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d, /* t">..<!--..docum */ \
	0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79, /* ent.getElementBy */ \
	0x49,0x64,0x28,0x27,0x68,0x65,0x6c,0x6c,0x6f,0x27,0x29,0x2e,0x69,0x6e,0x6e,0x65, /* Id('hello').inne */ \
	0x72,0x48,0x54,0x4d,0x4c,0x20,0x3d,0x20,0x22,0x7e,0x68,0x65,0x6c,0x6c,0x6f,0x6d, /* rHTML = "~hellom */ \
	0x73,0x67,0x7e,0x22,0x3b,0x0d,0x0a,0x2f,0x2f,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f, /* sg~";..//-->..</ */ \
	0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f, /* script>..~inc:fo */ \
	0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x00,0x00,0x00,0x00,0x33, /* oter.inc~......3 */ \
	0x00,0x00,0x00,0x9b,0x00,0x00,0x00,0x63,0x00,0x00,0x00,0xdd,0x00,0x00,0x00,0x64, /* .......c.......d */ \
	0x00,0x00,0x00,0x1e,0x01,0x00,0x00,0x66,0x00,0x00,0x00,0x5e,0x01,0x00,0x00,0x67, /* .......f...^...g */ \
	0x00,0x00,0x00,0xa4,0x01,0x00,0x00,0x69,0x00,0x00,0x00,0xe5,0x01,0x00,0x00,0x68, /* .......i.......h */ \
	0x00,0x00,0x00,0x9d,0x02,0x00,0x00,0x01,0x00,0x00,0x00,0xbd,0x02,0x00,0x00,0x02, /* ................ */ \
	0x00,0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69, /* ...~inc:header.i */ \
	0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f, /* nc~..<div id="co */ \
	0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x4e, /* ntent">....<h1>N */ \
	0x6f,0x64,0x65,0x20,0x41,0x64,0x61,0x70,0x74,0x65,0x72,0x20,0x43,0x6f,0x6e,0x66, /* ode Adapter Conf */ \
	0x69,0x67,0x75,0x72,0x61,0x74,0x69,0x6f,0x6e,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a, /* iguration</h1>.. */ \
	0x0d,0x0a,0x3c,0x66,0x6f,0x72,0x6d,0x20,0x6d,0x65,0x74,0x68,0x6f,0x64,0x3d,0x22, /* ..<form method=" */ \
	0x70,0x6f,0x73,0x74,0x22,0x20,0x61,0x63,0x74,0x69,0x6f,0x6e,0x3d,0x22,0x2f,0x6e, /* post" action="/n */ \
	0x6f,0x64,0x65,0x61,0x64,0x61,0x70,0x74,0x65,0x72,0x2f,0x63,0x6f,0x6e,0x66,0x69, /* odeadapter/confi */ \
	0x67,0x2e,0x68,0x74,0x6d,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6e,0x6f,0x64, /* g.htm" name="nod */ \
	0x65,0x63,0x66,0x67,0x22,0x3e,0x0d,0x0a,0x3c,0x66,0x69,0x65,0x6c,0x64,0x73,0x65, /* ecfg">..<fieldse */ \
	0x74,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e, /* t>..<div><label> */ \
	0x54,0x58,0x20,0x44,0x65,0x6c,0x61,0x79,0x20,0x54,0x69,0x6d,0x65,0x3a,0x3c,0x2f, /* TX Delay Time:</ */ \
	0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74, /* label>..<input t */ \
	0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d, /* ype="text" name= */ \
	0x22,0x64,0x65,0x6c,0x79,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x64, /* "dely" value="~d */ \
	0x65,0x6c,0x61,0x79,0x5f,0x74,0x69,0x6d,0x65,0x7e,0x22,0x20,0x73,0x69,0x7a,0x65, /* elay_time~" size */ \
	0x3d,0x22,0x34,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22, /* ="4" class="ad1" */ \
	0x20,0x2f,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x6d,0x53,0x65,0x63,0x2e,0x3c,0x2f, /*  />&nbsp;mSec.</ */ \
	0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65, /* div>..<div><labe */ \
	0x6c,0x3e,0x54,0x58,0x20,0x54,0x69,0x6d,0x65,0x20,0x6f,0x75,0x74,0x3a,0x3c,0x2f, /* l>TX Time out:</ */ \
	0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74, /* label>..<input t */ \
	0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d, /* ype="text" name= */ \
	0x22,0x74,0x6f,0x75,0x74,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x74, /* "tout" value="~t */ \
	0x69,0x6d,0x65,0x5f,0x6f,0x75,0x74,0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22, /* ime_out~" size=" */ \
	0x34,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f,0x3e, /* 4" class="ad1"/> */ \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x53,0x65,0x63,0x2e,0x3c,0x2f,0x64,0x69,0x76,0x3e, /* &nbsp;Sec.</div> */ \
	0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x52,0x58, /* ..<div><label>RX */ \
	0x20,0x4b,0x65,0x65,0x70,0x20,0x41,0x6c,0x69,0x76,0x65,0x3a,0x3c,0x2f,0x6c,0x61, /*  Keep Alive:</la */ \
	0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70, /* bel>..<input typ */ \
	0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6b, /* e="text" name="k */ \
	0x65,0x65,0x70,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x6b,0x65,0x65, /* eep" value="~kee */ \
	0x70,0x5f,0x61,0x6c,0x69,0x76,0x65,0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22, /* p_alive~" size=" */ \
	0x34,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f,0x3e, /* 4" class="ad1"/> */ \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x6d,0x53,0x65,0x63,0x2e,0x3c,0x2f,0x64,0x69,0x76, /* &nbsp;mSec.</div */ \
	0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x4a, /* >..<div><label>J */ \
	0x69,0x74,0x74,0x65,0x72,0x20,0x42,0x75,0x66,0x66,0x65,0x72,0x20,0x73,0x69,0x7a, /* itter Buffer siz */ \
	0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70, /* e:</label>..<inp */ \
	0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e, /* ut type="text" n */ \
	0x61,0x6d,0x65,0x3d,0x22,0x6a,0x69,0x74,0x74,0x22,0x20,0x76,0x61,0x6c,0x75,0x65, /* ame="jitt" value */ \
	0x3d,0x22,0x7e,0x6a,0x69,0x74,0x74,0x74,0x65,0x72,0x5f,0x73,0x69,0x7a,0x65,0x7e, /* ="~jittter_size~ */ \
	0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x33,0x22,0x20,0x63,0x6c,0x61,0x73,0x73, /* " size="3" class */ \
	0x3d,0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x30,0x3a, /* ="ad1"/>&nbsp;0: */ \
	0x20,0x6e,0x6f,0x74,0x20,0x65,0x66,0x66,0x65,0x63,0x74,0x3c,0x2f,0x64,0x69,0x76, /*  not effect</div */ \
	0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x52, /* >..<div><label>R */ \
	0x58,0x20,0x41,0x75,0x74,0x6f,0x20,0x50,0x6f,0x6c,0x61,0x72,0x69,0x74,0x79,0x3a, /* X Auto Polarity: */ \
	0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74, /* </label>..<input */ \
	0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22, /*  type="checkbox" */ \
	0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x72,0x78,0x70,0x6c,0x22,0x20,0x76,0x61,0x6c, /*  name="rxpl" val */ \
	0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x52,0x58,0x5f,0x41,0x75,0x74,0x6f,0x50,0x6f, /* ue="" ~RX_AutoPo */ \
	0x6c,0x61,0x72,0x69,0x74,0x79,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61, /* larity~ class="a */ \
	0x64,0x31,0x22,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69, /* d1"/></div>..<di */ \
	0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x52,0x58,0x20,0x50,0x6f,0x6c,0x61, /* v><label>RX Pola */ \
	0x72,0x69,0x74,0x79,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c  /* rity:</label>..< */
#define DATACHUNK000007 \
	0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63, /* input type="chec */ \
	0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x72,0x78,0x70,0x6f, /* kbox" name="rxpo */ \
	0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x52,0x58,0x5f,0x50, /* " value="" ~RX_P */ \
	0x6f,0x6c,0x61,0x72,0x69,0x74,0x79,0x7e,0x20,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d, /* olarity~  class= */ \
	0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c, /* "ad1"/></div>..< */ \
	0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x54,0x58,0x20,0x50,0x6f, /* div><label>TX Po */ \
	0x6c,0x61,0x72,0x69,0x74,0x79,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d, /* larity:</label>. */ \
	0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65, /* .<td><input type */ \
	0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65, /* ="checkbox" name */ \
	0x3d,0x22,0x74,0x78,0x70,0x6f,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22, /* ="txpo" value="" */ \
	0x20,0x7e,0x54,0x58,0x5f,0x50,0x6f,0x6c,0x61,0x72,0x69,0x74,0x79,0x7e,0x20,0x63, /*  ~TX_Polarity~ c */ \
	0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64, /* lass="ad1" /></d */ \
	0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c, /* iv>..<div><label */ \
	0x3e,0x43,0x4f,0x53,0x20,0x43,0x68,0x65,0x63,0x6b,0x3a,0x3c,0x2f,0x6c,0x61,0x62, /* >COS Check:</lab */ \
	0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20, /* el>..<td><input  */ \
	0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20, /* type="checkbox"  */ \
	0x6e,0x61,0x6d,0x65,0x3d,0x22,0x63,0x6f,0x73,0x22,0x20,0x76,0x61,0x6c,0x75,0x65, /* name="cos" value */ \
	0x3d,0x22,0x22,0x20,0x7e,0x43,0x4f,0x53,0x5f,0x43,0x68,0x65,0x63,0x6b,0x7e,0x20, /* ="" ~COS_Check~  */ \
	0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x20,0x2f,0x3e,0x3c,0x2f, /* class="ad1" /></ */ \
	0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65, /* div>..<div><labe */ \
	0x6c,0x3e,0x53,0x2f,0x4e,0x20,0x53,0x71,0x75,0x65,0x6c,0x63,0x68,0x20,0x56,0x61, /* l>S/N Squelch Va */ \
	0x6c,0x75,0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74, /* lue:</label>..<t */ \
	0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74, /* d><input type="t */ \
	0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x73,0x6e,0x22,0x20,0x76, /* ext" name="sn" v */ \
	0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x53,0x4e,0x5f,0x53,0x71,0x75,0x65,0x6c,0x63, /* alue="~SN_Squelc */ \
	0x68,0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x35,0x22,0x20,0x63,0x6c,0x61, /* h~" size="5" cla */ \
	0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b, /* ss="ad1"/>&nbsp; */ \
	0x30,0x3a,0x20,0x6e,0x6f,0x74,0x20,0x65,0x66,0x66,0x65,0x63,0x74,0x3c,0x2f,0x64, /* 0: not effect</d */ \
	0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c, /* iv>..<div><label */ \
	0x3e,0x43,0x52,0x43,0x20,0x43,0x68,0x65,0x63,0x6b,0x3a,0x3c,0x2f,0x6c,0x61,0x62, /* >CRC Check:</lab */ \
	0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20, /* el>..<td><input  */ \
	0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20, /* type="checkbox"  */ \
	0x6e,0x61,0x6d,0x65,0x3d,0x22,0x63,0x72,0x63,0x22,0x20,0x76,0x61,0x6c,0x75,0x65, /* name="crc" value */ \
	0x3d,0x22,0x22,0x20,0x7e,0x43,0x52,0x43,0x5f,0x43,0x68,0x65,0x63,0x6b,0x7e,0x20, /* ="" ~CRC_Check~  */ \
	0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x3c,0x2f,0x64, /* class="ad1"/></d */ \
	0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c, /* iv>..<div><label */ \
	0x3e,0x4c,0x61,0x73,0x74,0x20,0x46,0x72,0x61,0x6d,0x65,0x20,0x53,0x65,0x6e,0x64, /* >Last Frame Send */ \
	0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c, /* :</label>..<td>< */ \
	0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63, /* input type="chec */ \
	0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6c,0x61,0x73,0x74, /* kbox" name="last */ \
	0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x4c,0x61,0x73,0x74, /* " value="" ~Last */ \
	0x46,0x72,0x61,0x6d,0x65,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64, /* Frame~ class="ad */ \
	0x31,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69, /* 1" /></div>..<di */ \
	0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x48,0x65,0x61,0x64,0x65,0x72,0x20, /* v><label>Header  */ \
	0x47,0x65,0x6e,0x65,0x72,0x61,0x74,0x69,0x6f,0x6e,0x3a,0x3c,0x2f,0x6c,0x61,0x62, /* Generation:</lab */ \
	0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20, /* el>..<td><input  */ \
	0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20, /* type="checkbox"  */ \
	0x6e,0x61,0x6d,0x65,0x3d,0x22,0x68,0x64,0x72,0x67,0x22,0x20,0x76,0x61,0x6c,0x75, /* name="hdrg" valu */ \
	0x65,0x3d,0x22,0x22,0x20,0x7e,0x48,0x65,0x61,0x64,0x65,0x72,0x47,0x65,0x6e,0x7e, /* e="" ~HeaderGen~ */ \
	0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x20,0x2f,0x3e,0x3c, /*  class="ad1" />< */ \
	0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62, /* /div>..<div><lab */ \
	0x65,0x6c,0x3e,0x48,0x65,0x61,0x64,0x65,0x72,0x20,0x47,0x65,0x6e,0x2e,0x20,0x54, /* el>Header Gen. T */ \
	0x79,0x70,0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74, /* ype:</label>..<t */ \
	0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63, /* d><input type="c */ \
	0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x68, /* heckbox" name="h */ \
	0x64,0x72,0x74,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x48, /* drt" value="" ~H */ \
	0x65,0x61,0x64,0x65,0x72,0x47,0x65,0x6e,0x54,0x79,0x70,0x65,0x7e,0x20,0x20,0x63, /* eaderGenType~  c */ \
	0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x26,0x6e,0x62,0x73, /* lass="ad1"/>&nbs */ \
	0x70,0x3b,0x43,0x68,0x65,0x63,0x6b,0x65,0x64,0x3a,0x20,0x53,0x70,0x61,0x63,0x65, /* p;Checked: Space */ \
	0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x26,0x6e,0x62, /* </div>..<div>&nb */ \
	0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26, /* sp;&nbsp;&nbsp;& */ \
	0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70, /* nbsp;&nbsp;&nbsp */ \
	0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62, /* ;&nbsp;&nbsp;&nb */ \
	0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x0d,0x26,0x6e,0x62,0x73,0x70,0x3b  /* sp;&nbsp;.&nbsp; */
#define DATACHUNK000008 \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x0a,0x55,0x6e,0x63, /* &nbsp;&nbsp;.Unc */ \
	0x68,0x65,0x63,0x6b,0x65,0x64,0x3a,0x20,0x4c,0x61,0x73,0x74,0x20,0x52,0x46,0x20, /* hecked: Last RF  */ \
	0x48,0x65,0x61,0x64,0x65,0x72,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64, /* Header</div>..<d */ \
	0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x48,0x61,0x6c,0x66,0x2f,0x46, /* iv><label>Half/F */ \
	0x75,0x6c,0x6c,0x20,0x44,0x75,0x70,0x6c,0x65,0x78,0x3a,0x3c,0x2f,0x6c,0x61,0x62, /* ull Duplex:</lab */ \
	0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20, /* el>..<td><input  */ \
	0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20, /* type="checkbox"  */ \
	0x6e,0x61,0x6d,0x65,0x3d,0x22,0x68,0x5f,0x66,0x22,0x20,0x76,0x61,0x6c,0x75,0x65, /* name="h_f" value */ \
	0x3d,0x22,0x22,0x20,0x7e,0x48,0x61,0x6c,0x66,0x46,0x75,0x6c,0x6c,0x7e,0x20,0x20, /* ="" ~HalfFull~   */ \
	0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x26,0x6e,0x62, /* class="ad1"/>&nb */ \
	0x73,0x70,0x3b,0x43,0x68,0x65,0x63,0x6b,0x65,0x64,0x3a,0x26,0x6e,0x62,0x73,0x70, /* sp;Checked:&nbsp */ \
	0x3b,0x48,0x61,0x6c,0x66,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69, /* ;Half</div>..<di */ \
	0x76,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e, /* v>&nbsp;&nbsp;&n */ \
	0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b, /* bsp;&nbsp;&nbsp; */ \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73, /* &nbsp;&nbsp;&nbs */ \
	0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x0d,0x26, /* p;&nbsp;&nbsp;.& */ \
	0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70, /* nbsp;&nbsp;&nbsp */ \
	0x3b,0x0a,0x55,0x6e,0x63,0x68,0x65,0x63,0x6b,0x65,0x64,0x3a,0x20,0x46,0x75,0x6c, /* ;.Unchecked: Ful */ \
	0x6c,0x20,0x44,0x75,0x70,0x6c,0x65,0x78,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a, /* l Duplex</div>.. */ \
	0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20, /* ....<div><input  */ \
	0x74,0x79,0x70,0x65,0x3d,0x22,0x73,0x75,0x62,0x6d,0x69,0x74,0x22,0x20,0x63,0x6c, /* type="submit" cl */ \
	0x61,0x73,0x73,0x3d,0x22,0x61,0x70,0x31,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d, /* ass="ap1" value= */ \
	0x22,0x53,0x61,0x76,0x65,0x20,0x42,0x61,0x73,0x69,0x63,0x20,0x49,0x6e,0x66,0x6f, /* "Save Basic Info */ \
	0x2e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x2f,0x66, /* ." /></div>..</f */ \
	0x69,0x65,0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x6f,0x72,0x6d, /* ieldset>..</form */ \
	0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a, /* >..</div>..~inc: */ \
	0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33, /* footer.inc~....3 */ \
	0x00,0x00,0x00,0xeb,0x00,0x00,0x00,0x51,0x00,0x00,0x00,0x6b,0x01,0x00,0x00,0x52, /* .......Q...k...R */ \
	0x00,0x00,0x00,0xe9,0x01,0x00,0x00,0x53,0x00,0x00,0x00,0x6f,0x02,0x00,0x00,0x54, /* .......S...o...T */ \
	0x00,0x00,0x00,0x03,0x03,0x00,0x00,0x55,0x00,0x00,0x00,0x78,0x03,0x00,0x00,0x5e, /* .......U...x...^ */ \
	0x00,0x00,0x00,0xee,0x03,0x00,0x00,0x56,0x00,0x00,0x00,0x61,0x04,0x00,0x00,0x57, /* .......V...a...W */ \
	0x00,0x00,0x00,0xd3,0x04,0x00,0x00,0x58,0x00,0x00,0x00,0x61,0x05,0x00,0x00,0x59, /* .......X...a...Y */ \
	0x00,0x00,0x00,0xd8,0x05,0x00,0x00,0x5a,0x00,0x00,0x00,0x52,0x06,0x00,0x00,0x5b, /* .......Z...R...[ */ \
	0x00,0x00,0x00,0xcb,0x06,0x00,0x00,0x5c,0x00,0x00,0x00,0xd1,0x07,0x00,0x00,0x5d, /* .......\.......] */ \
	0x00,0x00,0x00,0xe8,0x08,0x00,0x00,0x02,0x00,0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a, /* ...........~inc: */ \
	0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69, /* header.inc~..<di */ \
	0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d, /* v id="content">. */ \
	0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x42,0x65,0x61,0x63,0x6f,0x6e,0x20,0x43,0x6f, /* ...<h1>Beacon Co */ \
	0x6e,0x66,0x69,0x67,0x75,0x72,0x61,0x74,0x69,0x6f,0x6e,0x3c,0x2f,0x68,0x31,0x3e, /* nfiguration</h1> */ \
	0x0d,0x0a,0x0d,0x0a,0x3c,0x66,0x6f,0x72,0x6d,0x20,0x6d,0x65,0x74,0x68,0x6f,0x64, /* ....<form method */ \
	0x3d,0x22,0x70,0x6f,0x73,0x74,0x22,0x20,0x61,0x63,0x74,0x69,0x6f,0x6e,0x3d,0x22, /* ="post" action=" */ \
	0x2f,0x6e,0x6f,0x64,0x65,0x61,0x64,0x61,0x70,0x74,0x65,0x72,0x2f,0x63,0x6f,0x6e, /* /nodeadapter/con */ \
	0x66,0x69,0x67,0x32,0x2e,0x68,0x74,0x6d,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22, /* fig2.htm" name=" */ \
	0x62,0x65,0x61,0x63,0x6f,0x6e,0x22,0x3e,0x0d,0x0a,0x3c,0x66,0x69,0x65,0x6c,0x64, /* beacon">..<field */ \
	0x73,0x65,0x74,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65, /* set>..<div><labe */ \
	0x6c,0x3e,0x42,0x65,0x61,0x63,0x6f,0x6e,0x20,0x4d,0x65,0x73,0x73,0x61,0x67,0x65, /* l>Beacon Message */ \
	0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75, /* :</label>..<inpu */ \
	0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61, /* t type="text" na */ \
	0x6d,0x65,0x3d,0x22,0x62,0x65,0x61,0x63,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d, /* me="beac" value= */ \
	0x22,0x7e,0x42,0x65,0x61,0x63,0x6f,0x6e,0x4d,0x7e,0x22,0x20,0x73,0x69,0x7a,0x65, /* "~BeaconM~" size */ \
	0x3d,0x22,0x32,0x30,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x73,0x6d,0x22, /* ="20" class="sm" */ \
	0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c, /* /></div>..<div>< */ \
	0x6c,0x61,0x62,0x65,0x6c,0x3e,0x49,0x6e,0x65,0x72,0x76,0x61,0x6c,0x3a,0x3c,0x2f, /* label>Inerval:</ */ \
	0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74, /* label>..<input t */ \
	0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d, /* ype="text" name= */ \
	0x22,0x69,0x6e,0x74,0x76,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x42, /* "intv" value="~B */ \
	0x65,0x61,0x63,0x6f,0x6e,0x49,0x6e,0x74,0x76,0x7e,0x22,0x20,0x73,0x69,0x7a,0x65, /* eaconIntv~" size */ \
	0x3d,0x22,0x33,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22, /* ="3" class="ad1" */ \
	0x2f,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x53,0x65,0x63,0x2e,0x3c,0x2f,0x64,0x69, /* />&nbsp;Sec.</di */ \
	0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x69,0x6e,0x70,0x75, /* v>....<div><inpu */ \
	0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x73,0x75,0x62,0x6d,0x69,0x74,0x22,0x20, /* t type="submit"  */ \
	0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x70,0x31,0x22,0x20,0x76,0x61,0x6c,0x75, /* class="ap1" valu */ \
	0x65,0x3d,0x22,0x53,0x61,0x76,0x65,0x20,0x42,0x65,0x61,0x63,0x6f,0x6e,0x20,0x49, /* e="Save Beacon I */ \
	0x6e,0x66,0x6f,0x2e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a  /* nfo." /></div>.. */
#define DATACHUNK000009 \
	0x3c,0x2f,0x66,0x69,0x65,0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a,0x3c,0x2f,0x66, /* </fieldset>..</f */ \
	0x6f,0x72,0x6d,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x7e,0x69, /* orm>..</div>..~i */ \
	0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x00,0x00, /* nc:footer.inc~.. */ \
	0x00,0x00,0x33,0x00,0x00,0x00,0xe6,0x00,0x00,0x00,0x71,0x00,0x00,0x00,0x53,0x01, /* ..3.......q...S. */ \
	0x00,0x00,0x72,0x00,0x00,0x00,0xf3,0x01,0x00,0x00,0x02,0x00,0x00,0x00,0x7e,0x69, /* ..r...........~i */ \
	0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a, /* nc:header.inc~.. */ \
	0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74, /* <div id="content */ \
	0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x54,0x58,0x20,0x48,0x65,0x61, /* ">....<h1>TX Hea */ \
	0x64,0x65,0x72,0x20,0x52,0x65,0x70,0x6c,0x61,0x63,0x65,0x20,0x43,0x6f,0x6e,0x66, /* der Replace Conf */ \
	0x69,0x67,0x75,0x72,0x61,0x74,0x69,0x6f,0x6e,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a, /* iguration</h1>.. */ \
	0x0d,0x0a,0x3c,0x66,0x6f,0x72,0x6d,0x20,0x6d,0x65,0x74,0x68,0x6f,0x64,0x3d,0x22, /* ..<form method=" */ \
	0x70,0x6f,0x73,0x74,0x22,0x20,0x61,0x63,0x74,0x69,0x6f,0x6e,0x3d,0x22,0x2f,0x6e, /* post" action="/n */ \
	0x6f,0x64,0x65,0x61,0x64,0x61,0x70,0x74,0x65,0x72,0x2f,0x63,0x6f,0x6e,0x66,0x69, /* odeadapter/confi */ \
	0x67,0x33,0x2e,0x68,0x74,0x6d,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x68,0x65, /* g3.htm" name="he */ \
	0x61,0x64,0x65,0x72,0x63,0x66,0x67,0x22,0x3e,0x0d,0x0a,0x3c,0x66,0x69,0x65,0x6c, /* adercfg">..<fiel */ \
	0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62, /* dset>..<div><lab */ \
	0x65,0x6c,0x3e,0x54,0x58,0x20,0x48,0x65,0x61,0x64,0x65,0x72,0x20,0x52,0x65,0x70, /* el>TX Header Rep */ \
	0x6c,0x61,0x63,0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c, /* lace:</label>..< */ \
	0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63, /* input type="chec */ \
	0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x74,0x78,0x68,0x72, /* kbox" name="txhr */ \
	0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x48,0x65,0x61,0x64, /* " value="" ~Head */ \
	0x65,0x72,0x52,0x65,0x70,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64, /* erRep~ class="ad */ \
	0x31,0x22,0x20,0x6f,0x6e,0x63,0x6c,0x69,0x63,0x6b,0x3d,0x22,0x63,0x6f,0x6e,0x66, /* 1" onclick="conf */ \
	0x69,0x67,0x48,0x65,0x61,0x64,0x65,0x72,0x28,0x29,0x22,0x2f,0x3e,0x3c,0x2f,0x64, /* igHeader()"/></d */ \
	0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x62,0x72,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e, /* iv>..<br>..<div> */ \
	0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x41,0x6c,0x74,0x65,0x72,0x20,0x4d,0x79,0x43, /* <label>Alter MyC */ \
	0x61,0x6c,0x6c,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69, /* all:</label>..<i */ \
	0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22, /* nput type="text" */ \
	0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6d,0x79,0x63,0x22,0x20,0x76,0x61,0x6c,0x75, /*  name="myc" valu */ \
	0x65,0x3d,0x22,0x7e,0x61,0x6c,0x74,0x5f,0x6d,0x79,0x63,0x61,0x6c,0x6c,0x7e,0x22, /* e="~alt_mycall~" */ \
	0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x38,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d, /*  size="8" class= */ \
	0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20, /* "ad1"/>..<input  */ \
	0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20, /* type="checkbox"  */ \
	0x6e,0x61,0x6d,0x65,0x3d,0x22,0x61,0x6d,0x79,0x63,0x22,0x20,0x76,0x61,0x6c,0x75, /* name="amyc" valu */ \
	0x65,0x3d,0x22,0x22,0x20,0x7e,0x61,0x5f,0x6d,0x79,0x63,0x61,0x6c,0x6c,0x7e,0x20, /* e="" ~a_mycall~  */ \
	0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x33,0x22,0x20,0x2f,0x3e,0x0d,0x0a, /* class="ad3" />.. */ \
	0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61, /* </div>..<div><la */ \
	0x62,0x65,0x6c,0x3e,0x41,0x6c,0x74,0x65,0x72,0x20,0x4d,0x79,0x43,0x61,0x6c,0x6c, /* bel>Alter MyCall */ \
	0x32,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70, /* 2:</label>..<inp */ \
	0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e, /* ut type="text" n */ \
	0x61,0x6d,0x65,0x3d,0x22,0x6d,0x79,0x63,0x32,0x22,0x20,0x76,0x61,0x6c,0x75,0x65, /* ame="myc2" value */ \
	0x3d,0x22,0x7e,0x61,0x6c,0x74,0x5f,0x6d,0x79,0x63,0x61,0x6c,0x6c,0x32,0x7e,0x22, /* ="~alt_mycall2~" */ \
	0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x34,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d, /*  size="4" class= */ \
	0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62, /* "ad1"/>&nbsp;&nb */ \
	0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x0d, /* sp;&nbsp;&nbsp;. */ \
	0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68, /* .<input type="ch */ \
	0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x61,0x6d, /* eckbox" name="am */ \
	0x79,0x32,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x61,0x5f, /* y2" value="" ~a_ */ \
	0x6d,0x79,0x63,0x61,0x6c,0x6c,0x32,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22, /* mycall2~ class=" */ \
	0x61,0x64,0x33,0x22,0x20,0x2f,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d, /* ad3" />..</div>. */ \
	0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x41,0x6c,0x74, /* .<div><label>Alt */ \
	0x65,0x72,0x20,0x59,0x6f,0x75,0x72,0x43,0x61,0x6c,0x6c,0x3a,0x3c,0x2f,0x6c,0x61, /* er YourCall:</la */ \
	0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70, /* bel>..<input typ */ \
	0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x79, /* e="text" name="y */ \
	0x72,0x63,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x61,0x6c,0x74,0x5f, /* rc" value="~alt_ */ \
	0x79,0x6f,0x75,0x72,0x63,0x61,0x6c,0x6c,0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d, /* yourcall~" size= */ \
	0x22,0x38,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f, /* "8" class="ad1"/ */ \
	0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22, /* >..<input type=" */ \
	0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22, /* checkbox" name=" */ \
	0x61,0x79,0x72,0x63,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e, /* ayrc" value="" ~ */ \
	0x61,0x5f,0x79,0x6f,0x75,0x72,0x63,0x61,0x6c,0x6c,0x7e,0x20,0x63,0x6c,0x61,0x73, /* a_yourcall~ clas */ \
	0x73,0x3d,0x22,0x61,0x64,0x33,0x22,0x20,0x2f,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69, /* s="ad3" />..</di */ \
	0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e, /* v>..<div><label> */ \
	0x41,0x6c,0x74,0x65,0x72,0x20,0x52,0x50,0x54,0x31,0x20,0x43,0x61,0x6c,0x6c,0x3a  /* Alter RPT1 Call: */
#define DATACHUNK00000a \
	0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74, /* </label>..<input */ \
	0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d, /*  type="text" nam */ \
	0x65,0x3d,0x22,0x72,0x70,0x74,0x31,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22, /* e="rpt1" value=" */ \
	0x7e,0x61,0x6c,0x74,0x5f,0x72,0x70,0x74,0x31,0x63,0x61,0x6c,0x6c,0x7e,0x22,0x20, /* ~alt_rpt1call~"  */ \
	0x73,0x69,0x7a,0x65,0x3d,0x22,0x38,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22, /* size="8" class=" */ \
	0x61,0x64,0x31,0x22,0x2f,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74, /* ad1"/>..<input t */ \
	0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e, /* ype="checkbox" n */ \
	0x61,0x6d,0x65,0x3d,0x22,0x61,0x72,0x74,0x31,0x22,0x20,0x76,0x61,0x6c,0x75,0x65, /* ame="art1" value */ \
	0x3d,0x22,0x22,0x20,0x7e,0x61,0x5f,0x72,0x70,0x74,0x31,0x63,0x61,0x6c,0x6c,0x7e, /* ="" ~a_rpt1call~ */ \
	0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x33,0x22,0x20,0x2f,0x3e,0x0d, /*  class="ad3" />. */ \
	0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c, /* .</div>..<div><l */ \
	0x61,0x62,0x65,0x6c,0x3e,0x41,0x6c,0x74,0x65,0x72,0x20,0x52,0x50,0x54,0x32,0x20, /* abel>Alter RPT2  */ \
	0x43,0x61,0x6c,0x6c,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c, /* Call:</label>..< */ \
	0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74, /* input type="text */ \
	0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x72,0x70,0x74,0x32,0x22,0x20,0x76,0x61, /* " name="rpt2" va */ \
	0x6c,0x75,0x65,0x3d,0x22,0x7e,0x61,0x6c,0x74,0x5f,0x72,0x70,0x74,0x32,0x63,0x61, /* lue="~alt_rpt2ca */ \
	0x6c,0x6c,0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x38,0x22,0x20,0x63,0x6c, /* ll~" size="8" cl */ \
	0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x0d,0x0a,0x3c,0x69,0x6e, /* ass="ad1"/>..<in */ \
	0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62, /* put type="checkb */ \
	0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x61,0x72,0x74,0x32,0x22,0x20, /* ox" name="art2"  */ \
	0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x61,0x5f,0x72,0x70,0x74,0x32, /* value="" ~a_rpt2 */ \
	0x63,0x61,0x6c,0x6c,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x33, /* call~ class="ad3 */ \
	0x22,0x20,0x2f,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a, /* " />..</div>.... */ \
	0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x41,0x6c,0x74,0x2e, /* <div><label>Alt. */ \
	0x20,0x54,0x58,0x20,0x48,0x65,0x61,0x64,0x65,0x72,0x20,0x46,0x6c,0x61,0x67,0x73, /*  TX Header Flags */ \
	0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75, /* :</label>..<inpu */ \
	0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78, /* t type="checkbox */ \
	0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x66,0x6c,0x67,0x37,0x22,0x20,0x76,0x61, /* " name="flg7" va */ \
	0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x66,0x6c,0x61,0x67,0x37,0x7e,0x20,0x63, /* lue="" ~flag7~ c */ \
	0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x20,0x64,0x69,0x73,0x61,0x62, /* lass="ad1" disab */ \
	0x6c,0x65,0x64,0x2f,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79, /* led/>..<input ty */ \
	0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61, /* pe="checkbox" na */ \
	0x6d,0x65,0x3d,0x22,0x66,0x6c,0x67,0x36,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d, /* me="flg6" value= */ \
	0x22,0x22,0x20,0x7e,0x66,0x6c,0x61,0x67,0x36,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73, /* "" ~flag6~ class */ \
	0x3d,0x22,0x61,0x64,0x33,0x22,0x20,0x2f,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75, /* ="ad3" />..<inpu */ \
	0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78, /* t type="checkbox */ \
	0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x66,0x6c,0x67,0x35,0x22,0x20,0x76,0x61, /* " name="flg5" va */ \
	0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x66,0x6c,0x61,0x67,0x35,0x7e,0x20,0x63, /* lue="" ~flag5~ c */ \
	0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x33,0x22,0x20,0x2f,0x3e,0x0d,0x0a,0x3c, /* lass="ad3" />..< */ \
	0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63, /* input type="chec */ \
	0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x66,0x6c,0x67,0x34, /* kbox" name="flg4 */ \
	0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x66,0x6c,0x61,0x67, /* " value="" ~flag */ \
	0x34,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x33,0x22,0x20,0x2f, /* 4~ class="ad3" / */ \
	0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22, /* >..<input type=" */ \
	0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22, /* checkbox" name=" */ \
	0x66,0x6c,0x67,0x33,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e, /* flg3" value="" ~ */ \
	0x66,0x6c,0x61,0x67,0x33,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64, /* flag3~ class="ad */ \
	0x33,0x22,0x20,0x2f,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79, /* 3" />..<input ty */ \
	0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61, /* pe="checkbox" na */ \
	0x6d,0x65,0x3d,0x22,0x66,0x6c,0x67,0x32,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d, /* me="flg2" value= */ \
	0x22,0x22,0x20,0x7e,0x66,0x6c,0x61,0x67,0x32,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73, /* "" ~flag2~ class */ \
	0x3d,0x22,0x61,0x64,0x33,0x22,0x20,0x2f,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75, /* ="ad3" />..<inpu */ \
	0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78, /* t type="checkbox */ \
	0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x66,0x6c,0x67,0x31,0x22,0x20,0x76,0x61, /* " name="flg1" va */ \
	0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x66,0x6c,0x61,0x67,0x31,0x7e,0x20,0x63, /* lue="" ~flag1~ c */ \
	0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x33,0x22,0x20,0x2f,0x3e,0x0d,0x0a,0x3c, /* lass="ad3" />..< */ \
	0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63, /* input type="chec */ \
	0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x66,0x6c,0x67,0x30, /* kbox" name="flg0 */ \
	0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x66,0x6c,0x61,0x67, /* " value="" ~flag */ \
	0x30,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x33,0x22,0x20,0x2f, /* 0~ class="ad3" / */ \
	0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x0d,0x0a,0x3c, /* >&nbsp;&nbsp;..< */ \
	0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63, /* input type="chec */ \
	0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x61,0x66,0x6c,0x67, /* kbox" name="aflg */ \
	0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x41,0x66,0x6c,0x61  /* " value="" ~Afla */
#define DATACHUNK00000b \
	0x67,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x33,0x22,0x20,0x2f, /* g~ class="ad3" / */ \
	0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x0d,0x0a,0x0d, /* >..</div>....... */ \
	0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70, /* .<div><input typ */ \
	0x65,0x3d,0x22,0x73,0x75,0x62,0x6d,0x69,0x74,0x22,0x20,0x63,0x6c,0x61,0x73,0x73, /* e="submit" class */ \
	0x3d,0x22,0x61,0x70,0x31,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x68,0x64,0x72, /* ="ap1" name="hdr */ \
	0x73,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x53,0x61,0x76,0x65,0x20,0x48, /* s" value="Save H */ \
	0x65,0x61,0x64,0x65,0x72,0x20,0x49,0x6e,0x66,0x6f,0x2e,0x22,0x20,0x2f,0x3e,0x3c, /* eader Info." />< */ \
	0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x69,0x65,0x6c,0x64,0x73,0x65, /* /div>..</fieldse */ \
	0x74,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x6f,0x72,0x6d,0x3e,0x0d,0x0a,0x3c,0x2f,0x64, /* t>..</form>..</d */ \
	0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x6c,0x61,0x6e, /* iv>..<script lan */ \
	0x67,0x75,0x61,0x67,0x65,0x3d,0x22,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70, /* guage="javascrip */ \
	0x74,0x22,0x3e,0x0d,0x0a,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x63,0x6f, /* t">..function co */ \
	0x6e,0x66,0x69,0x67,0x48,0x65,0x61,0x64,0x65,0x72,0x28,0x29,0x20,0x7b,0x0d,0x0a, /* nfigHeader() {.. */ \
	0x09,0x65,0x20,0x3d,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x66,0x6f, /* .e = document.fo */ \
	0x72,0x6d,0x73,0x2e,0x68,0x65,0x61,0x64,0x65,0x72,0x63,0x66,0x67,0x3b,0x0d,0x0a, /* rms.headercfg;.. */ \
	0x09,0x73,0x74,0x20,0x3d,0x20,0x21,0x28,0x65,0x2e,0x74,0x78,0x68,0x72,0x2e,0x63, /* .st = !(e.txhr.c */ \
	0x68,0x65,0x63,0x6b,0x65,0x64,0x29,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x6d,0x79,0x63, /* hecked);...e.myc */ \
	0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d, /* .disabled = st;. */ \
	0x0a,0x09,0x65,0x2e,0x6d,0x79,0x63,0x32,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65, /* ..e.myc2.disable */ \
	0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x79,0x72,0x63,0x2e, /* d = st;...e.yrc. */ \
	0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a, /* disabled = st;.. */ \
	0x09,0x65,0x2e,0x72,0x70,0x74,0x31,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64, /* .e.rpt1.disabled */ \
	0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x72,0x70,0x74,0x32,0x2e, /*  = st;...e.rpt2. */ \
	0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a, /* disabled = st;.. */ \
	0x09,0x65,0x2e,0x66,0x6c,0x67,0x36,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64, /* .e.flg6.disabled */ \
	0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x66,0x6c,0x67,0x35,0x2e, /*  = st;...e.flg5. */ \
	0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a, /* disabled = st;.. */ \
	0x09,0x65,0x2e,0x66,0x6c,0x67,0x34,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64, /* .e.flg4.disabled */ \
	0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x66,0x6c,0x67,0x33,0x2e, /*  = st;...e.flg3. */ \
	0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a, /* disabled = st;.. */ \
	0x09,0x65,0x2e,0x66,0x6c,0x67,0x32,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64, /* .e.flg2.disabled */ \
	0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x66,0x6c,0x67,0x31,0x2e, /*  = st;...e.flg1. */ \
	0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a, /* disabled = st;.. */ \
	0x09,0x65,0x2e,0x66,0x6c,0x67,0x30,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64, /* .e.flg0.disabled */ \
	0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x61,0x66,0x6c,0x67,0x2e, /*  = st;...e.aflg. */ \
	0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a, /* disabled = st;.. */ \
	0x09,0x65,0x2e,0x61,0x6d,0x79,0x63,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64, /* .e.amyc.disabled */ \
	0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x61,0x6d,0x79,0x32,0x2e, /*  = st;...e.amy2. */ \
	0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a, /* disabled = st;.. */ \
	0x09,0x65,0x2e,0x61,0x79,0x72,0x63,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64, /* .e.ayrc.disabled */ \
	0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x61,0x72,0x74,0x31,0x2e, /*  = st;...e.art1. */ \
	0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a, /* disabled = st;.. */ \
	0x09,0x65,0x2e,0x61,0x72,0x74,0x32,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64, /* .e.art2.disabled */ \
	0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x7d,0x0d,0x0a,0x0d,0x0a,0x63,0x6f,0x6e, /*  = st;..}....con */ \
	0x66,0x69,0x67,0x48,0x65,0x61,0x64,0x65,0x72,0x28,0x29,0x3b,0x0d,0x0a,0x0d,0x0a, /* figHeader();.... */ \
	0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a,0x0d,0x0a,0x7e,0x69,0x6e, /* </script>....~in */ \
	0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x00,0x00,0x00, /* c:footer.inc~... */ \
	0x00,0x33,0x00,0x00,0x00,0xfd,0x00,0x00,0x00,0x73,0x00,0x00,0x00,0x85,0x01,0x00, /* .3.......s...... */ \
	0x00,0x74,0x00,0x00,0x00,0xd7,0x01,0x00,0x00,0x81,0x00,0x00,0x00,0x44,0x02,0x00, /* .t...........D.. */ \
	0x00,0x75,0x00,0x00,0x00,0xaf,0x02,0x00,0x00,0x82,0x00,0x00,0x00,0x1d,0x03,0x00, /* .u.............. */ \
	0x00,0x76,0x00,0x00,0x00,0x71,0x03,0x00,0x00,0x83,0x00,0x00,0x00,0xe2,0x03,0x00, /* .v...q.......... */ \
	0x00,0x77,0x00,0x00,0x00,0x36,0x04,0x00,0x00,0x84,0x00,0x00,0x00,0xa7,0x04,0x00, /* .w...6.......... */ \
	0x00,0x78,0x00,0x00,0x00,0xfb,0x04,0x00,0x00,0x85,0x00,0x00,0x00,0x79,0x05,0x00, /* .x...........y.. */ \
	0x00,0x79,0x00,0x00,0x00,0xc5,0x05,0x00,0x00,0x7a,0x00,0x00,0x00,0x09,0x06,0x00, /* .y.......z...... */ \
	0x00,0x7b,0x00,0x00,0x00,0x4d,0x06,0x00,0x00,0x7c,0x00,0x00,0x00,0x91,0x06,0x00, /* .{...M...|...... */ \
	0x00,0x7d,0x00,0x00,0x00,0xd5,0x06,0x00,0x00,0x7e,0x00,0x00,0x00,0x19,0x07,0x00, /* .}.......~...... */ \
	0x00,0x7f,0x00,0x00,0x00,0x5d,0x07,0x00,0x00,0x80,0x00,0x00,0x00,0xad,0x07,0x00, /* .....].......... */ \
	0x00,0x88,0x00,0x00,0x00,0x8f,0x0a,0x00,0x00,0x02,0x00,0x00,0x00,0x7e,0x69,0x6e, /* .............~in */ \
	0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c, /* c:header.inc~..< */ \
	0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22, /* div id="content" */ \
	0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x4e,0x65,0x74,0x77,0x6f,0x72,0x6b, /* >....<h1>Network */ \
	0x20,0x43,0x6f,0x6e,0x66,0x69,0x67,0x75,0x72,0x61,0x74,0x69,0x6f,0x6e,0x3c,0x2f, /*  Configuration</ */ \
	0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x66,0x6f,0x72,0x6d,0x20,0x6d,0x65,0x74, /* h1>....<form met */ \
	0x68,0x6f,0x64,0x3d,0x22,0x70,0x6f,0x73,0x74,0x22,0x20,0x61,0x63,0x74,0x69,0x6f  /* hod="post" actio */
#define DATACHUNK00000c \
	0x6e,0x3d,0x22,0x2f,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x63,0x6f,0x6e,0x66, /* n="/protect/conf */ \
	0x69,0x67,0x2e,0x68,0x74,0x6d,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x63,0x6f, /* ig.htm" name="co */ \
	0x6e,0x66,0x69,0x67,0x22,0x3e,0x0d,0x0a,0x3c,0x66,0x69,0x65,0x6c,0x64,0x73,0x65, /* nfig">..<fieldse */ \
	0x74,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e, /* t>..<div><label> */ \
	0x4d,0x41,0x43,0x20,0x41,0x64,0x64,0x72,0x65,0x73,0x73,0x3a,0x3c,0x2f,0x6c,0x61, /* MAC Address:</la */ \
	0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70, /* bel>..<input typ */ \
	0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6d, /* e="text" name="m */ \
	0x61,0x63,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x63,0x6f,0x6e,0x66, /* ac" value="~conf */ \
	0x69,0x67,0x5f,0x6d,0x61,0x63,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76, /* ig_mac~" /></div */ \
	0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x53, /* >..<div><label>S */ \
	0x65,0x72,0x76,0x65,0x72,0x20,0x4e,0x61,0x6d,0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62, /* erver Name:</lab */ \
	0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65, /* el>..<input type */ \
	0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x68,0x6f, /* ="text" name="ho */ \
	0x73,0x74,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x73,0x65,0x72,0x76, /* st" value="~serv */ \
	0x65,0x72,0x5f,0x6e,0x61,0x6d,0x65,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69, /* er_name~" /></di */ \
	0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e, /* v>..<div><label> */ \
	0x4f,0x75,0x74,0x20,0x42,0x6f,0x75,0x6e,0x64,0x20,0x50,0x6f,0x72,0x74,0x3a,0x3c, /* Out Bound Port:< */ \
	0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20, /* /label>..<input  */ \
	0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65, /* type="text" name */ \
	0x3d,0x22,0x6f,0x70,0x72,0x74,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e, /* ="oprt" value="~ */ \
	0x6f,0x75,0x74,0x5f,0x70,0x6f,0x72,0x74,0x7e,0x22,0x20,0x63,0x6c,0x61,0x73,0x73, /* out_port~" class */ \
	0x3d,0x22,0x61,0x64,0x31,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x35,0x22,0x2f, /* ="ad1" size="5"/ */ \
	0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c, /* ></div>..<div><l */ \
	0x61,0x62,0x65,0x6c,0x3e,0x49,0x6e,0x20,0x42,0x6f,0x75,0x6e,0x64,0x20,0x50,0x6f, /* abel>In Bound Po */ \
	0x72,0x74,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e, /* rt:</label>..<in */ \
	0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20, /* put type="text"  */ \
	0x6e,0x61,0x6d,0x65,0x3d,0x22,0x69,0x70,0x72,0x74,0x22,0x20,0x76,0x61,0x6c,0x75, /* name="iprt" valu */ \
	0x65,0x3d,0x22,0x7e,0x69,0x6e,0x5f,0x70,0x6f,0x72,0x74,0x7e,0x22,0x20,0x63,0x6c, /* e="~in_port~" cl */ \
	0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22, /* ass="ad1" size=" */ \
	0x35,0x22,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76, /* 5"/></div>..<div */ \
	0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x52,0x6f,0x6f,0x6d,0x20,0x4e,0x61,0x6d, /* ><label>Room Nam */ \
	0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70, /* e:</label>..<inp */ \
	0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e, /* ut type="text" n */ \
	0x61,0x6d,0x65,0x3d,0x22,0x52,0x6d,0x4e,0x6d,0x22,0x20,0x76,0x61,0x6c,0x75,0x65, /* ame="RmNm" value */ \
	0x3d,0x22,0x7e,0x52,0x6f,0x6f,0x6d,0x4e,0x61,0x6d,0x65,0x7e,0x22,0x20,0x63,0x6c, /* ="~RoomName~" cl */ \
	0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22, /* ass="ad1" size=" */ \
	0x38,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69, /* 8" /></div>..<di */ \
	0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x4e,0x6f,0x64,0x65,0x20,0x43,0x61, /* v><label>Node Ca */ \
	0x6c,0x6c,0x73,0x69,0x67,0x6e,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d, /* llsign:</label>. */ \
	0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65, /* .<input type="te */ \
	0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x4e,0x64,0x4e,0x6d,0x22,0x20, /* xt" name="NdNm"  */ \
	0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x4e,0x6f,0x64,0x65,0x4e,0x61,0x6d,0x65, /* value="~NodeName */ \
	0x7e,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x20,0x73, /* ~" class="ad1" s */ \
	0x69,0x7a,0x65,0x3d,0x22,0x38,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e, /* ize="8" /></div> */ \
	0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x4a,0x69, /* ..<div><label>Ji */ \
	0x74,0x74,0x65,0x72,0x20,0x42,0x75,0x66,0x66,0x65,0x72,0x20,0x57,0x61,0x69,0x74, /* tter Buffer Wait */ \
	0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75, /* :</label>..<inpu */ \
	0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61, /* t type="text" na */ \
	0x6d,0x65,0x3d,0x22,0x6a,0x69,0x74,0x74,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d, /* me="jitt" value= */ \
	0x22,0x7e,0x4a,0x69,0x74,0x74,0x65,0x72,0x53,0x69,0x7a,0x65,0x7e,0x22,0x20,0x73, /* "~JitterSize~" s */ \
	0x69,0x7a,0x65,0x3d,0x22,0x32,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61, /* ize="2" class="a */ \
	0x64,0x31,0x22,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69, /* d1"/></div>..<di */ \
	0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x4e,0x54,0x50,0x20,0x53,0x65,0x72, /* v><label>NTP Ser */ \
	0x76,0x65,0x72,0x20,0x4e,0x61,0x6d,0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c, /* ver Name:</label */ \
	0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62, /* >&nbsp;&nbsp;&nb */ \
	0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26, /* sp;&nbsp;&nbsp;& */ \
	0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70, /* nbsp;&nbsp;&nbsp */ \
	0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x0d,0x0a,0x3c,0x73,0x65,0x6c,0x65,0x63,0x74, /* ;&nbsp;..<select */ \
	0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6e,0x74,0x70,0x22,0x3e,0x0d,0x0a,0x3c,0x6f, /*  name="ntp">..<o */ \
	0x70,0x74,0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x70,0x6f,0x6f, /* ption value="poo */ \
	0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x22,0x3e,0x70,0x6f,0x6f,0x6c,0x2e, /* l.ntp.org">pool. */ \
	0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x0d,0x0a,0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e, /* ntp.org..<option */ \
	0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x65,0x75,0x72,0x6f,0x70,0x65,0x2e,0x70, /*  value="europe.p */ \
	0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x22,0x3e,0x65,0x75,0x72  /* ool.ntp.org">eur */
#define DATACHUNK00000d \
	0x6f,0x70,0x65,0x2e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67, /* ope.pool.ntp.org */ \
	0x0d,0x0a,0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d, /* ..<option value= */ \
	0x22,0x61,0x73,0x69,0x61,0x2e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f, /* "asia.pool.ntp.o */ \
	0x72,0x67,0x22,0x3e,0x61,0x73,0x69,0x61,0x2e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74, /* rg">asia.pool.nt */ \
	0x70,0x2e,0x6f,0x72,0x67,0x0d,0x0a,0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x20,0x76, /* p.org..<option v */ \
	0x61,0x6c,0x75,0x65,0x3d,0x22,0x6f,0x63,0x65,0x61,0x6e,0x69,0x61,0x2e,0x70,0x6f, /* alue="oceania.po */ \
	0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x22,0x3e,0x6f,0x63,0x65,0x61, /* ol.ntp.org">ocea */ \
	0x6e,0x69,0x61,0x2e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67, /* nia.pool.ntp.org */ \
	0x0d,0x0a,0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d, /* ..<option value= */ \
	0x22,0x6e,0x6f,0x72,0x74,0x68,0x2d,0x61,0x6d,0x65,0x72,0x69,0x63,0x61,0x2e,0x70, /* "north-america.p */ \
	0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x22,0x3e,0x6e,0x6f,0x72, /* ool.ntp.org">nor */ \
	0x74,0x68,0x2d,0x61,0x6d,0x65,0x72,0x69,0x63,0x61,0x2e,0x70,0x6f,0x6f,0x6c,0x2e, /* th-america.pool. */ \
	0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x0d,0x0a,0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e, /* ntp.org..<option */ \
	0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x73,0x6f,0x75,0x74,0x68,0x2d,0x61,0x6d, /*  value="south-am */ \
	0x65,0x72,0x69,0x63,0x61,0x2e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f, /* erica.pool.ntp.o */ \
	0x72,0x67,0x22,0x3e,0x73,0x6f,0x75,0x74,0x68,0x2d,0x61,0x6d,0x65,0x72,0x69,0x63, /* rg">south-americ */ \
	0x61,0x2e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x0d,0x0a, /* a.pool.ntp.org.. */ \
	0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x61, /* <option value="a */ \
	0x66,0x72,0x69,0x63,0x61,0x2e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f, /* frica.pool.ntp.o */ \
	0x72,0x67,0x22,0x3e,0x61,0x66,0x72,0x69,0x63,0x61,0x2e,0x70,0x6f,0x6f,0x6c,0x2e, /* rg">africa.pool. */ \
	0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x0d,0x0a,0x3c,0x2f,0x73,0x65,0x6c,0x65,0x63, /* ntp.org..</selec */ \
	0x74,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76, /* t>..</div>..<div */ \
	0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x54,0x69,0x6d,0x65,0x20,0x5a,0x6f,0x6e, /* ><label>Time Zon */ \
	0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70, /* e:</label>..<inp */ \
	0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e, /* ut type="text" n */ \
	0x61,0x6d,0x65,0x3d,0x22,0x7a,0x6f,0x6e,0x65,0x22,0x20,0x76,0x61,0x6c,0x75,0x65, /* ame="zone" value */ \
	0x3d,0x22,0x7e,0x54,0x69,0x6d,0x65,0x5a,0x6f,0x6e,0x65,0x7e,0x22,0x20,0x63,0x6c, /* ="~TimeZone~" cl */ \
	0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22, /* ass="ad1" size=" */ \
	0x33,0x22,0x2f,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x68,0x6f,0x75,0x72,0x73,0x26, /* 3"/>&nbsp;hours& */ \
	0x6e,0x62,0x73,0x70,0x3b,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79, /* nbsp;..<input ty */ \
	0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22, /* pe="text" name=" */ \
	0x7a,0x6e,0x65,0x4d,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x54,0x69, /* zneM" value="~Ti */ \
	0x6d,0x65,0x5a,0x6f,0x6e,0x65,0x4d,0x69,0x6e,0x75,0x74,0x65,0x73,0x7e,0x22,0x20, /* meZoneMinutes~"  */ \
	0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x33,0x22,0x20,0x73,0x69,0x7a,0x65, /* class="ad3" size */ \
	0x3d,0x22,0x32,0x22,0x2f,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x6d,0x69,0x6e,0x75, /* ="2"/>&nbsp;minu */ \
	0x74,0x65,0x73,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e, /* tes</div>..<div> */ \
	0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x52,0x46,0x20,0x52,0x65,0x70,0x65,0x74,0x65, /* <label>RF Repete */ \
	0x72,0x20,0x43,0x6f,0x6e,0x6e,0x65,0x63,0x74,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65, /* r Connect:</labe */ \
	0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d, /* l>..<input type= */ \
	0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x63,0x6c,0x61,0x73,0x73, /* "checkbox" class */ \
	0x3d,0x22,0x61,0x64,0x31,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x72,0x65,0x70, /* ="ad1" name="rep */ \
	0x74,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x31,0x22,0x20,0x20,0x7e,0x72, /* t" value="1"  ~r */ \
	0x65,0x70,0x65,0x61,0x74,0x65,0x72,0x5f,0x6f,0x6e,0x7e,0x20,0x2f,0x3e,0x3c,0x2f, /* epeater_on~ /></ */ \
	0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65, /* div>..<div><labe */ \
	0x6c,0x3e,0x41,0x63,0x63,0x65,0x73,0x73,0x20,0x43,0x6f,0x6e,0x74,0x72,0x6f,0x6c, /* l>Access Control */ \
	0x20,0x46,0x69,0x6c,0x65,0x20,0x4e,0x61,0x6d,0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62, /*  File Name:</lab */ \
	0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65, /* el>..<input type */ \
	0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x61,0x63, /* ="text" name="ac */ \
	0x74,0x6c,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x41,0x63,0x63,0x43, /* tl" value="~AccC */ \
	0x74,0x72,0x6c,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a, /* trl~" /></div>.. */ \
	0x3c,0x64,0x69,0x76,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70, /* <div>&nbsp;&nbsp */ \
	0x3b,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x0d,0x0a, /* ;</div>..<div>.. */ \
	0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65, /* <input type="che */ \
	0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x73,0x6d, /* ckbox" class="sm */ \
	0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x64,0x68,0x63,0x70,0x22,0x20,0x76,0x61, /* " name="dhcp" va */ \
	0x6c,0x75,0x65,0x3d,0x22,0x31,0x22,0x20,0x6f,0x6e,0x63,0x6c,0x69,0x63,0x6b,0x3d, /* lue="1" onclick= */ \
	0x22,0x63,0x6f,0x6e,0x66,0x69,0x67,0x49,0x50,0x42,0x6f,0x78,0x65,0x73,0x28,0x29, /* "configIPBoxes() */ \
	0x22,0x20,0x7e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x5f,0x64,0x68,0x63,0x70,0x63,0x68, /* " ~config_dhcpch */ \
	0x65,0x63,0x6b,0x65,0x64,0x7e,0x20,0x2f,0x3e,0x20,0x45,0x6e,0x61,0x62,0x6c,0x65, /* ecked~ /> Enable */ \
	0x20,0x44,0x48,0x43,0x50,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69, /*  DHCP</div>..<di */ \
	0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x49,0x50,0x20,0x41,0x64,0x64,0x72, /* v><label>IP Addr */ \
	0x65,0x73,0x73,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74, /* ess:</label>..<t */ \
	0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74, /* d><input type="t */ \
	0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x69,0x70,0x22,0x20,0x76  /* ext" name="ip" v */
#define DATACHUNK00000e \
	0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x5f,0x69,0x70, /* alue="~config_ip */ \
	0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69, /* ~" /></div>..<di */ \
	0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x47,0x61,0x74,0x65,0x77,0x61,0x79, /* v><label>Gateway */ \
	0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c, /* :</label>..<td>< */ \
	0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74, /* input type="text */ \
	0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x67,0x77,0x22,0x20,0x76,0x61,0x6c,0x75, /* " name="gw" valu */ \
	0x65,0x3d,0x22,0x7e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x5f,0x67,0x77,0x7e,0x22,0x20, /* e="~config_gw~"  */ \
	0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c, /* /></div>..<div>< */ \
	0x6c,0x61,0x62,0x65,0x6c,0x3e,0x53,0x75,0x62,0x6e,0x65,0x74,0x20,0x4d,0x61,0x73, /* label>Subnet Mas */ \
	0x6b,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e, /* k:</label>..<td> */ \
	0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78, /* <input type="tex */ \
	0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x73,0x75,0x62,0x22,0x20,0x76,0x61, /* t" name="sub" va */ \
	0x6c,0x75,0x65,0x3d,0x22,0x7e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x5f,0x73,0x75,0x62, /* lue="~config_sub */ \
	0x6e,0x65,0x74,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a, /* net~" /></div>.. */ \
	0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x50,0x72,0x69,0x6d, /* <div><label>Prim */ \
	0x61,0x72,0x79,0x20,0x44,0x4e,0x53,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e, /* ary DNS:</label> */ \
	0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70, /* ..<td><input typ */ \
	0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x64, /* e="text" name="d */ \
	0x6e,0x73,0x31,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x63,0x6f,0x6e, /* ns1" value="~con */ \
	0x66,0x69,0x67,0x5f,0x64,0x6e,0x73,0x31,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64, /* fig_dns1~" /></d */ \
	0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c, /* iv>..<div><label */ \
	0x3e,0x53,0x65,0x63,0x6f,0x6e,0x64,0x61,0x72,0x79,0x20,0x44,0x4e,0x53,0x3a,0x3c, /* >Secondary DNS:< */ \
	0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20, /* /label>..<input  */ \
	0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65, /* type="text" name */ \
	0x3d,0x22,0x64,0x6e,0x73,0x32,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e, /* ="dns2" value="~ */ \
	0x63,0x6f,0x6e,0x66,0x69,0x67,0x5f,0x64,0x6e,0x73,0x32,0x7e,0x22,0x20,0x2f,0x3e, /* config_dns2~" /> */ \
	0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x69,0x6e, /* </div>..<div><in */ \
	0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x73,0x75,0x62,0x6d,0x69,0x74, /* put type="submit */ \
	0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x73,0x6d,0x22,0x20,0x76,0x61,0x6c, /* " class="sm" val */ \
	0x75,0x65,0x3d,0x22,0x53,0x61,0x76,0x65,0x20,0x43,0x6f,0x6e,0x66,0x69,0x67,0x22, /* ue="Save Config" */ \
	0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x69,0x65, /*  /></div>..</fie */ \
	0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x6f,0x72,0x6d,0x3e,0x0d, /* ldset>..</form>. */ \
	0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69, /* .</div>....<scri */ \
	0x70,0x74,0x20,0x6c,0x61,0x6e,0x67,0x75,0x61,0x67,0x65,0x3d,0x22,0x6a,0x61,0x76, /* pt language="jav */ \
	0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d, /* ascript">..<!--. */ \
	0x0a,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x63,0x6f,0x6e,0x66,0x69,0x67, /* .function config */ \
	0x49,0x50,0x42,0x6f,0x78,0x65,0x73,0x28,0x29,0x20,0x7b,0x0d,0x0a,0x09,0x65,0x20, /* IPBoxes() {...e  */ \
	0x3d,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x66,0x6f,0x72,0x6d,0x73, /* = document.forms */ \
	0x2e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x3b,0x0d,0x0a,0x09,0x73,0x74,0x20,0x3d,0x20, /* .config;...st =  */ \
	0x65,0x2e,0x64,0x68,0x63,0x70,0x2e,0x63,0x68,0x65,0x63,0x6b,0x65,0x64,0x3b,0x0d, /* e.dhcp.checked;. */ \
	0x0a,0x09,0x65,0x2e,0x69,0x70,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20, /* ..e.ip.disabled  */ \
	0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x67,0x77,0x2e,0x64,0x69,0x73, /* = st;...e.gw.dis */ \
	0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e, /* abled = st;...e. */ \
	0x73,0x75,0x62,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73, /* sub.disabled = s */ \
	0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x64,0x6e,0x73,0x31,0x2e,0x64,0x69,0x73,0x61, /* t;...e.dns1.disa */ \
	0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x64, /* bled = st;...e.d */ \
	0x6e,0x73,0x32,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73, /* ns2.disabled = s */ \
	0x74,0x3b,0x0d,0x0a,0x7d,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e, /* t;..}..document. */ \
	0x66,0x6f,0x72,0x6d,0x73,0x2e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x2e,0x6d,0x61,0x63, /* forms.config.mac */ \
	0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x74,0x72,0x75,0x65, /* .disabled = true */ \
	0x3b,0x0d,0x0a,0x0d,0x0a,0x63,0x6f,0x6e,0x66,0x69,0x67,0x49,0x50,0x42,0x6f,0x78, /* ;....configIPBox */ \
	0x65,0x73,0x28,0x29,0x3b,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e, /* es();..document. */ \
	0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27, /* getElementById(' */ \
	0x68,0x65,0x6c,0x6c,0x6f,0x27,0x29,0x2e,0x69,0x6e,0x6e,0x65,0x72,0x48,0x54,0x4d, /* hello').innerHTM */ \
	0x4c,0x20,0x3d,0x20,0x22,0x7e,0x68,0x65,0x6c,0x6c,0x6f,0x6d,0x73,0x67,0x7e,0x22, /* L = "~hellomsg~" */ \
	0x3b,0x0d,0x0a,0x2f,0x2f,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69, /* ;..//-->..</scri */ \
	0x70,0x74,0x3e,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72, /* pt>..~inc:footer */ \
	0x2e,0x69,0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0xde,0x00,0x00, /* .inc~....3...... */ \
	0x00,0x25,0x00,0x00,0x00,0x3e,0x01,0x00,0x00,0x4a,0x00,0x00,0x00,0xa2,0x01,0x00, /* .%...>...J...... */ \
	0x00,0x4b,0x00,0x00,0x00,0x16,0x02,0x00,0x00,0x4c,0x00,0x00,0x00,0x85,0x02,0x00, /* .K.......L...... */ \
	0x00,0x4d,0x00,0x00,0x00,0xfa,0x02,0x00,0x00,0x4e,0x00,0x00,0x00,0x74,0x03,0x00, /* .M.......N...t.. */ \
	0x00,0x6e,0x00,0x00,0x00,0x05,0x06,0x00,0x00,0x61,0x00,0x00,0x00,0x60,0x06,0x00, /* .n.......a...`.. */ \
	0x00,0x6d,0x00,0x00,0x00,0x01,0x07,0x00,0x00,0x87,0x00,0x00,0x00,0x6e,0x07,0x00, /* .m...........n.. */ \
	0x00,0x5f,0x00,0x00,0x00,0xf5,0x07,0x00,0x00,0x27,0x00,0x00,0x00,0x69,0x08,0x00  /* ._.......'...i.. */
#define DATACHUNK00000f \
	0x00,0x28,0x00,0x00,0x00,0xc6,0x08,0x00,0x00,0x29,0x00,0x00,0x00,0x28,0x09,0x00, /* .(.......)...(.. */ \
	0x00,0x2a,0x00,0x00,0x00,0x8f,0x09,0x00,0x00,0x2b,0x00,0x00,0x00,0xf2,0x09,0x00, /* .........+...... */ \
	0x00,0x2c,0x00,0x00,0x00,0xc8,0x0b,0x00,0x00,0x01,0x00,0x00,0x00,0xe8,0x0b,0x00, /* .,.............. */ \
	0x00,0x02,0x00,0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72, /* .....~inc:header */ \
	0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22, /* .inc~..<div id=" */ \
	0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31, /* content">....<h1 */ \
	0x3e,0x4c,0x6f,0x67,0x69,0x6e,0x20,0x53,0x75,0x63,0x63,0x65,0x73,0x73,0x66,0x75, /* >Login Successfu */ \
	0x6c,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x59,0x6f,0x75, /* l</h1>....<p>You */ \
	0x20,0x68,0x61,0x76,0x65,0x20,0x73,0x75,0x63,0x63,0x65,0x73,0x73,0x66,0x75,0x6c, /*  have successful */ \
	0x6c,0x79,0x20,0x6c,0x6f,0x67,0x67,0x65,0x64,0x20,0x69,0x6e,0x20,0x74,0x6f,0x20, /* ly logged in to  */ \
	0x74,0x68,0x65,0x20,0x77,0x65,0x62,0x20,0x73,0x65,0x72,0x76,0x65,0x72,0x2e,0x20, /* the web server.  */ \
	0x20,0x54,0x68,0x69,0x73,0x20,0x61,0x75,0x74,0x68,0x65,0x6e,0x74,0x69,0x63,0x61, /*  This authentica */ \
	0x74,0x69,0x6f,0x6e,0x20,0x0d,0x0a,0x69,0x73,0x20,0x76,0x61,0x6c,0x69,0x64,0x20, /* tion ..is valid  */ \
	0x75,0x6e,0x74,0x69,0x6c,0x20,0x79,0x6f,0x75,0x20,0x63,0x6c,0x6f,0x73,0x65,0x20, /* until you close  */ \
	0x79,0x6f,0x75,0x72,0x20,0x62,0x72,0x6f,0x77,0x73,0x65,0x72,0x2e,0x3c,0x2f,0x70, /* your browser.</p */ \
	0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x43,0x72,0x65,0x64,0x65,0x6e,0x74,0x69, /* >....<p>Credenti */ \
	0x61,0x6c,0x73,0x20,0x61,0x72,0x65,0x20,0x76,0x65,0x72,0x69,0x66,0x69,0x65,0x64, /* als are verified */ \
	0x20,0x69,0x6e,0x20,0x79,0x6f,0x75,0x72,0x20,0x6f,0x77,0x6e,0x20,0x63,0x75,0x73, /*  in your own cus */ \
	0x74,0x6f,0x6d,0x20,0x63,0x61,0x6c,0x6c,0x62,0x61,0x63,0x6b,0x20,0x66,0x75,0x6e, /* tom callback fun */ \
	0x63,0x74,0x69,0x6f,0x6e,0x20,0x63,0x61,0x6c,0x6c,0x65,0x64,0x20,0x0d,0x0a,0x3c, /* ction called ..< */ \
	0x63,0x6f,0x64,0x65,0x3e,0x48,0x54,0x54,0x50,0x41,0x75,0x74,0x68,0x65,0x6e,0x74, /* code>HTTPAuthent */ \
	0x69,0x63,0x61,0x74,0x65,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x2e,0x20,0x20,0x49, /* icate</code>.  I */ \
	0x6e,0x20,0x68,0x65,0x72,0x65,0x2c,0x20,0x79,0x6f,0x75,0x20,0x63,0x61,0x6e,0x20, /* n here, you can  */ \
	0x64,0x65,0x74,0x65,0x72,0x6d,0x69,0x6e,0x65,0x20,0x69,0x66,0x20,0x74,0x68,0x65, /* determine if the */ \
	0x20,0x73,0x75,0x70,0x70,0x6c,0x69,0x65,0x64,0x0d,0x0a,0x75,0x73,0x65,0x72,0x20, /*  supplied..user  */ \
	0x6e,0x61,0x6d,0x65,0x20,0x61,0x6e,0x64,0x20,0x70,0x61,0x73,0x73,0x77,0x6f,0x72, /* name and passwor */ \
	0x64,0x20,0x61,0x72,0x65,0x20,0x76,0x61,0x6c,0x69,0x64,0x20,0x66,0x6f,0x72,0x20, /* d are valid for  */ \
	0x61,0x63,0x63,0x65,0x73,0x73,0x20,0x74,0x6f,0x20,0x74,0x68,0x65,0x20,0x72,0x65, /* access to the re */ \
	0x71,0x75,0x65,0x73,0x74,0x65,0x64,0x20,0x70,0x61,0x67,0x65,0x2e,0x20,0x20,0x59, /* quested page.  Y */ \
	0x6f,0x75,0x20,0x63,0x61,0x6e,0x20,0x0d,0x0a,0x61,0x64,0x64,0x20,0x6d,0x75,0x6c, /* ou can ..add mul */ \
	0x74,0x69,0x70,0x6c,0x65,0x20,0x75,0x73,0x65,0x72,0x73,0x20,0x61,0x6e,0x64,0x20, /* tiple users and  */ \
	0x72,0x65,0x73,0x74,0x72,0x69,0x63,0x74,0x20,0x64,0x69,0x66,0x66,0x65,0x72,0x65, /* restrict differe */ \
	0x6e,0x74,0x20,0x75,0x73,0x65,0x72,0x73,0x20,0x74,0x6f,0x20,0x64,0x69,0x66,0x66, /* nt users to diff */ \
	0x65,0x72,0x65,0x6e,0x74,0x20,0x70,0x61,0x67,0x65,0x73,0x2e,0x3c,0x2f,0x70,0x3e, /* erent pages.</p> */ \
	0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x65,0x78, /* ....<p class="ex */ \
	0x65,0x72,0x63,0x69,0x73,0x65,0x22,0x3e,0x3c,0x62,0x3e,0x45,0x78,0x65,0x72,0x63, /* ercise"><b>Exerc */ \
	0x69,0x73,0x65,0x3a,0x3c,0x2f,0x62,0x3e,0x20,0x43,0x68,0x61,0x6e,0x67,0x65,0x20, /* ise:</b> Change  */ \
	0x74,0x68,0x65,0x20,0x75,0x73,0x65,0x72,0x20,0x6e,0x61,0x6d,0x65,0x20,0x61,0x6e, /* the user name an */ \
	0x64,0x20,0x70,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x20,0x69,0x6e,0x0d,0x0a,0x3c, /* d password in..< */ \
	0x63,0x6f,0x64,0x65,0x3e,0x48,0x54,0x54,0x50,0x41,0x75,0x74,0x68,0x65,0x6e,0x74, /* code>HTTPAuthent */ \
	0x69,0x63,0x61,0x74,0x65,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x20,0x74,0x6f,0x20, /* icate</code> to  */ \
	0x6f,0x6e,0x65,0x20,0x6f,0x66,0x20,0x79,0x6f,0x75,0x72,0x20,0x63,0x68,0x6f,0x6f, /* one of your choo */ \
	0x73,0x69,0x6e,0x67,0x2e,0x20,0x20,0x28,0x54,0x68,0x65,0x20,0x63,0x61,0x6c,0x6c, /* sing.  (The call */ \
	0x62,0x61,0x63,0x6b,0x20,0x69,0x73,0x20,0x0d,0x0a,0x6c,0x6f,0x63,0x61,0x74,0x65, /* back is ..locate */ \
	0x64,0x20,0x69,0x6e,0x20,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x43,0x75,0x73,0x74,0x6f, /* d in <code>Custo */ \
	0x6d,0x48,0x54,0x54,0x50,0x41,0x70,0x70,0x2e,0x63,0x3c,0x2f,0x63,0x6f,0x64,0x65, /* mHTTPApp.c</code */ \
	0x3e,0x2e,0x29,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20, /* >.)</p>....<div  */ \
	0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x65,0x78,0x61,0x6d,0x70,0x6c,0x65,0x62,0x6f, /* class="examplebo */ \
	0x78,0x22,0x3e,0x0d,0x0a,0x57,0x68,0x65,0x6e,0x20,0x79,0x6f,0x75,0x20,0x66,0x69, /* x">..When you fi */ \
	0x6e,0x69,0x73,0x68,0x2c,0x20,0x72,0x65,0x66,0x72,0x65,0x73,0x68,0x20,0x74,0x68, /* nish, refresh th */ \
	0x69,0x73,0x20,0x70,0x61,0x67,0x65,0x20,0x74,0x6f,0x20,0x74,0x65,0x73,0x74,0x20, /* is page to test  */ \
	0x79,0x6f,0x75,0x72,0x20,0x6e,0x65,0x77,0x20,0x75,0x73,0x65,0x72,0x20,0x6e,0x61, /* your new user na */ \
	0x6d,0x65,0x20,0x61,0x6e,0x64,0x20,0x70,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x20, /* me and password  */ \
	0x0d,0x0a,0x63,0x6f,0x6d,0x62,0x69,0x6e,0x61,0x74,0x69,0x6f,0x6e,0x2e,0x0d,0x0a, /* ..combination... */ \
	0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e, /* </div>....</div> */ \
	0x0d,0x0a,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x74,0x79,0x70,0x65, /* ....<script type */ \
	0x3d,0x22,0x74,0x65,0x78,0x74,0x2f,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70, /* ="text/javascrip */ \
	0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d, /* t">..<!--..docum */ \
	0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79, /* ent.getElementBy */ \
	0x49,0x64,0x28,0x27,0x68,0x65,0x6c,0x6c,0x6f,0x27,0x29,0x2e,0x69,0x6e,0x6e,0x65, /* Id('hello').inne */ \
	0x72,0x48,0x54,0x4d,0x4c,0x20,0x3d,0x20,0x22,0x7e,0x68,0x65,0x6c,0x6c,0x6f,0x6d, /* rHTML = "~hellom */ \
	0x73,0x67,0x7e,0x22,0x3b,0x0d,0x0a,0x2f,0x2f,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f, /* sg~";..//-->..</ */ \
	0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a, /* script>....~inc: */ \
	0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33  /* footer.inc~....3 */
#define DATACHUNK000010 \
	0x00,0x00,0x00,0x94,0x03,0x00,0x00,0x01,0x00,0x00,0x00,0xb6,0x03,0x00,0x00,0x02, /* ................ */ \
	0x00,0x00,0x00,0x7e,0x72,0x65,0x62,0x6f,0x6f,0x74,0x7e,0x00,0x00,0x00,0x00,0x2d, /* ...~reboot~....- */ \
	0x00,0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69, /* ...~inc:header.i */ \
	0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f, /* nc~..<div id="co */ \
	0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x52, /* ntent">....<h1>R */ \
	0x65,0x62,0x6f,0x6f,0x74,0x20,0x49,0x6e,0x20,0x50,0x72,0x6f,0x67,0x72,0x65,0x73, /* eboot In Progres */ \
	0x73,0x2e,0x2e,0x2e,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e, /* s...</h1>....<p> */ \
	0x59,0x6f,0x75,0x72,0x20,0x73,0x65,0x74,0x74,0x69,0x6e,0x67,0x73,0x20,0x77,0x65, /* Your settings we */ \
	0x72,0x65,0x20,0x73,0x75,0x63,0x63,0x65,0x73,0x73,0x66,0x75,0x6c,0x6c,0x79,0x20, /* re successfully  */ \
	0x73,0x61,0x76,0x65,0x64,0x2c,0x20,0x61,0x6e,0x64,0x20,0x74,0x68,0x65,0x20,0x62, /* saved, and the b */ \
	0x6f,0x61,0x72,0x64,0x20,0x69,0x73,0x20,0x6e,0x6f,0x77,0x20,0x72,0x65,0x62,0x6f, /* oard is now rebo */ \
	0x6f,0x74,0x69,0x6e,0x67,0x20,0x0d,0x0a,0x74,0x6f,0x20,0x63,0x6f,0x6e,0x66,0x69, /* oting ..to confi */ \
	0x67,0x75,0x72,0x65,0x20,0x69,0x74,0x73,0x65,0x6c,0x66,0x20,0x77,0x69,0x74,0x68, /* gure itself with */ \
	0x20,0x74,0x68,0x65,0x20,0x6e,0x65,0x77,0x20,0x73,0x65,0x74,0x74,0x69,0x6e,0x67, /*  the new setting */ \
	0x73,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x36,0x3e,0x3c,0x2f, /* s.</p>....<h6></ */ \
	0x68,0x36,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d, /* h6>....</div>... */ \
	0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x6c,0x61,0x6e,0x67,0x75,0x61,0x67, /* .<script languag */ \
	0x65,0x3d,0x22,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d, /* e="javascript">. */ \
	0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20, /* .<!--..function  */ \
	0x72,0x65,0x62,0x6f,0x6f,0x74,0x44,0x75,0x6d,0x6d,0x79,0x28,0x78,0x29,0x7b,0x7d, /* rebootDummy(x){} */ \
	0x0d,0x0a,0x73,0x65,0x74,0x54,0x69,0x6d,0x65,0x6f,0x75,0x74,0x28,0x22,0x6e,0x65, /* ..setTimeout("ne */ \
	0x77,0x41,0x4a,0x41,0x58,0x43,0x6f,0x6d,0x6d,0x61,0x6e,0x64,0x28,0x27,0x2f,0x70, /* wAJAXCommand('/p */ \
	0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x72,0x65,0x62,0x6f,0x6f,0x74,0x2e,0x63,0x67, /* rotect/reboot.cg */ \
	0x69,0x27,0x2c,0x72,0x65,0x62,0x6f,0x6f,0x74,0x44,0x75,0x6d,0x6d,0x79,0x2c,0x66, /* i',rebootDummy,f */ \
	0x61,0x6c,0x73,0x65,0x29,0x3b,0x22,0x2c,0x35,0x30,0x30,0x29,0x3b,0x0d,0x0a,0x2f, /* alse);",500);../ */ \
	0x2f,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d, /* /-->..</script>. */ \
	0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63, /* .~inc:footer.inc */ \
	0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0x7e,0x01,0x00,0x00,0x02,0x00,0x00, /* ~....3...~...... */ \
	0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63, /* .~inc:header.inc */ \
	0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74, /* ~..<div id="cont */ \
	0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x55,0x73,0x65, /* ent">....<h1>Use */ \
	0x72,0x20,0x49,0x44,0x20,0x61,0x6e,0x64,0x20,0x50,0x61,0x73,0x73,0x77,0x6f,0x72, /* r ID and Passwor */ \
	0x64,0x20,0x53,0x65,0x74,0x74,0x69,0x6e,0x67,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a, /* d Setting</h1>.. */ \
	0x0d,0x0a,0x3c,0x66,0x6f,0x72,0x6d,0x20,0x6d,0x65,0x74,0x68,0x6f,0x64,0x3d,0x22, /* ..<form method=" */ \
	0x70,0x6f,0x73,0x74,0x22,0x20,0x61,0x63,0x74,0x69,0x6f,0x6e,0x3d,0x22,0x2f,0x70, /* post" action="/p */ \
	0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x75,0x73,0x65,0x72,0x2e,0x68,0x74,0x6d,0x22, /* rotect/user.htm" */ \
	0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x75,0x73,0x65,0x72,0x22,0x3e,0x0d,0x0a,0x3c, /*  name="user">..< */ \
	0x66,0x69,0x65,0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e, /* fieldset>..<div> */ \
	0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x55,0x73,0x65,0x72,0x20,0x49,0x44,0x3a,0x3c, /* <label>User ID:< */ \
	0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20, /* /label>..<input  */ \
	0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65, /* type="text" name */ \
	0x3d,0x22,0x75,0x73,0x65,0x72,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e, /* ="user" value="~ */ \
	0x75,0x73,0x65,0x72,0x5f,0x69,0x64,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69, /* user_id~" /></di */ \
	0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e, /* v>..<div><label> */ \
	0x50,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c, /* Password:</label */ \
	0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22, /* >..<input type=" */ \
	0x70,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22, /* password" name=" */ \
	0x70,0x77,0x64,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x75,0x73,0x65, /* pwd" value="~use */ \
	0x72,0x5f,0x70,0x61,0x73,0x73,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76, /* r_pass~" /></div */ \
	0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x50, /* >..<div><label>P */ \
	0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e, /* assword:</label> */ \
	0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x70, /* ..<input type="p */ \
	0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x70, /* assword" name="p */ \
	0x77,0x64,0x43,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x75,0x73,0x65, /* wdC" value="~use */ \
	0x72,0x5f,0x70,0x61,0x73,0x73,0x43,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69, /* r_passC~" /></di */ \
	0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20, /* v>..<div><input  */ \
	0x74,0x79,0x70,0x65,0x3d,0x22,0x62,0x75,0x74,0x74,0x6f,0x6e,0x22,0x20,0x20,0x6f, /* type="button"  o */ \
	0x6e,0x43,0x6c,0x69,0x63,0x6b,0x3d,0x22,0x70,0x61,0x73,0x73,0x77,0x6f,0x72,0x64, /* nClick="password */ \
	0x43,0x68,0x65,0x63,0x6b,0x28,0x29,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22, /* Check()" class=" */ \
	0x61,0x64,0x31,0x62,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x53,0x61,0x76, /* ad1b" value="Sav */ \
	0x65,0x20,0x49,0x44,0x20,0x26,0x20,0x50,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x22, /* e ID & Password" */ \
	0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x69,0x65,0x6c, /* /></div>..</fiel */ \
	0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x6f,0x72,0x6d,0x3e,0x0d,0x0a, /* dset>..</form>.. */ \
	0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70  /* </div>....<scrip */
#define DATACHUNK000011 \
	0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x2f,0x6a,0x61,0x76, /* t type="text/jav */ \
	0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d, /* ascript">..<!--. */ \
	0x0a,0x2f,0x2f,0x2d,0x2d,0x3e,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74, /* .//-->..document */ \
	0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28, /* .getElementById( */ \
	0x27,0x68,0x65,0x6c,0x6c,0x6f,0x27,0x29,0x2e,0x69,0x6e,0x6e,0x65,0x72,0x48,0x54, /* 'hello').innerHT */ \
	0x4d,0x4c,0x20,0x3d,0x20,0x22,0x7e,0x68,0x65,0x6c,0x6c,0x6f,0x6d,0x73,0x67,0x7e, /* ML = "~hellomsg~ */ \
	0x22,0x3b,0x0d,0x0a,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x70,0x61,0x73, /* ";..function pas */ \
	0x73,0x77,0x6f,0x72,0x64,0x43,0x68,0x65,0x63,0x6b,0x28,0x29,0x0d,0x0a,0x7b,0x0d, /* swordCheck()..{. */ \
	0x0a,0x09,0x69,0x66,0x20,0x28,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x75, /* ..if (document.u */ \
	0x73,0x65,0x72,0x2e,0x70,0x77,0x64,0x2e,0x76,0x61,0x6c,0x75,0x65,0x20,0x21,0x3d, /* ser.pwd.value != */ \
	0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x75,0x73,0x65,0x72,0x2e,0x70, /*  document.user.p */ \
	0x77,0x64,0x43,0x2e,0x76,0x61,0x6c,0x75,0x65,0x29,0x0d,0x0a,0x09,0x7b,0x0d,0x0a, /* wdC.value)...{.. */ \
	0x09,0x09,0x61,0x6c,0x65,0x72,0x74,0x20,0x28,0x22,0x50,0x61,0x73,0x73,0x77,0x6f, /* ..alert ("Passwo */ \
	0x72,0x64,0x20,0x6d,0x69,0x73,0x73,0x6d,0x61,0x74,0x63,0x68,0x21,0x22,0x29,0x3b, /* rd missmatch!"); */ \
	0x0d,0x0a,0x09,0x09,0x72,0x65,0x74,0x75,0x72,0x6e,0x3b,0x0d,0x0a,0x09,0x7d,0x0d, /* ....return;...}. */ \
	0x0a,0x09,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x75,0x73,0x65,0x72,0x2e, /* ..document.user. */ \
	0x73,0x75,0x62,0x6d,0x69,0x74,0x28,0x29,0x3b,0x0d,0x0a,0x0d,0x0a,0x7d,0x0d,0x0a, /* submit();....}.. */ \
	0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a,0x0d,0x0a,0x7e,0x69,0x6e, /* </script>....~in */ \
	0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x00,0x00,0x00, /* c:footer.inc~... */ \
	0x00,0x33,0x00,0x00,0x00,0xde,0x00,0x00,0x00,0x6a,0x00,0x00,0x00,0x3b,0x01,0x00, /* .3.......j...;.. */ \
	0x00,0x6b,0x00,0x00,0x00,0x9b,0x01,0x00,0x00,0x6c,0x00,0x00,0x00,0x95,0x02,0x00, /* .k.......l...... */ \
	0x00,0x01,0x00,0x00,0x00,0x5c,0x03,0x00,0x00,0x02,0x00,0x00,0x00                 /* .....\.......    */


/**************************************
 * MPFS2 C linkable symbols
 **************************************/
// For C18, these are split into seperate arrays because it speeds up compilation a lot.  
// For other compilers, the entire data array must be defined as a single variable to 
// ensure that the linker does not reorder the data chunks in Flash when compiler 
// optimizations are turned on.
#if defined(__18CXX)
	ROM BYTE MPFS_Start[] = {DATACHUNK000000};
	ROM BYTE MPFS_000001[] = {DATACHUNK000001};
	ROM BYTE MPFS_000002[] = {DATACHUNK000002};
	ROM BYTE MPFS_000003[] = {DATACHUNK000003};
	ROM BYTE MPFS_000004[] = {DATACHUNK000004};
	ROM BYTE MPFS_000005[] = {DATACHUNK000005};
	ROM BYTE MPFS_000006[] = {DATACHUNK000006};
	ROM BYTE MPFS_000007[] = {DATACHUNK000007};
	ROM BYTE MPFS_000008[] = {DATACHUNK000008};
	ROM BYTE MPFS_000009[] = {DATACHUNK000009};
	ROM BYTE MPFS_00000a[] = {DATACHUNK00000a};
	ROM BYTE MPFS_00000b[] = {DATACHUNK00000b};
	ROM BYTE MPFS_00000c[] = {DATACHUNK00000c};
	ROM BYTE MPFS_00000d[] = {DATACHUNK00000d};
	ROM BYTE MPFS_00000e[] = {DATACHUNK00000e};
	ROM BYTE MPFS_00000f[] = {DATACHUNK00000f};
	ROM BYTE MPFS_000010[] = {DATACHUNK000010};
	ROM BYTE MPFS_000011[] = {DATACHUNK000011};
#else
	ROM BYTE MPFS_Start[] = {DATACHUNK000000, DATACHUNK000001, DATACHUNK000002, DATACHUNK000003, DATACHUNK000004, DATACHUNK000005, DATACHUNK000006, DATACHUNK000007, DATACHUNK000008, DATACHUNK000009, DATACHUNK00000a, DATACHUNK00000b, DATACHUNK00000c, DATACHUNK00000d, DATACHUNK00000e, DATACHUNK00000f, DATACHUNK000010, DATACHUNK000011};
#endif


/**************************************************************
 * End of MPFS
 **************************************************************/
#endif // #if defined(STACK_USE_MPFS2)
#endif // #if !defined(MPFS_USE_EEPROM) && !defined(MPFS_USE_SPI_FLASH)
