/*
 * Decompiled with CFR 0.152.
 */
package jdd.bdd.debug;

import jdd.bdd.CacheBase;
import jdd.util.Allocator;
import jdd.util.Array;
import jdd.util.Configuration;
import jdd.util.JDDConsole;
import jdd.util.math.Digits;

public final class RandomCache
extends CacheBase {
    private int[] in1;
    private int[] in2;
    private int[] in3;
    private int[] out;
    public int answer;
    public int hash_value;
    private int togo;
    private int p1;
    private int p2;
    private int p3;
    private int cache_bits;
    private int shift_bits;
    private int cache_size;
    private int cache_mask;
    private int bdds;
    private int num_clears;
    private int num_grows;
    private long num_access;
    private long hit;
    private long miss;
    private long last_hit;
    private long last_access;

    public RandomCache(String string, int n, int n2, int n3) {
        super(string);
        this.bdds = n3;
        this.cache_bits = n < 32 ? 5 : Digits.closest_log2(n);
        this.shift_bits = 32 - this.cache_bits;
        this.cache_size = 1 << this.cache_bits;
        this.cache_mask = this.cache_size - 1;
        this.num_grows = 0;
        this.num_access = 0L;
        this.last_access = 0L;
        this.last_hit = 0L;
        this.miss = 0L;
        this.hit = 0L;
        this.num_clears = 0;
        this.in1 = Allocator.allocateIntArray(this.cache_size);
        this.in2 = n2 >= 2 ? Allocator.allocateIntArray(this.cache_size) : null;
        this.in3 = n2 >= 3 ? Allocator.allocateIntArray(this.cache_size) : null;
        this.out = Allocator.allocateIntArray(this.cache_size);
        Array.set(this.in1, -1);
        this.update();
    }

    private void hash_check() {
        --this.togo;
        if (this.togo < 0) {
            this.update();
        }
    }

    private void update() {
        this.togo = 500000;
        this.p1 = (int)(1.0E7 * Math.random());
        this.p2 = (int)(1.0E7 * Math.random());
        this.p3 = (int)(1.0E7 * Math.random());
        JDDConsole.out.println("hash update:" + this.p1 + "/" + this.p2 + "/" + this.p3);
    }

    public int getSize() {
        return this.cache_size;
    }

    private boolean may_grow() {
        if (this.num_grows < Configuration.maxSimplecacheGrows) {
            long l = this.num_access - this.last_access;
            if (l * 100L < (long)(this.cache_size * Configuration.minSimplecacheAccessToGrow)) {
                return false;
            }
            int n = (int)((double)(this.hit - this.last_hit) * 100.0 / (double)l);
            if (n > Configuration.minSimplecacheHitrateToGrow) {
                this.last_hit = this.hit;
                this.last_access = this.num_access;
                ++this.num_grows;
                return true;
            }
        }
        return false;
    }

    public void invalidate_cache() {
        Array.set(this.in1, -1);
        ++this.num_clears;
    }

    public void free_or_grow() {
        if (this.may_grow()) {
            this.grow_and_invalidate_cache();
        } else {
            this.invalidate_cache();
        }
    }

    private void grow_and_invalidate_cache() {
        ++this.cache_bits;
        --this.shift_bits;
        this.cache_size = 1 << this.cache_bits;
        this.cache_mask = this.cache_size - 1;
        this.in1 = null;
        this.in1 = Allocator.allocateIntArray(this.cache_size);
        this.out = null;
        this.out = Allocator.allocateIntArray(this.cache_size);
        if (this.in2 != null) {
            this.in2 = null;
            this.in2 = Allocator.allocateIntArray(this.cache_size);
        }
        if (this.in3 != null) {
            this.in3 = null;
            this.in3 = Allocator.allocateIntArray(this.cache_size);
        }
        Array.set(this.in1, -1);
        ++this.num_clears;
    }

    public void free_or_grow(int[] nArray) {
        if (this.may_grow()) {
            this.grow_and_invalidate_cache();
        } else {
            this.invalidate_cache(nArray);
        }
    }

    public void invalidate_cache(int[] nArray) {
        this.invalidate_cache();
    }

    public void insert(int n, int n2, int n3) {
        this.in1[n] = n2;
        this.out[n] = n3;
    }

    public void insert(int n, int n2, int n3, int n4) {
        this.in1[n] = n2;
        this.in2[n] = n3;
        this.out[n] = n4;
    }

    public void insert(int n, int n2, int n3, int n4, int n5) {
        this.in1[n] = n2;
        this.in2[n] = n3;
        this.in3[n] = n4;
        this.out[n] = n5;
    }

    void add(int n, int n2) {
        this.insert(this.good_hash(n), n, n2);
    }

    void add(int n, int n2, int n3) {
        this.insert(this.good_hash(n, n2), n, n2, n3);
    }

    void add(int n, int n2, int n3, int n4) {
        this.insert(this.good_hash(n, n2, n3), n, n2, n3, n4);
    }

    public final boolean lookup(int n) {
        this.hash_check();
        ++this.num_access;
        int n2 = n & this.cache_mask;
        if (this.in1[n2] == n) {
            ++this.hit;
            this.answer = this.out[n2];
            return true;
        }
        ++this.miss;
        this.hash_value = n2;
        return false;
    }

    public final boolean lookup(int n, int n2) {
        this.hash_check();
        ++this.num_access;
        int n3 = this.good_hash(n, n2);
        if (this.in1[n3] == n && this.in2[n3] == n2) {
            ++this.hit;
            this.answer = this.out[n3];
            return true;
        }
        ++this.miss;
        this.hash_value = n3;
        return false;
    }

    public final boolean lookup(int n, int n2, int n3) {
        this.hash_check();
        ++this.num_access;
        int n4 = this.good_hash(n, n2, n3);
        if (this.in1[n4] == n && this.in2[n4] == n2 && this.in3[n4] == n3) {
            ++this.hit;
            this.answer = this.out[n4];
            return true;
        }
        ++this.miss;
        this.hash_value = n4;
        return false;
    }

    private final int good_hash(int n) {
        return n * this.p1 & this.cache_mask;
    }

    private final int good_hash(int n, int n2) {
        return n * this.p1 + n2 * this.p2 >>> this.shift_bits & this.cache_mask;
    }

    private final int good_hash(int n, int n2, int n3) {
        return n * this.p1 + n2 * this.p2 + n3 * this.p3 & this.cache_mask;
    }

    @Override
    public double computeLoadFactor() {
        if (this.in1 == null) {
            return 0.0;
        }
        int n = 0;
        for (int i = 0; i < this.cache_size; ++i) {
            if (this.in1[i] == -1) continue;
            ++n;
        }
        return (double)(n * 10000 / this.cache_size) / 100.0;
    }

    @Override
    public double computeHitRate() {
        if (this.num_access == 0L) {
            return 0.0;
        }
        return (double)((int)(this.hit * 10000L / this.num_access)) / 100.0;
    }

    @Override
    public long getAccessCount() {
        return this.num_access;
    }

    @Override
    public int getCacheSize() {
        return this.cache_size;
    }

    @Override
    public int getNumberOfClears() {
        return this.num_clears;
    }

    @Override
    public int getNumberOfPartialClears() {
        return 0;
    }

    @Override
    public int getNumberOfGrows() {
        return this.num_grows;
    }

    public void showStats() {
        if (this.num_access != 0L) {
            JDDConsole.out.print(this.getName() + "-cache ");
            JDDConsole.out.print("ld=" + this.computeLoadFactor() + "% ");
            JDDConsole.out.print("sz=");
            Digits.printNumber(this.cache_size);
            JDDConsole.out.print("accs=");
            Digits.printNumber(this.num_access);
            JDDConsole.out.print("clrs=" + this.num_clears + "/0 ");
            JDDConsole.out.print("hitr=" + this.computeHitRate() + "% ");
            if (this.num_grows > 0) {
                JDDConsole.out.print("grws=" + this.num_grows + " ");
            }
            JDDConsole.out.println();
        }
    }

    public void check_cache(int[] nArray) {
        for (int i = 0; i < this.cache_size; ++i) {
            if (this.in1[i] == -1 || nArray[this.out[i]] != -1) continue;
            JDDConsole.out.println("Invalied cache entry at position " + i);
            JDDConsole.out.println("" + i + " --> " + this.in1[i] + "/" + this.out[i]);
            this.showStats();
            System.exit(20);
        }
    }
}

