/*
 * Decompiled with CFR 0.152.
 */
package jdd.des.petrinets.interactive;

import java.util.Enumeration;
import java.util.Vector;
import jdd.des.petrinets.interactive.IPlace;
import jdd.des.petrinets.interactive.ITransition;
import jdd.util.JDDConsole;
import jdd.util.Test;

public class IPetrinet {
    public Vector places = new Vector();
    public Vector transitions = new Vector();

    public IPlace getPlaceByName(String string) {
        Enumeration enumeration = this.places.elements();
        while (enumeration.hasMoreElements()) {
            IPlace iPlace = (IPlace)enumeration.nextElement();
            if (!iPlace.name.equals(string)) continue;
            return iPlace;
        }
        return null;
    }

    public ITransition getTransitionByName(String string) {
        Enumeration enumeration = this.transitions.elements();
        while (enumeration.hasMoreElements()) {
            ITransition iTransition = (ITransition)enumeration.nextElement();
            if (!iTransition.name.equals(string)) continue;
            return iTransition;
        }
        return null;
    }

    public void add(IPlace iPlace) {
        IPlace iPlace2 = this.getPlaceByName(iPlace.name);
        if (iPlace2 == null) {
            this.places.add(iPlace);
        }
    }

    public void remove(IPlace iPlace) {
        ITransition iTransition;
        Enumeration enumeration = iPlace.incoming.elements();
        while (enumeration.hasMoreElements()) {
            iTransition = (ITransition)enumeration.nextElement();
            iTransition.outgoing.remove(iPlace);
        }
        enumeration = iPlace.outgoing.elements();
        while (enumeration.hasMoreElements()) {
            iTransition = (ITransition)enumeration.nextElement();
            iTransition.incoming.remove(iPlace);
        }
        iPlace.incoming.removeAllElements();
        iPlace.outgoing.removeAllElements();
        this.places.remove(iPlace);
    }

    public void add(ITransition iTransition) {
        ITransition iTransition2 = this.getTransitionByName(iTransition.name);
        if (iTransition2 == null) {
            this.transitions.add(iTransition);
        }
    }

    public void remove(ITransition iTransition) {
        IPlace iPlace;
        Enumeration enumeration = iTransition.incoming.elements();
        while (enumeration.hasMoreElements()) {
            iPlace = (IPlace)enumeration.nextElement();
            iPlace.outgoing.remove(iTransition);
        }
        enumeration = iTransition.outgoing.elements();
        while (enumeration.hasMoreElements()) {
            iPlace = (IPlace)enumeration.nextElement();
            iPlace.incoming.remove(iTransition);
        }
        iTransition.incoming.removeAllElements();
        iTransition.outgoing.removeAllElements();
        this.transitions.remove(iTransition);
    }

    public void add(IPlace iPlace, ITransition iTransition) {
        IPlace iPlace2 = this.getPlaceByName(iPlace.name);
        if (iPlace2 == null) {
            this.places.add(iPlace);
        } else {
            iPlace = iPlace2;
        }
        ITransition iTransition2 = this.getTransitionByName(iTransition.name);
        if (iTransition2 == null) {
            this.transitions.add(iTransition);
        } else {
            iTransition = iTransition2;
        }
        iPlace.outgoing.remove(iTransition);
        iPlace.outgoing.add(iTransition);
        iTransition.incoming.remove(iPlace);
        iTransition.incoming.add(iPlace);
    }

    public void add(ITransition iTransition, IPlace iPlace) {
        IPlace iPlace2 = this.getPlaceByName(iPlace.name);
        if (iPlace2 == null) {
            this.places.add(iPlace);
        } else {
            iPlace = iPlace2;
        }
        ITransition iTransition2 = this.getTransitionByName(iTransition.name);
        if (iTransition2 == null) {
            this.transitions.add(iTransition);
        } else {
            iTransition = iTransition2;
        }
        iPlace.incoming.remove(iTransition);
        iPlace.incoming.add(iTransition);
        iTransition.outgoing.remove(iPlace);
        iTransition.outgoing.add(iPlace);
    }

    public Vector getPlaces() {
        return this.places;
    }

    public Vector getTransitions() {
        return this.transitions;
    }

    public void show() {
        JDDConsole.out.print("\nPlaces: ");
        Enumeration enumeration = this.places.elements();
        while (enumeration.hasMoreElements()) {
            JDDConsole.out.print(" " + enumeration.nextElement());
        }
        JDDConsole.out.println();
        JDDConsole.out.print("Transitions: ");
        enumeration = this.transitions.elements();
        while (enumeration.hasMoreElements()) {
            JDDConsole.out.print(" " + enumeration.nextElement());
        }
        JDDConsole.out.println();
        enumeration = this.transitions.elements();
        while (enumeration.hasMoreElements()) {
            ITransition iTransition = (ITransition)enumeration.nextElement();
            JDDConsole.out.print(iTransition + ":");
            Enumeration enumeration2 = iTransition.incoming.elements();
            while (enumeration2.hasMoreElements()) {
                JDDConsole.out.print(" " + ((IPlace)enumeration2.nextElement()).name);
            }
            JDDConsole.out.print(" :");
            enumeration2 = iTransition.outgoing.elements();
            while (enumeration2.hasMoreElements()) {
                JDDConsole.out.print(" " + ((IPlace)enumeration2.nextElement()).name);
            }
            JDDConsole.out.println();
        }
    }

    public static void internal_test() {
        Test.start("IPetrinet");
        IPetrinet iPetrinet = new IPetrinet();
        ITransition iTransition = new ITransition("t1");
        ITransition iTransition2 = new ITransition("t2");
        IPlace iPlace = new IPlace("p1", 1);
        IPlace iPlace2 = new IPlace("p2", 0);
        IPlace iPlace3 = new IPlace("p3", 0);
        iPetrinet.add(iTransition);
        iPetrinet.add(iTransition);
        iPetrinet.add(iTransition2);
        iPetrinet.add(iPlace);
        iPetrinet.add(iPlace);
        iPetrinet.add(iPlace2);
        iPetrinet.add(iPlace2);
        iPetrinet.add(iPlace3);
        iPetrinet.add(iPlace, iTransition);
        iPetrinet.add(iTransition, iPlace2);
        iPetrinet.add(iPlace2, iTransition2);
        iPetrinet.add(iTransition2, iPlace3);
        Test.checkEquality(iPetrinet.places.size(), 3, "3 places");
        Test.checkEquality(iPetrinet.transitions.size(), 2, "2 transitions");
        iPetrinet.remove(iPlace2);
        Test.checkEquality(iPetrinet.places.size(), 2, "3-1 places");
        iPetrinet.remove(iTransition2);
        Test.checkEquality(iPetrinet.transitions.size(), 1, "2-1 transitions");
        Test.end();
    }
}

