/*
 * Decompiled with CFR 0.152.
 */
package jdd.bdd.sets;

import jdd.bdd.sets.BDDUniverse;
import jdd.util.Test;
import jdd.util.sets.Set;
import jdd.util.sets.SetEnumeration;

public class BDDSetEnumeration
implements SetEnumeration {
    private BDDUniverse universe;
    private int bdd;
    private int[] vec;
    static int[] dom = new int[]{10, 20, 30, 40, 50, 60};

    BDDSetEnumeration(BDDUniverse bDDUniverse, int n) {
        this.universe = bDDUniverse;
        this.bdd = n;
        this.vec = new int[this.universe.subdomainCount()];
        this.universe.ref(n);
    }

    @Override
    public void free() {
        this.universe.deref(this.bdd);
        this.bdd = 0;
    }

    @Override
    public boolean hasMoreElements() {
        return this.bdd != 0;
    }

    @Override
    public int[] nextElement() {
        this.universe.satOneVector(this.bdd, this.vec);
        int n = this.universe.ref(this.universe.vectorToBDD(this.vec));
        int n2 = this.universe.ref(this.universe.not(n));
        this.universe.deref(n);
        int n3 = this.universe.ref(this.universe.and(n2, this.bdd));
        this.universe.deref(n2);
        this.universe.deref(this.bdd);
        this.bdd = n3;
        return this.vec;
    }

    public static void internal_test() {
        Test.start("SetEnumeration");
        BDDUniverse bDDUniverse = new BDDUniverse(dom);
        Set set = bDDUniverse.createEmptySet();
        int[] nArray = new int[dom.length];
        int n = 0;
        for (int i = 0; i < 200; ++i) {
            for (int j = 0; j < dom.length; ++j) {
                nArray[j] = (int)(Math.random() * (double)dom[j]);
            }
            if (!set.insert(nArray)) continue;
            ++n;
        }
        Test.checkEquality((double)n, set.cardinality(), "# of elemnets inserted equals set cardinality");
        Set set2 = set.copy();
        SetEnumeration setEnumeration = set.elements();
        int n2 = 0;
        while (setEnumeration.hasMoreElements()) {
            ++n2;
            int[] nArray2 = setEnumeration.nextElement();
            Test.check(set2.remove(nArray2), " returned element really in set");
        }
        Test.checkEquality((double)n, set.cardinality(), "# of elemnets inserted still equals set cardinality");
        Test.checkEquality((double)n2, set.cardinality(), "right number of elements in set");
        Test.checkEquality(set2.cardinality(), 0.0, "right number of elements in set (Same as above)");
        set2.free();
        set.free();
        setEnumeration.free();
        Test.end();
    }
}

