/*
 * Decompiled with CFR 0.152.
 */
package jdd.des.automata.analysis;

import java.io.FileInputStream;
import java.util.Enumeration;
import java.util.Vector;
import jdd.des.automata.Automata;
import jdd.des.automata.AutomataIO;
import jdd.des.automata.analysis.AutomataAnalyzer;
import jdd.graph.Graph;
import jdd.graph.GraphIO;
import jdd.graph.SimpleAlgorithms;
import jdd.graph.Topology;
import jdd.graph.WeakTopologicalOrdering;

public class AutomataToPCG {
    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.err.println("Usage: java jdd.des.automata.analysis.AutomataToPCG <automata XML files>");
            System.exit(3);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                FileInputStream fileInputStream = new FileInputStream(stringArray[i]);
                Automata automata = AutomataIO.loadXML(fileInputStream);
                Graph graph = AutomataAnalyzer.getPCG(automata);
                Vector vector = SimpleAlgorithms.divide(graph);
                int n = 1;
                String string = stringArray[i];
                int n2 = string.lastIndexOf(46);
                if (n2 != -1) {
                    string = string.substring(0, n2);
                }
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    Graph graph2 = (Graph)enumeration.nextElement();
                    String string2 = string + "_PCG" + (n == 1 ? "" : "_" + n);
                    System.out.println("Writing to " + string2 + ".xml ...");
                    GraphIO.saveXML(graph2, string2 + ".xml");
                    graph2.showDot(string2);
                    string2 = string + "_WTO" + (n == 1 ? "" : "_" + n);
                    Topology topology = WeakTopologicalOrdering.bourdoncle_PCG(graph2);
                    topology.showDot(string2);
                    ++n;
                }
                continue;
            }
            catch (Exception exception) {
                System.err.println("Unable to load " + stringArray[i] + ": " + exception.getMessage());
            }
        }
    }
}

