/*
 * Decompiled with CFR 0.152.
 */
package jdd.des.petrinets;

import java.util.TreeSet;
import jdd.des.petrinets.Petrinet;
import jdd.des.petrinets.PetrinetIO;
import jdd.des.petrinets.Place;
import jdd.des.petrinets.PlaceEnumeration;
import jdd.des.petrinets.Transition;
import jdd.des.petrinets.TransitionEnumeration;
import jdd.des.petrinets.ZDDPN;
import jdd.util.Test;
import jdd.zdd.ZDDNames;

public class SymbolicPetrinet
extends ZDDPN {
    private Petrinet pn;
    private int zdd_M0;
    private int[] sigma_ready;
    private int sigma_tmp;

    public SymbolicPetrinet(Petrinet petrinet) throws IllegalArgumentException {
        super(10000, 1000);
        this.pn = petrinet;
        this.nodeNames = new SymbolicPetrinetNames();
        this.compute_symbolic_variables();
    }

    @Override
    public void cleanup() {
        this.deref(this.zdd_M0);
        super.cleanup();
    }

    private void compute_symbolic_variables() throws IllegalArgumentException {
        int n;
        Place place;
        this.zdd_M0 = 1;
        int n2 = this.pn.numberOfPlaces();
        for (int i = 0; i < n2; ++i) {
            place = this.pn.getPlaceByIndex(i);
            n = place.getTokens();
            if (n != 0 && n != 1) {
                throw new IllegalArgumentException("Place " + place.getName() + " should have zero or one tokens instead of " + n + "!");
            }
            place.zdd_place = this.createVar();
            if (n != 1) continue;
            int n3 = this.ref(this.change(this.zdd_M0, place.zdd_place));
            this.deref(this.zdd_M0);
            this.zdd_M0 = n3;
        }
        n2 = this.pn.numberOfTransitions();
        PlaceEnumeration placeEnumeration = this.pn.createPlaceEnumeration();
        for (n = 0; n < this.pn.transitions.length; ++n) {
            int n4;
            Transition transition = this.pn.transitions[n];
            transition.zdd_ot = 1;
            transition.zdd_to = 1;
            this.pn.incomingPlaces(placeEnumeration, transition);
            while ((place = placeEnumeration.nextPlace()) != null) {
                n4 = this.ref(this.change(transition.zdd_ot, place.zdd_place));
                this.deref(transition.zdd_ot);
                transition.zdd_ot = n4;
            }
            this.pn.outgoingPlaces(placeEnumeration, transition);
            while ((place = placeEnumeration.nextPlace()) != null) {
                n4 = this.ref(this.change(transition.zdd_to, place.zdd_place));
                this.deref(transition.zdd_to);
                transition.zdd_to = n4;
            }
            transition.zdd_otUto = this.ref(this.Change(transition.zdd_ot, transition.zdd_to));
        }
    }

    public int forward() {
        return this.forward(this.zdd_M0, this.pn.transitions);
    }

    private int enabledInFuture(int n, Transition transition, TreeSet treeSet) {
        Place place;
        if (treeSet.contains(transition)) {
            return 0;
        }
        int n2 = transition.index;
        int n3 = this.ref(this.enabled(n, transition));
        if (n3 != 0) {
            this.sigma_ready[n2] = this.union(this.sigma_ready[n2], n3);
        }
        int n4 = this.ref(this.diff(n, n3));
        this.deref(n3);
        PlaceEnumeration placeEnumeration = this.pn.createPlaceEnumeration();
        TransitionEnumeration transitionEnumeration = this.pn.createTransitionEnumeration();
        this.pn.incomingPlaces(placeEnumeration, transition);
        while ((place = placeEnumeration.nextPlace()) != null) {
            Transition transition2;
            int n5 = this.ref(this.subset0(n4, place.zdd_place));
            int n6 = this.ref(n5);
            int n7 = 0;
            this.pn.outgoingTransitions(transitionEnumeration, place);
            while ((transition2 = transitionEnumeration.nextTransition()) != null) {
                boolean bl = treeSet.add(transition2);
                n3 = this.ref(this.enabledInFuture(n6, transition2, treeSet));
                if (n3 != 0) {
                    n7 = this.unionTo(n7, n3);
                }
                if (bl) {
                    treeSet.remove(transition2);
                }
                this.deref(n3);
            }
            n3 = this.ref(this.diff(n6, n7));
            n = this.diffTo(n, n3);
            this.deref(n3);
            n3 = this.ref(this.subset0(n4, n5));
            this.deref(n5);
            this.deref(n6);
            this.deref(n7);
        }
        return n;
    }

    public static void internal_test() {
        Test.start("SymbolicPetrinet");
        SymbolicPetrinet symbolicPetrinet = new SymbolicPetrinet(PetrinetIO.loadXML("data/pn.xml"));
        int n = symbolicPetrinet.forward();
        Test.checkEquality(symbolicPetrinet.count(n), 4, "4 reachable markings");
        symbolicPetrinet.cleanup();
        symbolicPetrinet = new SymbolicPetrinet(PetrinetIO.loadXML("data/largepn1.xml"));
        n = symbolicPetrinet.forward();
        Test.checkEquality(symbolicPetrinet.count(n), 43046721, "43046721 reachable markings");
        symbolicPetrinet.cleanup();
        symbolicPetrinet = new SymbolicPetrinet(PetrinetIO.loadXML("data/largepn2.xml"));
        n = symbolicPetrinet.forward();
        Test.checkEquality(symbolicPetrinet.count(n), 729, "729 reachable markings");
        symbolicPetrinet.cleanup();
        symbolicPetrinet = new SymbolicPetrinet(PetrinetIO.loadXML("data/agv.xml"));
        n = symbolicPetrinet.forward();
        Test.checkEquality(symbolicPetrinet.count(n), 30965760, "30965760 reachable markings");
        symbolicPetrinet.cleanup();
        Test.end();
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            long l = System.currentTimeMillis();
            SymbolicPetrinet symbolicPetrinet = new SymbolicPetrinet(PetrinetIO.loadXML(stringArray[i]));
            int n = symbolicPetrinet.forward();
            int n2 = symbolicPetrinet.count(n);
            l = System.currentTimeMillis() - l;
            long l2 = (symbolicPetrinet.getMemoryUsage() + 512L) / 1024L;
            System.out.println(stringArray[i] + ": | [m0> | = " + n2);
            System.out.println("Time = " + l + " [ms], Memory = " + l2 + "[kB]");
            symbolicPetrinet.cleanup();
        }
    }

    public class SymbolicPetrinetNames
    extends ZDDNames {
        @Override
        public String variable(int n) {
            if (n < 0) {
                return "(none)";
            }
            return SymbolicPetrinet.this.pn.getPlaceByIndex(n).getName();
        }
    }
}

