# encoding: utf-8
require 'archive/tar/minitar'
require 'anjson'

DELTA_SRC = 'autoupdate/delta.tar'

EntryDataItem = Struct.new(:full_name, :mtime, :size, :directory)

class Task
	attr_accessor :src_dir, :src_name, :dest_dir_path, :src_size
	
	def self.get
		re = []
		conf = PinkyBlog::Config.load(CONFIG_FILE_NAME)

		table = {}
		#table['res/pinkyblog/'] = conf.res_dir_path + 'pinkyblog/'
		#table['mod/'] = conf.mod_dir_path
		table['lib/'] = conf.lib_dir_path
		
		entry_data = []
		Archive::Tar::Minitar::Input.open(DELTA_SRC) do |input|
			input.each do |entry|
				entry_data << EntryDataItem.new(entry.full_name, Time.at(entry.mtime), entry.size, entry.directory?)
			end
		end
		

		
		table.each_pair do |src_dir, dest_dir_path|
			pattern = /^#{src_dir}(.+)$/
			entry_data.each do |item|
				if not item.directory and item.full_name =~ pattern then
					src_name = $1
					dest = dest_dir_path + src_name
					
					if not dest.exist? or item.mtime > dest.mtime then
						re << Task.new(src_dir, src_name, dest_dir_path, item.size)
					end
				end
			end
		end
		
		
		list = ['blog.cgi', 'blog.rb', 'blog_server.rb']
		entry_data.each do |item|
			dest = Pathname.new(item.full_name)
			if item.full_name.in?(list) and (not dest.exist? or item.mtime > dest.mtime) then
				re << Task.new('', item.full_name, '.', item.size)
			end
		end
		
		re
	end

	
	def initialize(src_dir, src_name, dest_dir_path, src_size)
		@src_dir, @src_name, @dest_dir_path, @src_size = src_dir, src_name, Pathname.new(dest_dir_path), src_size
	end
	
	def execute(tar_entry, log_io = nil)
		dest = dest_path
		FileUtils.mkpath(dest.parent)
		
		dest.open('wb'){|f| f.write(tar_entry.read)}
		dest.utime(tar_entry.mtime, tar_entry.mtime)
		if log_io then
			log_io.puts "#{tar_entry.full_name} => #{dest.cleanpath.to_s}"
		end
	end
	
	def dest_path
		@dest_dir_path + @src_name
	end
	
	def src_full_name
		@src_dir + @src_name
	end
	
end

class Caller
	def call(env)
		req = Rack::Request.new(env)
		resp = Rack::Response.new
	
		tenjin = Tenjin::Engine.new
		context = Tenjin::Context.new
		conf = PinkyBlog::Config.load(CONFIG_FILE_NAME)
		tasks = Task.get
		
		if (password = req.params['password']) and not password.empty? then
			if password == conf.master_password then
				open('autoupdate.log', 'w'){|log_io|
					Archive::Tar::Minitar::Input.open(DELTA_SRC){|input|
						input.each do |entry|
							if (found = tasks.find{|x| x.src_full_name == entry.full_name}) then
								found.execute(entry, log_io)
							end
						end
	
					}
				}
				
				context[:finished] = true
			else
				context[:error_message] = 'エラー: 管理パスワードが違うと判定されました。設定ファイルを確認してください。'
			end
		end
		
		context[:request] = req
		context[:tasks] = tasks
		spec = AnJSON.parse(PinkyBlog::Util.read_text('autoupdate/delta_spec.json'))
		context[:new_version] = spec['core_version']
		resp.body << tenjin.render('autoupdate/template.rbhtml', context)
		
		resp.to_a
	end
end

