#include "config.h"
#include "pipes/pipes.h"
#include <stdio.h>

static void version()
{
    printf("Pipes version %s\n", getenv("PIPES_VERSION"));
}

int main(int argc, char** argv)
{
    CHECKML_BEGIN(FALSE);

    setenv("PIPES_VERSION", "1.0.4", 1);
    setenv("PIPES_DATAROOTDIR", DATAROOTDIR, 1);

    srandom((unsigned)time(NULL));

    char* optc = NULL;
    BOOL no_runtime_script = FALSE;
    char* file = NULL;
    int i;
    for(i=1; i<argc; i++) {
        if(strcmp(argv[i], "-c") == 0 && i+1 < argc) {
            optc = argv[i+1];
        }
        else if(strcmp(argv[i], "--version") == 0) {
            version();
            exit(0);
        }
        else if(strcmp(argv[i], "-nr") == 0) {
            no_runtime_script = TRUE;
        }
        else {
            file = argv[i];
        }
    }

    if(optc) {
        pipes_opt_c(optc, argv, argc, no_runtime_script);
    }
    else if(file) {
        pipes_load_file(file, argv, argc, no_runtime_script);
    }
    else {
        setenv("PIPES_RUNNING_AS_INTRACTIVE_MODE", "1", 1);
        pipes_readline_interface(argv, argc, no_runtime_script);
    }

    CHECKML_END();

    return 0;
}
